/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartEntitiesDetectionJobResponse extends ComprehendResponse implements
        ToCopyableBuilder<StartEntitiesDetectionJobResponse.Builder, StartEntitiesDetectionJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(StartEntitiesDetectionJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobArn")
            .getter(getter(StartEntitiesDetectionJobResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(StartEntitiesDetectionJobResponse::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<String> ENTITY_RECOGNIZER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityRecognizerArn").getter(getter(StartEntitiesDetectionJobResponse::entityRecognizerArn))
            .setter(setter(Builder::entityRecognizerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognizerArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_ARN_FIELD,
            JOB_STATUS_FIELD, ENTITY_RECOGNIZER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final String jobArn;

    private final String jobStatus;

    private final String entityRecognizerArn;

    private StartEntitiesDetectionJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.jobArn = builder.jobArn;
        this.jobStatus = builder.jobStatus;
        this.entityRecognizerArn = builder.entityRecognizerArn;
    }

    /**
     * <p>
     * The identifier generated for the job. To get the status of job, use this identifier with the operation.
     * </p>
     * 
     * @return The identifier generated for the job. To get the status of job, use this identifier with the operation.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the
     * job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format of the
     * ARN is as follows:
     * </p>
     * <p>
     * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
     * </p>
     * <p>
     * The following is an example job ARN:
     * </p>
     * <p>
     * <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier
     *         for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The
     *         format of the ARN is as follows:</p>
     *         <p>
     *         <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
     *         </p>
     *         <p>
     *         The following is an example job ARN:
     *         </p>
     *         <p>
     *         <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUBMITTED - The job has been received and is queued for processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS - Amazon Comprehend is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED - The job was successfully completed and the output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The job did not complete. To get details, use the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED - The job was successfully stopped without completing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SUBMITTED - The job has been received and is queued for processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN_PROGRESS - Amazon Comprehend is processing the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED - The job was successfully completed and the output is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The job did not complete. To get details, use the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED - The job was successfully stopped without completing.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * SUBMITTED - The job has been received and is queued for processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * IN_PROGRESS - Amazon Comprehend is processing the job.
     * </p>
     * </li>
     * <li>
     * <p>
     * COMPLETED - The job was successfully completed and the output is available.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The job did not complete. To get details, use the operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * STOPPED - The job was successfully stopped without completing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the job. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SUBMITTED - The job has been received and is queued for processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         IN_PROGRESS - Amazon Comprehend is processing the job.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         COMPLETED - The job was successfully completed and the output is available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The job did not complete. To get details, use the operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STOPPED - The job was successfully stopped without completing.
     *         </p>
     *         </li>
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The ARN of the custom entity recognition model.
     * </p>
     * 
     * @return The ARN of the custom entity recognition model.
     */
    public final String entityRecognizerArn() {
        return entityRecognizerArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(entityRecognizerArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEntitiesDetectionJobResponse)) {
            return false;
        }
        StartEntitiesDetectionJobResponse other = (StartEntitiesDetectionJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(entityRecognizerArn(), other.entityRecognizerArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartEntitiesDetectionJobResponse").add("JobId", jobId()).add("JobArn", jobArn())
                .add("JobStatus", jobStatusAsString()).add("EntityRecognizerArn", entityRecognizerArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "JobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "EntityRecognizerArn":
            return Optional.ofNullable(clazz.cast(entityRecognizerArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("JobArn", JOB_ARN_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("EntityRecognizerArn", ENTITY_RECOGNIZER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartEntitiesDetectionJobResponse, T> g) {
        return obj -> g.apply((StartEntitiesDetectionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComprehendResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartEntitiesDetectionJobResponse> {
        /**
         * <p>
         * The identifier generated for the job. To get the status of job, use this identifier with the operation.
         * </p>
         * 
         * @param jobId
         *        The identifier generated for the job. To get the status of job, use this identifier with the
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for
         * the job. It includes the Amazon Web Services account, Amazon Web Services Region, and the job ID. The format
         * of the ARN is as follows:
         * </p>
         * <p>
         * <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
         * </p>
         * <p>
         * The following is an example job ARN:
         * </p>
         * <p>
         * <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified
         *        identifier for the job. It includes the Amazon Web Services account, Amazon Web Services Region, and
         *        the job ID. The format of the ARN is as follows:</p>
         *        <p>
         *        <code>arn:&lt;partition&gt;:comprehend:&lt;region&gt;:&lt;account-id&gt;:entities-detection-job/&lt;job-id&gt;</code>
         *        </p>
         *        <p>
         *        The following is an example job ARN:
         *        </p>
         *        <p>
         *        <code>arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The status of the job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * SUBMITTED - The job has been received and is queued for processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN_PROGRESS - Amazon Comprehend is processing the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED - The job was successfully completed and the output is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The job did not complete. To get details, use the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED - The job was successfully stopped without completing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The status of the job. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SUBMITTED - The job has been received and is queued for processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN_PROGRESS - Amazon Comprehend is processing the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED - The job was successfully completed and the output is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The job did not complete. To get details, use the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED - The job was successfully stopped without completing.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * SUBMITTED - The job has been received and is queued for processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * IN_PROGRESS - Amazon Comprehend is processing the job.
         * </p>
         * </li>
         * <li>
         * <p>
         * COMPLETED - The job was successfully completed and the output is available.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The job did not complete. To get details, use the operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * STOPPED - The job was successfully stopped without completing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param jobStatus
         *        The status of the job. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SUBMITTED - The job has been received and is queued for processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        IN_PROGRESS - Amazon Comprehend is processing the job.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        COMPLETED - The job was successfully completed and the output is available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The job did not complete. To get details, use the operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STOPPED - The job was successfully stopped without completing.
         *        </p>
         *        </li>
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The ARN of the custom entity recognition model.
         * </p>
         * 
         * @param entityRecognizerArn
         *        The ARN of the custom entity recognition model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRecognizerArn(String entityRecognizerArn);
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private String jobId;

        private String jobArn;

        private String jobStatus;

        private String entityRecognizerArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEntitiesDetectionJobResponse model) {
            super(model);
            jobId(model.jobId);
            jobArn(model.jobArn);
            jobStatus(model.jobStatus);
            entityRecognizerArn(model.entityRecognizerArn);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getEntityRecognizerArn() {
            return entityRecognizerArn;
        }

        public final void setEntityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
        }

        @Override
        public final Builder entityRecognizerArn(String entityRecognizerArn) {
            this.entityRecognizerArn = entityRecognizerArn;
            return this;
        }

        @Override
        public StartEntitiesDetectionJobResponse build() {
            return new StartEntitiesDetectionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
