/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides additional detail about why the request failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidRequestDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<InvalidRequestDetail.Builder, InvalidRequestDetail> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(InvalidRequestDetail::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reason;

    private InvalidRequestDetail(BuilderImpl builder) {
        this.reason = builder.reason;
    }

    /**
     * <p>
     * Reason codes include the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your file and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of pages in your file and resubmit the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your account has permission to use Amazon
     * Textract API operations and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the format and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID_DOCUMENT - Invalid document. Check the file and resubmit the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link InvalidRequestDetailReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Reason codes include the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your file and resubmit the
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type and resubmit the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of pages in your file and resubmit
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your account has permission to use
     *         Amazon Textract API operations and resubmit the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the format and resubmit the
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and resubmit the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_DOCUMENT - Invalid document. Check the file and resubmit the request.
     *         </p>
     *         </li>
     * @see InvalidRequestDetailReason
     */
    public final InvalidRequestDetailReason reason() {
        return InvalidRequestDetailReason.fromValue(reason);
    }

    /**
     * <p>
     * Reason codes include the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your file and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of pages in your file and resubmit the
     * request.
     * </p>
     * </li>
     * <li>
     * <p>
     * TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your account has permission to use Amazon
     * Textract API operations and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the format and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and resubmit the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * INVALID_DOCUMENT - Invalid document. Check the file and resubmit the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link InvalidRequestDetailReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Reason codes include the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your file and resubmit the
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type and resubmit the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of pages in your file and resubmit
     *         the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your account has permission to use
     *         Amazon Textract API operations and resubmit the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the format and resubmit the
     *         request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and resubmit the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVALID_DOCUMENT - Invalid document. Check the file and resubmit the request.
     *         </p>
     *         </li>
     * @see InvalidRequestDetailReason
     */
    public final String reasonAsString() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvalidRequestDetail)) {
            return false;
        }
        InvalidRequestDetail other = (InvalidRequestDetail) obj;
        return Objects.equals(reasonAsString(), other.reasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvalidRequestDetail").add("Reason", reasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidRequestDetail, T> g) {
        return obj -> g.apply((InvalidRequestDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidRequestDetail> {
        /**
         * <p>
         * Reason codes include the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your file and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of pages in your file and resubmit the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your account has permission to use
         * Amazon Textract API operations and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the format and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * INVALID_DOCUMENT - Invalid document. Check the file and resubmit the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        Reason codes include the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your file and resubmit the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type and resubmit the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of pages in your file and
         *        resubmit the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your account has permission to
         *        use Amazon Textract API operations and resubmit the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the format and resubmit the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and resubmit the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVALID_DOCUMENT - Invalid document. Check the file and resubmit the request.
         *        </p>
         *        </li>
         * @see InvalidRequestDetailReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvalidRequestDetailReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * Reason codes include the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your file and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of pages in your file and resubmit the
         * request.
         * </p>
         * </li>
         * <li>
         * <p>
         * TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your account has permission to use
         * Amazon Textract API operations and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the format and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and resubmit the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * INVALID_DOCUMENT - Invalid document. Check the file and resubmit the request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        Reason codes include the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        DOCUMENT_SIZE_EXCEEDED - Document size is too large. Check the size of your file and resubmit the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        UNSUPPORTED_DOC_TYPE - Document type is not supported. Check the file type and resubmit the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAGE_LIMIT_EXCEEDED - Too many pages in the document. Check the number of pages in your file and
         *        resubmit the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TEXTRACT_ACCESS_DENIED - Access denied to Amazon Textract. Verify that your account has permission to
         *        use Amazon Textract API operations and resubmit the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        NOT_TEXTRACT_JSON - Document is not Amazon Textract JSON format. Verify the format and resubmit the
         *        request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        MISMATCHED_TOTAL_PAGE_COUNT - Check the number of pages in your file and resubmit the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVALID_DOCUMENT - Invalid document. Check the file and resubmit the request.
         *        </p>
         *        </li>
         * @see InvalidRequestDetailReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvalidRequestDetailReason
         */
        Builder reason(InvalidRequestDetailReason reason);
    }

    static final class BuilderImpl implements Builder {
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidRequestDetail model) {
            reason(model.reason);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(InvalidRequestDetailReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public InvalidRequestDetail build() {
            return new InvalidRequestDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
