/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDatasetResponse extends ComprehendResponse implements
        ToCopyableBuilder<DescribeDatasetResponse.Builder, DescribeDatasetResponse> {
    private static final SdkField<DatasetProperties> DATASET_PROPERTIES_FIELD = SdkField
            .<DatasetProperties> builder(MarshallingType.SDK_POJO).memberName("DatasetProperties")
            .getter(getter(DescribeDatasetResponse::datasetProperties)).setter(setter(Builder::datasetProperties))
            .constructor(DatasetProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DatasetProperties datasetProperties;

    private DescribeDatasetResponse(BuilderImpl builder) {
        super(builder);
        this.datasetProperties = builder.datasetProperties;
    }

    /**
     * <p>
     * The dataset properties.
     * </p>
     * 
     * @return The dataset properties.
     */
    public final DatasetProperties datasetProperties() {
        return datasetProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatasetResponse)) {
            return false;
        }
        DescribeDatasetResponse other = (DescribeDatasetResponse) obj;
        return Objects.equals(datasetProperties(), other.datasetProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDatasetResponse").add("DatasetProperties", datasetProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetProperties":
            return Optional.ofNullable(clazz.cast(datasetProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatasetProperties", DATASET_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatasetResponse, T> g) {
        return obj -> g.apply((DescribeDatasetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ComprehendResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDatasetResponse> {
        /**
         * <p>
         * The dataset properties.
         * </p>
         * 
         * @param datasetProperties
         *        The dataset properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetProperties(DatasetProperties datasetProperties);

        /**
         * <p>
         * The dataset properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetProperties.Builder} avoiding the
         * need to create one manually via {@link DatasetProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetProperties(DatasetProperties)}.
         * 
         * @param datasetProperties
         *        a consumer that will call methods on {@link DatasetProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetProperties(DatasetProperties)
         */
        default Builder datasetProperties(Consumer<DatasetProperties.Builder> datasetProperties) {
            return datasetProperties(DatasetProperties.builder().applyMutation(datasetProperties).build());
        }
    }

    static final class BuilderImpl extends ComprehendResponse.BuilderImpl implements Builder {
        private DatasetProperties datasetProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatasetResponse model) {
            super(model);
            datasetProperties(model.datasetProperties);
        }

        public final DatasetProperties.Builder getDatasetProperties() {
            return datasetProperties != null ? datasetProperties.toBuilder() : null;
        }

        public final void setDatasetProperties(DatasetProperties.BuilderImpl datasetProperties) {
            this.datasetProperties = datasetProperties != null ? datasetProperties.build() : null;
        }

        @Override
        public final Builder datasetProperties(DatasetProperties datasetProperties) {
            this.datasetProperties = datasetProperties;
            return this;
        }

        @Override
        public DescribeDatasetResponse build() {
            return new DescribeDatasetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
