/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the format and location of the input data. You must provide either the <code>Annotations</code> parameter
 * or the <code>EntityList</code> parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetEntityRecognizerInputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetEntityRecognizerInputDataConfig.Builder, DatasetEntityRecognizerInputDataConfig> {
    private static final SdkField<DatasetEntityRecognizerAnnotations> ANNOTATIONS_FIELD = SdkField
            .<DatasetEntityRecognizerAnnotations> builder(MarshallingType.SDK_POJO).memberName("Annotations")
            .getter(getter(DatasetEntityRecognizerInputDataConfig::annotations)).setter(setter(Builder::annotations))
            .constructor(DatasetEntityRecognizerAnnotations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build()).build();

    private static final SdkField<DatasetEntityRecognizerDocuments> DOCUMENTS_FIELD = SdkField
            .<DatasetEntityRecognizerDocuments> builder(MarshallingType.SDK_POJO).memberName("Documents")
            .getter(getter(DatasetEntityRecognizerInputDataConfig::documents)).setter(setter(Builder::documents))
            .constructor(DatasetEntityRecognizerDocuments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build()).build();

    private static final SdkField<DatasetEntityRecognizerEntityList> ENTITY_LIST_FIELD = SdkField
            .<DatasetEntityRecognizerEntityList> builder(MarshallingType.SDK_POJO).memberName("EntityList")
            .getter(getter(DatasetEntityRecognizerInputDataConfig::entityList)).setter(setter(Builder::entityList))
            .constructor(DatasetEntityRecognizerEntityList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATIONS_FIELD,
            DOCUMENTS_FIELD, ENTITY_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DatasetEntityRecognizerAnnotations annotations;

    private final DatasetEntityRecognizerDocuments documents;

    private final DatasetEntityRecognizerEntityList entityList;

    private DatasetEntityRecognizerInputDataConfig(BuilderImpl builder) {
        this.annotations = builder.annotations;
        this.documents = builder.documents;
        this.entityList = builder.entityList;
    }

    /**
     * <p>
     * The S3 location of the annotation documents for your custom entity recognizer.
     * </p>
     * 
     * @return The S3 location of the annotation documents for your custom entity recognizer.
     */
    public final DatasetEntityRecognizerAnnotations annotations() {
        return annotations;
    }

    /**
     * <p>
     * The format and location of the training documents for your custom entity recognizer.
     * </p>
     * 
     * @return The format and location of the training documents for your custom entity recognizer.
     */
    public final DatasetEntityRecognizerDocuments documents() {
        return documents;
    }

    /**
     * <p>
     * The S3 location of the entity list for your custom entity recognizer.
     * </p>
     * 
     * @return The S3 location of the entity list for your custom entity recognizer.
     */
    public final DatasetEntityRecognizerEntityList entityList() {
        return entityList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(annotations());
        hashCode = 31 * hashCode + Objects.hashCode(documents());
        hashCode = 31 * hashCode + Objects.hashCode(entityList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetEntityRecognizerInputDataConfig)) {
            return false;
        }
        DatasetEntityRecognizerInputDataConfig other = (DatasetEntityRecognizerInputDataConfig) obj;
        return Objects.equals(annotations(), other.annotations()) && Objects.equals(documents(), other.documents())
                && Objects.equals(entityList(), other.entityList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetEntityRecognizerInputDataConfig").add("Annotations", annotations())
                .add("Documents", documents()).add("EntityList", entityList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        case "Documents":
            return Optional.ofNullable(clazz.cast(documents()));
        case "EntityList":
            return Optional.ofNullable(clazz.cast(entityList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Annotations", ANNOTATIONS_FIELD);
        map.put("Documents", DOCUMENTS_FIELD);
        map.put("EntityList", ENTITY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatasetEntityRecognizerInputDataConfig, T> g) {
        return obj -> g.apply((DatasetEntityRecognizerInputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetEntityRecognizerInputDataConfig> {
        /**
         * <p>
         * The S3 location of the annotation documents for your custom entity recognizer.
         * </p>
         * 
         * @param annotations
         *        The S3 location of the annotation documents for your custom entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(DatasetEntityRecognizerAnnotations annotations);

        /**
         * <p>
         * The S3 location of the annotation documents for your custom entity recognizer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatasetEntityRecognizerAnnotations.Builder} avoiding the need to create one manually via
         * {@link DatasetEntityRecognizerAnnotations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetEntityRecognizerAnnotations.Builder#build()} is called
         * immediately and its result is passed to {@link #annotations(DatasetEntityRecognizerAnnotations)}.
         * 
         * @param annotations
         *        a consumer that will call methods on {@link DatasetEntityRecognizerAnnotations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotations(DatasetEntityRecognizerAnnotations)
         */
        default Builder annotations(Consumer<DatasetEntityRecognizerAnnotations.Builder> annotations) {
            return annotations(DatasetEntityRecognizerAnnotations.builder().applyMutation(annotations).build());
        }

        /**
         * <p>
         * The format and location of the training documents for your custom entity recognizer.
         * </p>
         * 
         * @param documents
         *        The format and location of the training documents for your custom entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(DatasetEntityRecognizerDocuments documents);

        /**
         * <p>
         * The format and location of the training documents for your custom entity recognizer.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetEntityRecognizerDocuments.Builder}
         * avoiding the need to create one manually via {@link DatasetEntityRecognizerDocuments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetEntityRecognizerDocuments.Builder#build()} is called
         * immediately and its result is passed to {@link #documents(DatasetEntityRecognizerDocuments)}.
         * 
         * @param documents
         *        a consumer that will call methods on {@link DatasetEntityRecognizerDocuments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(DatasetEntityRecognizerDocuments)
         */
        default Builder documents(Consumer<DatasetEntityRecognizerDocuments.Builder> documents) {
            return documents(DatasetEntityRecognizerDocuments.builder().applyMutation(documents).build());
        }

        /**
         * <p>
         * The S3 location of the entity list for your custom entity recognizer.
         * </p>
         * 
         * @param entityList
         *        The S3 location of the entity list for your custom entity recognizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityList(DatasetEntityRecognizerEntityList entityList);

        /**
         * <p>
         * The S3 location of the entity list for your custom entity recognizer.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DatasetEntityRecognizerEntityList.Builder} avoiding the need to create one manually via
         * {@link DatasetEntityRecognizerEntityList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetEntityRecognizerEntityList.Builder#build()} is called
         * immediately and its result is passed to {@link #entityList(DatasetEntityRecognizerEntityList)}.
         * 
         * @param entityList
         *        a consumer that will call methods on {@link DatasetEntityRecognizerEntityList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityList(DatasetEntityRecognizerEntityList)
         */
        default Builder entityList(Consumer<DatasetEntityRecognizerEntityList.Builder> entityList) {
            return entityList(DatasetEntityRecognizerEntityList.builder().applyMutation(entityList).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DatasetEntityRecognizerAnnotations annotations;

        private DatasetEntityRecognizerDocuments documents;

        private DatasetEntityRecognizerEntityList entityList;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetEntityRecognizerInputDataConfig model) {
            annotations(model.annotations);
            documents(model.documents);
            entityList(model.entityList);
        }

        public final DatasetEntityRecognizerAnnotations.Builder getAnnotations() {
            return annotations != null ? annotations.toBuilder() : null;
        }

        public final void setAnnotations(DatasetEntityRecognizerAnnotations.BuilderImpl annotations) {
            this.annotations = annotations != null ? annotations.build() : null;
        }

        @Override
        public final Builder annotations(DatasetEntityRecognizerAnnotations annotations) {
            this.annotations = annotations;
            return this;
        }

        public final DatasetEntityRecognizerDocuments.Builder getDocuments() {
            return documents != null ? documents.toBuilder() : null;
        }

        public final void setDocuments(DatasetEntityRecognizerDocuments.BuilderImpl documents) {
            this.documents = documents != null ? documents.build() : null;
        }

        @Override
        public final Builder documents(DatasetEntityRecognizerDocuments documents) {
            this.documents = documents;
            return this;
        }

        public final DatasetEntityRecognizerEntityList.Builder getEntityList() {
            return entityList != null ? entityList.toBuilder() : null;
        }

        public final void setEntityList(DatasetEntityRecognizerEntityList.BuilderImpl entityList) {
            this.entityList = entityList != null ? entityList.build() : null;
        }

        @Override
        public final Builder entityList(DatasetEntityRecognizerEntityList entityList) {
            this.entityList = entityList;
            return this;
        }

        @Override
        public DatasetEntityRecognizerInputDataConfig build() {
            return new DatasetEntityRecognizerInputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
