/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to post updates to records or add and delete records for a dataset and user.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRecordsRequest extends CognitoSyncRequest implements
        ToCopyableBuilder<UpdateRecordsRequest.Builder, UpdateRecordsRequest> {
    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(UpdateRecordsRequest::identityPoolId))
            .setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IdentityPoolId").build()).build();

    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityId").getter(getter(UpdateRecordsRequest::identityId)).setter(setter(Builder::identityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IdentityId").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(UpdateRecordsRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DatasetName").build()).build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(UpdateRecordsRequest::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<List<RecordPatch>> RECORD_PATCHES_FIELD = SdkField
            .<List<RecordPatch>> builder(MarshallingType.LIST)
            .memberName("RecordPatches")
            .getter(getter(UpdateRecordsRequest::recordPatches))
            .setter(setter(Builder::recordPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordPatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecordPatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecordPatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SYNC_SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncSessionToken").getter(getter(UpdateRecordsRequest::syncSessionToken))
            .setter(setter(Builder::syncSessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncSessionToken").build()).build();

    private static final SdkField<String> CLIENT_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientContext").getter(getter(UpdateRecordsRequest::clientContext))
            .setter(setter(Builder::clientContext))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Client-Context").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_ID_FIELD,
            IDENTITY_ID_FIELD, DATASET_NAME_FIELD, DEVICE_ID_FIELD, RECORD_PATCHES_FIELD, SYNC_SESSION_TOKEN_FIELD,
            CLIENT_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String identityPoolId;

    private final String identityId;

    private final String datasetName;

    private final String deviceId;

    private final List<RecordPatch> recordPatches;

    private final String syncSessionToken;

    private final String clientContext;

    private UpdateRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityId = builder.identityId;
        this.datasetName = builder.datasetName;
        this.deviceId = builder.deviceId;
        this.recordPatches = builder.recordPatches;
        this.syncSessionToken = builder.syncSessionToken;
        this.clientContext = builder.clientContext;
    }

    /**
     * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
     * generation is unique within a region.
     * 
     * @return A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
     *         Cognito. GUID generation is unique within a region.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID
     * generation is unique within a region.
     * 
     * @return A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
     *         Cognito. GUID generation is unique within a region.
     */
    public final String identityId() {
        return identityId;
    }

    /**
     * A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
     * (dot).
     * 
     * @return A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and
     *         '.' (dot).
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The unique ID generated for this device by Cognito.
     * </p>
     * 
     * @return The unique ID generated for this device by Cognito.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecordPatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecordPatches() {
        return recordPatches != null && !(recordPatches instanceof SdkAutoConstructList);
    }

    /**
     * A list of patch operations.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordPatches} method.
     * </p>
     * 
     * @return A list of patch operations.
     */
    public final List<RecordPatch> recordPatches() {
        return recordPatches;
    }

    /**
     * The SyncSessionToken returned by a previous call to ListRecords for this dataset and identity.
     * 
     * @return The SyncSessionToken returned by a previous call to ListRecords for this dataset and identity.
     */
    public final String syncSessionToken() {
        return syncSessionToken;
    }

    /**
     * Intended to supply a device ID that will populate the lastModifiedBy field referenced in other methods. The
     * ClientContext field is not yet implemented.
     * 
     * @return Intended to supply a device ID that will populate the lastModifiedBy field referenced in other methods.
     *         The ClientContext field is not yet implemented.
     */
    public final String clientContext() {
        return clientContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordPatches() ? recordPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(syncSessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(clientContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecordsRequest)) {
            return false;
        }
        UpdateRecordsRequest other = (UpdateRecordsRequest) obj;
        return Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(identityId(), other.identityId())
                && Objects.equals(datasetName(), other.datasetName()) && Objects.equals(deviceId(), other.deviceId())
                && hasRecordPatches() == other.hasRecordPatches() && Objects.equals(recordPatches(), other.recordPatches())
                && Objects.equals(syncSessionToken(), other.syncSessionToken())
                && Objects.equals(clientContext(), other.clientContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRecordsRequest").add("IdentityPoolId", identityPoolId()).add("IdentityId", identityId())
                .add("DatasetName", datasetName()).add("DeviceId", deviceId())
                .add("RecordPatches", hasRecordPatches() ? recordPatches() : null).add("SyncSessionToken", syncSessionToken())
                .add("ClientContext", clientContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "IdentityId":
            return Optional.ofNullable(clazz.cast(identityId()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "RecordPatches":
            return Optional.ofNullable(clazz.cast(recordPatches()));
        case "SyncSessionToken":
            return Optional.ofNullable(clazz.cast(syncSessionToken()));
        case "ClientContext":
            return Optional.ofNullable(clazz.cast(clientContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityPoolId", IDENTITY_POOL_ID_FIELD);
        map.put("IdentityId", IDENTITY_ID_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("DeviceId", DEVICE_ID_FIELD);
        map.put("RecordPatches", RECORD_PATCHES_FIELD);
        map.put("SyncSessionToken", SYNC_SESSION_TOKEN_FIELD);
        map.put("x-amz-Client-Context", CLIENT_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecordsRequest, T> g) {
        return obj -> g.apply((UpdateRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRecordsRequest> {
        /**
         * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
         * GUID generation is unique within a region.
         * 
         * @param identityPoolId
         *        A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
         *        Cognito. GUID generation is unique within a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito.
         * GUID generation is unique within a region.
         * 
         * @param identityId
         *        A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon
         *        Cognito. GUID generation is unique within a region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityId(String identityId);

        /**
         * A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.'
         * (dot).
         * 
         * @param datasetName
         *        A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash),
         *        and '.' (dot).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The unique ID generated for this device by Cognito.
         * </p>
         * 
         * @param deviceId
         *        The unique ID generated for this device by Cognito.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * A list of patch operations.
         * 
         * @param recordPatches
         *        A list of patch operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordPatches(Collection<RecordPatch> recordPatches);

        /**
         * A list of patch operations.
         * 
         * @param recordPatches
         *        A list of patch operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordPatches(RecordPatch... recordPatches);

        /**
         * A list of patch operations. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitosync.model.RecordPatch.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cognitosync.model.RecordPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitosync.model.RecordPatch.Builder#build()} is called immediately
         * and its result is passed to {@link #recordPatches(List<RecordPatch>)}.
         * 
         * @param recordPatches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitosync.model.RecordPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordPatches(java.util.Collection<RecordPatch>)
         */
        Builder recordPatches(Consumer<RecordPatch.Builder>... recordPatches);

        /**
         * The SyncSessionToken returned by a previous call to ListRecords for this dataset and identity.
         * 
         * @param syncSessionToken
         *        The SyncSessionToken returned by a previous call to ListRecords for this dataset and identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncSessionToken(String syncSessionToken);

        /**
         * Intended to supply a device ID that will populate the lastModifiedBy field referenced in other methods. The
         * ClientContext field is not yet implemented.
         * 
         * @param clientContext
         *        Intended to supply a device ID that will populate the lastModifiedBy field referenced in other
         *        methods. The ClientContext field is not yet implemented.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientContext(String clientContext);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CognitoSyncRequest.BuilderImpl implements Builder {
        private String identityPoolId;

        private String identityId;

        private String datasetName;

        private String deviceId;

        private List<RecordPatch> recordPatches = DefaultSdkAutoConstructList.getInstance();

        private String syncSessionToken;

        private String clientContext;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecordsRequest model) {
            super(model);
            identityPoolId(model.identityPoolId);
            identityId(model.identityId);
            datasetName(model.datasetName);
            deviceId(model.deviceId);
            recordPatches(model.recordPatches);
            syncSessionToken(model.syncSessionToken);
            clientContext(model.clientContext);
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getIdentityId() {
            return identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final List<RecordPatch.Builder> getRecordPatches() {
            List<RecordPatch.Builder> result = RecordPatchListCopier.copyToBuilder(this.recordPatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecordPatches(Collection<RecordPatch.BuilderImpl> recordPatches) {
            this.recordPatches = RecordPatchListCopier.copyFromBuilder(recordPatches);
        }

        @Override
        public final Builder recordPatches(Collection<RecordPatch> recordPatches) {
            this.recordPatches = RecordPatchListCopier.copy(recordPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordPatches(RecordPatch... recordPatches) {
            recordPatches(Arrays.asList(recordPatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordPatches(Consumer<RecordPatch.Builder>... recordPatches) {
            recordPatches(Stream.of(recordPatches).map(c -> RecordPatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSyncSessionToken() {
            return syncSessionToken;
        }

        public final void setSyncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
        }

        @Override
        public final Builder syncSessionToken(String syncSessionToken) {
            this.syncSessionToken = syncSessionToken;
            return this;
        }

        public final String getClientContext() {
            return clientContext;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        @Override
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecordsRequest build() {
            return new UpdateRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
