/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Returned for a successful ListIdentityPoolUsage request.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentityPoolUsageResponse extends CognitoSyncResponse implements
        ToCopyableBuilder<ListIdentityPoolUsageResponse.Builder, ListIdentityPoolUsageResponse> {
    private static final SdkField<List<IdentityPoolUsage>> IDENTITY_POOL_USAGES_FIELD = SdkField
            .<List<IdentityPoolUsage>> builder(MarshallingType.LIST)
            .memberName("IdentityPoolUsages")
            .getter(getter(ListIdentityPoolUsageResponse::identityPoolUsages))
            .setter(setter(Builder::identityPoolUsages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolUsages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityPoolUsage> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityPoolUsage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListIdentityPoolUsageResponse::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(ListIdentityPoolUsageResponse::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIdentityPoolUsageResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_POOL_USAGES_FIELD,
            MAX_RESULTS_FIELD, COUNT_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<IdentityPoolUsage> identityPoolUsages;

    private final Integer maxResults;

    private final Integer count;

    private final String nextToken;

    private ListIdentityPoolUsageResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolUsages = builder.identityPoolUsages;
        this.maxResults = builder.maxResults;
        this.count = builder.count;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityPoolUsages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIdentityPoolUsages() {
        return identityPoolUsages != null && !(identityPoolUsages instanceof SdkAutoConstructList);
    }

    /**
     * Usage information for the identity pools.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityPoolUsages} method.
     * </p>
     * 
     * @return Usage information for the identity pools.
     */
    public final List<IdentityPoolUsage> identityPoolUsages() {
        return identityPoolUsages;
    }

    /**
     * The maximum number of results to be returned.
     * 
     * @return The maximum number of results to be returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Total number of identities for the identity pool.
     * 
     * @return Total number of identities for the identity pool.
     */
    public final Integer count() {
        return count;
    }

    /**
     * A pagination token for obtaining the next page of results.
     * 
     * @return A pagination token for obtaining the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityPoolUsages() ? identityPoolUsages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityPoolUsageResponse)) {
            return false;
        }
        ListIdentityPoolUsageResponse other = (ListIdentityPoolUsageResponse) obj;
        return hasIdentityPoolUsages() == other.hasIdentityPoolUsages()
                && Objects.equals(identityPoolUsages(), other.identityPoolUsages())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(count(), other.count())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdentityPoolUsageResponse")
                .add("IdentityPoolUsages", hasIdentityPoolUsages() ? identityPoolUsages() : null).add("MaxResults", maxResults())
                .add("Count", count()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityPoolUsages":
            return Optional.ofNullable(clazz.cast(identityPoolUsages()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityPoolUsages", IDENTITY_POOL_USAGES_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityPoolUsageResponse, T> g) {
        return obj -> g.apply((ListIdentityPoolUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIdentityPoolUsageResponse> {
        /**
         * Usage information for the identity pools.
         * 
         * @param identityPoolUsages
         *        Usage information for the identity pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolUsages(Collection<IdentityPoolUsage> identityPoolUsages);

        /**
         * Usage information for the identity pools.
         * 
         * @param identityPoolUsages
         *        Usage information for the identity pools.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolUsages(IdentityPoolUsage... identityPoolUsages);

        /**
         * Usage information for the identity pools. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage.Builder#build()} is called
         * immediately and its result is passed to {@link #identityPoolUsages(List<IdentityPoolUsage>)}.
         * 
         * @param identityPoolUsages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cognitosync.model.IdentityPoolUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityPoolUsages(java.util.Collection<IdentityPoolUsage>)
         */
        Builder identityPoolUsages(Consumer<IdentityPoolUsage.Builder>... identityPoolUsages);

        /**
         * The maximum number of results to be returned.
         * 
         * @param maxResults
         *        The maximum number of results to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Total number of identities for the identity pool.
         * 
         * @param count
         *        Total number of identities for the identity pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * A pagination token for obtaining the next page of results.
         * 
         * @param nextToken
         *        A pagination token for obtaining the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CognitoSyncResponse.BuilderImpl implements Builder {
        private List<IdentityPoolUsage> identityPoolUsages = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private Integer count;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityPoolUsageResponse model) {
            super(model);
            identityPoolUsages(model.identityPoolUsages);
            maxResults(model.maxResults);
            count(model.count);
            nextToken(model.nextToken);
        }

        public final List<IdentityPoolUsage.Builder> getIdentityPoolUsages() {
            List<IdentityPoolUsage.Builder> result = IdentityPoolUsageListCopier.copyToBuilder(this.identityPoolUsages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityPoolUsages(Collection<IdentityPoolUsage.BuilderImpl> identityPoolUsages) {
            this.identityPoolUsages = IdentityPoolUsageListCopier.copyFromBuilder(identityPoolUsages);
        }

        @Override
        public final Builder identityPoolUsages(Collection<IdentityPoolUsage> identityPoolUsages) {
            this.identityPoolUsages = IdentityPoolUsageListCopier.copy(identityPoolUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPoolUsages(IdentityPoolUsage... identityPoolUsages) {
            identityPoolUsages(Arrays.asList(identityPoolUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityPoolUsages(Consumer<IdentityPoolUsage.Builder>... identityPoolUsages) {
            identityPoolUsages(Stream.of(identityPoolUsages).map(c -> IdentityPoolUsage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityPoolUsageResponse build() {
            return new ListIdentityPoolUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
