/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitosync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The response to a successful DescribeIdentityUsage request.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeIdentityUsageResponse extends CognitoSyncResponse implements
        ToCopyableBuilder<DescribeIdentityUsageResponse.Builder, DescribeIdentityUsageResponse> {
    private static final SdkField<IdentityUsage> IDENTITY_USAGE_FIELD = SdkField
            .<IdentityUsage> builder(MarshallingType.SDK_POJO).memberName("IdentityUsage")
            .getter(getter(DescribeIdentityUsageResponse::identityUsage)).setter(setter(Builder::identityUsage))
            .constructor(IdentityUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityUsage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final IdentityUsage identityUsage;

    private DescribeIdentityUsageResponse(BuilderImpl builder) {
        super(builder);
        this.identityUsage = builder.identityUsage;
    }

    /**
     * Usage information for the identity.
     * 
     * @return Usage information for the identity.
     */
    public final IdentityUsage identityUsage() {
        return identityUsage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityUsage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityUsageResponse)) {
            return false;
        }
        DescribeIdentityUsageResponse other = (DescribeIdentityUsageResponse) obj;
        return Objects.equals(identityUsage(), other.identityUsage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeIdentityUsageResponse").add("IdentityUsage", identityUsage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityUsage":
            return Optional.ofNullable(clazz.cast(identityUsage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityUsage", IDENTITY_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIdentityUsageResponse, T> g) {
        return obj -> g.apply((DescribeIdentityUsageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CognitoSyncResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeIdentityUsageResponse> {
        /**
         * Usage information for the identity.
         * 
         * @param identityUsage
         *        Usage information for the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityUsage(IdentityUsage identityUsage);

        /**
         * Usage information for the identity. This is a convenience method that creates an instance of the
         * {@link IdentityUsage.Builder} avoiding the need to create one manually via {@link IdentityUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdentityUsage.Builder#build()} is called immediately and its
         * result is passed to {@link #identityUsage(IdentityUsage)}.
         * 
         * @param identityUsage
         *        a consumer that will call methods on {@link IdentityUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityUsage(IdentityUsage)
         */
        default Builder identityUsage(Consumer<IdentityUsage.Builder> identityUsage) {
            return identityUsage(IdentityUsage.builder().applyMutation(identityUsage).build());
        }
    }

    static final class BuilderImpl extends CognitoSyncResponse.BuilderImpl implements Builder {
        private IdentityUsage identityUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityUsageResponse model) {
            super(model);
            identityUsage(model.identityUsage);
        }

        public final IdentityUsage.Builder getIdentityUsage() {
            return identityUsage != null ? identityUsage.toBuilder() : null;
        }

        public final void setIdentityUsage(IdentityUsage.BuilderImpl identityUsage) {
            this.identityUsage = identityUsage != null ? identityUsage.build() : null;
        }

        @Override
        public final Builder identityUsage(IdentityUsage identityUsage) {
            this.identityUsage = identityUsage;
            return this;
        }

        @Override
        public DescribeIdentityUsageResponse build() {
            return new DescribeIdentityUsageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
