/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authentication applied to incoming webhook trigger requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WebhookAuthConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<WebhookAuthConfiguration.Builder, WebhookAuthConfiguration> {
    private static final SdkField<String> ALLOWED_IP_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowedIPRange").getter(getter(WebhookAuthConfiguration::allowedIPRange))
            .setter(setter(Builder::allowedIPRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedIPRange").build()).build();

    private static final SdkField<String> SECRET_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretToken").getter(getter(WebhookAuthConfiguration::secretToken)).setter(setter(Builder::secretToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_IP_RANGE_FIELD,
            SECRET_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String allowedIPRange;

    private final String secretToken;

    private WebhookAuthConfiguration(BuilderImpl builder) {
        this.allowedIPRange = builder.allowedIPRange;
        this.secretToken = builder.secretToken;
    }

    /**
     * <p>
     * The property used to configure acceptance of webhooks in an IP address range. For IP, only the
     * <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.
     * </p>
     * 
     * @return The property used to configure acceptance of webhooks in an IP address range. For IP, only the
     *         <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.
     */
    public final String allowedIPRange() {
        return allowedIPRange;
    }

    /**
     * <p>
     * The property used to configure GitHub authentication. For GITHUB_HMAC, only the <code>SecretToken</code> property
     * must be set.
     * </p>
     * <important>
     * <p>
     * When creating CodePipeline webhooks, do not use your own credentials or reuse the same secret token across
     * multiple webhooks. For optimal security, generate a unique secret token for each webhook you create. The secret
     * token is an arbitrary string that you provide, which GitHub uses to compute and sign the webhook payloads sent to
     * CodePipeline, for protecting the integrity and authenticity of the webhook payloads. Using your own credentials
     * or reusing the same token across multiple webhooks can lead to security vulnerabilities.
     * </p>
     * </important> <note>
     * <p>
     * If a secret token was provided, it will be redacted in the response.
     * </p>
     * </note>
     * 
     * @return The property used to configure GitHub authentication. For GITHUB_HMAC, only the <code>SecretToken</code>
     *         property must be set.</p> <important>
     *         <p>
     *         When creating CodePipeline webhooks, do not use your own credentials or reuse the same secret token
     *         across multiple webhooks. For optimal security, generate a unique secret token for each webhook you
     *         create. The secret token is an arbitrary string that you provide, which GitHub uses to compute and sign
     *         the webhook payloads sent to CodePipeline, for protecting the integrity and authenticity of the webhook
     *         payloads. Using your own credentials or reusing the same token across multiple webhooks can lead to
     *         security vulnerabilities.
     *         </p>
     *         </important> <note>
     *         <p>
     *         If a secret token was provided, it will be redacted in the response.
     *         </p>
     */
    public final String secretToken() {
        return secretToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowedIPRange());
        hashCode = 31 * hashCode + Objects.hashCode(secretToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookAuthConfiguration)) {
            return false;
        }
        WebhookAuthConfiguration other = (WebhookAuthConfiguration) obj;
        return Objects.equals(allowedIPRange(), other.allowedIPRange()) && Objects.equals(secretToken(), other.secretToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WebhookAuthConfiguration").add("AllowedIPRange", allowedIPRange())
                .add("SecretToken", secretToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedIPRange":
            return Optional.ofNullable(clazz.cast(allowedIPRange()));
        case "SecretToken":
            return Optional.ofNullable(clazz.cast(secretToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllowedIPRange", ALLOWED_IP_RANGE_FIELD);
        map.put("SecretToken", SECRET_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WebhookAuthConfiguration, T> g) {
        return obj -> g.apply((WebhookAuthConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WebhookAuthConfiguration> {
        /**
         * <p>
         * The property used to configure acceptance of webhooks in an IP address range. For IP, only the
         * <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.
         * </p>
         * 
         * @param allowedIPRange
         *        The property used to configure acceptance of webhooks in an IP address range. For IP, only the
         *        <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedIPRange(String allowedIPRange);

        /**
         * <p>
         * The property used to configure GitHub authentication. For GITHUB_HMAC, only the <code>SecretToken</code>
         * property must be set.
         * </p>
         * <important>
         * <p>
         * When creating CodePipeline webhooks, do not use your own credentials or reuse the same secret token across
         * multiple webhooks. For optimal security, generate a unique secret token for each webhook you create. The
         * secret token is an arbitrary string that you provide, which GitHub uses to compute and sign the webhook
         * payloads sent to CodePipeline, for protecting the integrity and authenticity of the webhook payloads. Using
         * your own credentials or reusing the same token across multiple webhooks can lead to security vulnerabilities.
         * </p>
         * </important> <note>
         * <p>
         * If a secret token was provided, it will be redacted in the response.
         * </p>
         * </note>
         * 
         * @param secretToken
         *        The property used to configure GitHub authentication. For GITHUB_HMAC, only the
         *        <code>SecretToken</code> property must be set.</p> <important>
         *        <p>
         *        When creating CodePipeline webhooks, do not use your own credentials or reuse the same secret token
         *        across multiple webhooks. For optimal security, generate a unique secret token for each webhook you
         *        create. The secret token is an arbitrary string that you provide, which GitHub uses to compute and
         *        sign the webhook payloads sent to CodePipeline, for protecting the integrity and authenticity of the
         *        webhook payloads. Using your own credentials or reusing the same token across multiple webhooks can
         *        lead to security vulnerabilities.
         *        </p>
         *        </important> <note>
         *        <p>
         *        If a secret token was provided, it will be redacted in the response.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretToken(String secretToken);
    }

    static final class BuilderImpl implements Builder {
        private String allowedIPRange;

        private String secretToken;

        private BuilderImpl() {
        }

        private BuilderImpl(WebhookAuthConfiguration model) {
            allowedIPRange(model.allowedIPRange);
            secretToken(model.secretToken);
        }

        public final String getAllowedIPRange() {
            return allowedIPRange;
        }

        public final void setAllowedIPRange(String allowedIPRange) {
            this.allowedIPRange = allowedIPRange;
        }

        @Override
        public final Builder allowedIPRange(String allowedIPRange) {
            this.allowedIPRange = allowedIPRange;
            return this;
        }

        public final String getSecretToken() {
            return secretToken;
        }

        public final void setSecretToken(String secretToken) {
            this.secretToken = secretToken;
        }

        @Override
        public final Builder secretToken(String secretToken) {
            this.secretToken = secretToken;
            return this;
        }

        @Override
        public WebhookAuthConfiguration build() {
            return new WebhookAuthConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
