/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the state of the stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StageState implements SdkPojo, Serializable, ToCopyableBuilder<StageState.Builder, StageState> {
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageName").getter(getter(StageState::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()).build();

    private static final SdkField<StageExecution> INBOUND_EXECUTION_FIELD = SdkField
            .<StageExecution> builder(MarshallingType.SDK_POJO).memberName("inboundExecution")
            .getter(getter(StageState::inboundExecution)).setter(setter(Builder::inboundExecution))
            .constructor(StageExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundExecution").build()).build();

    private static final SdkField<List<StageExecution>> INBOUND_EXECUTIONS_FIELD = SdkField
            .<List<StageExecution>> builder(MarshallingType.LIST)
            .memberName("inboundExecutions")
            .getter(getter(StageState::inboundExecutions))
            .setter(setter(Builder::inboundExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StageExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(StageExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TransitionState> INBOUND_TRANSITION_STATE_FIELD = SdkField
            .<TransitionState> builder(MarshallingType.SDK_POJO).memberName("inboundTransitionState")
            .getter(getter(StageState::inboundTransitionState)).setter(setter(Builder::inboundTransitionState))
            .constructor(TransitionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inboundTransitionState").build())
            .build();

    private static final SdkField<List<ActionState>> ACTION_STATES_FIELD = SdkField
            .<List<ActionState>> builder(MarshallingType.LIST)
            .memberName("actionStates")
            .getter(getter(StageState::actionStates))
            .setter(setter(Builder::actionStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionState> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StageExecution> LATEST_EXECUTION_FIELD = SdkField
            .<StageExecution> builder(MarshallingType.SDK_POJO).memberName("latestExecution")
            .getter(getter(StageState::latestExecution)).setter(setter(Builder::latestExecution))
            .constructor(StageExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()).build();

    private static final SdkField<StageConditionState> BEFORE_ENTRY_CONDITION_STATE_FIELD = SdkField
            .<StageConditionState> builder(MarshallingType.SDK_POJO).memberName("beforeEntryConditionState")
            .getter(getter(StageState::beforeEntryConditionState)).setter(setter(Builder::beforeEntryConditionState))
            .constructor(StageConditionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeEntryConditionState").build())
            .build();

    private static final SdkField<StageConditionState> ON_SUCCESS_CONDITION_STATE_FIELD = SdkField
            .<StageConditionState> builder(MarshallingType.SDK_POJO).memberName("onSuccessConditionState")
            .getter(getter(StageState::onSuccessConditionState)).setter(setter(Builder::onSuccessConditionState))
            .constructor(StageConditionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onSuccessConditionState").build())
            .build();

    private static final SdkField<StageConditionState> ON_FAILURE_CONDITION_STATE_FIELD = SdkField
            .<StageConditionState> builder(MarshallingType.SDK_POJO).memberName("onFailureConditionState")
            .getter(getter(StageState::onFailureConditionState)).setter(setter(Builder::onFailureConditionState))
            .constructor(StageConditionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onFailureConditionState").build())
            .build();

    private static final SdkField<RetryStageMetadata> RETRY_STAGE_METADATA_FIELD = SdkField
            .<RetryStageMetadata> builder(MarshallingType.SDK_POJO).memberName("retryStageMetadata")
            .getter(getter(StageState::retryStageMetadata)).setter(setter(Builder::retryStageMetadata))
            .constructor(RetryStageMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryStageMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_NAME_FIELD,
            INBOUND_EXECUTION_FIELD, INBOUND_EXECUTIONS_FIELD, INBOUND_TRANSITION_STATE_FIELD, ACTION_STATES_FIELD,
            LATEST_EXECUTION_FIELD, BEFORE_ENTRY_CONDITION_STATE_FIELD, ON_SUCCESS_CONDITION_STATE_FIELD,
            ON_FAILURE_CONDITION_STATE_FIELD, RETRY_STAGE_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stageName;

    private final StageExecution inboundExecution;

    private final List<StageExecution> inboundExecutions;

    private final TransitionState inboundTransitionState;

    private final List<ActionState> actionStates;

    private final StageExecution latestExecution;

    private final StageConditionState beforeEntryConditionState;

    private final StageConditionState onSuccessConditionState;

    private final StageConditionState onFailureConditionState;

    private final RetryStageMetadata retryStageMetadata;

    private StageState(BuilderImpl builder) {
        this.stageName = builder.stageName;
        this.inboundExecution = builder.inboundExecution;
        this.inboundExecutions = builder.inboundExecutions;
        this.inboundTransitionState = builder.inboundTransitionState;
        this.actionStates = builder.actionStates;
        this.latestExecution = builder.latestExecution;
        this.beforeEntryConditionState = builder.beforeEntryConditionState;
        this.onSuccessConditionState = builder.onSuccessConditionState;
        this.onFailureConditionState = builder.onFailureConditionState;
        this.retryStageMetadata = builder.retryStageMetadata;
    }

    /**
     * <p>
     * The name of the stage.
     * </p>
     * 
     * @return The name of the stage.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * Returns the value of the InboundExecution property for this object.
     * 
     * @return The value of the InboundExecution property for this object.
     */
    public final StageExecution inboundExecution() {
        return inboundExecution;
    }

    /**
     * For responses, this returns true if the service returned a value for the InboundExecutions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInboundExecutions() {
        return inboundExecutions != null && !(inboundExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inbound executions for a stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInboundExecutions} method.
     * </p>
     * 
     * @return The inbound executions for a stage.
     */
    public final List<StageExecution> inboundExecutions() {
        return inboundExecutions;
    }

    /**
     * <p>
     * The state of the inbound transition, which is either enabled or disabled.
     * </p>
     * 
     * @return The state of the inbound transition, which is either enabled or disabled.
     */
    public final TransitionState inboundTransitionState() {
        return inboundTransitionState;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionStates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionStates() {
        return actionStates != null && !(actionStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The state of the stage.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionStates} method.
     * </p>
     * 
     * @return The state of the stage.
     */
    public final List<ActionState> actionStates() {
        return actionStates;
    }

    /**
     * <p>
     * Information about the latest execution in the stage, including its ID and status.
     * </p>
     * 
     * @return Information about the latest execution in the stage, including its ID and status.
     */
    public final StageExecution latestExecution() {
        return latestExecution;
    }

    /**
     * <p>
     * The state of the entry conditions for a stage.
     * </p>
     * 
     * @return The state of the entry conditions for a stage.
     */
    public final StageConditionState beforeEntryConditionState() {
        return beforeEntryConditionState;
    }

    /**
     * <p>
     * The state of the success conditions for a stage.
     * </p>
     * 
     * @return The state of the success conditions for a stage.
     */
    public final StageConditionState onSuccessConditionState() {
        return onSuccessConditionState;
    }

    /**
     * <p>
     * The state of the failure conditions for a stage.
     * </p>
     * 
     * @return The state of the failure conditions for a stage.
     */
    public final StageConditionState onFailureConditionState() {
        return onFailureConditionState;
    }

    /**
     * <p>
     * he details of a specific automatic retry on stage failure, including the attempt number and trigger.
     * </p>
     * 
     * @return he details of a specific automatic retry on stage failure, including the attempt number and trigger.
     */
    public final RetryStageMetadata retryStageMetadata() {
        return retryStageMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(inboundExecution());
        hashCode = 31 * hashCode + Objects.hashCode(hasInboundExecutions() ? inboundExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inboundTransitionState());
        hashCode = 31 * hashCode + Objects.hashCode(hasActionStates() ? actionStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(beforeEntryConditionState());
        hashCode = 31 * hashCode + Objects.hashCode(onSuccessConditionState());
        hashCode = 31 * hashCode + Objects.hashCode(onFailureConditionState());
        hashCode = 31 * hashCode + Objects.hashCode(retryStageMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StageState)) {
            return false;
        }
        StageState other = (StageState) obj;
        return Objects.equals(stageName(), other.stageName()) && Objects.equals(inboundExecution(), other.inboundExecution())
                && hasInboundExecutions() == other.hasInboundExecutions()
                && Objects.equals(inboundExecutions(), other.inboundExecutions())
                && Objects.equals(inboundTransitionState(), other.inboundTransitionState())
                && hasActionStates() == other.hasActionStates() && Objects.equals(actionStates(), other.actionStates())
                && Objects.equals(latestExecution(), other.latestExecution())
                && Objects.equals(beforeEntryConditionState(), other.beforeEntryConditionState())
                && Objects.equals(onSuccessConditionState(), other.onSuccessConditionState())
                && Objects.equals(onFailureConditionState(), other.onFailureConditionState())
                && Objects.equals(retryStageMetadata(), other.retryStageMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StageState").add("StageName", stageName()).add("InboundExecution", inboundExecution())
                .add("InboundExecutions", hasInboundExecutions() ? inboundExecutions() : null)
                .add("InboundTransitionState", inboundTransitionState())
                .add("ActionStates", hasActionStates() ? actionStates() : null).add("LatestExecution", latestExecution())
                .add("BeforeEntryConditionState", beforeEntryConditionState())
                .add("OnSuccessConditionState", onSuccessConditionState())
                .add("OnFailureConditionState", onFailureConditionState()).add("RetryStageMetadata", retryStageMetadata())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "inboundExecution":
            return Optional.ofNullable(clazz.cast(inboundExecution()));
        case "inboundExecutions":
            return Optional.ofNullable(clazz.cast(inboundExecutions()));
        case "inboundTransitionState":
            return Optional.ofNullable(clazz.cast(inboundTransitionState()));
        case "actionStates":
            return Optional.ofNullable(clazz.cast(actionStates()));
        case "latestExecution":
            return Optional.ofNullable(clazz.cast(latestExecution()));
        case "beforeEntryConditionState":
            return Optional.ofNullable(clazz.cast(beforeEntryConditionState()));
        case "onSuccessConditionState":
            return Optional.ofNullable(clazz.cast(onSuccessConditionState()));
        case "onFailureConditionState":
            return Optional.ofNullable(clazz.cast(onFailureConditionState()));
        case "retryStageMetadata":
            return Optional.ofNullable(clazz.cast(retryStageMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stageName", STAGE_NAME_FIELD);
        map.put("inboundExecution", INBOUND_EXECUTION_FIELD);
        map.put("inboundExecutions", INBOUND_EXECUTIONS_FIELD);
        map.put("inboundTransitionState", INBOUND_TRANSITION_STATE_FIELD);
        map.put("actionStates", ACTION_STATES_FIELD);
        map.put("latestExecution", LATEST_EXECUTION_FIELD);
        map.put("beforeEntryConditionState", BEFORE_ENTRY_CONDITION_STATE_FIELD);
        map.put("onSuccessConditionState", ON_SUCCESS_CONDITION_STATE_FIELD);
        map.put("onFailureConditionState", ON_FAILURE_CONDITION_STATE_FIELD);
        map.put("retryStageMetadata", RETRY_STAGE_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StageState, T> g) {
        return obj -> g.apply((StageState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StageState> {
        /**
         * <p>
         * The name of the stage.
         * </p>
         * 
         * @param stageName
         *        The name of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * Sets the value of the InboundExecution property for this object.
         *
         * @param inboundExecution
         *        The new value for the InboundExecution property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundExecution(StageExecution inboundExecution);

        /**
         * Sets the value of the InboundExecution property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StageExecution.Builder} avoiding the need
         * to create one manually via {@link StageExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #inboundExecution(StageExecution)}.
         * 
         * @param inboundExecution
         *        a consumer that will call methods on {@link StageExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundExecution(StageExecution)
         */
        default Builder inboundExecution(Consumer<StageExecution.Builder> inboundExecution) {
            return inboundExecution(StageExecution.builder().applyMutation(inboundExecution).build());
        }

        /**
         * <p>
         * The inbound executions for a stage.
         * </p>
         * 
         * @param inboundExecutions
         *        The inbound executions for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundExecutions(Collection<StageExecution> inboundExecutions);

        /**
         * <p>
         * The inbound executions for a stage.
         * </p>
         * 
         * @param inboundExecutions
         *        The inbound executions for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundExecutions(StageExecution... inboundExecutions);

        /**
         * <p>
         * The inbound executions for a stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.StageExecution.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codepipeline.model.StageExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.StageExecution.Builder#build()} is called
         * immediately and its result is passed to {@link #inboundExecutions(List<StageExecution>)}.
         * 
         * @param inboundExecutions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.StageExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundExecutions(java.util.Collection<StageExecution>)
         */
        Builder inboundExecutions(Consumer<StageExecution.Builder>... inboundExecutions);

        /**
         * <p>
         * The state of the inbound transition, which is either enabled or disabled.
         * </p>
         * 
         * @param inboundTransitionState
         *        The state of the inbound transition, which is either enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboundTransitionState(TransitionState inboundTransitionState);

        /**
         * <p>
         * The state of the inbound transition, which is either enabled or disabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransitionState.Builder} avoiding the
         * need to create one manually via {@link TransitionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransitionState.Builder#build()} is called immediately and its
         * result is passed to {@link #inboundTransitionState(TransitionState)}.
         * 
         * @param inboundTransitionState
         *        a consumer that will call methods on {@link TransitionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inboundTransitionState(TransitionState)
         */
        default Builder inboundTransitionState(Consumer<TransitionState.Builder> inboundTransitionState) {
            return inboundTransitionState(TransitionState.builder().applyMutation(inboundTransitionState).build());
        }

        /**
         * <p>
         * The state of the stage.
         * </p>
         * 
         * @param actionStates
         *        The state of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionStates(Collection<ActionState> actionStates);

        /**
         * <p>
         * The state of the stage.
         * </p>
         * 
         * @param actionStates
         *        The state of the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionStates(ActionState... actionStates);

        /**
         * <p>
         * The state of the stage.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionState.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codepipeline.model.ActionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.ActionState.Builder#build()} is called immediately
         * and its result is passed to {@link #actionStates(List<ActionState>)}.
         * 
         * @param actionStates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.ActionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionStates(java.util.Collection<ActionState>)
         */
        Builder actionStates(Consumer<ActionState.Builder>... actionStates);

        /**
         * <p>
         * Information about the latest execution in the stage, including its ID and status.
         * </p>
         * 
         * @param latestExecution
         *        Information about the latest execution in the stage, including its ID and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestExecution(StageExecution latestExecution);

        /**
         * <p>
         * Information about the latest execution in the stage, including its ID and status.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageExecution.Builder} avoiding the need
         * to create one manually via {@link StageExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #latestExecution(StageExecution)}.
         * 
         * @param latestExecution
         *        a consumer that will call methods on {@link StageExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestExecution(StageExecution)
         */
        default Builder latestExecution(Consumer<StageExecution.Builder> latestExecution) {
            return latestExecution(StageExecution.builder().applyMutation(latestExecution).build());
        }

        /**
         * <p>
         * The state of the entry conditions for a stage.
         * </p>
         * 
         * @param beforeEntryConditionState
         *        The state of the entry conditions for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeEntryConditionState(StageConditionState beforeEntryConditionState);

        /**
         * <p>
         * The state of the entry conditions for a stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageConditionState.Builder} avoiding the
         * need to create one manually via {@link StageConditionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageConditionState.Builder#build()} is called immediately and
         * its result is passed to {@link #beforeEntryConditionState(StageConditionState)}.
         * 
         * @param beforeEntryConditionState
         *        a consumer that will call methods on {@link StageConditionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #beforeEntryConditionState(StageConditionState)
         */
        default Builder beforeEntryConditionState(Consumer<StageConditionState.Builder> beforeEntryConditionState) {
            return beforeEntryConditionState(StageConditionState.builder().applyMutation(beforeEntryConditionState).build());
        }

        /**
         * <p>
         * The state of the success conditions for a stage.
         * </p>
         * 
         * @param onSuccessConditionState
         *        The state of the success conditions for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onSuccessConditionState(StageConditionState onSuccessConditionState);

        /**
         * <p>
         * The state of the success conditions for a stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageConditionState.Builder} avoiding the
         * need to create one manually via {@link StageConditionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageConditionState.Builder#build()} is called immediately and
         * its result is passed to {@link #onSuccessConditionState(StageConditionState)}.
         * 
         * @param onSuccessConditionState
         *        a consumer that will call methods on {@link StageConditionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onSuccessConditionState(StageConditionState)
         */
        default Builder onSuccessConditionState(Consumer<StageConditionState.Builder> onSuccessConditionState) {
            return onSuccessConditionState(StageConditionState.builder().applyMutation(onSuccessConditionState).build());
        }

        /**
         * <p>
         * The state of the failure conditions for a stage.
         * </p>
         * 
         * @param onFailureConditionState
         *        The state of the failure conditions for a stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onFailureConditionState(StageConditionState onFailureConditionState);

        /**
         * <p>
         * The state of the failure conditions for a stage.
         * </p>
         * This is a convenience method that creates an instance of the {@link StageConditionState.Builder} avoiding the
         * need to create one manually via {@link StageConditionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StageConditionState.Builder#build()} is called immediately and
         * its result is passed to {@link #onFailureConditionState(StageConditionState)}.
         * 
         * @param onFailureConditionState
         *        a consumer that will call methods on {@link StageConditionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onFailureConditionState(StageConditionState)
         */
        default Builder onFailureConditionState(Consumer<StageConditionState.Builder> onFailureConditionState) {
            return onFailureConditionState(StageConditionState.builder().applyMutation(onFailureConditionState).build());
        }

        /**
         * <p>
         * he details of a specific automatic retry on stage failure, including the attempt number and trigger.
         * </p>
         * 
         * @param retryStageMetadata
         *        he details of a specific automatic retry on stage failure, including the attempt number and trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryStageMetadata(RetryStageMetadata retryStageMetadata);

        /**
         * <p>
         * he details of a specific automatic retry on stage failure, including the attempt number and trigger.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetryStageMetadata.Builder} avoiding the
         * need to create one manually via {@link RetryStageMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetryStageMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #retryStageMetadata(RetryStageMetadata)}.
         * 
         * @param retryStageMetadata
         *        a consumer that will call methods on {@link RetryStageMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryStageMetadata(RetryStageMetadata)
         */
        default Builder retryStageMetadata(Consumer<RetryStageMetadata.Builder> retryStageMetadata) {
            return retryStageMetadata(RetryStageMetadata.builder().applyMutation(retryStageMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stageName;

        private StageExecution inboundExecution;

        private List<StageExecution> inboundExecutions = DefaultSdkAutoConstructList.getInstance();

        private TransitionState inboundTransitionState;

        private List<ActionState> actionStates = DefaultSdkAutoConstructList.getInstance();

        private StageExecution latestExecution;

        private StageConditionState beforeEntryConditionState;

        private StageConditionState onSuccessConditionState;

        private StageConditionState onFailureConditionState;

        private RetryStageMetadata retryStageMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(StageState model) {
            stageName(model.stageName);
            inboundExecution(model.inboundExecution);
            inboundExecutions(model.inboundExecutions);
            inboundTransitionState(model.inboundTransitionState);
            actionStates(model.actionStates);
            latestExecution(model.latestExecution);
            beforeEntryConditionState(model.beforeEntryConditionState);
            onSuccessConditionState(model.onSuccessConditionState);
            onFailureConditionState(model.onFailureConditionState);
            retryStageMetadata(model.retryStageMetadata);
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final StageExecution.Builder getInboundExecution() {
            return inboundExecution != null ? inboundExecution.toBuilder() : null;
        }

        public final void setInboundExecution(StageExecution.BuilderImpl inboundExecution) {
            this.inboundExecution = inboundExecution != null ? inboundExecution.build() : null;
        }

        @Override
        public final Builder inboundExecution(StageExecution inboundExecution) {
            this.inboundExecution = inboundExecution;
            return this;
        }

        public final List<StageExecution.Builder> getInboundExecutions() {
            List<StageExecution.Builder> result = StageExecutionListCopier.copyToBuilder(this.inboundExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInboundExecutions(Collection<StageExecution.BuilderImpl> inboundExecutions) {
            this.inboundExecutions = StageExecutionListCopier.copyFromBuilder(inboundExecutions);
        }

        @Override
        public final Builder inboundExecutions(Collection<StageExecution> inboundExecutions) {
            this.inboundExecutions = StageExecutionListCopier.copy(inboundExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundExecutions(StageExecution... inboundExecutions) {
            inboundExecutions(Arrays.asList(inboundExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inboundExecutions(Consumer<StageExecution.Builder>... inboundExecutions) {
            inboundExecutions(Stream.of(inboundExecutions).map(c -> StageExecution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TransitionState.Builder getInboundTransitionState() {
            return inboundTransitionState != null ? inboundTransitionState.toBuilder() : null;
        }

        public final void setInboundTransitionState(TransitionState.BuilderImpl inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState != null ? inboundTransitionState.build() : null;
        }

        @Override
        public final Builder inboundTransitionState(TransitionState inboundTransitionState) {
            this.inboundTransitionState = inboundTransitionState;
            return this;
        }

        public final List<ActionState.Builder> getActionStates() {
            List<ActionState.Builder> result = ActionStateListCopier.copyToBuilder(this.actionStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionStates(Collection<ActionState.BuilderImpl> actionStates) {
            this.actionStates = ActionStateListCopier.copyFromBuilder(actionStates);
        }

        @Override
        public final Builder actionStates(Collection<ActionState> actionStates) {
            this.actionStates = ActionStateListCopier.copy(actionStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(ActionState... actionStates) {
            actionStates(Arrays.asList(actionStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionStates(Consumer<ActionState.Builder>... actionStates) {
            actionStates(Stream.of(actionStates).map(c -> ActionState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StageExecution.Builder getLatestExecution() {
            return latestExecution != null ? latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(StageExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(StageExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final StageConditionState.Builder getBeforeEntryConditionState() {
            return beforeEntryConditionState != null ? beforeEntryConditionState.toBuilder() : null;
        }

        public final void setBeforeEntryConditionState(StageConditionState.BuilderImpl beforeEntryConditionState) {
            this.beforeEntryConditionState = beforeEntryConditionState != null ? beforeEntryConditionState.build() : null;
        }

        @Override
        public final Builder beforeEntryConditionState(StageConditionState beforeEntryConditionState) {
            this.beforeEntryConditionState = beforeEntryConditionState;
            return this;
        }

        public final StageConditionState.Builder getOnSuccessConditionState() {
            return onSuccessConditionState != null ? onSuccessConditionState.toBuilder() : null;
        }

        public final void setOnSuccessConditionState(StageConditionState.BuilderImpl onSuccessConditionState) {
            this.onSuccessConditionState = onSuccessConditionState != null ? onSuccessConditionState.build() : null;
        }

        @Override
        public final Builder onSuccessConditionState(StageConditionState onSuccessConditionState) {
            this.onSuccessConditionState = onSuccessConditionState;
            return this;
        }

        public final StageConditionState.Builder getOnFailureConditionState() {
            return onFailureConditionState != null ? onFailureConditionState.toBuilder() : null;
        }

        public final void setOnFailureConditionState(StageConditionState.BuilderImpl onFailureConditionState) {
            this.onFailureConditionState = onFailureConditionState != null ? onFailureConditionState.build() : null;
        }

        @Override
        public final Builder onFailureConditionState(StageConditionState onFailureConditionState) {
            this.onFailureConditionState = onFailureConditionState;
            return this;
        }

        public final RetryStageMetadata.Builder getRetryStageMetadata() {
            return retryStageMetadata != null ? retryStageMetadata.toBuilder() : null;
        }

        public final void setRetryStageMetadata(RetryStageMetadata.BuilderImpl retryStageMetadata) {
            this.retryStageMetadata = retryStageMetadata != null ? retryStageMetadata.build() : null;
        }

        @Override
        public final Builder retryStageMetadata(RetryStageMetadata retryStageMetadata) {
            this.retryStageMetadata = retryStageMetadata;
            return this;
        }

        @Override
        public StageState build() {
            return new StageState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
