/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutWebhookResponse extends CodePipelineResponse implements
        ToCopyableBuilder<PutWebhookResponse.Builder, PutWebhookResponse> {
    private static final SdkField<ListWebhookItem> WEBHOOK_FIELD = SdkField.<ListWebhookItem> builder(MarshallingType.SDK_POJO)
            .memberName("webhook").getter(getter(PutWebhookResponse::webhook)).setter(setter(Builder::webhook))
            .constructor(ListWebhookItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webhook").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBHOOK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ListWebhookItem webhook;

    private PutWebhookResponse(BuilderImpl builder) {
        super(builder);
        this.webhook = builder.webhook;
    }

    /**
     * <p>
     * The detail returned from creating the webhook, such as the webhook name, webhook URL, and webhook ARN.
     * </p>
     * 
     * @return The detail returned from creating the webhook, such as the webhook name, webhook URL, and webhook ARN.
     */
    public final ListWebhookItem webhook() {
        return webhook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webhook());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutWebhookResponse)) {
            return false;
        }
        PutWebhookResponse other = (PutWebhookResponse) obj;
        return Objects.equals(webhook(), other.webhook());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutWebhookResponse").add("Webhook", webhook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "webhook":
            return Optional.ofNullable(clazz.cast(webhook()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("webhook", WEBHOOK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutWebhookResponse, T> g) {
        return obj -> g.apply((PutWebhookResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodePipelineResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutWebhookResponse> {
        /**
         * <p>
         * The detail returned from creating the webhook, such as the webhook name, webhook URL, and webhook ARN.
         * </p>
         * 
         * @param webhook
         *        The detail returned from creating the webhook, such as the webhook name, webhook URL, and webhook ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webhook(ListWebhookItem webhook);

        /**
         * <p>
         * The detail returned from creating the webhook, such as the webhook name, webhook URL, and webhook ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListWebhookItem.Builder} avoiding the
         * need to create one manually via {@link ListWebhookItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListWebhookItem.Builder#build()} is called immediately and its
         * result is passed to {@link #webhook(ListWebhookItem)}.
         * 
         * @param webhook
         *        a consumer that will call methods on {@link ListWebhookItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webhook(ListWebhookItem)
         */
        default Builder webhook(Consumer<ListWebhookItem.Builder> webhook) {
            return webhook(ListWebhookItem.builder().applyMutation(webhook).build());
        }
    }

    static final class BuilderImpl extends CodePipelineResponse.BuilderImpl implements Builder {
        private ListWebhookItem webhook;

        private BuilderImpl() {
        }

        private BuilderImpl(PutWebhookResponse model) {
            super(model);
            webhook(model.webhook);
        }

        public final ListWebhookItem.Builder getWebhook() {
            return webhook != null ? webhook.toBuilder() : null;
        }

        public final void setWebhook(ListWebhookItem.BuilderImpl webhook) {
            this.webhook = webhook != null ? webhook.build() : null;
        }

        @Override
        public final Builder webhook(ListWebhookItem webhook) {
            this.webhook = webhook;
            return this;
        }

        @Override
        public PutWebhookResponse build() {
            return new PutWebhookResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
