/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>PollForJobs</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PollForJobsRequest extends CodePipelineRequest implements
        ToCopyableBuilder<PollForJobsRequest.Builder, PollForJobsRequest> {
    private static final SdkField<ActionTypeId> ACTION_TYPE_ID_FIELD = SdkField.<ActionTypeId> builder(MarshallingType.SDK_POJO)
            .memberName("actionTypeId").getter(getter(PollForJobsRequest::actionTypeId)).setter(setter(Builder::actionTypeId))
            .constructor(ActionTypeId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypeId").build()).build();

    private static final SdkField<Integer> MAX_BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxBatchSize").getter(getter(PollForJobsRequest::maxBatchSize)).setter(setter(Builder::maxBatchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchSize").build()).build();

    private static final SdkField<Map<String, String>> QUERY_PARAM_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("queryParam")
            .getter(getter(PollForJobsRequest::queryParam))
            .setter(setter(Builder::queryParam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryParam").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_ID_FIELD,
            MAX_BATCH_SIZE_FIELD, QUERY_PARAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ActionTypeId actionTypeId;

    private final Integer maxBatchSize;

    private final Map<String, String> queryParam;

    private PollForJobsRequest(BuilderImpl builder) {
        super(builder);
        this.actionTypeId = builder.actionTypeId;
        this.maxBatchSize = builder.maxBatchSize;
        this.queryParam = builder.queryParam;
    }

    /**
     * <p>
     * Represents information about an action type.
     * </p>
     * 
     * @return Represents information about an action type.
     */
    public final ActionTypeId actionTypeId() {
        return actionTypeId;
    }

    /**
     * <p>
     * The maximum number of jobs to return in a poll for jobs call.
     * </p>
     * 
     * @return The maximum number of jobs to return in a poll for jobs call.
     */
    public final Integer maxBatchSize() {
        return maxBatchSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryParam property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueryParam() {
        return queryParam != null && !(queryParam instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of property names and values. For an action type with no queryable properties, this value must be null or
     * an empty map. For an action type with a queryable property, you must supply that property as a key in the map.
     * Only jobs whose action configuration matches the mapped value are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryParam} method.
     * </p>
     * 
     * @return A map of property names and values. For an action type with no queryable properties, this value must be
     *         null or an empty map. For an action type with a queryable property, you must supply that property as a
     *         key in the map. Only jobs whose action configuration matches the mapped value are returned.
     */
    public final Map<String, String> queryParam() {
        return queryParam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(maxBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryParam() ? queryParam() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PollForJobsRequest)) {
            return false;
        }
        PollForJobsRequest other = (PollForJobsRequest) obj;
        return Objects.equals(actionTypeId(), other.actionTypeId()) && Objects.equals(maxBatchSize(), other.maxBatchSize())
                && hasQueryParam() == other.hasQueryParam() && Objects.equals(queryParam(), other.queryParam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PollForJobsRequest").add("ActionTypeId", actionTypeId()).add("MaxBatchSize", maxBatchSize())
                .add("QueryParam", hasQueryParam() ? queryParam() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionTypeId":
            return Optional.ofNullable(clazz.cast(actionTypeId()));
        case "maxBatchSize":
            return Optional.ofNullable(clazz.cast(maxBatchSize()));
        case "queryParam":
            return Optional.ofNullable(clazz.cast(queryParam()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionTypeId", ACTION_TYPE_ID_FIELD);
        map.put("maxBatchSize", MAX_BATCH_SIZE_FIELD);
        map.put("queryParam", QUERY_PARAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PollForJobsRequest, T> g) {
        return obj -> g.apply((PollForJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodePipelineRequest.Builder, SdkPojo, CopyableBuilder<Builder, PollForJobsRequest> {
        /**
         * <p>
         * Represents information about an action type.
         * </p>
         * 
         * @param actionTypeId
         *        Represents information about an action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionTypeId(ActionTypeId actionTypeId);

        /**
         * <p>
         * Represents information about an action type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionTypeId.Builder} avoiding the need
         * to create one manually via {@link ActionTypeId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionTypeId.Builder#build()} is called immediately and its
         * result is passed to {@link #actionTypeId(ActionTypeId)}.
         * 
         * @param actionTypeId
         *        a consumer that will call methods on {@link ActionTypeId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionTypeId(ActionTypeId)
         */
        default Builder actionTypeId(Consumer<ActionTypeId.Builder> actionTypeId) {
            return actionTypeId(ActionTypeId.builder().applyMutation(actionTypeId).build());
        }

        /**
         * <p>
         * The maximum number of jobs to return in a poll for jobs call.
         * </p>
         * 
         * @param maxBatchSize
         *        The maximum number of jobs to return in a poll for jobs call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBatchSize(Integer maxBatchSize);

        /**
         * <p>
         * A map of property names and values. For an action type with no queryable properties, this value must be null
         * or an empty map. For an action type with a queryable property, you must supply that property as a key in the
         * map. Only jobs whose action configuration matches the mapped value are returned.
         * </p>
         * 
         * @param queryParam
         *        A map of property names and values. For an action type with no queryable properties, this value must
         *        be null or an empty map. For an action type with a queryable property, you must supply that property
         *        as a key in the map. Only jobs whose action configuration matches the mapped value are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParam(Map<String, String> queryParam);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodePipelineRequest.BuilderImpl implements Builder {
        private ActionTypeId actionTypeId;

        private Integer maxBatchSize;

        private Map<String, String> queryParam = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PollForJobsRequest model) {
            super(model);
            actionTypeId(model.actionTypeId);
            maxBatchSize(model.maxBatchSize);
            queryParam(model.queryParam);
        }

        public final ActionTypeId.Builder getActionTypeId() {
            return actionTypeId != null ? actionTypeId.toBuilder() : null;
        }

        public final void setActionTypeId(ActionTypeId.BuilderImpl actionTypeId) {
            this.actionTypeId = actionTypeId != null ? actionTypeId.build() : null;
        }

        @Override
        public final Builder actionTypeId(ActionTypeId actionTypeId) {
            this.actionTypeId = actionTypeId;
            return this;
        }

        public final Integer getMaxBatchSize() {
            return maxBatchSize;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final Map<String, String> getQueryParam() {
            if (queryParam instanceof SdkAutoConstructMap) {
                return null;
            }
            return queryParam;
        }

        public final void setQueryParam(Map<String, String> queryParam) {
            this.queryParam = QueryParamMapCopier.copy(queryParam);
        }

        @Override
        public final Builder queryParam(Map<String, String> queryParam) {
            this.queryParam = QueryParamMapCopier.copy(queryParam);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PollForJobsRequest build() {
            return new PollForJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
