/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the specified trigger configuration, such as the filter criteria and the source stage
 * for the action that contains the trigger.
 * </p>
 * <note>
 * <p>
 * This is only supported for the <code>CodeStarSourceConnection</code> action type.
 * </p>
 * </note> <note>
 * <p>
 * When a trigger configuration is specified, default change detection for repository and branch commits is disabled.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineTriggerDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineTriggerDeclaration.Builder, PipelineTriggerDeclaration> {
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerType").getter(getter(PipelineTriggerDeclaration::providerTypeAsString))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerType").build()).build();

    private static final SdkField<GitConfiguration> GIT_CONFIGURATION_FIELD = SdkField
            .<GitConfiguration> builder(MarshallingType.SDK_POJO).memberName("gitConfiguration")
            .getter(getter(PipelineTriggerDeclaration::gitConfiguration)).setter(setter(Builder::gitConfiguration))
            .constructor(GitConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_TYPE_FIELD,
            GIT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String providerType;

    private final GitConfiguration gitConfiguration;

    private PipelineTriggerDeclaration(BuilderImpl builder) {
        this.providerType = builder.providerType;
        this.gitConfiguration = builder.gitConfiguration;
    }

    /**
     * <p>
     * The source provider for the event, such as connections configured for a repository with Git tags, for the
     * specified trigger configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link PipelineTriggerProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The source provider for the event, such as connections configured for a repository with Git tags, for the
     *         specified trigger configuration.
     * @see PipelineTriggerProviderType
     */
    public final PipelineTriggerProviderType providerType() {
        return PipelineTriggerProviderType.fromValue(providerType);
    }

    /**
     * <p>
     * The source provider for the event, such as connections configured for a repository with Git tags, for the
     * specified trigger configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #providerType} will
     * return {@link PipelineTriggerProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #providerTypeAsString}.
     * </p>
     * 
     * @return The source provider for the event, such as connections configured for a repository with Git tags, for the
     *         specified trigger configuration.
     * @see PipelineTriggerProviderType
     */
    public final String providerTypeAsString() {
        return providerType;
    }

    /**
     * <p>
     * Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git
     * tags.
     * </p>
     * 
     * @return Provides the filter criteria and the source stage for the repository event that starts the pipeline, such
     *         as Git tags.
     */
    public final GitConfiguration gitConfiguration() {
        return gitConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gitConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineTriggerDeclaration)) {
            return false;
        }
        PipelineTriggerDeclaration other = (PipelineTriggerDeclaration) obj;
        return Objects.equals(providerTypeAsString(), other.providerTypeAsString())
                && Objects.equals(gitConfiguration(), other.gitConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineTriggerDeclaration").add("ProviderType", providerTypeAsString())
                .add("GitConfiguration", gitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "providerType":
            return Optional.ofNullable(clazz.cast(providerTypeAsString()));
        case "gitConfiguration":
            return Optional.ofNullable(clazz.cast(gitConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("providerType", PROVIDER_TYPE_FIELD);
        map.put("gitConfiguration", GIT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineTriggerDeclaration, T> g) {
        return obj -> g.apply((PipelineTriggerDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineTriggerDeclaration> {
        /**
         * <p>
         * The source provider for the event, such as connections configured for a repository with Git tags, for the
         * specified trigger configuration.
         * </p>
         * 
         * @param providerType
         *        The source provider for the event, such as connections configured for a repository with Git tags, for
         *        the specified trigger configuration.
         * @see PipelineTriggerProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineTriggerProviderType
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The source provider for the event, such as connections configured for a repository with Git tags, for the
         * specified trigger configuration.
         * </p>
         * 
         * @param providerType
         *        The source provider for the event, such as connections configured for a repository with Git tags, for
         *        the specified trigger configuration.
         * @see PipelineTriggerProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineTriggerProviderType
         */
        Builder providerType(PipelineTriggerProviderType providerType);

        /**
         * <p>
         * Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as
         * Git tags.
         * </p>
         * 
         * @param gitConfiguration
         *        Provides the filter criteria and the source stage for the repository event that starts the pipeline,
         *        such as Git tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitConfiguration(GitConfiguration gitConfiguration);

        /**
         * <p>
         * Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as
         * Git tags.
         * </p>
         * This is a convenience method that creates an instance of the {@link GitConfiguration.Builder} avoiding the
         * need to create one manually via {@link GitConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GitConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #gitConfiguration(GitConfiguration)}.
         * 
         * @param gitConfiguration
         *        a consumer that will call methods on {@link GitConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gitConfiguration(GitConfiguration)
         */
        default Builder gitConfiguration(Consumer<GitConfiguration.Builder> gitConfiguration) {
            return gitConfiguration(GitConfiguration.builder().applyMutation(gitConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String providerType;

        private GitConfiguration gitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineTriggerDeclaration model) {
            providerType(model.providerType);
            gitConfiguration(model.gitConfiguration);
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(PipelineTriggerProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final GitConfiguration.Builder getGitConfiguration() {
            return gitConfiguration != null ? gitConfiguration.toBuilder() : null;
        }

        public final void setGitConfiguration(GitConfiguration.BuilderImpl gitConfiguration) {
            this.gitConfiguration = gitConfiguration != null ? gitConfiguration.build() : null;
        }

        @Override
        public final Builder gitConfiguration(GitConfiguration gitConfiguration) {
            this.gitConfiguration = gitConfiguration;
            return this;
        }

        @Override
        public PipelineTriggerDeclaration build() {
            return new PipelineTriggerDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
