/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Git tags specified as filter criteria for whether a Git tag repository event will start the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GitTagFilterCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<GitTagFilterCriteria.Builder, GitTagFilterCriteria> {
    private static final SdkField<List<String>> INCLUDES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("includes")
            .getter(getter(GitTagFilterCriteria::includes))
            .setter(setter(Builder::includes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("excludes")
            .getter(getter(GitTagFilterCriteria::excludes))
            .setter(setter(Builder::excludes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INCLUDES_FIELD, EXCLUDES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> includes;

    private final List<String> excludes;

    private GitTagFilterCriteria(BuilderImpl builder) {
        this.includes = builder.includes;
        this.excludes = builder.excludes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Includes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIncludes() {
        return includes != null && !(includes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludes} method.
     * </p>
     * 
     * @return The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the
     *         pipeline.
     */
    public final List<String> includes() {
        return includes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Excludes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExcludes() {
        return excludes != null && !(excludes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludes} method.
     * </p>
     * 
     * @return The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
     */
    public final List<String> excludes() {
        return excludes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludes() ? includes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludes() ? excludes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitTagFilterCriteria)) {
            return false;
        }
        GitTagFilterCriteria other = (GitTagFilterCriteria) obj;
        return hasIncludes() == other.hasIncludes() && Objects.equals(includes(), other.includes())
                && hasExcludes() == other.hasExcludes() && Objects.equals(excludes(), other.excludes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GitTagFilterCriteria").add("Includes", hasIncludes() ? includes() : null)
                .add("Excludes", hasExcludes() ? excludes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includes":
            return Optional.ofNullable(clazz.cast(includes()));
        case "excludes":
            return Optional.ofNullable(clazz.cast(excludes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("includes", INCLUDES_FIELD);
        map.put("excludes", EXCLUDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GitTagFilterCriteria, T> g) {
        return obj -> g.apply((GitTagFilterCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GitTagFilterCriteria> {
        /**
         * <p>
         * The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
         * </p>
         * 
         * @param includes
         *        The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the
         *        pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(Collection<String> includes);

        /**
         * <p>
         * The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
         * </p>
         * 
         * @param includes
         *        The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the
         *        pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includes(String... includes);

        /**
         * <p>
         * The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
         * </p>
         * 
         * @param excludes
         *        The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(Collection<String> excludes);

        /**
         * <p>
         * The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
         * </p>
         * 
         * @param excludes
         *        The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludes(String... excludes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> includes = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GitTagFilterCriteria model) {
            includes(model.includes);
            excludes(model.excludes);
        }

        public final Collection<String> getIncludes() {
            if (includes instanceof SdkAutoConstructList) {
                return null;
            }
            return includes;
        }

        public final void setIncludes(Collection<String> includes) {
            this.includes = GitTagPatternListCopier.copy(includes);
        }

        @Override
        public final Builder includes(Collection<String> includes) {
            this.includes = GitTagPatternListCopier.copy(includes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includes(String... includes) {
            includes(Arrays.asList(includes));
            return this;
        }

        public final Collection<String> getExcludes() {
            if (excludes instanceof SdkAutoConstructList) {
                return null;
            }
            return excludes;
        }

        public final void setExcludes(Collection<String> excludes) {
            this.excludes = GitTagPatternListCopier.copy(excludes);
        }

        @Override
        public final Builder excludes(Collection<String> excludes) {
            this.excludes = GitTagPatternListCopier.copy(excludes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludes(String... excludes) {
            excludes(Arrays.asList(excludes));
            return this;
        }

        @Override
        public GitTagFilterCriteria build() {
            return new GitTagFilterCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
