/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the state of the condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionState implements SdkPojo, Serializable, ToCopyableBuilder<ConditionState.Builder, ConditionState> {
    private static final SdkField<ConditionExecution> LATEST_EXECUTION_FIELD = SdkField
            .<ConditionExecution> builder(MarshallingType.SDK_POJO).memberName("latestExecution")
            .getter(getter(ConditionState::latestExecution)).setter(setter(Builder::latestExecution))
            .constructor(ConditionExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestExecution").build()).build();

    private static final SdkField<List<RuleState>> RULE_STATES_FIELD = SdkField
            .<List<RuleState>> builder(MarshallingType.LIST)
            .memberName("ruleStates")
            .getter(getter(ConditionState::ruleStates))
            .setter(setter(Builder::ruleStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuleState> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuleState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_EXECUTION_FIELD,
            RULE_STATES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConditionExecution latestExecution;

    private final List<RuleState> ruleStates;

    private ConditionState(BuilderImpl builder) {
        this.latestExecution = builder.latestExecution;
        this.ruleStates = builder.ruleStates;
    }

    /**
     * <p>
     * The state of the latest run of the rule.
     * </p>
     * 
     * @return The state of the latest run of the rule.
     */
    public final ConditionExecution latestExecution() {
        return latestExecution;
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleStates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRuleStates() {
        return ruleStates != null && !(ruleStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The state of the rules for the condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleStates} method.
     * </p>
     * 
     * @return The state of the rules for the condition.
     */
    public final List<RuleState> ruleStates() {
        return ruleStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latestExecution());
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleStates() ? ruleStates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionState)) {
            return false;
        }
        ConditionState other = (ConditionState) obj;
        return Objects.equals(latestExecution(), other.latestExecution()) && hasRuleStates() == other.hasRuleStates()
                && Objects.equals(ruleStates(), other.ruleStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionState").add("LatestExecution", latestExecution())
                .add("RuleStates", hasRuleStates() ? ruleStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latestExecution":
            return Optional.ofNullable(clazz.cast(latestExecution()));
        case "ruleStates":
            return Optional.ofNullable(clazz.cast(ruleStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("latestExecution", LATEST_EXECUTION_FIELD);
        map.put("ruleStates", RULE_STATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionState, T> g) {
        return obj -> g.apply((ConditionState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionState> {
        /**
         * <p>
         * The state of the latest run of the rule.
         * </p>
         * 
         * @param latestExecution
         *        The state of the latest run of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestExecution(ConditionExecution latestExecution);

        /**
         * <p>
         * The state of the latest run of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionExecution.Builder} avoiding the
         * need to create one manually via {@link ConditionExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #latestExecution(ConditionExecution)}.
         * 
         * @param latestExecution
         *        a consumer that will call methods on {@link ConditionExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestExecution(ConditionExecution)
         */
        default Builder latestExecution(Consumer<ConditionExecution.Builder> latestExecution) {
            return latestExecution(ConditionExecution.builder().applyMutation(latestExecution).build());
        }

        /**
         * <p>
         * The state of the rules for the condition.
         * </p>
         * 
         * @param ruleStates
         *        The state of the rules for the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleStates(Collection<RuleState> ruleStates);

        /**
         * <p>
         * The state of the rules for the condition.
         * </p>
         * 
         * @param ruleStates
         *        The state of the rules for the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleStates(RuleState... ruleStates);

        /**
         * <p>
         * The state of the rules for the condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codepipeline.model.RuleState.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codepipeline.model.RuleState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codepipeline.model.RuleState.Builder#build()} is called immediately
         * and its result is passed to {@link #ruleStates(List<RuleState>)}.
         * 
         * @param ruleStates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codepipeline.model.RuleState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleStates(java.util.Collection<RuleState>)
         */
        Builder ruleStates(Consumer<RuleState.Builder>... ruleStates);
    }

    static final class BuilderImpl implements Builder {
        private ConditionExecution latestExecution;

        private List<RuleState> ruleStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionState model) {
            latestExecution(model.latestExecution);
            ruleStates(model.ruleStates);
        }

        public final ConditionExecution.Builder getLatestExecution() {
            return latestExecution != null ? latestExecution.toBuilder() : null;
        }

        public final void setLatestExecution(ConditionExecution.BuilderImpl latestExecution) {
            this.latestExecution = latestExecution != null ? latestExecution.build() : null;
        }

        @Override
        public final Builder latestExecution(ConditionExecution latestExecution) {
            this.latestExecution = latestExecution;
            return this;
        }

        public final List<RuleState.Builder> getRuleStates() {
            List<RuleState.Builder> result = RuleStateListCopier.copyToBuilder(this.ruleStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleStates(Collection<RuleState.BuilderImpl> ruleStates) {
            this.ruleStates = RuleStateListCopier.copyFromBuilder(ruleStates);
        }

        @Override
        public final Builder ruleStates(Collection<RuleState> ruleStates) {
            this.ruleStates = RuleStateListCopier.copy(ruleStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleStates(RuleState... ruleStates) {
            ruleStates(Arrays.asList(ruleStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleStates(Consumer<RuleState.Builder>... ruleStates) {
            ruleStates(Stream.of(ruleStates).map(c -> RuleState.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConditionState build() {
            return new ConditionState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
