/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The run of a condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionExecution.Builder, ConditionExecution> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ConditionExecution::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("summary")
            .getter(getter(ConditionExecution::summary)).setter(setter(Builder::summary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<Instant> LAST_STATUS_CHANGE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStatusChange").getter(getter(ConditionExecution::lastStatusChange))
            .setter(setter(Builder::lastStatusChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, SUMMARY_FIELD,
            LAST_STATUS_CHANGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String summary;

    private final Instant lastStatusChange;

    private ConditionExecution(BuilderImpl builder) {
        this.status = builder.status;
        this.summary = builder.summary;
        this.lastStatusChange = builder.lastStatusChange;
    }

    /**
     * <p>
     * The status of the run for a condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConditionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the run for a condition.
     * @see ConditionExecutionStatus
     */
    public final ConditionExecutionStatus status() {
        return ConditionExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the run for a condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConditionExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the run for a condition.
     * @see ConditionExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The summary of information about a run for a condition.
     * </p>
     * 
     * @return The summary of information about a run for a condition.
     */
    public final String summary() {
        return summary;
    }

    /**
     * <p>
     * The last status change of the condition.
     * </p>
     * 
     * @return The last status change of the condition.
     */
    public final Instant lastStatusChange() {
        return lastStatusChange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatusChange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionExecution)) {
            return false;
        }
        ConditionExecution other = (ConditionExecution) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(summary(), other.summary())
                && Objects.equals(lastStatusChange(), other.lastStatusChange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionExecution").add("Status", statusAsString()).add("Summary", summary())
                .add("LastStatusChange", lastStatusChange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "lastStatusChange":
            return Optional.ofNullable(clazz.cast(lastStatusChange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("summary", SUMMARY_FIELD);
        map.put("lastStatusChange", LAST_STATUS_CHANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConditionExecution, T> g) {
        return obj -> g.apply((ConditionExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionExecution> {
        /**
         * <p>
         * The status of the run for a condition.
         * </p>
         * 
         * @param status
         *        The status of the run for a condition.
         * @see ConditionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the run for a condition.
         * </p>
         * 
         * @param status
         *        The status of the run for a condition.
         * @see ConditionExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConditionExecutionStatus
         */
        Builder status(ConditionExecutionStatus status);

        /**
         * <p>
         * The summary of information about a run for a condition.
         * </p>
         * 
         * @param summary
         *        The summary of information about a run for a condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(String summary);

        /**
         * <p>
         * The last status change of the condition.
         * </p>
         * 
         * @param lastStatusChange
         *        The last status change of the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatusChange(Instant lastStatusChange);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String summary;

        private Instant lastStatusChange;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionExecution model) {
            status(model.status);
            summary(model.summary);
            lastStatusChange(model.lastStatusChange);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConditionExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSummary() {
            return summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public final Instant getLastStatusChange() {
            return lastStatusChange;
        }

        public final void setLastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
        }

        @Override
        public final Builder lastStatusChange(Instant lastStatusChange) {
            this.lastStatusChange = lastStatusChange;
            return this;
        }

        @Override
        public ConditionExecution build() {
            return new ConditionExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
