/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Execution result information, such as the external execution ID.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionExecutionResult implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionExecutionResult.Builder, ActionExecutionResult> {
    private static final SdkField<String> EXTERNAL_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalExecutionId").getter(getter(ActionExecutionResult::externalExecutionId))
            .setter(setter(Builder::externalExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionId").build())
            .build();

    private static final SdkField<String> EXTERNAL_EXECUTION_SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalExecutionSummary").getter(getter(ActionExecutionResult::externalExecutionSummary))
            .setter(setter(Builder::externalExecutionSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionSummary").build())
            .build();

    private static final SdkField<String> EXTERNAL_EXECUTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalExecutionUrl").getter(getter(ActionExecutionResult::externalExecutionUrl))
            .setter(setter(Builder::externalExecutionUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalExecutionUrl").build())
            .build();

    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("errorDetails").getter(getter(ActionExecutionResult::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()).build();

    private static final SdkField<String> LOG_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logStreamARN").getter(getter(ActionExecutionResult::logStreamARN)).setter(setter(Builder::logStreamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_EXECUTION_ID_FIELD,
            EXTERNAL_EXECUTION_SUMMARY_FIELD, EXTERNAL_EXECUTION_URL_FIELD, ERROR_DETAILS_FIELD, LOG_STREAM_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String externalExecutionId;

    private final String externalExecutionSummary;

    private final String externalExecutionUrl;

    private final ErrorDetails errorDetails;

    private final String logStreamARN;

    private ActionExecutionResult(BuilderImpl builder) {
        this.externalExecutionId = builder.externalExecutionId;
        this.externalExecutionSummary = builder.externalExecutionSummary;
        this.externalExecutionUrl = builder.externalExecutionUrl;
        this.errorDetails = builder.errorDetails;
        this.logStreamARN = builder.logStreamARN;
    }

    /**
     * <p>
     * The action provider's external ID for the action execution.
     * </p>
     * 
     * @return The action provider's external ID for the action execution.
     */
    public final String externalExecutionId() {
        return externalExecutionId;
    }

    /**
     * <p>
     * The action provider's summary for the action execution.
     * </p>
     * 
     * @return The action provider's summary for the action execution.
     */
    public final String externalExecutionSummary() {
        return externalExecutionSummary;
    }

    /**
     * <p>
     * The deepest external link to the external resource (for example, a repository URL or deployment endpoint) that is
     * used when running the action.
     * </p>
     * 
     * @return The deepest external link to the external resource (for example, a repository URL or deployment endpoint)
     *         that is used when running the action.
     */
    public final String externalExecutionUrl() {
        return externalExecutionUrl;
    }

    /**
     * Returns the value of the ErrorDetails property for this object.
     * 
     * @return The value of the ErrorDetails property for this object.
     */
    public final ErrorDetails errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the log stream for the action compute.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the log stream for the action compute.
     */
    public final String logStreamARN() {
        return logStreamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(externalExecutionUrl());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(logStreamARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionResult)) {
            return false;
        }
        ActionExecutionResult other = (ActionExecutionResult) obj;
        return Objects.equals(externalExecutionId(), other.externalExecutionId())
                && Objects.equals(externalExecutionSummary(), other.externalExecutionSummary())
                && Objects.equals(externalExecutionUrl(), other.externalExecutionUrl())
                && Objects.equals(errorDetails(), other.errorDetails()) && Objects.equals(logStreamARN(), other.logStreamARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionExecutionResult").add("ExternalExecutionId", externalExecutionId())
                .add("ExternalExecutionSummary", externalExecutionSummary()).add("ExternalExecutionUrl", externalExecutionUrl())
                .add("ErrorDetails", errorDetails()).add("LogStreamARN", logStreamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "externalExecutionId":
            return Optional.ofNullable(clazz.cast(externalExecutionId()));
        case "externalExecutionSummary":
            return Optional.ofNullable(clazz.cast(externalExecutionSummary()));
        case "externalExecutionUrl":
            return Optional.ofNullable(clazz.cast(externalExecutionUrl()));
        case "errorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "logStreamARN":
            return Optional.ofNullable(clazz.cast(logStreamARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("externalExecutionId", EXTERNAL_EXECUTION_ID_FIELD);
        map.put("externalExecutionSummary", EXTERNAL_EXECUTION_SUMMARY_FIELD);
        map.put("externalExecutionUrl", EXTERNAL_EXECUTION_URL_FIELD);
        map.put("errorDetails", ERROR_DETAILS_FIELD);
        map.put("logStreamARN", LOG_STREAM_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionResult, T> g) {
        return obj -> g.apply((ActionExecutionResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionExecutionResult> {
        /**
         * <p>
         * The action provider's external ID for the action execution.
         * </p>
         * 
         * @param externalExecutionId
         *        The action provider's external ID for the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionId(String externalExecutionId);

        /**
         * <p>
         * The action provider's summary for the action execution.
         * </p>
         * 
         * @param externalExecutionSummary
         *        The action provider's summary for the action execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionSummary(String externalExecutionSummary);

        /**
         * <p>
         * The deepest external link to the external resource (for example, a repository URL or deployment endpoint)
         * that is used when running the action.
         * </p>
         * 
         * @param externalExecutionUrl
         *        The deepest external link to the external resource (for example, a repository URL or deployment
         *        endpoint) that is used when running the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalExecutionUrl(String externalExecutionUrl);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * @param errorDetails
         *        The new value for the ErrorDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetails errorDetails);

        /**
         * Sets the value of the ErrorDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(ErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ErrorDetails)
         */
        default Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return errorDetails(ErrorDetails.builder().applyMutation(errorDetails).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the log stream for the action compute.
         * </p>
         * 
         * @param logStreamARN
         *        The Amazon Resource Name (ARN) of the log stream for the action compute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamARN(String logStreamARN);
    }

    static final class BuilderImpl implements Builder {
        private String externalExecutionId;

        private String externalExecutionSummary;

        private String externalExecutionUrl;

        private ErrorDetails errorDetails;

        private String logStreamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionResult model) {
            externalExecutionId(model.externalExecutionId);
            externalExecutionSummary(model.externalExecutionSummary);
            externalExecutionUrl(model.externalExecutionUrl);
            errorDetails(model.errorDetails);
            logStreamARN(model.logStreamARN);
        }

        public final String getExternalExecutionId() {
            return externalExecutionId;
        }

        public final void setExternalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
        }

        @Override
        public final Builder externalExecutionId(String externalExecutionId) {
            this.externalExecutionId = externalExecutionId;
            return this;
        }

        public final String getExternalExecutionSummary() {
            return externalExecutionSummary;
        }

        public final void setExternalExecutionSummary(String externalExecutionSummary) {
            this.externalExecutionSummary = externalExecutionSummary;
        }

        @Override
        public final Builder externalExecutionSummary(String externalExecutionSummary) {
            this.externalExecutionSummary = externalExecutionSummary;
            return this;
        }

        public final String getExternalExecutionUrl() {
            return externalExecutionUrl;
        }

        public final void setExternalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
        }

        @Override
        public final Builder externalExecutionUrl(String externalExecutionUrl) {
            this.externalExecutionUrl = externalExecutionUrl;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getLogStreamARN() {
            return logStreamARN;
        }

        public final void setLogStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
        }

        @Override
        public final Builder logStreamARN(String logStreamARN) {
            this.logStreamARN = logStreamARN;
            return this;
        }

        @Override
        public ActionExecutionResult build() {
            return new ActionExecutionResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
