/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the values for reactions to a comment. CodeCommit supports a limited set of reactions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReactionValueFormats implements SdkPojo, Serializable,
        ToCopyableBuilder<ReactionValueFormats.Builder, ReactionValueFormats> {
    private static final SdkField<String> EMOJI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("emoji")
            .getter(getter(ReactionValueFormats::emoji)).setter(setter(Builder::emoji))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emoji").build()).build();

    private static final SdkField<String> SHORT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shortCode").getter(getter(ReactionValueFormats::shortCode)).setter(setter(Builder::shortCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortCode").build()).build();

    private static final SdkField<String> UNICODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unicode")
            .getter(getter(ReactionValueFormats::unicode)).setter(setter(Builder::unicode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unicode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMOJI_FIELD, SHORT_CODE_FIELD,
            UNICODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String emoji;

    private final String shortCode;

    private final String unicode;

    private ReactionValueFormats(BuilderImpl builder) {
        this.emoji = builder.emoji;
        this.shortCode = builder.shortCode;
        this.unicode = builder.unicode;
    }

    /**
     * <p>
     * The Emoji Version 1.0 graphic of the reaction. These graphics are interpreted slightly differently on different
     * operating systems.
     * </p>
     * 
     * @return The Emoji Version 1.0 graphic of the reaction. These graphics are interpreted slightly differently on
     *         different operating systems.
     */
    public final String emoji() {
        return emoji;
    }

    /**
     * <p>
     * The emoji short code for the reaction. Short codes are interpreted slightly differently on different operating
     * systems.
     * </p>
     * 
     * @return The emoji short code for the reaction. Short codes are interpreted slightly differently on different
     *         operating systems.
     */
    public final String shortCode() {
        return shortCode;
    }

    /**
     * <p>
     * The Unicode codepoint for the reaction.
     * </p>
     * 
     * @return The Unicode codepoint for the reaction.
     */
    public final String unicode() {
        return unicode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emoji());
        hashCode = 31 * hashCode + Objects.hashCode(shortCode());
        hashCode = 31 * hashCode + Objects.hashCode(unicode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactionValueFormats)) {
            return false;
        }
        ReactionValueFormats other = (ReactionValueFormats) obj;
        return Objects.equals(emoji(), other.emoji()) && Objects.equals(shortCode(), other.shortCode())
                && Objects.equals(unicode(), other.unicode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReactionValueFormats").add("Emoji", emoji()).add("ShortCode", shortCode())
                .add("Unicode", unicode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "emoji":
            return Optional.ofNullable(clazz.cast(emoji()));
        case "shortCode":
            return Optional.ofNullable(clazz.cast(shortCode()));
        case "unicode":
            return Optional.ofNullable(clazz.cast(unicode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("emoji", EMOJI_FIELD);
        map.put("shortCode", SHORT_CODE_FIELD);
        map.put("unicode", UNICODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReactionValueFormats, T> g) {
        return obj -> g.apply((ReactionValueFormats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReactionValueFormats> {
        /**
         * <p>
         * The Emoji Version 1.0 graphic of the reaction. These graphics are interpreted slightly differently on
         * different operating systems.
         * </p>
         * 
         * @param emoji
         *        The Emoji Version 1.0 graphic of the reaction. These graphics are interpreted slightly differently on
         *        different operating systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emoji(String emoji);

        /**
         * <p>
         * The emoji short code for the reaction. Short codes are interpreted slightly differently on different
         * operating systems.
         * </p>
         * 
         * @param shortCode
         *        The emoji short code for the reaction. Short codes are interpreted slightly differently on different
         *        operating systems.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortCode(String shortCode);

        /**
         * <p>
         * The Unicode codepoint for the reaction.
         * </p>
         * 
         * @param unicode
         *        The Unicode codepoint for the reaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unicode(String unicode);
    }

    static final class BuilderImpl implements Builder {
        private String emoji;

        private String shortCode;

        private String unicode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReactionValueFormats model) {
            emoji(model.emoji);
            shortCode(model.shortCode);
            unicode(model.unicode);
        }

        public final String getEmoji() {
            return emoji;
        }

        public final void setEmoji(String emoji) {
            this.emoji = emoji;
        }

        @Override
        public final Builder emoji(String emoji) {
            this.emoji = emoji;
            return this;
        }

        public final String getShortCode() {
            return shortCode;
        }

        public final void setShortCode(String shortCode) {
            this.shortCode = shortCode;
        }

        @Override
        public final Builder shortCode(String shortCode) {
            this.shortCode = shortCode;
            return this;
        }

        public final String getUnicode() {
            return unicode;
        }

        public final void setUnicode(String unicode) {
            this.unicode = unicode;
        }

        @Override
        public final Builder unicode(String unicode) {
            this.unicode = unicode;
            return this;
        }

        @Override
        public ReactionValueFormats build() {
            return new ReactionValueFormats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
