/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about an approval rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApprovalRule implements SdkPojo, Serializable, ToCopyableBuilder<ApprovalRule.Builder, ApprovalRule> {
    private static final SdkField<String> APPROVAL_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleId").getter(getter(ApprovalRule::approvalRuleId)).setter(setter(Builder::approvalRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleId").build()).build();

    private static final SdkField<String> APPROVAL_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleName").getter(getter(ApprovalRule::approvalRuleName))
            .setter(setter(Builder::approvalRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleName").build()).build();

    private static final SdkField<String> APPROVAL_RULE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleContent").getter(getter(ApprovalRule::approvalRuleContent))
            .setter(setter(Builder::approvalRuleContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleContent").build())
            .build();

    private static final SdkField<String> RULE_CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleContentSha256").getter(getter(ApprovalRule::ruleContentSha256))
            .setter(setter(Builder::ruleContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleContentSha256").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(ApprovalRule::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(ApprovalRule::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> LAST_MODIFIED_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastModifiedUser").getter(getter(ApprovalRule::lastModifiedUser))
            .setter(setter(Builder::lastModifiedUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedUser").build()).build();

    private static final SdkField<OriginApprovalRuleTemplate> ORIGIN_APPROVAL_RULE_TEMPLATE_FIELD = SdkField
            .<OriginApprovalRuleTemplate> builder(MarshallingType.SDK_POJO)
            .memberName("originApprovalRuleTemplate")
            .getter(getter(ApprovalRule::originApprovalRuleTemplate))
            .setter(setter(Builder::originApprovalRuleTemplate))
            .constructor(OriginApprovalRuleTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originApprovalRuleTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVAL_RULE_ID_FIELD,
            APPROVAL_RULE_NAME_FIELD, APPROVAL_RULE_CONTENT_FIELD, RULE_CONTENT_SHA256_FIELD, LAST_MODIFIED_DATE_FIELD,
            CREATION_DATE_FIELD, LAST_MODIFIED_USER_FIELD, ORIGIN_APPROVAL_RULE_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String approvalRuleId;

    private final String approvalRuleName;

    private final String approvalRuleContent;

    private final String ruleContentSha256;

    private final Instant lastModifiedDate;

    private final Instant creationDate;

    private final String lastModifiedUser;

    private final OriginApprovalRuleTemplate originApprovalRuleTemplate;

    private ApprovalRule(BuilderImpl builder) {
        this.approvalRuleId = builder.approvalRuleId;
        this.approvalRuleName = builder.approvalRuleName;
        this.approvalRuleContent = builder.approvalRuleContent;
        this.ruleContentSha256 = builder.ruleContentSha256;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.lastModifiedUser = builder.lastModifiedUser;
        this.originApprovalRuleTemplate = builder.originApprovalRuleTemplate;
    }

    /**
     * <p>
     * The system-generated ID of the approval rule.
     * </p>
     * 
     * @return The system-generated ID of the approval rule.
     */
    public final String approvalRuleId() {
        return approvalRuleId;
    }

    /**
     * <p>
     * The name of the approval rule.
     * </p>
     * 
     * @return The name of the approval rule.
     */
    public final String approvalRuleName() {
        return approvalRuleName;
    }

    /**
     * <p>
     * The content of the approval rule.
     * </p>
     * 
     * @return The content of the approval rule.
     */
    public final String approvalRuleContent() {
        return approvalRuleContent;
    }

    /**
     * <p>
     * The SHA-256 hash signature for the content of the approval rule.
     * </p>
     * 
     * @return The SHA-256 hash signature for the content of the approval rule.
     */
    public final String ruleContentSha256() {
        return ruleContentSha256;
    }

    /**
     * <p>
     * The date the approval rule was most recently changed, in timestamp format.
     * </p>
     * 
     * @return The date the approval rule was most recently changed, in timestamp format.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The date the approval rule was created, in timestamp format.
     * </p>
     * 
     * @return The date the approval rule was created, in timestamp format.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.
     */
    public final String lastModifiedUser() {
        return lastModifiedUser;
    }

    /**
     * <p>
     * The approval rule template used to create the rule.
     * </p>
     * 
     * @return The approval rule template used to create the rule.
     */
    public final OriginApprovalRuleTemplate originApprovalRuleTemplate() {
        return originApprovalRuleTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleContent());
        hashCode = 31 * hashCode + Objects.hashCode(ruleContentSha256());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedUser());
        hashCode = 31 * hashCode + Objects.hashCode(originApprovalRuleTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovalRule)) {
            return false;
        }
        ApprovalRule other = (ApprovalRule) obj;
        return Objects.equals(approvalRuleId(), other.approvalRuleId())
                && Objects.equals(approvalRuleName(), other.approvalRuleName())
                && Objects.equals(approvalRuleContent(), other.approvalRuleContent())
                && Objects.equals(ruleContentSha256(), other.ruleContentSha256())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedUser(), other.lastModifiedUser())
                && Objects.equals(originApprovalRuleTemplate(), other.originApprovalRuleTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApprovalRule").add("ApprovalRuleId", approvalRuleId())
                .add("ApprovalRuleName", approvalRuleName()).add("ApprovalRuleContent", approvalRuleContent())
                .add("RuleContentSha256", ruleContentSha256()).add("LastModifiedDate", lastModifiedDate())
                .add("CreationDate", creationDate()).add("LastModifiedUser", lastModifiedUser())
                .add("OriginApprovalRuleTemplate", originApprovalRuleTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleId":
            return Optional.ofNullable(clazz.cast(approvalRuleId()));
        case "approvalRuleName":
            return Optional.ofNullable(clazz.cast(approvalRuleName()));
        case "approvalRuleContent":
            return Optional.ofNullable(clazz.cast(approvalRuleContent()));
        case "ruleContentSha256":
            return Optional.ofNullable(clazz.cast(ruleContentSha256()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedUser":
            return Optional.ofNullable(clazz.cast(lastModifiedUser()));
        case "originApprovalRuleTemplate":
            return Optional.ofNullable(clazz.cast(originApprovalRuleTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("approvalRuleId", APPROVAL_RULE_ID_FIELD);
        map.put("approvalRuleName", APPROVAL_RULE_NAME_FIELD);
        map.put("approvalRuleContent", APPROVAL_RULE_CONTENT_FIELD);
        map.put("ruleContentSha256", RULE_CONTENT_SHA256_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastModifiedUser", LAST_MODIFIED_USER_FIELD);
        map.put("originApprovalRuleTemplate", ORIGIN_APPROVAL_RULE_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApprovalRule, T> g) {
        return obj -> g.apply((ApprovalRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApprovalRule> {
        /**
         * <p>
         * The system-generated ID of the approval rule.
         * </p>
         * 
         * @param approvalRuleId
         *        The system-generated ID of the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleId(String approvalRuleId);

        /**
         * <p>
         * The name of the approval rule.
         * </p>
         * 
         * @param approvalRuleName
         *        The name of the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleName(String approvalRuleName);

        /**
         * <p>
         * The content of the approval rule.
         * </p>
         * 
         * @param approvalRuleContent
         *        The content of the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleContent(String approvalRuleContent);

        /**
         * <p>
         * The SHA-256 hash signature for the content of the approval rule.
         * </p>
         * 
         * @param ruleContentSha256
         *        The SHA-256 hash signature for the content of the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleContentSha256(String ruleContentSha256);

        /**
         * <p>
         * The date the approval rule was most recently changed, in timestamp format.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date the approval rule was most recently changed, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The date the approval rule was created, in timestamp format.
         * </p>
         * 
         * @param creationDate
         *        The date the approval rule was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.
         * </p>
         * 
         * @param lastModifiedUser
         *        The Amazon Resource Name (ARN) of the user who made the most recent changes to the approval rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedUser(String lastModifiedUser);

        /**
         * <p>
         * The approval rule template used to create the rule.
         * </p>
         * 
         * @param originApprovalRuleTemplate
         *        The approval rule template used to create the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originApprovalRuleTemplate(OriginApprovalRuleTemplate originApprovalRuleTemplate);

        /**
         * <p>
         * The approval rule template used to create the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link OriginApprovalRuleTemplate.Builder}
         * avoiding the need to create one manually via {@link OriginApprovalRuleTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OriginApprovalRuleTemplate.Builder#build()} is called immediately
         * and its result is passed to {@link #originApprovalRuleTemplate(OriginApprovalRuleTemplate)}.
         * 
         * @param originApprovalRuleTemplate
         *        a consumer that will call methods on {@link OriginApprovalRuleTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originApprovalRuleTemplate(OriginApprovalRuleTemplate)
         */
        default Builder originApprovalRuleTemplate(Consumer<OriginApprovalRuleTemplate.Builder> originApprovalRuleTemplate) {
            return originApprovalRuleTemplate(OriginApprovalRuleTemplate.builder().applyMutation(originApprovalRuleTemplate)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String approvalRuleId;

        private String approvalRuleName;

        private String approvalRuleContent;

        private String ruleContentSha256;

        private Instant lastModifiedDate;

        private Instant creationDate;

        private String lastModifiedUser;

        private OriginApprovalRuleTemplate originApprovalRuleTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovalRule model) {
            approvalRuleId(model.approvalRuleId);
            approvalRuleName(model.approvalRuleName);
            approvalRuleContent(model.approvalRuleContent);
            ruleContentSha256(model.ruleContentSha256);
            lastModifiedDate(model.lastModifiedDate);
            creationDate(model.creationDate);
            lastModifiedUser(model.lastModifiedUser);
            originApprovalRuleTemplate(model.originApprovalRuleTemplate);
        }

        public final String getApprovalRuleId() {
            return approvalRuleId;
        }

        public final void setApprovalRuleId(String approvalRuleId) {
            this.approvalRuleId = approvalRuleId;
        }

        @Override
        public final Builder approvalRuleId(String approvalRuleId) {
            this.approvalRuleId = approvalRuleId;
            return this;
        }

        public final String getApprovalRuleName() {
            return approvalRuleName;
        }

        public final void setApprovalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
        }

        @Override
        public final Builder approvalRuleName(String approvalRuleName) {
            this.approvalRuleName = approvalRuleName;
            return this;
        }

        public final String getApprovalRuleContent() {
            return approvalRuleContent;
        }

        public final void setApprovalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
        }

        @Override
        public final Builder approvalRuleContent(String approvalRuleContent) {
            this.approvalRuleContent = approvalRuleContent;
            return this;
        }

        public final String getRuleContentSha256() {
            return ruleContentSha256;
        }

        public final void setRuleContentSha256(String ruleContentSha256) {
            this.ruleContentSha256 = ruleContentSha256;
        }

        @Override
        public final Builder ruleContentSha256(String ruleContentSha256) {
            this.ruleContentSha256 = ruleContentSha256;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getLastModifiedUser() {
            return lastModifiedUser;
        }

        public final void setLastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
        }

        @Override
        public final Builder lastModifiedUser(String lastModifiedUser) {
            this.lastModifiedUser = lastModifiedUser;
            return this;
        }

        public final OriginApprovalRuleTemplate.Builder getOriginApprovalRuleTemplate() {
            return originApprovalRuleTemplate != null ? originApprovalRuleTemplate.toBuilder() : null;
        }

        public final void setOriginApprovalRuleTemplate(OriginApprovalRuleTemplate.BuilderImpl originApprovalRuleTemplate) {
            this.originApprovalRuleTemplate = originApprovalRuleTemplate != null ? originApprovalRuleTemplate.build() : null;
        }

        @Override
        public final Builder originApprovalRuleTemplate(OriginApprovalRuleTemplate originApprovalRuleTemplate) {
            this.originApprovalRuleTemplate = originApprovalRuleTemplate;
            return this;
        }

        @Override
        public ApprovalRule build() {
            return new ApprovalRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
