/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.codecommit.internal.CodeCommitServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.codecommit.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.codecommit.model.ActorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleNameAlreadyExistsException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateInUseException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateNameAlreadyExistsException;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ApprovalStateRequiredException;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.AssociateApprovalRuleTemplateWithRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.AuthorDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchAssociateApprovalRuleTemplateWithRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetCommitsResponse;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.BatchGetRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.BeforeCommitIdAndAfterCommitIdAreSameException;
import software.amazon.awssdk.services.codecommit.model.BlobIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BlobIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.BranchDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.BranchNameExistsException;
import software.amazon.awssdk.services.codecommit.model.BranchNameIsTagNameException;
import software.amazon.awssdk.services.codecommit.model.BranchNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.CannotDeleteApprovalRuleFromTemplateException;
import software.amazon.awssdk.services.codecommit.model.CannotModifyApprovalRuleFromTemplateException;
import software.amazon.awssdk.services.codecommit.model.ClientRequestTokenRequiredException;
import software.amazon.awssdk.services.codecommit.model.CodeCommitException;
import software.amazon.awssdk.services.codecommit.model.CommentContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommentDeletedException;
import software.amazon.awssdk.services.codecommit.model.CommentDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommentIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommentNotCreatedByCallerException;
import software.amazon.awssdk.services.codecommit.model.CommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.CommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitIdsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.CommitMessageLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.CommitRequiredException;
import software.amazon.awssdk.services.codecommit.model.ConcurrentReferenceUpdateException;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.CreateApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.CreateBranchRequest;
import software.amazon.awssdk.services.codecommit.model.CreateBranchResponse;
import software.amazon.awssdk.services.codecommit.model.CreateCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateCommitResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.CreatePullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.CreateUnreferencedMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.DefaultBranchCannotBeDeletedException;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteBranchResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteCommentContentResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteFileRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteFileResponse;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleRequest;
import software.amazon.awssdk.services.codecommit.model.DeletePullRequestApprovalRuleResponse;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribeMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsRequest;
import software.amazon.awssdk.services.codecommit.model.DescribePullRequestEventsResponse;
import software.amazon.awssdk.services.codecommit.model.DirectoryNameConflictsWithFileNameException;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.DisassociateApprovalRuleTemplateFromRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.EncryptionIntegrityChecksFailedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyAccessDeniedException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyDisabledException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyInvalidIdException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyInvalidUsageException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyNotFoundException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyRequiredException;
import software.amazon.awssdk.services.codecommit.model.EncryptionKeyUnavailableException;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.EvaluatePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.FileContentAndSourceFileSpecifiedException;
import software.amazon.awssdk.services.codecommit.model.FileContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FileDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.FileEntryRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileModeRequiredException;
import software.amazon.awssdk.services.codecommit.model.FileNameConflictsWithDirectoryNameException;
import software.amazon.awssdk.services.codecommit.model.FilePathConflictsWithSubmodulePathException;
import software.amazon.awssdk.services.codecommit.model.FileTooLargeException;
import software.amazon.awssdk.services.codecommit.model.FolderContentSizeLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.FolderDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.GetApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.GetBlobRequest;
import software.amazon.awssdk.services.codecommit.model.GetBlobResponse;
import software.amazon.awssdk.services.codecommit.model.GetBranchRequest;
import software.amazon.awssdk.services.codecommit.model.GetBranchResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentReactionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesRequest;
import software.amazon.awssdk.services.codecommit.model.GetDifferencesResponse;
import software.amazon.awssdk.services.codecommit.model.GetFileRequest;
import software.amazon.awssdk.services.codecommit.model.GetFileResponse;
import software.amazon.awssdk.services.codecommit.model.GetFolderRequest;
import software.amazon.awssdk.services.codecommit.model.GetFolderResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeConflictsResponse;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsRequest;
import software.amazon.awssdk.services.codecommit.model.GetMergeOptionsResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestApprovalStatesResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestOverrideStateResponse;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.GetPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.GetRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.IdempotencyParameterMismatchException;
import software.amazon.awssdk.services.codecommit.model.InvalidActorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalRuleTemplateNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidApprovalStateException;
import software.amazon.awssdk.services.codecommit.model.InvalidAuthorArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidBlobIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidClientRequestTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommentIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitException;
import software.amazon.awssdk.services.codecommit.model.InvalidCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictDetailLevelException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionException;
import software.amazon.awssdk.services.codecommit.model.InvalidConflictResolutionStrategyException;
import software.amazon.awssdk.services.codecommit.model.InvalidContinuationTokenException;
import software.amazon.awssdk.services.codecommit.model.InvalidDeletionParameterException;
import software.amazon.awssdk.services.codecommit.model.InvalidDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidDestinationCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidEmailException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileLocationException;
import software.amazon.awssdk.services.codecommit.model.InvalidFileModeException;
import software.amazon.awssdk.services.codecommit.model.InvalidFilePositionException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxConflictFilesException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxMergeHunksException;
import software.amazon.awssdk.services.codecommit.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.codecommit.model.InvalidMergeOptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidOrderException;
import software.amazon.awssdk.services.codecommit.model.InvalidOverrideStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidParentCommitIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPathException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestEventTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusException;
import software.amazon.awssdk.services.codecommit.model.InvalidPullRequestStatusUpdateException;
import software.amazon.awssdk.services.codecommit.model.InvalidReactionUserArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidReactionValueException;
import software.amazon.awssdk.services.codecommit.model.InvalidReferenceNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRelativeFileVersionEnumException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementContentException;
import software.amazon.awssdk.services.codecommit.model.InvalidReplacementTypeException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryDescriptionException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerBranchNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerCustomDataException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerDestinationArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerEventsException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerNameException;
import software.amazon.awssdk.services.codecommit.model.InvalidRepositoryTriggerRegionException;
import software.amazon.awssdk.services.codecommit.model.InvalidResourceArnException;
import software.amazon.awssdk.services.codecommit.model.InvalidRevisionIdException;
import software.amazon.awssdk.services.codecommit.model.InvalidRuleContentSha256Exception;
import software.amazon.awssdk.services.codecommit.model.InvalidSortByException;
import software.amazon.awssdk.services.codecommit.model.InvalidSourceCommitSpecifierException;
import software.amazon.awssdk.services.codecommit.model.InvalidSystemTagUsageException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagKeysListException;
import software.amazon.awssdk.services.codecommit.model.InvalidTagsMapException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetBranchException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetException;
import software.amazon.awssdk.services.codecommit.model.InvalidTargetsException;
import software.amazon.awssdk.services.codecommit.model.InvalidTitleException;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryRequest;
import software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse;
import software.amazon.awssdk.services.codecommit.model.ListBranchesRequest;
import software.amazon.awssdk.services.codecommit.model.ListBranchesResponse;
import software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryRequest;
import software.amazon.awssdk.services.codecommit.model.ListFileCommitHistoryResponse;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsRequest;
import software.amazon.awssdk.services.codecommit.model.ListPullRequestsResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesForApprovalRuleTemplateResponse;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codecommit.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.codecommit.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.codecommit.model.ManualMergeRequiredException;
import software.amazon.awssdk.services.codecommit.model.MaximumBranchesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumConflictResolutionEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileContentToLoadExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumFileEntriesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumItemsToCompareExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumNumberOfApprovalsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumOpenPullRequestsExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryNamesExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRepositoryTriggersExceededException;
import software.amazon.awssdk.services.codecommit.model.MaximumRuleTemplatesAssociatedWithRepositoryException;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergeBranchesByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MergeOptionRequiredException;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByFastForwardResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestBySquashResponse;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayRequest;
import software.amazon.awssdk.services.codecommit.model.MergePullRequestByThreeWayResponse;
import software.amazon.awssdk.services.codecommit.model.MultipleConflictResolutionEntriesException;
import software.amazon.awssdk.services.codecommit.model.MultipleRepositoriesInPullRequestException;
import software.amazon.awssdk.services.codecommit.model.NameLengthExceededException;
import software.amazon.awssdk.services.codecommit.model.NoChangeException;
import software.amazon.awssdk.services.codecommit.model.NumberOfRuleTemplatesExceededException;
import software.amazon.awssdk.services.codecommit.model.NumberOfRulesExceededException;
import software.amazon.awssdk.services.codecommit.model.OperationNotAllowedException;
import software.amazon.awssdk.services.codecommit.model.OverrideAlreadySetException;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesRequest;
import software.amazon.awssdk.services.codecommit.model.OverridePullRequestApprovalRulesResponse;
import software.amazon.awssdk.services.codecommit.model.OverrideStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdOutdatedException;
import software.amazon.awssdk.services.codecommit.model.ParentCommitIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PathDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PathRequiredException;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForComparedCommitResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentForPullRequestResponse;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyRequest;
import software.amazon.awssdk.services.codecommit.model.PostCommentReplyResponse;
import software.amazon.awssdk.services.codecommit.model.PullRequestAlreadyClosedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestApprovalRulesNotSatisfiedException;
import software.amazon.awssdk.services.codecommit.model.PullRequestCannotBeApprovedByAuthorException;
import software.amazon.awssdk.services.codecommit.model.PullRequestDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.PullRequestIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.PullRequestStatusRequiredException;
import software.amazon.awssdk.services.codecommit.model.PutCommentReactionRequest;
import software.amazon.awssdk.services.codecommit.model.PutCommentReactionResponse;
import software.amazon.awssdk.services.codecommit.model.PutFileEntryConflictException;
import software.amazon.awssdk.services.codecommit.model.PutFileRequest;
import software.amazon.awssdk.services.codecommit.model.PutFileResponse;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.PutRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.ReactionLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.ReactionValueRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReferenceDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.ReferenceNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReferenceTypeNotSupportedException;
import software.amazon.awssdk.services.codecommit.model.ReplacementContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.ReplacementTypeRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryDoesNotExistException;
import software.amazon.awssdk.services.codecommit.model.RepositoryLimitExceededException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameExistsException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNamesRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryNotAssociatedWithPullRequestException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerBranchNameListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerDestinationArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerEventsListRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerNameRequiredException;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggersListRequiredException;
import software.amazon.awssdk.services.codecommit.model.ResourceArnRequiredException;
import software.amazon.awssdk.services.codecommit.model.RestrictedSourceFileException;
import software.amazon.awssdk.services.codecommit.model.RevisionIdRequiredException;
import software.amazon.awssdk.services.codecommit.model.RevisionNotCurrentException;
import software.amazon.awssdk.services.codecommit.model.SameFileContentException;
import software.amazon.awssdk.services.codecommit.model.SamePathRequestException;
import software.amazon.awssdk.services.codecommit.model.SourceAndDestinationAreSameException;
import software.amazon.awssdk.services.codecommit.model.SourceFileOrContentRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagKeysListRequiredException;
import software.amazon.awssdk.services.codecommit.model.TagPolicyException;
import software.amazon.awssdk.services.codecommit.model.TagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.TagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.TagsMapRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetRequiredException;
import software.amazon.awssdk.services.codecommit.model.TargetsRequiredException;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersRequest;
import software.amazon.awssdk.services.codecommit.model.TestRepositoryTriggersResponse;
import software.amazon.awssdk.services.codecommit.model.TipOfSourceReferenceIsDifferentException;
import software.amazon.awssdk.services.codecommit.model.TipsDivergenceExceededException;
import software.amazon.awssdk.services.codecommit.model.TitleRequiredException;
import software.amazon.awssdk.services.codecommit.model.TooManyTagsException;
import software.amazon.awssdk.services.codecommit.model.UntagResourceRequest;
import software.amazon.awssdk.services.codecommit.model.UntagResourceResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateApprovalRuleTemplateNameResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateCommentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateDefaultBranchResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalRuleContentResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestApprovalStateResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestStatusResponse;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleRequest;
import software.amazon.awssdk.services.codecommit.model.UpdatePullRequestTitleResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryDescriptionResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryEncryptionKeyResponse;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameRequest;
import software.amazon.awssdk.services.codecommit.model.UpdateRepositoryNameResponse;
import software.amazon.awssdk.services.codecommit.transform.AssociateApprovalRuleTemplateWithRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchAssociateApprovalRuleTemplateWithRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchDescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchDisassociateApprovalRuleTemplateFromRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetCommitsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.BatchGetRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestApprovalRuleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreatePullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.CreateUnreferencedMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteCommentContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeletePullRequestApprovalRuleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribeMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DescribePullRequestEventsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.DisassociateApprovalRuleTemplateFromRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.EvaluatePullRequestApprovalRulesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBlobRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentReactionsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommentsForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetDifferencesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeConflictsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetMergeOptionsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestApprovalStatesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestOverrideStateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.GetRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListApprovalRuleTemplatesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListAssociatedApprovalRuleTemplatesForRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListBranchesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListFileCommitHistoryRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListPullRequestsRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesForApprovalRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergeBranchesByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByFastForwardRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestBySquashRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.MergePullRequestByThreeWayRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.OverridePullRequestApprovalRulesRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForComparedCommitRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentForPullRequestRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PostCommentReplyRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutCommentReactionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutFileRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.PutRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.TestRepositoryTriggersRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateApprovalRuleTemplateNameRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateCommentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateDefaultBranchRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestApprovalRuleContentRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestApprovalStateRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestStatusRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdatePullRequestTitleRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryDescriptionRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryEncryptionKeyRequestMarshaller;
import software.amazon.awssdk.services.codecommit.transform.UpdateRepositoryNameRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link CodeCommitClient}.
 *
 * @see CodeCommitClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCodeCommitClient implements CodeCommitClient {
    private static final Logger log = Logger.loggerFor(DefaultCodeCommitClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeCommitClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "CodeCommit" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Creates an association between an approval rule template and a specified repository. Then, the next time a pull
     * request is created in the repository where the destination reference (if specified) matches the destination
     * reference (branch) for the pull request, an approval rule that matches the template conditions is automatically
     * created for that pull request. If no destination references are specified in the template, an approval rule that
     * matches the template contents is created for all pull requests in that repository.
     * </p>
     *
     * @param associateApprovalRuleTemplateWithRepositoryRequest
     * @return Result of the AssociateApprovalRuleTemplateWithRepository operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Quotas</a> in the
     *         <i>CodeCommit User Guide</i>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the Amazon Web Services Region where the template was created, and then try again.
     * @throws MaximumRuleTemplatesAssociatedWithRepositoryException
     *         The maximum number of approval rule templates for a repository has been exceeded. You cannot associate
     *         more than 25 approval rule templates with a repository.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.AssociateApprovalRuleTemplateWithRepository
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/AssociateApprovalRuleTemplateWithRepository"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateApprovalRuleTemplateWithRepositoryResponse associateApprovalRuleTemplateWithRepository(
            AssociateApprovalRuleTemplateWithRepositoryRequest associateApprovalRuleTemplateWithRepositoryRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, MaximumRuleTemplatesAssociatedWithRepositoryException,
            RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateApprovalRuleTemplateWithRepositoryResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, AssociateApprovalRuleTemplateWithRepositoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                associateApprovalRuleTemplateWithRepositoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateApprovalRuleTemplateWithRepositoryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateApprovalRuleTemplateWithRepository");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateApprovalRuleTemplateWithRepositoryRequest, AssociateApprovalRuleTemplateWithRepositoryResponse>()
                            .withOperationName("AssociateApprovalRuleTemplateWithRepository")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withInput(associateApprovalRuleTemplateWithRepositoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateApprovalRuleTemplateWithRepositoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an association between an approval rule template and one or more specified repositories.
     * </p>
     *
     * @param batchAssociateApprovalRuleTemplateWithRepositoriesRequest
     * @return Result of the BatchAssociateApprovalRuleTemplateWithRepositories operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Quotas</a> in the
     *         <i>CodeCommit User Guide</i>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the Amazon Web Services Region where the template was created, and then try again.
     * @throws RepositoryNamesRequiredException
     *         At least one repository name object is required, but was not specified.
     * @throws MaximumRepositoryNamesExceededException
     *         The maximum number of allowed repository names was exceeded. Currently, this number is 100.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchAssociateApprovalRuleTemplateWithRepositories
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchAssociateApprovalRuleTemplateWithRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchAssociateApprovalRuleTemplateWithRepositoriesResponse batchAssociateApprovalRuleTemplateWithRepositories(
            BatchAssociateApprovalRuleTemplateWithRepositoriesRequest batchAssociateApprovalRuleTemplateWithRepositoriesRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, RepositoryNamesRequiredException, MaximumRepositoryNamesExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchAssociateApprovalRuleTemplateWithRepositoriesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchAssociateApprovalRuleTemplateWithRepositoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchAssociateApprovalRuleTemplateWithRepositoriesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchAssociateApprovalRuleTemplateWithRepositories");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchAssociateApprovalRuleTemplateWithRepositoriesRequest, BatchAssociateApprovalRuleTemplateWithRepositoriesResponse>()
                            .withOperationName("BatchAssociateApprovalRuleTemplateWithRepositories")
                            .withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(batchAssociateApprovalRuleTemplateWithRepositoriesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new BatchAssociateApprovalRuleTemplateWithRepositoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about one or more merge conflicts in the attempted merge of two commit specifiers using the
     * squash or three-way merge strategy.
     * </p>
     *
     * @param batchDescribeMergeConflictsRequest
     * @return Result of the BatchDescribeMergeConflicts operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws MergeOptionRequiredException
     *         A merge option or stategy is required, and none was provided.
     * @throws InvalidMergeOptionException
     *         The specified merge option is not valid for this operation. Not all merge strategies are supported for
     *         all operations.
     * @throws InvalidContinuationTokenException
     *         The specified continuation token is not valid.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws InvalidMaxConflictFilesException
     *         The specified value for the number of conflict files to return is not valid.
     * @throws InvalidMaxMergeHunksException
     *         The specified value for the number of merge hunks to return is not valid.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchDescribeMergeConflicts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDescribeMergeConflicts"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDescribeMergeConflictsResponse batchDescribeMergeConflicts(
            BatchDescribeMergeConflictsRequest batchDescribeMergeConflictsRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, MergeOptionRequiredException,
            InvalidMergeOptionException, InvalidContinuationTokenException, CommitRequiredException, CommitDoesNotExistException,
            InvalidCommitException, TipsDivergenceExceededException, InvalidMaxConflictFilesException,
            InvalidMaxMergeHunksException, InvalidConflictDetailLevelException, InvalidConflictResolutionStrategyException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDescribeMergeConflictsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDescribeMergeConflictsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDescribeMergeConflictsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDescribeMergeConflictsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDescribeMergeConflicts");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDescribeMergeConflictsRequest, BatchDescribeMergeConflictsResponse>()
                            .withOperationName("BatchDescribeMergeConflicts").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchDescribeMergeConflictsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchDescribeMergeConflictsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the association between an approval rule template and one or more specified repositories.
     * </p>
     *
     * @param batchDisassociateApprovalRuleTemplateFromRepositoriesRequest
     * @return Result of the BatchDisassociateApprovalRuleTemplateFromRepositories operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Quotas</a> in the
     *         <i>CodeCommit User Guide</i>.
     * @throws ApprovalRuleTemplateDoesNotExistException
     *         The specified approval rule template does not exist. Verify that the name is correct and that you are
     *         signed in to the Amazon Web Services Region where the template was created, and then try again.
     * @throws RepositoryNamesRequiredException
     *         At least one repository name object is required, but was not specified.
     * @throws MaximumRepositoryNamesExceededException
     *         The maximum number of allowed repository names was exceeded. Currently, this number is 100.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchDisassociateApprovalRuleTemplateFromRepositories
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchDisassociateApprovalRuleTemplateFromRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse batchDisassociateApprovalRuleTemplateFromRepositories(
            BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest batchDisassociateApprovalRuleTemplateFromRepositoriesRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateDoesNotExistException, RepositoryNamesRequiredException, MaximumRepositoryNamesExceededException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                batchDisassociateApprovalRuleTemplateFromRepositoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchDisassociateApprovalRuleTemplateFromRepositoriesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME,
                    "BatchDisassociateApprovalRuleTemplateFromRepositories");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchDisassociateApprovalRuleTemplateFromRepositoriesRequest, BatchDisassociateApprovalRuleTemplateFromRepositoriesResponse>()
                            .withOperationName("BatchDisassociateApprovalRuleTemplateFromRepositories")
                            .withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(batchDisassociateApprovalRuleTemplateFromRepositoriesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new BatchDisassociateApprovalRuleTemplateFromRepositoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the contents of one or more commits in a repository.
     * </p>
     *
     * @param batchGetCommitsRequest
     * @return Result of the BatchGetCommits operation returned by the service.
     * @throws CommitIdsListRequiredException
     *         A list of commit IDs is required, but was either not specified or the list was empty.
     * @throws CommitIdsLimitExceededException
     *         The maximum number of allowed commit IDs in a batch request is 100. Verify that your batch requests
     *         contains no more than 100 commit IDs, and then try again.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchGetCommits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetCommits" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public BatchGetCommitsResponse batchGetCommits(BatchGetCommitsRequest batchGetCommitsRequest)
            throws CommitIdsListRequiredException, CommitIdsLimitExceededException, RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetCommitsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                BatchGetCommitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetCommitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetCommitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetCommits");

            return clientHandler.execute(new ClientExecutionParams<BatchGetCommitsRequest, BatchGetCommitsResponse>()
                    .withOperationName("BatchGetCommits").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetCommitsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetCommitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about one or more repositories.
     * </p>
     * <note>
     * <p>
     * The description field for a repository accepts all HTML characters and all valid Unicode characters. Applications
     * that do not HTML-encode the description and display it in a webpage can expose users to potentially malicious
     * code. Make sure that you HTML-encode the description field in any application that uses this API to display the
     * repository description on a webpage.
     * </p>
     * </note>
     *
     * @param batchGetRepositoriesRequest
     *        Represents the input of a batch get repositories operation.
     * @return Result of the BatchGetRepositories operation returned by the service.
     * @throws RepositoryNamesRequiredException
     *         At least one repository name object is required, but was not specified.
     * @throws MaximumRepositoryNamesExceededException
     *         The maximum number of allowed repository names was exceeded. Currently, this number is 100.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.BatchGetRepositories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetRepositoriesResponse batchGetRepositories(BatchGetRepositoriesRequest batchGetRepositoriesRequest)
            throws RepositoryNamesRequiredException, MaximumRepositoryNamesExceededException, InvalidRepositoryNameException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetRepositoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetRepositoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetRepositoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetRepositoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetRepositories");

            return clientHandler.execute(new ClientExecutionParams<BatchGetRepositoriesRequest, BatchGetRepositoriesResponse>()
                    .withOperationName("BatchGetRepositories").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(batchGetRepositoriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchGetRepositoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a template for approval rules that can then be associated with one or more repositories in your Amazon
     * Web Services account. When you associate a template with a repository, CodeCommit creates an approval rule that
     * matches the conditions of the template for all pull requests that meet the conditions of the template. For more
     * information, see <a>AssociateApprovalRuleTemplateWithRepository</a>.
     * </p>
     *
     * @param createApprovalRuleTemplateRequest
     * @return Result of the CreateApprovalRuleTemplate operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Quotas</a> in the
     *         <i>CodeCommit User Guide</i>.
     * @throws ApprovalRuleTemplateNameAlreadyExistsException
     *         You cannot create an approval rule template with that name because a template with that name already
     *         exists in this Amazon Web Services Region for your Amazon Web Services account. Approval rule template
     *         names must be unique.
     * @throws ApprovalRuleTemplateContentRequiredException
     *         The content for the approval rule template is empty. You must provide some content for an approval rule
     *         template. The content cannot be null.
     * @throws InvalidApprovalRuleTemplateContentException
     *         The content of the approval rule template is not valid.
     * @throws InvalidApprovalRuleTemplateDescriptionException
     *         The description for the approval rule template is not valid because it exceeds the maximum characters
     *         allowed for a description. For more information about limits in CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Quotas</a> in the
     *         <i>CodeCommit User Guide</i>.
     * @throws NumberOfRuleTemplatesExceededException
     *         The maximum number of approval rule templates has been exceeded for this Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateApprovalRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateApprovalRuleTemplateResponse createApprovalRuleTemplate(
            CreateApprovalRuleTemplateRequest createApprovalRuleTemplateRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateNameAlreadyExistsException, ApprovalRuleTemplateContentRequiredException,
            InvalidApprovalRuleTemplateContentException, InvalidApprovalRuleTemplateDescriptionException,
            NumberOfRuleTemplatesExceededException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApprovalRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateApprovalRuleTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApprovalRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApprovalRuleTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApprovalRuleTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateApprovalRuleTemplateRequest, CreateApprovalRuleTemplateResponse>()
                            .withOperationName("CreateApprovalRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createApprovalRuleTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateApprovalRuleTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a branch in a repository and points the branch to a commit.
     * </p>
     * <note>
     * <p>
     * Calling the create branch operation does not set a repository's default branch. To do this, call the update
     * default branch operation.
     * </p>
     * </note>
     *
     * @param createBranchRequest
     *        Represents the input of a create branch operation.
     * @return Result of the CreateBranch operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws BranchNameExistsException
     *         Cannot create the branch with the specified name because the commit conflicts with an existing branch
     *         with the same name. Branch names must be unique.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws CommitIdRequiredException
     *         A commit ID was not specified.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws InvalidCommitIdException
     *         The specified commit ID is not valid.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateBranchResponse createBranch(CreateBranchRequest createBranchRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, BranchNameRequiredException,
            BranchNameExistsException, InvalidBranchNameException, CommitIdRequiredException, CommitDoesNotExistException,
            InvalidCommitIdException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBranchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateBranchResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBranchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBranchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBranch");

            return clientHandler.execute(new ClientExecutionParams<CreateBranchRequest, CreateBranchResponse>()
                    .withOperationName("CreateBranch").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBranchRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBranchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a commit for a repository on the tip of a specified branch.
     * </p>
     *
     * @param createCommitRequest
     * @return Result of the CreateCommit operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws ParentCommitIdRequiredException
     *         A parent commit ID is required. To view the full commit ID of a branch in a repository, use
     *         <a>GetBranch</a> or a Git command (for example, git pull or git log).
     * @throws InvalidParentCommitIdException
     *         The parent commit ID is not valid. The commit ID cannot be empty, and must match the head commit ID for
     *         the branch of the repository where you want to add or update a file.
     * @throws ParentCommitDoesNotExistException
     *         The parent commit ID is not valid because it does not exist. The specified parent commit ID does not
     *         exist in the specified branch of the repository.
     * @throws ParentCommitIdOutdatedException
     *         The file could not be added because the provided parent commit ID is not the current tip of the specified
     *         branch. To view the full commit ID of the current head of the branch, use <a>GetBranch</a>.
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws BranchDoesNotExistException
     *         The specified branch does not exist.
     * @throws BranchNameIsTagNameException
     *         The specified branch name is not valid because it is a tag name. Enter the name of a branch in the
     *         repository. For a list of valid branch names, use <a>ListBranches</a>.
     * @throws FileEntryRequiredException
     *         The commit cannot be created because no files have been specified as added, updated, or changed (PutFile
     *         or DeleteFile) for the commit.
     * @throws MaximumFileEntriesExceededException
     *         The number of specified files to change as part of this commit exceeds the maximum number of files that
     *         can be changed in a single commit. Consider using a Git client for these changes.
     * @throws PutFileEntryConflictException
     *         The commit cannot be created because one or more files specified in the commit reference both a file and
     *         a folder.
     * @throws SourceFileOrContentRequiredException
     *         The commit cannot be created because no source files or file content have been specified for the commit.
     * @throws FileContentAndSourceFileSpecifiedException
     *         The commit cannot be created because both a source file and file content have been specified for the same
     *         file. You cannot provide both. Either specify a source file or provide the file content directly.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws SamePathRequestException
     *         The commit cannot be created because one or more changes in this commit duplicate actions in the same
     *         file path. For example, you cannot make the same delete request to the same file in the same file path
     *         twice, or make a delete request and a move request to the same file as part of the same commit.
     * @throws FileDoesNotExistException
     *         The specified file does not exist. Verify that you have used the correct file name, full path, and
     *         extension.
     * @throws FileContentSizeLimitExceededException
     *         The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file
     *         content change size is 7 MB. Consider making these changes using a Git client.
     * @throws FolderContentSizeLimitExceededException
     *         The commit cannot be created because at least one of the overall changes in the commit results in a
     *         folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or
     *         split the changes across multiple folders.
     * @throws InvalidDeletionParameterException
     *         The specified deletion parameter is not valid.
     * @throws RestrictedSourceFileException
     *         The commit cannot be created because one of the changes specifies copying or moving a .gitkeep file.
     * @throws FileModeRequiredException
     *         The commit cannot be created because no file mode has been specified. A file mode is required to update
     *         mode permissions for a file.
     * @throws InvalidFileModeException
     *         The specified file mode permission is not valid. For a list of valid file mode permissions, see
     *         <a>PutFile</a>.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws NoChangeException
     *         The commit cannot be created because no changes will be made to the repository as a result of this
     *         commit. A commit must contain at least one change.
     * @throws FileNameConflictsWithDirectoryNameException
     *         A file cannot be added to the repository because the specified file name has the same name as a directory
     *         in this repository. Either provide another name for the file, or add the file in a directory that does
     *         not match the file name.
     * @throws DirectoryNameConflictsWithFileNameException
     *         A file cannot be added to the repository because the specified path name has the same name as a file that
     *         already exists in this repository. Either provide a different name for the file, or specify a different
     *         path for the file.
     * @throws FilePathConflictsWithSubmodulePathException
     *         The commit cannot be created because a specified file path points to a submodule. Verify that the
     *         destination files have valid file paths that do not point to a submodule.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateCommit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateCommit" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCommitResponse createCommit(CreateCommitRequest createCommitRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, ParentCommitIdRequiredException,
            InvalidParentCommitIdException, ParentCommitDoesNotExistException, ParentCommitIdOutdatedException,
            BranchNameRequiredException, InvalidBranchNameException, BranchDoesNotExistException, BranchNameIsTagNameException,
            FileEntryRequiredException, MaximumFileEntriesExceededException, PutFileEntryConflictException,
            SourceFileOrContentRequiredException, FileContentAndSourceFileSpecifiedException, PathRequiredException,
            InvalidPathException, SamePathRequestException, FileDoesNotExistException, FileContentSizeLimitExceededException,
            FolderContentSizeLimitExceededException, InvalidDeletionParameterException, RestrictedSourceFileException,
            FileModeRequiredException, InvalidFileModeException, NameLengthExceededException, InvalidEmailException,
            CommitMessageLengthExceededException, EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException,
            EncryptionKeyDisabledException, EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, NoChangeException,
            FileNameConflictsWithDirectoryNameException, DirectoryNameConflictsWithFileNameException,
            FilePathConflictsWithSubmodulePathException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCommitResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCommitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCommitRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCommitRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCommit");

            return clientHandler.execute(new ClientExecutionParams<CreateCommitRequest, CreateCommitResponse>()
                    .withOperationName("CreateCommit").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCommitRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCommitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a pull request in the specified repository.
     * </p>
     *
     * @param createPullRequestRequest
     * @return Result of the CreatePullRequest operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws ClientRequestTokenRequiredException
     *         A client request token is required. A client request token is an unique, client-generated idempotency
     *         token that, when provided in a request, ensures the request cannot be repeated with a changed parameter.
     *         If a request is received with the same parameters and a token is included, the request returns
     *         information about the initial request that used that token.
     * @throws InvalidClientRequestTokenException
     *         The client request token is not valid.
     * @throws IdempotencyParameterMismatchException
     *         The client request token is not valid. Either the token is not in a valid format, or the token has been
     *         used in a previous request and cannot be reused.
     * @throws ReferenceNameRequiredException
     *         A reference name is required, but none was provided.
     * @throws InvalidReferenceNameException
     *         The specified reference name format is not valid. Reference names must conform to the Git references
     *         format (for example, refs/heads/main). For more information, see <a
     *         href="https://git-scm.com/book/en/v2/Git-Internals-Git-References">Git Internals - Git References</a> or
     *         consult your Git documentation.
     * @throws ReferenceDoesNotExistException
     *         The specified reference does not exist. You must provide a full commit ID.
     * @throws ReferenceTypeNotSupportedException
     *         The specified reference is not a supported type.
     * @throws TitleRequiredException
     *         A pull request title is required. It cannot be empty or null.
     * @throws InvalidTitleException
     *         The title of the pull request is not valid. Pull request titles cannot exceed 100 characters in length.
     * @throws InvalidDescriptionException
     *         The pull request description is not valid. Descriptions cannot be more than 1,000 characters.
     * @throws TargetsRequiredException
     *         An array of target objects is required. It cannot be empty or null.
     * @throws InvalidTargetsException
     *         The targets for the pull request is not valid or not in a valid format. Targets are a list of target
     *         objects. Each target object must contain the full values for the repository name, source branch, and
     *         destination branch for a pull request.
     * @throws TargetRequiredException
     *         A pull request target is required. It cannot be empty or null. A pull request target must contain the
     *         full values for the repository name, source branch, and destination branch for the pull request.
     * @throws InvalidTargetException
     *         The target for the pull request is not valid. A target must contain the full values for the repository
     *         name, source branch, and destination branch for the pull request.
     * @throws MultipleRepositoriesInPullRequestException
     *         You cannot include more than one repository in a pull request. Make sure you have specified only one
     *         repository name in your request, and then try again.
     * @throws MaximumOpenPullRequestsExceededException
     *         You cannot create the pull request because the repository has too many open pull requests. The maximum
     *         number of open pull requests for a repository is 1,000. Close one or more open pull requests, and then
     *         try again.
     * @throws SourceAndDestinationAreSameException
     *         The source branch and destination branch for the pull request are the same. You must specify different
     *         branches for the source and destination.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreatePullRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequest" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreatePullRequestResponse createPullRequest(CreatePullRequestRequest createPullRequestRequest)
            throws RepositoryNameRequiredException, InvalidRepositoryNameException, RepositoryDoesNotExistException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, ClientRequestTokenRequiredException,
            InvalidClientRequestTokenException, IdempotencyParameterMismatchException, ReferenceNameRequiredException,
            InvalidReferenceNameException, ReferenceDoesNotExistException, ReferenceTypeNotSupportedException,
            TitleRequiredException, InvalidTitleException, InvalidDescriptionException, TargetsRequiredException,
            InvalidTargetsException, TargetRequiredException, InvalidTargetException, MultipleRepositoriesInPullRequestException,
            MaximumOpenPullRequestsExceededException, SourceAndDestinationAreSameException, AwsServiceException,
            SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePullRequestResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePullRequestResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPullRequestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPullRequestRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePullRequest");

            return clientHandler.execute(new ClientExecutionParams<CreatePullRequestRequest, CreatePullRequestResponse>()
                    .withOperationName("CreatePullRequest").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPullRequestRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePullRequestRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an approval rule for a pull request.
     * </p>
     *
     * @param createPullRequestApprovalRuleRequest
     * @return Result of the CreatePullRequestApprovalRule operation returned by the service.
     * @throws ApprovalRuleNameRequiredException
     *         An approval rule name is required, but was not specified.
     * @throws InvalidApprovalRuleNameException
     *         The name for the approval rule is not valid.
     * @throws ApprovalRuleNameAlreadyExistsException
     *         An approval rule with that name already exists. Approval rule names must be unique within the scope of a
     *         pull request.
     * @throws ApprovalRuleContentRequiredException
     *         The content for the approval rule is empty. You must provide some content for an approval rule. The
     *         content cannot be null.
     * @throws InvalidApprovalRuleContentException
     *         The content for the approval rule is not valid.
     * @throws NumberOfRulesExceededException
     *         The approval rule cannot be added. The pull request has the maximum number of approval rules associated
     *         with it.
     * @throws PullRequestDoesNotExistException
     *         The pull request ID could not be found. Make sure that you have specified the correct repository name and
     *         pull request ID, and then try again.
     * @throws InvalidPullRequestIdException
     *         The pull request ID is not valid. Make sure that you have provided the full ID and that the pull request
     *         is in the specified repository, and then try again.
     * @throws PullRequestIdRequiredException
     *         A pull request ID is required, but none was provided.
     * @throws PullRequestAlreadyClosedException
     *         The pull request status cannot be updated because it is already closed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreatePullRequestApprovalRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequestApprovalRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreatePullRequestApprovalRuleResponse createPullRequestApprovalRule(
            CreatePullRequestApprovalRuleRequest createPullRequestApprovalRuleRequest) throws ApprovalRuleNameRequiredException,
            InvalidApprovalRuleNameException, ApprovalRuleNameAlreadyExistsException, ApprovalRuleContentRequiredException,
            InvalidApprovalRuleContentException, NumberOfRulesExceededException, PullRequestDoesNotExistException,
            InvalidPullRequestIdException, PullRequestIdRequiredException, PullRequestAlreadyClosedException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, AwsServiceException, SdkClientException,
            CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePullRequestApprovalRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePullRequestApprovalRuleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPullRequestApprovalRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createPullRequestApprovalRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePullRequestApprovalRule");

            return clientHandler
                    .execute(new ClientExecutionParams<CreatePullRequestApprovalRuleRequest, CreatePullRequestApprovalRuleResponse>()
                            .withOperationName("CreatePullRequestApprovalRule").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createPullRequestApprovalRuleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreatePullRequestApprovalRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new, empty repository.
     * </p>
     *
     * @param createRepositoryRequest
     *        Represents the input of a create repository operation.
     * @return Result of the CreateRepository operation returned by the service.
     * @throws RepositoryNameExistsException
     *         The specified repository name already exists.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws InvalidRepositoryDescriptionException
     *         The specified repository description is not valid.
     * @throws RepositoryLimitExceededException
     *         A repository resource limit was exceeded.
     * @throws OperationNotAllowedException
     *         The requested action is not allowed.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws EncryptionKeyInvalidIdException
     *         The Key Management Service encryption key is not valid.
     * @throws EncryptionKeyInvalidUsageException
     *         A KMS encryption key was used to try and encrypt or decrypt a repository, but either the repository or
     *         the key was not in a valid state to support the operation.
     * @throws InvalidTagsMapException
     *         The map of tags is not valid.
     * @throws TooManyTagsException
     *         The maximum number of tags for an CodeCommit resource has been exceeded.
     * @throws InvalidSystemTagUsageException
     *         The specified tag is not valid. Key names cannot be prefixed with aws:.
     * @throws TagPolicyException
     *         The tag policy is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepository" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest)
            throws RepositoryNameExistsException, RepositoryNameRequiredException, InvalidRepositoryNameException,
            InvalidRepositoryDescriptionException, RepositoryLimitExceededException, OperationNotAllowedException,
            EncryptionIntegrityChecksFailedException, EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException,
            EncryptionKeyNotFoundException, EncryptionKeyUnavailableException, EncryptionKeyInvalidIdException,
            EncryptionKeyInvalidUsageException, InvalidTagsMapException, TooManyTagsException, InvalidSystemTagUsageException,
            TagPolicyException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRepositoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRepositoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRepositoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRepositoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRepository");

            return clientHandler.execute(new ClientExecutionParams<CreateRepositoryRequest, CreateRepositoryResponse>()
                    .withOperationName("CreateRepository").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRepositoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRepositoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an unreferenced commit that represents the result of merging two branches using a specified merge
     * strategy. This can help you determine the outcome of a potential merge. This API cannot be used with the
     * fast-forward merge strategy because that strategy does not create a merge commit.
     * </p>
     * <note>
     * <p>
     * This unreferenced merge commit can only be accessed using the GetCommit API or through git commands such as git
     * fetch. To retrieve this commit, you must specify its commit ID or otherwise reference it.
     * </p>
     * </note>
     *
     * @param createUnreferencedMergeCommitRequest
     * @return Result of the CreateUnreferencedMergeCommit operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws TipsDivergenceExceededException
     *         The divergence between the tips of the provided commit specifiers is too great to determine whether there
     *         might be any merge conflicts. Locally compare the specifiers using <code>git diff</code> or a diff tool.
     * @throws CommitRequiredException
     *         A commit was not specified.
     * @throws InvalidCommitException
     *         The specified commit is not valid.
     * @throws CommitDoesNotExistException
     *         The specified commit does not exist or no commit was specified, and the specified repository has no
     *         default branch.
     * @throws MergeOptionRequiredException
     *         A merge option or stategy is required, and none was provided.
     * @throws InvalidMergeOptionException
     *         The specified merge option is not valid for this operation. Not all merge strategies are supported for
     *         all operations.
     * @throws InvalidConflictDetailLevelException
     *         The specified conflict detail level is not valid.
     * @throws InvalidConflictResolutionStrategyException
     *         The specified conflict resolution strategy is not valid.
     * @throws InvalidConflictResolutionException
     *         The specified conflict resolution list is not valid.
     * @throws ManualMergeRequiredException
     *         The pull request cannot be merged automatically into the destination branch. You must manually merge the
     *         branches and resolve any conflicts.
     * @throws MaximumConflictResolutionEntriesExceededException
     *         The number of allowed conflict resolution entries was exceeded.
     * @throws MultipleConflictResolutionEntriesException
     *         More than one conflict resolution entries exists for the conflict. A conflict can have only one conflict
     *         resolution entry.
     * @throws ReplacementTypeRequiredException
     *         A replacement type is required.
     * @throws InvalidReplacementTypeException
     *         Automerge was specified for resolving the conflict, but the specified replacement type is not valid.
     * @throws ReplacementContentRequiredException
     *         USE_NEW_CONTENT was specified, but no replacement content has been provided.
     * @throws InvalidReplacementContentException
     *         Automerge was specified for resolving the conflict, but the replacement type is not valid or content is
     *         missing.
     * @throws PathRequiredException
     *         The folderPath for a location cannot be null.
     * @throws InvalidPathException
     *         The specified path is not valid.
     * @throws FileContentSizeLimitExceededException
     *         The file cannot be added because it is too large. The maximum file size is 6 MB, and the combined file
     *         content change size is 7 MB. Consider making these changes using a Git client.
     * @throws FolderContentSizeLimitExceededException
     *         The commit cannot be created because at least one of the overall changes in the commit results in a
     *         folder whose contents exceed the limit of 6 MB. Either reduce the number and size of your changes, or
     *         split the changes across multiple folders.
     * @throws MaximumFileContentToLoadExceededException
     *         The number of files to load exceeds the allowed limit.
     * @throws MaximumItemsToCompareExceededException
     *         The number of items to compare between the source or destination branches and the merge base has exceeded
     *         the maximum allowed.
     * @throws ConcurrentReferenceUpdateException
     *         The merge cannot be completed because the target branch has been modified. Another user might have
     *         modified the target branch while the merge was in progress. Wait a few minutes, and then try again.
     * @throws FileModeRequiredException
     *         The commit cannot be created because no file mode has been specified. A file mode is required to update
     *         mode permissions for a file.
     * @throws InvalidFileModeException
     *         The specified file mode permission is not valid. For a list of valid file mode permissions, see
     *         <a>PutFile</a>.
     * @throws NameLengthExceededException
     *         The user name is not valid because it has exceeded the character limit for author names.
     * @throws InvalidEmailException
     *         The specified email address either contains one or more characters that are not allowed, or it exceeds
     *         the maximum number of characters allowed for an email address.
     * @throws CommitMessageLengthExceededException
     *         The commit message is too long. Provide a shorter string.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.CreateUnreferencedMergeCommit
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateUnreferencedMergeCommit"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUnreferencedMergeCommitResponse createUnreferencedMergeCommit(
            CreateUnreferencedMergeCommitRequest createUnreferencedMergeCommitRequest) throws RepositoryNameRequiredException,
            InvalidRepositoryNameException, RepositoryDoesNotExistException, TipsDivergenceExceededException,
            CommitRequiredException, InvalidCommitException, CommitDoesNotExistException, MergeOptionRequiredException,
            InvalidMergeOptionException, InvalidConflictDetailLevelException, InvalidConflictResolutionStrategyException,
            InvalidConflictResolutionException, ManualMergeRequiredException, MaximumConflictResolutionEntriesExceededException,
            MultipleConflictResolutionEntriesException, ReplacementTypeRequiredException, InvalidReplacementTypeException,
            ReplacementContentRequiredException, InvalidReplacementContentException, PathRequiredException, InvalidPathException,
            FileContentSizeLimitExceededException, FolderContentSizeLimitExceededException,
            MaximumFileContentToLoadExceededException, MaximumItemsToCompareExceededException,
            ConcurrentReferenceUpdateException, FileModeRequiredException, InvalidFileModeException, NameLengthExceededException,
            InvalidEmailException, CommitMessageLengthExceededException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUnreferencedMergeCommitResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUnreferencedMergeCommitResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUnreferencedMergeCommitRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createUnreferencedMergeCommitRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUnreferencedMergeCommit");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateUnreferencedMergeCommitRequest, CreateUnreferencedMergeCommitResponse>()
                            .withOperationName("CreateUnreferencedMergeCommit").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createUnreferencedMergeCommitRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateUnreferencedMergeCommitRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specified approval rule template. Deleting a template does not remove approval rules on pull requests
     * already created with the template.
     * </p>
     *
     * @param deleteApprovalRuleTemplateRequest
     * @return Result of the DeleteApprovalRuleTemplate operation returned by the service.
     * @throws ApprovalRuleTemplateNameRequiredException
     *         An approval rule template name is required, but was not specified.
     * @throws InvalidApprovalRuleTemplateNameException
     *         The name of the approval rule template is not valid. Template names must be between 1 and 100 valid
     *         characters in length. For more information about limits in CodeCommit, see <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/limits.html">Quotas</a> in the
     *         <i>CodeCommit User Guide</i>.
     * @throws ApprovalRuleTemplateInUseException
     *         The approval rule template is associated with one or more repositories. You cannot delete a template that
     *         is associated with a repository. Remove all associations, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DeleteApprovalRuleTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteApprovalRuleTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteApprovalRuleTemplateResponse deleteApprovalRuleTemplate(
            DeleteApprovalRuleTemplateRequest deleteApprovalRuleTemplateRequest)
            throws ApprovalRuleTemplateNameRequiredException, InvalidApprovalRuleTemplateNameException,
            ApprovalRuleTemplateInUseException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApprovalRuleTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteApprovalRuleTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApprovalRuleTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApprovalRuleTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApprovalRuleTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteApprovalRuleTemplateRequest, DeleteApprovalRuleTemplateResponse>()
                            .withOperationName("DeleteApprovalRuleTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteApprovalRuleTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteApprovalRuleTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a branch from a repository, unless that branch is the default branch for the repository.
     * </p>
     *
     * @param deleteBranchRequest
     *        Represents the input of a delete branch operation.
     * @return Result of the DeleteBranch operation returned by the service.
     * @throws RepositoryNameRequiredException
     *         A repository name is required, but was not specified.
     * @throws RepositoryDoesNotExistException
     *         The specified repository does not exist.
     * @throws InvalidRepositoryNameException
     *         A specified repository name is not valid.</p> <note>
     *         <p>
     *         This exception occurs only when a specified repository name is not valid. Other exceptions occur when a
     *         required repository parameter is missing, or when a specified repository does not exist.
     *         </p>
     * @throws BranchNameRequiredException
     *         A branch name is required, but was not specified.
     * @throws InvalidBranchNameException
     *         The specified reference name is not valid.
     * @throws DefaultBranchCannotBeDeletedException
     *         The specified branch is the default branch for the repository, and cannot be deleted. To delete this
     *         branch, you must first set another branch as the default branch.
     * @throws EncryptionIntegrityChecksFailedException
     *         An encryption integrity check failed.
     * @throws EncryptionKeyAccessDeniedException
     *         An encryption key could not be accessed.
     * @throws EncryptionKeyDisabledException
     *         The encryption key is disabled.
     * @throws EncryptionKeyNotFoundException
     *         No encryption key was found.
     * @throws EncryptionKeyUnavailableException
     *         The encryption key is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DeleteBranch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteBranch" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteBranchResponse deleteBranch(DeleteBranchRequest deleteBranchRequest) throws RepositoryNameRequiredException,
            RepositoryDoesNotExistException, InvalidRepositoryNameException, BranchNameRequiredException,
            InvalidBranchNameException, DefaultBranchCannotBeDeletedException, EncryptionIntegrityChecksFailedException,
            EncryptionKeyAccessDeniedException, EncryptionKeyDisabledException, EncryptionKeyNotFoundException,
            EncryptionKeyUnavailableException, AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBranchResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteBranchResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "ParentCommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitDoesNotExistException::builder).build());
            case "FileEntryRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileEntryRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileEntryRequiredException::builder).build());
            case "InvalidActorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidActorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidActorArnException::builder).build());
            case "CommitIdsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsLimitExceededException::builder).build());
            case "InvalidDestinationCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDestinationCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidDestinationCommitSpecifierException::builder)
                        .build());
            case "RepositoryTriggerBranchNameListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerBranchNameListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerBranchNameListRequiredException::builder)
                        .build());
            case "InvalidApprovalRuleNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalRuleNameException::builder).build());
            case "DirectoryNameConflictsWithFileNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNameConflictsWithFileNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DirectoryNameConflictsWithFileNameException::builder)
                        .build());
            case "SourceAndDestinationAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceAndDestinationAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceAndDestinationAreSameException::builder).build());
            case "InvalidTitleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTitleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTitleException::builder).build());
            case "EncryptionKeyUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyUnavailableException::builder).build());
            case "InvalidRepositoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRepositoryNameException::builder).build());
            case "InvalidBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBranchNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBranchNameException::builder).build());
            case "TargetsRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetsRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetsRequiredException::builder).build());
            case "RepositoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryLimitExceededException::builder).build());
            case "BranchNameIsTagNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameIsTagNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameIsTagNameException::builder).build());
            case "CommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdRequiredException::builder).build());
            case "TitleRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TitleRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TitleRequiredException::builder).build());
            case "InvalidTargetsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetsException::builder).build());
            case "MaximumRepositoryTriggersExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryTriggersExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryTriggersExceededException::builder)
                        .build());
            case "EncryptionKeyInvalidUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidUsageException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyInvalidUsageException::builder).build());
            case "BlobIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdRequiredException::builder).build());
            case "InvalidReplacementTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementTypeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReplacementTypeException::builder).build());
            case "RepositoryNamesRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNamesRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNamesRequiredException::builder).build());
            case "AuthorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthorDoesNotExistException::builder).build());
            case "InvalidFilePositionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFilePositionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFilePositionException::builder).build());
            case "FileNameConflictsWithDirectoryNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileNameConflictsWithDirectoryNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileNameConflictsWithDirectoryNameException::builder)
                        .build());
            case "InvalidResourceArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceArnException::builder).build());
            case "EncryptionKeyAccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyAccessDeniedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EncryptionKeyAccessDeniedException::builder).build());
            case "PullRequestCannotBeApprovedByAuthorException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestCannotBeApprovedByAuthorException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestCannotBeApprovedByAuthorException::builder)
                        .build());
            case "BranchDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchDoesNotExistException::builder).build());
            case "ReactionValueRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionValueRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionValueRequiredException::builder).build());
            case "ApprovalRuleTemplateNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameAlreadyExistsException::builder)
                        .build());
            case "InvalidRepositoryTriggerCustomDataException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerCustomDataException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerCustomDataException::builder)
                        .build());
            case "ApprovalRuleContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleContentRequiredException::builder).build());
            case "MaximumRepositoryNamesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRepositoryNamesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumRepositoryNamesExceededException::builder).build());
            case "RepositoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryDoesNotExistException::builder).build());
            case "InvalidRevisionIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRevisionIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRevisionIdException::builder).build());
            case "MaximumOpenPullRequestsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumOpenPullRequestsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumOpenPullRequestsExceededException::builder).build());
            case "DefaultBranchCannotBeDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DefaultBranchCannotBeDeletedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DefaultBranchCannotBeDeletedException::builder).build());
            case "EncryptionKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyNotFoundException::builder).build());
            case "InvalidPathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPathException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPathException::builder).build());
            case "InvalidConflictResolutionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionException::builder).build());
            case "EncryptionKeyRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateContentException::builder)
                        .build());
            case "RepositoryTriggerDestinationArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerDestinationArnRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerDestinationArnRequiredException::builder)
                        .build());
            case "InvalidConflictResolutionStrategyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictResolutionStrategyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictResolutionStrategyException::builder)
                        .build());
            case "InvalidAuthorArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidAuthorArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidAuthorArnException::builder).build());
            case "InvalidTargetBranchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetBranchException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetBranchException::builder).build());
            case "ReplacementTypeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementTypeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReplacementTypeRequiredException::builder).build());
            case "RepositoryTriggerNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerNameRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerNameRequiredException::builder).build());
            case "OperationNotAllowedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotAllowedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotAllowedException::builder).build());
            case "ApprovalStateRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalStateRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalStateRequiredException::builder).build());
            case "InvalidPullRequestStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestStatusException::builder).build());
            case "OverrideAlreadySetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideAlreadySetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideAlreadySetException::builder).build());
            case "NumberOfRulesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRulesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NumberOfRulesExceededException::builder).build());
            case "InvalidOverrideStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOverrideStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOverrideStatusException::builder).build());
            case "ApprovalRuleNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleNameRequiredException::builder).build());
            case "InvalidPullRequestStatusUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestStatusUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestStatusUpdateException::builder).build());
            case "ParentCommitIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdRequiredException::builder).build());
            case "InvalidPullRequestEventTypeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestEventTypeException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidPullRequestEventTypeException::builder).build());
            case "ActorDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ActorDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ActorDoesNotExistException::builder).build());
            case "IdempotencyParameterMismatchException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IdempotencyParameterMismatchException")
                        .httpStatusCode(400).exceptionBuilderSupplier(IdempotencyParameterMismatchException::builder).build());
            case "NumberOfRuleTemplatesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NumberOfRuleTemplatesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NumberOfRuleTemplatesExceededException::builder).build());
            case "InvalidDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDescriptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDescriptionException::builder).build());
            case "FolderDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FolderDoesNotExistException::builder).build());
            case "PullRequestIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestIdRequiredException::builder).build());
            case "TipOfSourceReferenceIsDifferentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipOfSourceReferenceIsDifferentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(TipOfSourceReferenceIsDifferentException::builder).build());
            case "RepositoryTriggersListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggersListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggersListRequiredException::builder).build());
            case "InvalidReplacementContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReplacementContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidReplacementContentException::builder).build());
            case "MaximumNumberOfApprovalsExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumNumberOfApprovalsExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfApprovalsExceededException::builder)
                                .build());
            case "CommitMessageLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitMessageLengthExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommitMessageLengthExceededException::builder).build());
            case "InvalidMaxMergeHunksException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxMergeHunksException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxMergeHunksException::builder).build());
            case "InvalidEmailException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEmailException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEmailException::builder).build());
            case "InvalidDeletionParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeletionParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDeletionParameterException::builder).build());
            case "InvalidRuleContentSha256Exception":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRuleContentSha256Exception").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidRuleContentSha256Exception::builder).build());
            case "SourceFileOrContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SourceFileOrContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(SourceFileOrContentRequiredException::builder).build());
            case "CommentIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentIdRequiredException::builder).build());
            case "CommitRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitRequiredException::builder).build());
            case "RevisionNotCurrentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionNotCurrentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionNotCurrentException::builder).build());
            case "MaximumConflictResolutionEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumConflictResolutionEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumConflictResolutionEntriesExceededException::builder)
                        .build());
            case "CommentNotCreatedByCallerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentNotCreatedByCallerException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentNotCreatedByCallerException::builder).build());
            case "TargetRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TargetRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TargetRequiredException::builder).build());
            case "InvalidTagsMapException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagsMapException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagsMapException::builder).build());
            case "RestrictedSourceFileException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RestrictedSourceFileException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RestrictedSourceFileException::builder).build());
            case "FileTooLargeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileTooLargeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileTooLargeException::builder).build());
            case "PutFileEntryConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PutFileEntryConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PutFileEntryConflictException::builder).build());
            case "FileContentAndSourceFileSpecifiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentAndSourceFileSpecifiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentAndSourceFileSpecifiedException::builder)
                        .build());
            case "PullRequestStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestStatusRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestStatusRequiredException::builder).build());
            case "ConcurrentReferenceUpdateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentReferenceUpdateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ConcurrentReferenceUpdateException::builder).build());
            case "SamePathRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SamePathRequestException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SamePathRequestException::builder).build());
            case "TipsDivergenceExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TipsDivergenceExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TipsDivergenceExceededException::builder).build());
            case "InvalidSortByException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSortByException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSortByException::builder).build());
            case "CannotDeleteApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDeleteApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDeleteApprovalRuleFromTemplateException::builder)
                        .build());
            case "ReferenceDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceDoesNotExistException::builder).build());
            case "OverrideStatusRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OverrideStatusRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OverrideStatusRequiredException::builder).build());
            case "ApprovalRuleNameAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleNameAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleNameAlreadyExistsException::builder).build());
            case "TagPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagPolicyException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagPolicyException::builder).build());
            case "InvalidFileModeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileModeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileModeException::builder).build());
            case "InvalidApprovalRuleTemplateNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateNameException::builder).build());
            case "InvalidSourceCommitSpecifierException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceCommitSpecifierException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidSourceCommitSpecifierException::builder).build());
            case "ReplacementContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReplacementContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReplacementContentRequiredException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBranchRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBranchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CodeCommit");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBranch");

            return clientHandler.execute(new ClientExecutionParams<DeleteBranchRequest, DeleteBranchResponse>()
                    .withOperationName("DeleteBranch").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBranchRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBranchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the content of a comment made on a change, file, or commit in a repository.
     * </p>
     *
     * @param deleteCommentContentRequest
     * @return Result of the DeleteCommentContent operation returned by the service.
     * @throws CommentDoesNotExistException
     *         No comment exists with the provided ID. Verify that you have used the correct ID, and then try again.
     * @throws CommentIdRequiredException
     *         The comment ID is missing or null. A comment ID is required.
     * @throws InvalidCommentIdException
     *         The comment ID is not in a valid format. Make sure that you have provided the full comment ID.
     * @throws CommentDeletedException
     *         This comment has already been deleted. You cannot edit or delete a deleted comment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CodeCommitException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CodeCommitClient.DeleteCommentContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteCommentContent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCommentContentResponse deleteCommentContent(DeleteCommentContentRequest deleteCommentContentRequest)
            throws CommentDoesNotExistException, CommentIdRequiredException, InvalidCommentIdException, CommentDeletedException,
            AwsServiceException, SdkClientException, CodeCommitException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCommentContentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCommentContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "FileContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileContentRequiredException::builder).build());
            case "InvalidApprovalRuleTemplateDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleTemplateDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleTemplateDescriptionException::builder)
                        .build());
            case "ApprovalRuleTemplateDoesNotExistException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateDoesNotExistException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateDoesNotExistException::builder)
                                .build());
            case "CommentDeletedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDeletedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDeletedException::builder).build());
            case "MaximumItemsToCompareExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumItemsToCompareExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumItemsToCompareExceededException::builder).build());
            case "InvalidBlobIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidBlobIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidBlobIdException::builder).build());
            case "InvalidRepositoryDescriptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryDescriptionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryDescriptionException::builder).build());
            case "InvalidRepositoryTriggerDestinationArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerDestinationArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerDestinationArnException::builder)
                        .build());
            case "CommentDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentDoesNotExistException::builder).build());
            case "InvalidConflictDetailLevelException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConflictDetailLevelException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidConflictDetailLevelException::builder).build());
            case "ReactionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReactionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReactionLimitExceededException::builder).build());
            case "BeforeCommitIdAndAfterCommitIdAreSameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BeforeCommitIdAndAfterCommitIdAreSameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(BeforeCommitIdAndAfterCommitIdAreSameException::builder)
                        .build());
            case "CannotModifyApprovalRuleFromTemplateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotModifyApprovalRuleFromTemplateException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotModifyApprovalRuleFromTemplateException::builder)
                        .build());
            case "RevisionIdRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RevisionIdRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RevisionIdRequiredException::builder).build());
            case "PullRequestDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestDoesNotExistException::builder).build());
            case "ReferenceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceTypeNotSupportedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ReferenceTypeNotSupportedException::builder).build());
            case "FilePathConflictsWithSubmodulePathException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FilePathConflictsWithSubmodulePathException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FilePathConflictsWithSubmodulePathException::builder)
                        .build());
            case "RepositoryTriggerEventsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryTriggerEventsListRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryTriggerEventsListRequiredException::builder)
                        .build());
            case "FileModeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileModeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileModeRequiredException::builder).build());
            case "CommitDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitDoesNotExistException::builder).build());
            case "ResourceArnRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceArnRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnRequiredException::builder).build());
            case "InvalidReactionUserArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionUserArnException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionUserArnException::builder).build());
            case "InvalidRepositoryTriggerEventsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerEventsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerEventsException::builder).build());
            case "RepositoryNotAssociatedWithPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNotAssociatedWithPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(RepositoryNotAssociatedWithPullRequestException::builder)
                        .build());
            case "InvalidFileLocationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidFileLocationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidFileLocationException::builder).build());
            case "MaximumBranchesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumBranchesExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumBranchesExceededException::builder).build());
            case "EncryptionKeyInvalidIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyInvalidIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyInvalidIdException::builder).build());
            case "InvalidRelativeFileVersionEnumException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRelativeFileVersionEnumException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRelativeFileVersionEnumException::builder).build());
            case "InvalidReactionValueException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReactionValueException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReactionValueException::builder).build());
            case "TagKeysListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagKeysListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagKeysListRequiredException::builder).build());
            case "InvalidClientRequestTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientRequestTokenException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidClientRequestTokenException::builder).build());
            case "FolderContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FolderContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FolderContentSizeLimitExceededException::builder).build());
            case "RepositoryNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameRequiredException::builder).build());
            case "InvalidReferenceNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidReferenceNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidReferenceNameException::builder).build());
            case "CommentContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommentContentRequiredException::builder).build());
            case "InvalidTagKeysListException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagKeysListException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagKeysListException::builder).build());
            case "TagsMapRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsMapRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsMapRequiredException::builder).build());
            case "PathRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathRequiredException::builder).build());
            case "InvalidSystemTagUsageException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSystemTagUsageException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSystemTagUsageException::builder).build());
            case "CommitIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdDoesNotExistException::builder).build());
            case "InvalidParentCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParentCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParentCommitIdException::builder).build());
            case "ReferenceNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ReferenceNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ReferenceNameRequiredException::builder).build());
            case "InvalidMaxConflictFilesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxConflictFilesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxConflictFilesException::builder).build());
            case "MaximumRuleTemplatesAssociatedWithRepositoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumRuleTemplatesAssociatedWithRepositoryException")
                        .httpStatusCode(400)
                        .exceptionBuilderSupplier(MaximumRuleTemplatesAssociatedWithRepositoryException::builder).build());
            case "ApprovalRuleTemplateContentRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateContentRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateContentRequiredException::builder)
                        .build());
            case "InvalidCommentIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommentIdException::builder).build());
            case "InvalidApprovalStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidApprovalStateException::builder).build());
            case "InvalidCommitException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitException::builder).build());
            case "ApprovalRuleTemplateNameRequiredException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateNameRequiredException")
                                .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateNameRequiredException::builder)
                                .build());
            case "NoChangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoChangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoChangeException::builder).build());
            case "ApprovalRuleDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApprovalRuleDoesNotExistException::builder).build());
            case "MaximumFileContentToLoadExceededException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("MaximumFileContentToLoadExceededException")
                                .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileContentToLoadExceededException::builder)
                                .build());
            case "MultipleRepositoriesInPullRequestException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleRepositoriesInPullRequestException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleRepositoriesInPullRequestException::builder)
                        .build());
            case "BlobIdDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BlobIdDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BlobIdDoesNotExistException::builder).build());
            case "MergeOptionRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MergeOptionRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MergeOptionRequiredException::builder).build());
            case "InvalidPullRequestIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPullRequestIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPullRequestIdException::builder).build());
            case "ApprovalRuleTemplateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApprovalRuleTemplateInUseException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ApprovalRuleTemplateInUseException::builder).build());
            case "FileDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(FileDoesNotExistException::builder).build());
            case "RepositoryNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RepositoryNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RepositoryNameExistsException::builder).build());
            case "PathDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PathDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PathDoesNotExistException::builder).build());
            case "BranchNameExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameExistsException::builder).build());
            case "EncryptionIntegrityChecksFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionIntegrityChecksFailedException")
                        .httpStatusCode(500).exceptionBuilderSupplier(EncryptionIntegrityChecksFailedException::builder).build());
            case "InvalidCommitIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommitIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCommitIdException::builder).build());
            case "InvalidOrderException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOrderException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOrderException::builder).build());
            case "PullRequestAlreadyClosedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestAlreadyClosedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(PullRequestAlreadyClosedException::builder).build());
            case "BranchNameRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("BranchNameRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(BranchNameRequiredException::builder).build());
            case "InvalidRepositoryTriggerNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerNameException::builder).build());
            case "InvalidMergeOptionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMergeOptionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMergeOptionException::builder).build());
            case "ParentCommitIdOutdatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ParentCommitIdOutdatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ParentCommitIdOutdatedException::builder).build());
            case "CommitIdsListRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommitIdsListRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CommitIdsListRequiredException::builder).build());
            case "InvalidContinuationTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContinuationTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidContinuationTokenException::builder).build());
            case "MaximumFileEntriesExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumFileEntriesExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumFileEntriesExceededException::builder).build());
            case "PullRequestApprovalRulesNotSatisfiedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("PullRequestApprovalRulesNotSatisfiedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(PullRequestApprovalRulesNotSatisfiedException::builder)
                        .build());
            case "ClientRequestTokenRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientRequestTokenRequiredException")
                        .httpStatusCode(400).exceptionBuilderSupplier(ClientRequestTokenRequiredException::builder).build());
            case "NameLengthExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NameLengthExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NameLengthExceededException::builder).build());
            case "EncryptionKeyDisabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EncryptionKeyDisabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EncryptionKeyDisabledException::builder).build());
            case "MultipleConflictResolutionEntriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MultipleConflictResolutionEntriesException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MultipleConflictResolutionEntriesException::builder)
                        .build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "FileContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("FileContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(FileContentSizeLimitExceededException::builder).build());
            case "ManualMergeRequiredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ManualMergeRequiredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ManualMergeRequiredException::builder).build());
            case "InvalidApprovalRuleContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidApprovalRuleContentException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidApprovalRuleContentException::builder).build());
            case "InvalidRepositoryTriggerBranchNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerBranchNameException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerBranchNameException::builder)
                        .build());
            case "SameFileContentException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SameFileContentException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SameFileContentException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "InvalidRepositoryTriggerRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRepositoryTriggerRegionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidRepositoryTriggerRegionException::builder).build());
            case "CommentContentSizeLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CommentContentSizeLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CommentContentSizeLimitExceededException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(4