/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information about the scope for a webhook.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScopeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScopeConfiguration.Builder, ScopeConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ScopeConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(ScopeConfiguration::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(ScopeConfiguration::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOMAIN_FIELD,
            SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String domain;

    private final String scope;

    private ScopeConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.domain = builder.domain;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * The name of either the group, enterprise, or organization that will send webhook events to CodeBuild, depending
     * on the type of webhook.
     * </p>
     * 
     * @return The name of either the group, enterprise, or organization that will send webhook events to CodeBuild,
     *         depending on the type of webhook.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The domain of the GitHub Enterprise organization or the GitLab Self Managed group. Note that this parameter is
     * only required if your project's source type is GITHUB_ENTERPRISE or GITLAB_SELF_MANAGED.
     * </p>
     * 
     * @return The domain of the GitHub Enterprise organization or the GitLab Self Managed group. Note that this
     *         parameter is only required if your project's source type is GITHUB_ENTERPRISE or GITLAB_SELF_MANAGED.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The type of scope for a GitHub or GitLab webhook. The scope default is GITHUB_ORGANIZATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link WebhookScopeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The type of scope for a GitHub or GitLab webhook. The scope default is GITHUB_ORGANIZATION.
     * @see WebhookScopeType
     */
    public final WebhookScopeType scope() {
        return WebhookScopeType.fromValue(scope);
    }

    /**
     * <p>
     * The type of scope for a GitHub or GitLab webhook. The scope default is GITHUB_ORGANIZATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link WebhookScopeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The type of scope for a GitHub or GitLab webhook. The scope default is GITHUB_ORGANIZATION.
     * @see WebhookScopeType
     */
    public final String scopeAsString() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScopeConfiguration)) {
            return false;
        }
        ScopeConfiguration other = (ScopeConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(domain(), other.domain())
                && Objects.equals(scopeAsString(), other.scopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScopeConfiguration").add("Name", name()).add("Domain", domain()).add("Scope", scopeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("domain", DOMAIN_FIELD);
        map.put("scope", SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScopeConfiguration, T> g) {
        return obj -> g.apply((ScopeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScopeConfiguration> {
        /**
         * <p>
         * The name of either the group, enterprise, or organization that will send webhook events to CodeBuild,
         * depending on the type of webhook.
         * </p>
         * 
         * @param name
         *        The name of either the group, enterprise, or organization that will send webhook events to CodeBuild,
         *        depending on the type of webhook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The domain of the GitHub Enterprise organization or the GitLab Self Managed group. Note that this parameter
         * is only required if your project's source type is GITHUB_ENTERPRISE or GITLAB_SELF_MANAGED.
         * </p>
         * 
         * @param domain
         *        The domain of the GitHub Enterprise organization or the GitLab Self Managed group. Note that this
         *        parameter is only required if your project's source type is GITHUB_ENTERPRISE or GITLAB_SELF_MANAGED.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The type of scope for a GitHub or GitLab webhook. The scope default is GITHUB_ORGANIZATION.
         * </p>
         * 
         * @param scope
         *        The type of scope for a GitHub or GitLab webhook. The scope default is GITHUB_ORGANIZATION.
         * @see WebhookScopeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebhookScopeType
         */
        Builder scope(String scope);

        /**
         * <p>
         * The type of scope for a GitHub or GitLab webhook. The scope default is GITHUB_ORGANIZATION.
         * </p>
         * 
         * @param scope
         *        The type of scope for a GitHub or GitLab webhook. The scope default is GITHUB_ORGANIZATION.
         * @see WebhookScopeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebhookScopeType
         */
        Builder scope(WebhookScopeType scope);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String domain;

        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(ScopeConfiguration model) {
            name(model.name);
            domain(model.domain);
            scope(model.scope);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(WebhookScopeType scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        @Override
        public ScopeConfiguration build() {
            return new ScopeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
