/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains sandbox information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Sandbox implements SdkPojo, Serializable, ToCopyableBuilder<Sandbox.Builder, Sandbox> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Sandbox::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Sandbox::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(Sandbox::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("requestTime").getter(getter(Sandbox::requestTime)).setter(setter(Builder::requestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(Sandbox::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(Sandbox::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Sandbox::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ProjectSource> SOURCE_FIELD = SdkField.<ProjectSource> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(Sandbox::source)).setter(setter(Builder::source))
            .constructor(ProjectSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVersion").getter(getter(Sandbox::sourceVersion)).setter(setter(Builder::sourceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()).build();

    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_FIELD = SdkField
            .<List<ProjectSource>> builder(MarshallingType.LIST)
            .memberName("secondarySources")
            .getter(getter(Sandbox::secondarySources))
            .setter(setter(Builder::secondarySources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCE_VERSIONS_FIELD = SdkField
            .<List<ProjectSourceVersion>> builder(MarshallingType.LIST)
            .memberName("secondarySourceVersions")
            .getter(getter(Sandbox::secondarySourceVersions))
            .setter(setter(Builder::secondarySourceVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourceVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectSourceVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectSourceVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProjectEnvironment> ENVIRONMENT_FIELD = SdkField
            .<ProjectEnvironment> builder(MarshallingType.SDK_POJO).memberName("environment")
            .getter(getter(Sandbox::environment)).setter(setter(Builder::environment)).constructor(ProjectEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()).build();

    private static final SdkField<List<ProjectFileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField
            .<List<ProjectFileSystemLocation>> builder(MarshallingType.LIST)
            .memberName("fileSystemLocations")
            .getter(getter(Sandbox::fileSystemLocations))
            .setter(setter(Builder::fileSystemLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProjectFileSystemLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProjectFileSystemLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutInMinutes").getter(getter(Sandbox::timeoutInMinutes)).setter(setter(Builder::timeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()).build();

    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queuedTimeoutInMinutes").getter(getter(Sandbox::queuedTimeoutInMinutes))
            .setter(setter(Builder::queuedTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutes").build())
            .build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("vpcConfig").getter(getter(Sandbox::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<LogsConfig> LOG_CONFIG_FIELD = SdkField.<LogsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("logConfig").getter(getter(Sandbox::logConfig)).setter(setter(Builder::logConfig))
            .constructor(LogsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKey").getter(getter(Sandbox::encryptionKey)).setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRole").getter(getter(Sandbox::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<SandboxSession> CURRENT_SESSION_FIELD = SdkField
            .<SandboxSession> builder(MarshallingType.SDK_POJO).memberName("currentSession")
            .getter(getter(Sandbox::currentSession)).setter(setter(Builder::currentSession)).constructor(SandboxSession::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentSession").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            PROJECT_NAME_FIELD, REQUEST_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, SOURCE_FIELD,
            SOURCE_VERSION_FIELD, SECONDARY_SOURCES_FIELD, SECONDARY_SOURCE_VERSIONS_FIELD, ENVIRONMENT_FIELD,
            FILE_SYSTEM_LOCATIONS_FIELD, TIMEOUT_IN_MINUTES_FIELD, QUEUED_TIMEOUT_IN_MINUTES_FIELD, VPC_CONFIG_FIELD,
            LOG_CONFIG_FIELD, ENCRYPTION_KEY_FIELD, SERVICE_ROLE_FIELD, CURRENT_SESSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String projectName;

    private final Instant requestTime;

    private final Instant startTime;

    private final Instant endTime;

    private final String status;

    private final ProjectSource source;

    private final String sourceVersion;

    private final List<ProjectSource> secondarySources;

    private final List<ProjectSourceVersion> secondarySourceVersions;

    private final ProjectEnvironment environment;

    private final List<ProjectFileSystemLocation> fileSystemLocations;

    private final Integer timeoutInMinutes;

    private final Integer queuedTimeoutInMinutes;

    private final VpcConfig vpcConfig;

    private final LogsConfig logConfig;

    private final String encryptionKey;

    private final String serviceRole;

    private final SandboxSession currentSession;

    private Sandbox(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.projectName = builder.projectName;
        this.requestTime = builder.requestTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.source = builder.source;
        this.sourceVersion = builder.sourceVersion;
        this.secondarySources = builder.secondarySources;
        this.secondarySourceVersions = builder.secondarySourceVersions;
        this.environment = builder.environment;
        this.fileSystemLocations = builder.fileSystemLocations;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.queuedTimeoutInMinutes = builder.queuedTimeoutInMinutes;
        this.vpcConfig = builder.vpcConfig;
        this.logConfig = builder.logConfig;
        this.encryptionKey = builder.encryptionKey;
        this.serviceRole = builder.serviceRole;
        this.currentSession = builder.currentSession;
    }

    /**
     * <p>
     * The ID of the sandbox.
     * </p>
     * 
     * @return The ID of the sandbox.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the sandbox.
     * </p>
     * 
     * @return The ARN of the sandbox.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The CodeBuild project name.
     * </p>
     * 
     * @return The CodeBuild project name.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * When the sandbox process was initially requested, expressed in Unix time format.
     * </p>
     * 
     * @return When the sandbox process was initially requested, expressed in Unix time format.
     */
    public final Instant requestTime() {
        return requestTime;
    }

    /**
     * <p>
     * When the sandbox process started, expressed in Unix time format.
     * </p>
     * 
     * @return When the sandbox process started, expressed in Unix time format.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the sandbox process ended, expressed in Unix time format.
     * </p>
     * 
     * @return When the sandbox process ended, expressed in Unix time format.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The status of the sandbox.
     * </p>
     * 
     * @return The status of the sandbox.
     */
    public final String status() {
        return status;
    }

    /**
     * Returns the value of the Source property for this object.
     * 
     * @return The value of the Source property for this object.
     */
    public final ProjectSource source() {
        return source;
    }

    /**
     * <p>
     * Any version identifier for the version of the sandbox to be built.
     * </p>
     * 
     * @return Any version identifier for the version of the sandbox to be built.
     */
    public final String sourceVersion() {
        return sourceVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondarySources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecondarySources() {
        return secondarySources != null && !(secondarySources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSource</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondarySources} method.
     * </p>
     * 
     * @return An array of <code>ProjectSource</code> objects.
     */
    public final List<ProjectSource> secondarySources() {
        return secondarySources;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondarySourceVersions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecondarySourceVersions() {
        return secondarySourceVersions != null && !(secondarySourceVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectSourceVersion</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondarySourceVersions} method.
     * </p>
     * 
     * @return An array of <code>ProjectSourceVersion</code> objects.
     */
    public final List<ProjectSourceVersion> secondarySourceVersions() {
        return secondarySourceVersions;
    }

    /**
     * Returns the value of the Environment property for this object.
     * 
     * @return The value of the Environment property for this object.
     */
    public final ProjectEnvironment environment() {
        return environment;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileSystemLocations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileSystemLocations() {
        return fileSystemLocations != null && !(fileSystemLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
     * <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>,
     * <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using Amazon
     * Elastic File System.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileSystemLocations} method.
     * </p>
     * 
     * @return An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
     *         <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>,
     *         <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a
     *         file system created using Amazon Elastic File System.
     */
    public final List<ProjectFileSystemLocation> fileSystemLocations() {
        return fileSystemLocations;
    }

    /**
     * <p>
     * How long, in minutes, from 5 to 2160 (36 hours), for CodeBuild to wait before timing out this sandbox if it does
     * not get marked as completed.
     * </p>
     * 
     * @return How long, in minutes, from 5 to 2160 (36 hours), for CodeBuild to wait before timing out this sandbox if
     *         it does not get marked as completed.
     */
    public final Integer timeoutInMinutes() {
        return timeoutInMinutes;
    }

    /**
     * <p>
     * The number of minutes a sandbox is allowed to be queued before it times out.
     * </p>
     * 
     * @return The number of minutes a sandbox is allowed to be queued before it times out.
     */
    public final Integer queuedTimeoutInMinutes() {
        return queuedTimeoutInMinutes;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * Returns the value of the LogConfig property for this object.
     * 
     * @return The value of the LogConfig property for this object.
     */
    public final LogsConfig logConfig() {
        return logConfig;
    }

    /**
     * <p>
     * The Key Management Service customer master key (CMK) to be used for encrypting the sandbox output artifacts.
     * </p>
     * 
     * @return The Key Management Service customer master key (CMK) to be used for encrypting the sandbox output
     *         artifacts.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * The name of a service role used for this sandbox.
     * </p>
     * 
     * @return The name of a service role used for this sandbox.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The current session for the sandbox.
     * </p>
     * 
     * @return The current session for the sandbox.
     */
    public final SandboxSession currentSession() {
        return currentSession;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondarySources() ? secondarySources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondarySourceVersions() ? secondarySourceVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystemLocations() ? fileSystemLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(queuedTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(currentSession());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sandbox)) {
            return false;
        }
        Sandbox other = (Sandbox) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(projectName(), other.projectName()) && Objects.equals(requestTime(), other.requestTime())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(status(), other.status()) && Objects.equals(source(), other.source())
                && Objects.equals(sourceVersion(), other.sourceVersion()) && hasSecondarySources() == other.hasSecondarySources()
                && Objects.equals(secondarySources(), other.secondarySources())
                && hasSecondarySourceVersions() == other.hasSecondarySourceVersions()
                && Objects.equals(secondarySourceVersions(), other.secondarySourceVersions())
                && Objects.equals(environment(), other.environment())
                && hasFileSystemLocations() == other.hasFileSystemLocations()
                && Objects.equals(fileSystemLocations(), other.fileSystemLocations())
                && Objects.equals(timeoutInMinutes(), other.timeoutInMinutes())
                && Objects.equals(queuedTimeoutInMinutes(), other.queuedTimeoutInMinutes())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(logConfig(), other.logConfig())
                && Objects.equals(encryptionKey(), other.encryptionKey()) && Objects.equals(serviceRole(), other.serviceRole())
                && Objects.equals(currentSession(), other.currentSession());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Sandbox").add("Id", id()).add("Arn", arn()).add("ProjectName", projectName())
                .add("RequestTime", requestTime()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("Status", status()).add("Source", source()).add("SourceVersion", sourceVersion())
                .add("SecondarySources", hasSecondarySources() ? secondarySources() : null)
                .add("SecondarySourceVersions", hasSecondarySourceVersions() ? secondarySourceVersions() : null)
                .add("Environment", environment())
                .add("FileSystemLocations", hasFileSystemLocations() ? fileSystemLocations() : null)
                .add("TimeoutInMinutes", timeoutInMinutes()).add("QueuedTimeoutInMinutes", queuedTimeoutInMinutes())
                .add("VpcConfig", vpcConfig()).add("LogConfig", logConfig()).add("EncryptionKey", encryptionKey())
                .add("ServiceRole", serviceRole()).add("CurrentSession", currentSession()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "requestTime":
            return Optional.ofNullable(clazz.cast(requestTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "sourceVersion":
            return Optional.ofNullable(clazz.cast(sourceVersion()));
        case "secondarySources":
            return Optional.ofNullable(clazz.cast(secondarySources()));
        case "secondarySourceVersions":
            return Optional.ofNullable(clazz.cast(secondarySourceVersions()));
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "fileSystemLocations":
            return Optional.ofNullable(clazz.cast(fileSystemLocations()));
        case "timeoutInMinutes":
            return Optional.ofNullable(clazz.cast(timeoutInMinutes()));
        case "queuedTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(queuedTimeoutInMinutes()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "logConfig":
            return Optional.ofNullable(clazz.cast(logConfig()));
        case "encryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "currentSession":
            return Optional.ofNullable(clazz.cast(currentSession()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("requestTime", REQUEST_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        map.put("secondarySources", SECONDARY_SOURCES_FIELD);
        map.put("secondarySourceVersions", SECONDARY_SOURCE_VERSIONS_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("fileSystemLocations", FILE_SYSTEM_LOCATIONS_FIELD);
        map.put("timeoutInMinutes", TIMEOUT_IN_MINUTES_FIELD);
        map.put("queuedTimeoutInMinutes", QUEUED_TIMEOUT_IN_MINUTES_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("logConfig", LOG_CONFIG_FIELD);
        map.put("encryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("serviceRole", SERVICE_ROLE_FIELD);
        map.put("currentSession", CURRENT_SESSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sandbox, T> g) {
        return obj -> g.apply((Sandbox) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Sandbox> {
        /**
         * <p>
         * The ID of the sandbox.
         * </p>
         * 
         * @param id
         *        The ID of the sandbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the sandbox.
         * </p>
         * 
         * @param arn
         *        The ARN of the sandbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The CodeBuild project name.
         * </p>
         * 
         * @param projectName
         *        The CodeBuild project name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * When the sandbox process was initially requested, expressed in Unix time format.
         * </p>
         * 
         * @param requestTime
         *        When the sandbox process was initially requested, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTime(Instant requestTime);

        /**
         * <p>
         * When the sandbox process started, expressed in Unix time format.
         * </p>
         * 
         * @param startTime
         *        When the sandbox process started, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the sandbox process ended, expressed in Unix time format.
         * </p>
         * 
         * @param endTime
         *        When the sandbox process ended, expressed in Unix time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The status of the sandbox.
         * </p>
         * 
         * @param status
         *        The status of the sandbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * Sets the value of the Source property for this object.
         *
         * @param source
         *        The new value for the Source property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ProjectSource source);

        /**
         * Sets the value of the Source property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProjectSource.Builder} avoiding the need
         * to create one manually via {@link ProjectSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ProjectSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ProjectSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ProjectSource)
         */
        default Builder source(Consumer<ProjectSource.Builder> source) {
            return source(ProjectSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * Any version identifier for the version of the sandbox to be built.
         * </p>
         * 
         * @param sourceVersion
         *        Any version identifier for the version of the sandbox to be built.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVersion(String sourceVersion);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySources
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySources(Collection<ProjectSource> secondarySources);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * 
         * @param secondarySources
         *        An array of <code>ProjectSource</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySources(ProjectSource... secondarySources);

        /**
         * <p>
         * An array of <code>ProjectSource</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.ProjectSource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codebuild.model.ProjectSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.ProjectSource.Builder#build()} is called immediately
         * and its result is passed to {@link #secondarySources(List<ProjectSource>)}.
         * 
         * @param secondarySources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.ProjectSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySources(java.util.Collection<ProjectSource>)
         */
        Builder secondarySources(Consumer<ProjectSource.Builder>... secondarySources);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects.
         * </p>
         * 
         * @param secondarySourceVersions
         *        An array of <code>ProjectSourceVersion</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects.
         * </p>
         * 
         * @param secondarySourceVersions
         *        An array of <code>ProjectSourceVersion</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondarySourceVersions(ProjectSourceVersion... secondarySourceVersions);

        /**
         * <p>
         * An array of <code>ProjectSourceVersion</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion.Builder#build()} is called
         * immediately and its result is passed to {@link #secondarySourceVersions(List<ProjectSourceVersion>)}.
         * 
         * @param secondarySourceVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondarySourceVersions(java.util.Collection<ProjectSourceVersion>)
         */
        Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder>... secondarySourceVersions);

        /**
         * Sets the value of the Environment property for this object.
         *
         * @param environment
         *        The new value for the Environment property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(ProjectEnvironment environment);

        /**
         * Sets the value of the Environment property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ProjectEnvironment.Builder} avoiding the
         * need to create one manually via {@link ProjectEnvironment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectEnvironment.Builder#build()} is called immediately and its
         * result is passed to {@link #environment(ProjectEnvironment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link ProjectEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(ProjectEnvironment)
         */
        default Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return environment(ProjectEnvironment.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         * <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>,
         * <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using
         * Amazon Elastic File System.
         * </p>
         * 
         * @param fileSystemLocations
         *        An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         *        <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>,
         *        <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a
         *        file system created using Amazon Elastic File System.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations);

        /**
         * <p>
         * An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         * <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>,
         * <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using
         * Amazon Elastic File System.
         * </p>
         * 
         * @param fileSystemLocations
         *        An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         *        <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>,
         *        <code>location</code>, <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a
         *        file system created using Amazon Elastic File System.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemLocations(ProjectFileSystemLocation... fileSystemLocations);

        /**
         * <p>
         * An array of <code>ProjectFileSystemLocation</code> objects for a CodeBuild build project. A
         * <code>ProjectFileSystemLocation</code> object specifies the <code>identifier</code>, <code>location</code>,
         * <code>mountOptions</code>, <code>mountPoint</code>, and <code>type</code> of a file system created using
         * Amazon Elastic File System.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #fileSystemLocations(List<ProjectFileSystemLocation>)}.
         * 
         * @param fileSystemLocations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemLocations(java.util.Collection<ProjectFileSystemLocation>)
         */
        Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder>... fileSystemLocations);

        /**
         * <p>
         * How long, in minutes, from 5 to 2160 (36 hours), for CodeBuild to wait before timing out this sandbox if it
         * does not get marked as completed.
         * </p>
         * 
         * @param timeoutInMinutes
         *        How long, in minutes, from 5 to 2160 (36 hours), for CodeBuild to wait before timing out this sandbox
         *        if it does not get marked as completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInMinutes(Integer timeoutInMinutes);

        /**
         * <p>
         * The number of minutes a sandbox is allowed to be queued before it times out.
         * </p>
         * 
         * @param queuedTimeoutInMinutes
         *        The number of minutes a sandbox is allowed to be queued before it times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * Sets the value of the LogConfig property for this object.
         *
         * @param logConfig
         *        The new value for the LogConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfig(LogsConfig logConfig);

        /**
         * Sets the value of the LogConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LogsConfig.Builder} avoiding the need to
         * create one manually via {@link LogsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogsConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logConfig(LogsConfig)}.
         * 
         * @param logConfig
         *        a consumer that will call methods on {@link LogsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfig(LogsConfig)
         */
        default Builder logConfig(Consumer<LogsConfig.Builder> logConfig) {
            return logConfig(LogsConfig.builder().applyMutation(logConfig).build());
        }

        /**
         * <p>
         * The Key Management Service customer master key (CMK) to be used for encrypting the sandbox output artifacts.
         * </p>
         * 
         * @param encryptionKey
         *        The Key Management Service customer master key (CMK) to be used for encrypting the sandbox output
         *        artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * The name of a service role used for this sandbox.
         * </p>
         * 
         * @param serviceRole
         *        The name of a service role used for this sandbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The current session for the sandbox.
         * </p>
         * 
         * @param currentSession
         *        The current session for the sandbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentSession(SandboxSession currentSession);

        /**
         * <p>
         * The current session for the sandbox.
         * </p>
         * This is a convenience method that creates an instance of the {@link SandboxSession.Builder} avoiding the need
         * to create one manually via {@link SandboxSession#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SandboxSession.Builder#build()} is called immediately and its
         * result is passed to {@link #currentSession(SandboxSession)}.
         * 
         * @param currentSession
         *        a consumer that will call methods on {@link SandboxSession.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentSession(SandboxSession)
         */
        default Builder currentSession(Consumer<SandboxSession.Builder> currentSession) {
            return currentSession(SandboxSession.builder().applyMutation(currentSession).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String projectName;

        private Instant requestTime;

        private Instant startTime;

        private Instant endTime;

        private String status;

        private ProjectSource source;

        private String sourceVersion;

        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();

        private List<ProjectSourceVersion> secondarySourceVersions = DefaultSdkAutoConstructList.getInstance();

        private ProjectEnvironment environment;

        private List<ProjectFileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();

        private Integer timeoutInMinutes;

        private Integer queuedTimeoutInMinutes;

        private VpcConfig vpcConfig;

        private LogsConfig logConfig;

        private String encryptionKey;

        private String serviceRole;

        private SandboxSession currentSession;

        private BuilderImpl() {
        }

        private BuilderImpl(Sandbox model) {
            id(model.id);
            arn(model.arn);
            projectName(model.projectName);
            requestTime(model.requestTime);
            startTime(model.startTime);
            endTime(model.endTime);
            status(model.status);
            source(model.source);
            sourceVersion(model.sourceVersion);
            secondarySources(model.secondarySources);
            secondarySourceVersions(model.secondarySourceVersions);
            environment(model.environment);
            fileSystemLocations(model.fileSystemLocations);
            timeoutInMinutes(model.timeoutInMinutes);
            queuedTimeoutInMinutes(model.queuedTimeoutInMinutes);
            vpcConfig(model.vpcConfig);
            logConfig(model.logConfig);
            encryptionKey(model.encryptionKey);
            serviceRole(model.serviceRole);
            currentSession(model.currentSession);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final Instant getRequestTime() {
            return requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final ProjectSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final String getSourceVersion() {
            return sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final List<ProjectSource.Builder> getSecondarySources() {
            List<ProjectSource.Builder> result = ProjectSourcesCopier.copyToBuilder(this.secondarySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        @Override
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(ProjectSource... secondarySources) {
            secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder>... secondarySources) {
            secondarySources(Stream.of(secondarySources).map(c -> ProjectSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ProjectSourceVersion.Builder> getSecondarySourceVersions() {
            List<ProjectSourceVersion.Builder> result = ProjectSecondarySourceVersionsCopier
                    .copyToBuilder(this.secondarySourceVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourceVersions(Collection<ProjectSourceVersion.BuilderImpl> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourceVersions);
        }

        @Override
        public final Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copy(secondarySourceVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(ProjectSourceVersion... secondarySourceVersions) {
            secondarySourceVersions(Arrays.asList(secondarySourceVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder>... secondarySourceVersions) {
            secondarySourceVersions(Stream.of(secondarySourceVersions)
                    .map(c -> ProjectSourceVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final List<ProjectFileSystemLocation.Builder> getFileSystemLocations() {
            List<ProjectFileSystemLocation.Builder> result = ProjectFileSystemLocationsCopier
                    .copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<ProjectFileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        public final Builder fileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(ProjectFileSystemLocation... fileSystemLocations) {
            fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder>... fileSystemLocations) {
            fileSystemLocations(Stream.of(fileSystemLocations)
                    .map(c -> ProjectFileSystemLocation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final Integer getQueuedTimeoutInMinutes() {
            return queuedTimeoutInMinutes;
        }

        public final void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
        }

        @Override
        public final Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final LogsConfig.Builder getLogConfig() {
            return logConfig != null ? logConfig.toBuilder() : null;
        }

        public final void setLogConfig(LogsConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(LogsConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final SandboxSession.Builder getCurrentSession() {
            return currentSession != null ? currentSession.toBuilder() : null;
        }

        public final void setCurrentSession(SandboxSession.BuilderImpl currentSession) {
            this.currentSession = currentSession != null ? currentSession.build() : null;
        }

        @Override
        public final Builder currentSession(SandboxSession currentSession) {
            this.currentSession = currentSession;
            return this;
        }

        @Override
        public Sandbox build() {
            return new Sandbox(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
