/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Session Manager session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SSMSession implements SdkPojo, Serializable, ToCopyableBuilder<SSMSession.Builder, SSMSession> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(SSMSession::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> TOKEN_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenValue").getter(getter(SSMSession::tokenValue)).setter(setter(Builder::tokenValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenValue").build()).build();

    private static final SdkField<String> STREAM_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("streamUrl").getter(getter(SSMSession::streamUrl)).setter(setter(Builder::streamUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            TOKEN_VALUE_FIELD, STREAM_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sessionId;

    private final String tokenValue;

    private final String streamUrl;

    private SSMSession(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.tokenValue = builder.tokenValue;
        this.streamUrl = builder.streamUrl;
    }

    /**
     * <p>
     * The ID of the session.
     * </p>
     * 
     * @return The ID of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * An encrypted token value containing session and caller information.
     * </p>
     * 
     * @return An encrypted token value containing session and caller information.
     */
    public final String tokenValue() {
        return tokenValue;
    }

    /**
     * <p>
     * A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive
     * output from the node.
     * </p>
     * 
     * @return A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and
     *         receive output from the node.
     */
    public final String streamUrl() {
        return streamUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(tokenValue());
        hashCode = 31 * hashCode + Objects.hashCode(streamUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSMSession)) {
            return false;
        }
        SSMSession other = (SSMSession) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(tokenValue(), other.tokenValue())
                && Objects.equals(streamUrl(), other.streamUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SSMSession").add("SessionId", sessionId()).add("TokenValue", tokenValue())
                .add("StreamUrl", streamUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "tokenValue":
            return Optional.ofNullable(clazz.cast(tokenValue()));
        case "streamUrl":
            return Optional.ofNullable(clazz.cast(streamUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("tokenValue", TOKEN_VALUE_FIELD);
        map.put("streamUrl", STREAM_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SSMSession, T> g) {
        return obj -> g.apply((SSMSession) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SSMSession> {
        /**
         * <p>
         * The ID of the session.
         * </p>
         * 
         * @param sessionId
         *        The ID of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * An encrypted token value containing session and caller information.
         * </p>
         * 
         * @param tokenValue
         *        An encrypted token value containing session and caller information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenValue(String tokenValue);

        /**
         * <p>
         * A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive
         * output from the node.
         * </p>
         * 
         * @param streamUrl
         *        A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and
         *        receive output from the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamUrl(String streamUrl);
    }

    static final class BuilderImpl implements Builder {
        private String sessionId;

        private String tokenValue;

        private String streamUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SSMSession model) {
            sessionId(model.sessionId);
            tokenValue(model.tokenValue);
            streamUrl(model.streamUrl);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getTokenValue() {
            return tokenValue;
        }

        public final void setTokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
        }

        @Override
        public final Builder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            return this;
        }

        public final String getStreamUrl() {
            return streamUrl;
        }

        public final void setStreamUrl(String streamUrl) {
            this.streamUrl = streamUrl;
        }

        @Override
        public final Builder streamUrl(String streamUrl) {
            this.streamUrl = streamUrl;
            return this;
        }

        @Override
        public SSMSession build() {
            return new SSMSession(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
