/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the proxy configurations that apply network access control to your reserved capacity instances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProxyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProxyConfiguration.Builder, ProxyConfiguration> {
    private static final SdkField<String> DEFAULT_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultBehavior").getter(getter(ProxyConfiguration::defaultBehaviorAsString))
            .setter(setter(Builder::defaultBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBehavior").build()).build();

    private static final SdkField<List<FleetProxyRule>> ORDERED_PROXY_RULES_FIELD = SdkField
            .<List<FleetProxyRule>> builder(MarshallingType.LIST)
            .memberName("orderedProxyRules")
            .getter(getter(ProxyConfiguration::orderedProxyRules))
            .setter(setter(Builder::orderedProxyRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orderedProxyRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetProxyRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetProxyRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_BEHAVIOR_FIELD,
            ORDERED_PROXY_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String defaultBehavior;

    private final List<FleetProxyRule> orderedProxyRules;

    private ProxyConfiguration(BuilderImpl builder) {
        this.defaultBehavior = builder.defaultBehavior;
        this.orderedProxyRules = builder.orderedProxyRules;
    }

    /**
     * <p>
     * The default behavior of outgoing traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultBehavior}
     * will return {@link FleetProxyRuleBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultBehaviorAsString}.
     * </p>
     * 
     * @return The default behavior of outgoing traffic.
     * @see FleetProxyRuleBehavior
     */
    public final FleetProxyRuleBehavior defaultBehavior() {
        return FleetProxyRuleBehavior.fromValue(defaultBehavior);
    }

    /**
     * <p>
     * The default behavior of outgoing traffic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #defaultBehavior}
     * will return {@link FleetProxyRuleBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #defaultBehaviorAsString}.
     * </p>
     * 
     * @return The default behavior of outgoing traffic.
     * @see FleetProxyRuleBehavior
     */
    public final String defaultBehaviorAsString() {
        return defaultBehavior;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrderedProxyRules property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOrderedProxyRules() {
        return orderedProxyRules != null && !(orderedProxyRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or IPs to allow
     * or deny network access control to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrderedProxyRules} method.
     * </p>
     * 
     * @return An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or IPs
     *         to allow or deny network access control to.
     */
    public final List<FleetProxyRule> orderedProxyRules() {
        return orderedProxyRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrderedProxyRules() ? orderedProxyRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration other = (ProxyConfiguration) obj;
        return Objects.equals(defaultBehaviorAsString(), other.defaultBehaviorAsString())
                && hasOrderedProxyRules() == other.hasOrderedProxyRules()
                && Objects.equals(orderedProxyRules(), other.orderedProxyRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProxyConfiguration").add("DefaultBehavior", defaultBehaviorAsString())
                .add("OrderedProxyRules", hasOrderedProxyRules() ? orderedProxyRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultBehavior":
            return Optional.ofNullable(clazz.cast(defaultBehaviorAsString()));
        case "orderedProxyRules":
            return Optional.ofNullable(clazz.cast(orderedProxyRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("defaultBehavior", DEFAULT_BEHAVIOR_FIELD);
        map.put("orderedProxyRules", ORDERED_PROXY_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProxyConfiguration, T> g) {
        return obj -> g.apply((ProxyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProxyConfiguration> {
        /**
         * <p>
         * The default behavior of outgoing traffic.
         * </p>
         * 
         * @param defaultBehavior
         *        The default behavior of outgoing traffic.
         * @see FleetProxyRuleBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetProxyRuleBehavior
         */
        Builder defaultBehavior(String defaultBehavior);

        /**
         * <p>
         * The default behavior of outgoing traffic.
         * </p>
         * 
         * @param defaultBehavior
         *        The default behavior of outgoing traffic.
         * @see FleetProxyRuleBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetProxyRuleBehavior
         */
        Builder defaultBehavior(FleetProxyRuleBehavior defaultBehavior);

        /**
         * <p>
         * An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or IPs to
         * allow or deny network access control to.
         * </p>
         * 
         * @param orderedProxyRules
         *        An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or
         *        IPs to allow or deny network access control to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedProxyRules(Collection<FleetProxyRule> orderedProxyRules);

        /**
         * <p>
         * An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or IPs to
         * allow or deny network access control to.
         * </p>
         * 
         * @param orderedProxyRules
         *        An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or
         *        IPs to allow or deny network access control to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedProxyRules(FleetProxyRule... orderedProxyRules);

        /**
         * <p>
         * An array of <code>FleetProxyRule</code> objects that represent the specified destination domains or IPs to
         * allow or deny network access control to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.FleetProxyRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codebuild.model.FleetProxyRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.FleetProxyRule.Builder#build()} is called immediately
         * and its result is passed to {@link #orderedProxyRules(List<FleetProxyRule>)}.
         * 
         * @param orderedProxyRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.FleetProxyRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderedProxyRules(java.util.Collection<FleetProxyRule>)
         */
        Builder orderedProxyRules(Consumer<FleetProxyRule.Builder>... orderedProxyRules);
    }

    static final class BuilderImpl implements Builder {
        private String defaultBehavior;

        private List<FleetProxyRule> orderedProxyRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfiguration model) {
            defaultBehavior(model.defaultBehavior);
            orderedProxyRules(model.orderedProxyRules);
        }

        public final String getDefaultBehavior() {
            return defaultBehavior;
        }

        public final void setDefaultBehavior(String defaultBehavior) {
            this.defaultBehavior = defaultBehavior;
        }

        @Override
        public final Builder defaultBehavior(String defaultBehavior) {
            this.defaultBehavior = defaultBehavior;
            return this;
        }

        @Override
        public final Builder defaultBehavior(FleetProxyRuleBehavior defaultBehavior) {
            this.defaultBehavior(defaultBehavior == null ? null : defaultBehavior.toString());
            return this;
        }

        public final List<FleetProxyRule.Builder> getOrderedProxyRules() {
            List<FleetProxyRule.Builder> result = FleetProxyRulesCopier.copyToBuilder(this.orderedProxyRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderedProxyRules(Collection<FleetProxyRule.BuilderImpl> orderedProxyRules) {
            this.orderedProxyRules = FleetProxyRulesCopier.copyFromBuilder(orderedProxyRules);
        }

        @Override
        public final Builder orderedProxyRules(Collection<FleetProxyRule> orderedProxyRules) {
            this.orderedProxyRules = FleetProxyRulesCopier.copy(orderedProxyRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedProxyRules(FleetProxyRule... orderedProxyRules) {
            orderedProxyRules(Arrays.asList(orderedProxyRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedProxyRules(Consumer<FleetProxyRule.Builder>... orderedProxyRules) {
            orderedProxyRules(Stream.of(orderedProxyRules).map(c -> FleetProxyRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
