/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the build badge for the build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProjectBadge implements SdkPojo, Serializable, ToCopyableBuilder<ProjectBadge.Builder, ProjectBadge> {
    private static final SdkField<Boolean> BADGE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("badgeEnabled").getter(getter(ProjectBadge::badgeEnabled)).setter(setter(Builder::badgeEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("badgeEnabled").build()).build();

    private static final SdkField<String> BADGE_REQUEST_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("badgeRequestUrl").getter(getter(ProjectBadge::badgeRequestUrl)).setter(setter(Builder::badgeRequestUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("badgeRequestUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BADGE_ENABLED_FIELD,
            BADGE_REQUEST_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean badgeEnabled;

    private final String badgeRequestUrl;

    private ProjectBadge(BuilderImpl builder) {
        this.badgeEnabled = builder.badgeEnabled;
        this.badgeRequestUrl = builder.badgeRequestUrl;
    }

    /**
     * <p>
     * Set this to true to generate a publicly accessible URL for your project's build badge.
     * </p>
     * 
     * @return Set this to true to generate a publicly accessible URL for your project's build badge.
     */
    public final Boolean badgeEnabled() {
        return badgeEnabled;
    }

    /**
     * <p>
     * The publicly-accessible URL through which you can access the build badge for your project.
     * </p>
     * 
     * @return The publicly-accessible URL through which you can access the build badge for your project.
     */
    public final String badgeRequestUrl() {
        return badgeRequestUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(badgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(badgeRequestUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectBadge)) {
            return false;
        }
        ProjectBadge other = (ProjectBadge) obj;
        return Objects.equals(badgeEnabled(), other.badgeEnabled()) && Objects.equals(badgeRequestUrl(), other.badgeRequestUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProjectBadge").add("BadgeEnabled", badgeEnabled()).add("BadgeRequestUrl", badgeRequestUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "badgeEnabled":
            return Optional.ofNullable(clazz.cast(badgeEnabled()));
        case "badgeRequestUrl":
            return Optional.ofNullable(clazz.cast(badgeRequestUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("badgeEnabled", BADGE_ENABLED_FIELD);
        map.put("badgeRequestUrl", BADGE_REQUEST_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProjectBadge, T> g) {
        return obj -> g.apply((ProjectBadge) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProjectBadge> {
        /**
         * <p>
         * Set this to true to generate a publicly accessible URL for your project's build badge.
         * </p>
         * 
         * @param badgeEnabled
         *        Set this to true to generate a publicly accessible URL for your project's build badge.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder badgeEnabled(Boolean badgeEnabled);

        /**
         * <p>
         * The publicly-accessible URL through which you can access the build badge for your project.
         * </p>
         * 
         * @param badgeRequestUrl
         *        The publicly-accessible URL through which you can access the build badge for your project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder badgeRequestUrl(String badgeRequestUrl);
    }

    static final class BuilderImpl implements Builder {
        private Boolean badgeEnabled;

        private String badgeRequestUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectBadge model) {
            badgeEnabled(model.badgeEnabled);
            badgeRequestUrl(model.badgeRequestUrl);
        }

        public final Boolean getBadgeEnabled() {
            return badgeEnabled;
        }

        public final void setBadgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
        }

        @Override
        public final Builder badgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
            return this;
        }

        public final String getBadgeRequestUrl() {
            return badgeRequestUrl;
        }

        public final void setBadgeRequestUrl(String badgeRequestUrl) {
            this.badgeRequestUrl = badgeRequestUrl;
        }

        @Override
        public final Builder badgeRequestUrl(String badgeRequestUrl) {
            this.badgeRequestUrl = badgeRequestUrl;
            return this;
        }

        @Override
        public ProjectBadge build() {
            return new ProjectBadge(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
