/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBuildsForProjectRequest extends CodeBuildRequest implements
        ToCopyableBuilder<ListBuildsForProjectRequest.Builder, ListBuildsForProjectRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectName").getter(getter(ListBuildsForProjectRequest::projectName))
            .setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListBuildsForProjectRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBuildsForProjectRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            SORT_ORDER_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectName;

    private final String sortOrder;

    private final String nextToken;

    private ListBuildsForProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the CodeBuild project.
     * </p>
     * 
     * @return The name of the CodeBuild project.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * The order to sort the results in. The results are sorted by build number, not the build identifier. If this is
     * not specified, the results are sorted in descending order.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESCENDING</code>: List the build identifiers in descending order, by build number.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the project has more than 100 builds, setting the sort order will result in an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort the results in. The results are sorted by build number, not the build identifier. If
     *         this is not specified, the results are sorted in descending order.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESCENDING</code>: List the build identifiers in descending order, by build number.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the project has more than 100 builds, setting the sort order will result in an error.
     * @see SortOrderType
     */
    public final SortOrderType sortOrder() {
        return SortOrderType.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order to sort the results in. The results are sorted by build number, not the build identifier. If this is
     * not specified, the results are sorted in descending order.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DESCENDING</code>: List the build identifiers in descending order, by build number.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the project has more than 100 builds, setting the sort order will result in an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order to sort the results in. The results are sorted by build number, not the build identifier. If
     *         this is not specified, the results are sorted in descending order.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DESCENDING</code>: List the build identifiers in descending order, by build number.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the project has more than 100 builds, setting the sort order will result in an error.
     * @see SortOrderType
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * During a previous call, if there are more than 100 items in the list, only the first 100 items are returned,
     * along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this
     * operation again, adding the next token to the call. To get all of the items in the list, keep calling this
     * operation with each subsequent next token that is returned, until no more next tokens are returned.
     * </p>
     * 
     * @return During a previous call, if there are more than 100 items in the list, only the first 100 items are
     *         returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the
     *         list, call this operation again, adding the next token to the call. To get all of the items in the list,
     *         keep calling this operation with each subsequent next token that is returned, until no more next tokens
     *         are returned.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuildsForProjectRequest)) {
            return false;
        }
        ListBuildsForProjectRequest other = (ListBuildsForProjectRequest) obj;
        return Objects.equals(projectName(), other.projectName())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBuildsForProjectRequest").add("ProjectName", projectName())
                .add("SortOrder", sortOrderAsString()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("projectName", PROJECT_NAME_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBuildsForProjectRequest, T> g) {
        return obj -> g.apply((ListBuildsForProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListBuildsForProjectRequest> {
        /**
         * <p>
         * The name of the CodeBuild project.
         * </p>
         * 
         * @param projectName
         *        The name of the CodeBuild project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * The order to sort the results in. The results are sorted by build number, not the build identifier. If this
         * is not specified, the results are sorted in descending order.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESCENDING</code>: List the build identifiers in descending order, by build number.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the project has more than 100 builds, setting the sort order will result in an error.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort the results in. The results are sorted by build number, not the build identifier. If
         *        this is not specified, the results are sorted in descending order.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESCENDING</code>: List the build identifiers in descending order, by build number.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the project has more than 100 builds, setting the sort order will result in an error.
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order to sort the results in. The results are sorted by build number, not the build identifier. If this
         * is not specified, the results are sorted in descending order.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DESCENDING</code>: List the build identifiers in descending order, by build number.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the project has more than 100 builds, setting the sort order will result in an error.
         * </p>
         * 
         * @param sortOrder
         *        The order to sort the results in. The results are sorted by build number, not the build identifier. If
         *        this is not specified, the results are sorted in descending order.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASCENDING</code>: List the build identifiers in ascending order, by build number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DESCENDING</code>: List the build identifiers in descending order, by build number.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the project has more than 100 builds, setting the sort order will result in an error.
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(SortOrderType sortOrder);

        /**
         * <p>
         * During a previous call, if there are more than 100 items in the list, only the first 100 items are returned,
         * along with a unique string called a <i>nextToken</i>. To get the next batch of items in the list, call this
         * operation again, adding the next token to the call. To get all of the items in the list, keep calling this
         * operation with each subsequent next token that is returned, until no more next tokens are returned.
         * </p>
         * 
         * @param nextToken
         *        During a previous call, if there are more than 100 items in the list, only the first 100 items are
         *        returned, along with a unique string called a <i>nextToken</i>. To get the next batch of items in the
         *        list, call this operation again, adding the next token to the call. To get all of the items in the
         *        list, keep calling this operation with each subsequent next token that is returned, until no more next
         *        tokens are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String projectName;

        private String sortOrder;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuildsForProjectRequest model) {
            super(model);
            projectName(model.projectName);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBuildsForProjectRequest build() {
            return new ListBuildsForProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
