/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCodeCoveragesRequest extends CodeBuildRequest implements
        ToCopyableBuilder<DescribeCodeCoveragesRequest.Builder, DescribeCodeCoveragesRequest> {
    private static final SdkField<String> REPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportArn").getter(getter(DescribeCodeCoveragesRequest::reportArn)).setter(setter(Builder::reportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportArn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeCodeCoveragesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeCodeCoveragesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(DescribeCodeCoveragesRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortOrder").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(DescribeCodeCoveragesRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<Double> MIN_LINE_COVERAGE_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("minLineCoveragePercentage").getter(getter(DescribeCodeCoveragesRequest::minLineCoveragePercentage))
            .setter(setter(Builder::minLineCoveragePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLineCoveragePercentage").build())
            .build();

    private static final SdkField<Double> MAX_LINE_COVERAGE_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("maxLineCoveragePercentage").getter(getter(DescribeCodeCoveragesRequest::maxLineCoveragePercentage))
            .setter(setter(Builder::maxLineCoveragePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLineCoveragePercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, MIN_LINE_COVERAGE_PERCENTAGE_FIELD,
            MAX_LINE_COVERAGE_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reportArn;

    private final String nextToken;

    private final Integer maxResults;

    private final String sortOrder;

    private final String sortBy;

    private final Double minLineCoveragePercentage;

    private final Double maxLineCoveragePercentage;

    private DescribeCodeCoveragesRequest(BuilderImpl builder) {
        super(builder);
        this.reportArn = builder.reportArn;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.minLineCoveragePercentage = builder.minLineCoveragePercentage;
        this.maxLineCoveragePercentage = builder.maxLineCoveragePercentage;
    }

    /**
     * <p>
     * The ARN of the report for which test cases are returned.
     * </p>
     * 
     * @return The ARN of the report for which test cases are returned.
     */
    public final String reportArn() {
        return reportArn;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous call to <code>DescribeCodeCoverages</code>. This
     * specifies the next item to return. To return the beginning of the list, exclude this parameter.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous call to <code>DescribeCodeCoverages</code>.
     *         This specifies the next item to return. To return the beginning of the list, exclude this parameter.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies if the results are sorted in ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies if the results are sorted in ascending or descending order.
     * @see SortOrderType
     */
    public final SortOrderType sortOrder() {
        return SortOrderType.fromValue(sortOrder);
    }

    /**
     * <p>
     * Specifies if the results are sorted in ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Specifies if the results are sorted in ascending or descending order.
     * @see SortOrderType
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * Specifies how the results are sorted. Possible values are:
     * </p>
     * <dl>
     * <dt>FILE_PATH</dt>
     * <dd>
     * <p>
     * The results are sorted by file path.
     * </p>
     * </dd>
     * <dt>LINE_COVERAGE_PERCENTAGE</dt>
     * <dd>
     * <p>
     * The results are sorted by the percentage of lines that are covered.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ReportCodeCoverageSortByType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies how the results are sorted. Possible values are:</p>
     *         <dl>
     *         <dt>FILE_PATH</dt>
     *         <dd>
     *         <p>
     *         The results are sorted by file path.
     *         </p>
     *         </dd>
     *         <dt>LINE_COVERAGE_PERCENTAGE</dt>
     *         <dd>
     *         <p>
     *         The results are sorted by the percentage of lines that are covered.
     *         </p>
     *         </dd>
     * @see ReportCodeCoverageSortByType
     */
    public final ReportCodeCoverageSortByType sortBy() {
        return ReportCodeCoverageSortByType.fromValue(sortBy);
    }

    /**
     * <p>
     * Specifies how the results are sorted. Possible values are:
     * </p>
     * <dl>
     * <dt>FILE_PATH</dt>
     * <dd>
     * <p>
     * The results are sorted by file path.
     * </p>
     * </dd>
     * <dt>LINE_COVERAGE_PERCENTAGE</dt>
     * <dd>
     * <p>
     * The results are sorted by the percentage of lines that are covered.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ReportCodeCoverageSortByType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies how the results are sorted. Possible values are:</p>
     *         <dl>
     *         <dt>FILE_PATH</dt>
     *         <dd>
     *         <p>
     *         The results are sorted by file path.
     *         </p>
     *         </dd>
     *         <dt>LINE_COVERAGE_PERCENTAGE</dt>
     *         <dd>
     *         <p>
     *         The results are sorted by the percentage of lines that are covered.
     *         </p>
     *         </dd>
     * @see ReportCodeCoverageSortByType
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The minimum line coverage percentage to report.
     * </p>
     * 
     * @return The minimum line coverage percentage to report.
     */
    public final Double minLineCoveragePercentage() {
        return minLineCoveragePercentage;
    }

    /**
     * <p>
     * The maximum line coverage percentage to report.
     * </p>
     * 
     * @return The maximum line coverage percentage to report.
     */
    public final Double maxLineCoveragePercentage() {
        return maxLineCoveragePercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reportArn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minLineCoveragePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(maxLineCoveragePercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCodeCoveragesRequest)) {
            return false;
        }
        DescribeCodeCoveragesRequest other = (DescribeCodeCoveragesRequest) obj;
        return Objects.equals(reportArn(), other.reportArn()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(minLineCoveragePercentage(), other.minLineCoveragePercentage())
                && Objects.equals(maxLineCoveragePercentage(), other.maxLineCoveragePercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCodeCoveragesRequest").add("ReportArn", reportArn()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SortOrder", sortOrderAsString()).add("SortBy", sortByAsString())
                .add("MinLineCoveragePercentage", minLineCoveragePercentage())
                .add("MaxLineCoveragePercentage", maxLineCoveragePercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportArn":
            return Optional.ofNullable(clazz.cast(reportArn()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "minLineCoveragePercentage":
            return Optional.ofNullable(clazz.cast(minLineCoveragePercentage()));
        case "maxLineCoveragePercentage":
            return Optional.ofNullable(clazz.cast(maxLineCoveragePercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reportArn", REPORT_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("minLineCoveragePercentage", MIN_LINE_COVERAGE_PERCENTAGE_FIELD);
        map.put("maxLineCoveragePercentage", MAX_LINE_COVERAGE_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCodeCoveragesRequest, T> g) {
        return obj -> g.apply((DescribeCodeCoveragesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCodeCoveragesRequest> {
        /**
         * <p>
         * The ARN of the report for which test cases are returned.
         * </p>
         * 
         * @param reportArn
         *        The ARN of the report for which test cases are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportArn(String reportArn);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous call to <code>DescribeCodeCoverages</code>. This
         * specifies the next item to return. To return the beginning of the list, exclude this parameter.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous call to <code>DescribeCodeCoverages</code>.
         *        This specifies the next item to return. To return the beginning of the list, exclude this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies if the results are sorted in ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Specifies if the results are sorted in ascending or descending order.
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Specifies if the results are sorted in ascending or descending order.
         * </p>
         * 
         * @param sortOrder
         *        Specifies if the results are sorted in ascending or descending order.
         * @see SortOrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrderType
         */
        Builder sortOrder(SortOrderType sortOrder);

        /**
         * <p>
         * Specifies how the results are sorted. Possible values are:
         * </p>
         * <dl>
         * <dt>FILE_PATH</dt>
         * <dd>
         * <p>
         * The results are sorted by file path.
         * </p>
         * </dd>
         * <dt>LINE_COVERAGE_PERCENTAGE</dt>
         * <dd>
         * <p>
         * The results are sorted by the percentage of lines that are covered.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param sortBy
         *        Specifies how the results are sorted. Possible values are:</p>
         *        <dl>
         *        <dt>FILE_PATH</dt>
         *        <dd>
         *        <p>
         *        The results are sorted by file path.
         *        </p>
         *        </dd>
         *        <dt>LINE_COVERAGE_PERCENTAGE</dt>
         *        <dd>
         *        <p>
         *        The results are sorted by the percentage of lines that are covered.
         *        </p>
         *        </dd>
         * @see ReportCodeCoverageSortByType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportCodeCoverageSortByType
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Specifies how the results are sorted. Possible values are:
         * </p>
         * <dl>
         * <dt>FILE_PATH</dt>
         * <dd>
         * <p>
         * The results are sorted by file path.
         * </p>
         * </dd>
         * <dt>LINE_COVERAGE_PERCENTAGE</dt>
         * <dd>
         * <p>
         * The results are sorted by the percentage of lines that are covered.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param sortBy
         *        Specifies how the results are sorted. Possible values are:</p>
         *        <dl>
         *        <dt>FILE_PATH</dt>
         *        <dd>
         *        <p>
         *        The results are sorted by file path.
         *        </p>
         *        </dd>
         *        <dt>LINE_COVERAGE_PERCENTAGE</dt>
         *        <dd>
         *        <p>
         *        The results are sorted by the percentage of lines that are covered.
         *        </p>
         *        </dd>
         * @see ReportCodeCoverageSortByType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportCodeCoverageSortByType
         */
        Builder sortBy(ReportCodeCoverageSortByType sortBy);

        /**
         * <p>
         * The minimum line coverage percentage to report.
         * </p>
         * 
         * @param minLineCoveragePercentage
         *        The minimum line coverage percentage to report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLineCoveragePercentage(Double minLineCoveragePercentage);

        /**
         * <p>
         * The maximum line coverage percentage to report.
         * </p>
         * 
         * @param maxLineCoveragePercentage
         *        The maximum line coverage percentage to report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLineCoveragePercentage(Double maxLineCoveragePercentage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String reportArn;

        private String nextToken;

        private Integer maxResults;

        private String sortOrder;

        private String sortBy;

        private Double minLineCoveragePercentage;

        private Double maxLineCoveragePercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCodeCoveragesRequest model) {
            super(model);
            reportArn(model.reportArn);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            sortOrder(model.sortOrder);
            sortBy(model.sortBy);
            minLineCoveragePercentage(model.minLineCoveragePercentage);
            maxLineCoveragePercentage(model.maxLineCoveragePercentage);
        }

        public final String getReportArn() {
            return reportArn;
        }

        public final void setReportArn(String reportArn) {
            this.reportArn = reportArn;
        }

        @Override
        public final Builder reportArn(String reportArn) {
            this.reportArn = reportArn;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrderType sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ReportCodeCoverageSortByType sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final Double getMinLineCoveragePercentage() {
            return minLineCoveragePercentage;
        }

        public final void setMinLineCoveragePercentage(Double minLineCoveragePercentage) {
            this.minLineCoveragePercentage = minLineCoveragePercentage;
        }

        @Override
        public final Builder minLineCoveragePercentage(Double minLineCoveragePercentage) {
            this.minLineCoveragePercentage = minLineCoveragePercentage;
            return this;
        }

        public final Double getMaxLineCoveragePercentage() {
            return maxLineCoveragePercentage;
        }

        public final void setMaxLineCoveragePercentage(Double maxLineCoveragePercentage) {
            this.maxLineCoveragePercentage = maxLineCoveragePercentage;
        }

        @Override
        public final Builder maxLineCoveragePercentage(Double maxLineCoveragePercentage) {
            this.maxLineCoveragePercentage = maxLineCoveragePercentage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCodeCoveragesRequest build() {
            return new DescribeCodeCoveragesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
