/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBuildBatchResponse extends CodeBuildResponse implements
        ToCopyableBuilder<DeleteBuildBatchResponse.Builder, DeleteBuildBatchResponse> {
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusCode").getter(getter(DeleteBuildBatchResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()).build();

    private static final SdkField<List<String>> BUILDS_DELETED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("buildsDeleted")
            .getter(getter(DeleteBuildBatchResponse::buildsDeleted))
            .setter(setter(Builder::buildsDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsDeleted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BuildNotDeleted>> BUILDS_NOT_DELETED_FIELD = SdkField
            .<List<BuildNotDeleted>> builder(MarshallingType.LIST)
            .memberName("buildsNotDeleted")
            .getter(getter(DeleteBuildBatchResponse::buildsNotDeleted))
            .setter(setter(Builder::buildsNotDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildsNotDeleted").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BuildNotDeleted> builder(MarshallingType.SDK_POJO)
                                            .constructor(BuildNotDeleted::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            BUILDS_DELETED_FIELD, BUILDS_NOT_DELETED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String statusCodeValue;

    private final List<String> buildsDeleted;

    private final List<BuildNotDeleted> buildsNotDeleted;

    private DeleteBuildBatchResponse(BuilderImpl builder) {
        super(builder);
        this.statusCodeValue = builder.statusCodeValue;
        this.buildsDeleted = builder.buildsDeleted;
        this.buildsNotDeleted = builder.buildsNotDeleted;
    }

    /**
     * <p>
     * The status code.
     * </p>
     * 
     * @return The status code.
     */
    public final String statusCode() {
        return statusCodeValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the BuildsDeleted property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBuildsDeleted() {
        return buildsDeleted != null && !(buildsDeleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that contain the identifiers of the builds that were deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuildsDeleted} method.
     * </p>
     * 
     * @return An array of strings that contain the identifiers of the builds that were deleted.
     */
    public final List<String> buildsDeleted() {
        return buildsDeleted;
    }

    /**
     * For responses, this returns true if the service returned a value for the BuildsNotDeleted property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBuildsNotDeleted() {
        return buildsNotDeleted != null && !(buildsNotDeleted instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be deleted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuildsNotDeleted} method.
     * </p>
     * 
     * @return An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be deleted.
     */
    public final List<BuildNotDeleted> buildsNotDeleted() {
        return buildsNotDeleted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasBuildsDeleted() ? buildsDeleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBuildsNotDeleted() ? buildsNotDeleted() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBuildBatchResponse)) {
            return false;
        }
        DeleteBuildBatchResponse other = (DeleteBuildBatchResponse) obj;
        return Objects.equals(statusCode(), other.statusCode()) && hasBuildsDeleted() == other.hasBuildsDeleted()
                && Objects.equals(buildsDeleted(), other.buildsDeleted()) && hasBuildsNotDeleted() == other.hasBuildsNotDeleted()
                && Objects.equals(buildsNotDeleted(), other.buildsNotDeleted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBuildBatchResponse").add("StatusCode", statusCode())
                .add("BuildsDeleted", hasBuildsDeleted() ? buildsDeleted() : null)
                .add("BuildsNotDeleted", hasBuildsNotDeleted() ? buildsNotDeleted() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "buildsDeleted":
            return Optional.ofNullable(clazz.cast(buildsDeleted()));
        case "buildsNotDeleted":
            return Optional.ofNullable(clazz.cast(buildsNotDeleted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("statusCode", STATUS_CODE_FIELD);
        map.put("buildsDeleted", BUILDS_DELETED_FIELD);
        map.put("buildsNotDeleted", BUILDS_NOT_DELETED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBuildBatchResponse, T> g) {
        return obj -> g.apply((DeleteBuildBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBuildBatchResponse> {
        /**
         * <p>
         * The status code.
         * </p>
         * 
         * @param statusCodeValue
         *        The status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(String statusCodeValue);

        /**
         * <p>
         * An array of strings that contain the identifiers of the builds that were deleted.
         * </p>
         * 
         * @param buildsDeleted
         *        An array of strings that contain the identifiers of the builds that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsDeleted(Collection<String> buildsDeleted);

        /**
         * <p>
         * An array of strings that contain the identifiers of the builds that were deleted.
         * </p>
         * 
         * @param buildsDeleted
         *        An array of strings that contain the identifiers of the builds that were deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsDeleted(String... buildsDeleted);

        /**
         * <p>
         * An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be deleted.
         * </p>
         * 
         * @param buildsNotDeleted
         *        An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsNotDeleted(Collection<BuildNotDeleted> buildsNotDeleted);

        /**
         * <p>
         * An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be deleted.
         * </p>
         * 
         * @param buildsNotDeleted
         *        An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildsNotDeleted(BuildNotDeleted... buildsNotDeleted);

        /**
         * <p>
         * An array of <code>BuildNotDeleted</code> objects that specify the builds that could not be deleted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.BuildNotDeleted.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.codebuild.model.BuildNotDeleted#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.BuildNotDeleted.Builder#build()} is called immediately
         * and its result is passed to {@link #buildsNotDeleted(List<BuildNotDeleted>)}.
         * 
         * @param buildsNotDeleted
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.BuildNotDeleted.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buildsNotDeleted(java.util.Collection<BuildNotDeleted>)
         */
        Builder buildsNotDeleted(Consumer<BuildNotDeleted.Builder>... buildsNotDeleted);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private String statusCodeValue;

        private List<String> buildsDeleted = DefaultSdkAutoConstructList.getInstance();

        private List<BuildNotDeleted> buildsNotDeleted = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBuildBatchResponse model) {
            super(model);
            statusCode(model.statusCodeValue);
            buildsDeleted(model.buildsDeleted);
            buildsNotDeleted(model.buildsNotDeleted);
        }

        public final String getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final Collection<String> getBuildsDeleted() {
            if (buildsDeleted instanceof SdkAutoConstructList) {
                return null;
            }
            return buildsDeleted;
        }

        public final void setBuildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
        }

        @Override
        public final Builder buildsDeleted(Collection<String> buildsDeleted) {
            this.buildsDeleted = BuildIdsCopier.copy(buildsDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsDeleted(String... buildsDeleted) {
            buildsDeleted(Arrays.asList(buildsDeleted));
            return this;
        }

        public final List<BuildNotDeleted.Builder> getBuildsNotDeleted() {
            List<BuildNotDeleted.Builder> result = BuildsNotDeletedCopier.copyToBuilder(this.buildsNotDeleted);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuildsNotDeleted(Collection<BuildNotDeleted.BuilderImpl> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copyFromBuilder(buildsNotDeleted);
        }

        @Override
        public final Builder buildsNotDeleted(Collection<BuildNotDeleted> buildsNotDeleted) {
            this.buildsNotDeleted = BuildsNotDeletedCopier.copy(buildsNotDeleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotDeleted(BuildNotDeleted... buildsNotDeleted) {
            buildsNotDeleted(Arrays.asList(buildsNotDeleted));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildsNotDeleted(Consumer<BuildNotDeleted.Builder>... buildsNotDeleted) {
            buildsNotDeleted(Stream.of(buildsNotDeleted).map(c -> BuildNotDeleted.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteBuildBatchResponse build() {
            return new DeleteBuildBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
