/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetSandboxesResponse extends CodeBuildResponse implements
        ToCopyableBuilder<BatchGetSandboxesResponse.Builder, BatchGetSandboxesResponse> {
    private static final SdkField<List<Sandbox>> SANDBOXES_FIELD = SdkField
            .<List<Sandbox>> builder(MarshallingType.LIST)
            .memberName("sandboxes")
            .getter(getter(BatchGetSandboxesResponse::sandboxes))
            .setter(setter(Builder::sandboxes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Sandbox> builder(MarshallingType.SDK_POJO)
                                            .constructor(Sandbox::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SANDBOXES_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sandboxesNotFound")
            .getter(getter(BatchGetSandboxesResponse::sandboxesNotFound))
            .setter(setter(Builder::sandboxesNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sandboxesNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SANDBOXES_FIELD,
            SANDBOXES_NOT_FOUND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Sandbox> sandboxes;

    private final List<String> sandboxesNotFound;

    private BatchGetSandboxesResponse(BuilderImpl builder) {
        super(builder);
        this.sandboxes = builder.sandboxes;
        this.sandboxesNotFound = builder.sandboxesNotFound;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sandboxes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSandboxes() {
        return sandboxes != null && !(sandboxes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the requested sandboxes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSandboxes} method.
     * </p>
     * 
     * @return Information about the requested sandboxes.
     */
    public final List<Sandbox> sandboxes() {
        return sandboxes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SandboxesNotFound property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSandboxesNotFound() {
        return sandboxesNotFound != null && !(sandboxesNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of sandboxes for which information could not be found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSandboxesNotFound} method.
     * </p>
     * 
     * @return The IDs of sandboxes for which information could not be found.
     */
    public final List<String> sandboxesNotFound() {
        return sandboxesNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSandboxes() ? sandboxes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSandboxesNotFound() ? sandboxesNotFound() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSandboxesResponse)) {
            return false;
        }
        BatchGetSandboxesResponse other = (BatchGetSandboxesResponse) obj;
        return hasSandboxes() == other.hasSandboxes() && Objects.equals(sandboxes(), other.sandboxes())
                && hasSandboxesNotFound() == other.hasSandboxesNotFound()
                && Objects.equals(sandboxesNotFound(), other.sandboxesNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetSandboxesResponse").add("Sandboxes", hasSandboxes() ? sandboxes() : null)
                .add("SandboxesNotFound", hasSandboxesNotFound() ? sandboxesNotFound() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sandboxes":
            return Optional.ofNullable(clazz.cast(sandboxes()));
        case "sandboxesNotFound":
            return Optional.ofNullable(clazz.cast(sandboxesNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sandboxes", SANDBOXES_FIELD);
        map.put("sandboxesNotFound", SANDBOXES_NOT_FOUND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSandboxesResponse, T> g) {
        return obj -> g.apply((BatchGetSandboxesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetSandboxesResponse> {
        /**
         * <p>
         * Information about the requested sandboxes.
         * </p>
         * 
         * @param sandboxes
         *        Information about the requested sandboxes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandboxes(Collection<Sandbox> sandboxes);

        /**
         * <p>
         * Information about the requested sandboxes.
         * </p>
         * 
         * @param sandboxes
         *        Information about the requested sandboxes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandboxes(Sandbox... sandboxes);

        /**
         * <p>
         * Information about the requested sandboxes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codebuild.model.Sandbox.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codebuild.model.Sandbox#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codebuild.model.Sandbox.Builder#build()} is called immediately and its
         * result is passed to {@link #sandboxes(List<Sandbox>)}.
         * 
         * @param sandboxes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codebuild.model.Sandbox.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sandboxes(java.util.Collection<Sandbox>)
         */
        Builder sandboxes(Consumer<Sandbox.Builder>... sandboxes);

        /**
         * <p>
         * The IDs of sandboxes for which information could not be found.
         * </p>
         * 
         * @param sandboxesNotFound
         *        The IDs of sandboxes for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandboxesNotFound(Collection<String> sandboxesNotFound);

        /**
         * <p>
         * The IDs of sandboxes for which information could not be found.
         * </p>
         * 
         * @param sandboxesNotFound
         *        The IDs of sandboxes for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sandboxesNotFound(String... sandboxesNotFound);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<Sandbox> sandboxes = DefaultSdkAutoConstructList.getInstance();

        private List<String> sandboxesNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSandboxesResponse model) {
            super(model);
            sandboxes(model.sandboxes);
            sandboxesNotFound(model.sandboxesNotFound);
        }

        public final List<Sandbox.Builder> getSandboxes() {
            List<Sandbox.Builder> result = SandboxesCopier.copyToBuilder(this.sandboxes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSandboxes(Collection<Sandbox.BuilderImpl> sandboxes) {
            this.sandboxes = SandboxesCopier.copyFromBuilder(sandboxes);
        }

        @Override
        public final Builder sandboxes(Collection<Sandbox> sandboxes) {
            this.sandboxes = SandboxesCopier.copy(sandboxes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sandboxes(Sandbox... sandboxes) {
            sandboxes(Arrays.asList(sandboxes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sandboxes(Consumer<Sandbox.Builder>... sandboxes) {
            sandboxes(Stream.of(sandboxes).map(c -> Sandbox.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSandboxesNotFound() {
            if (sandboxesNotFound instanceof SdkAutoConstructList) {
                return null;
            }
            return sandboxesNotFound;
        }

        public final void setSandboxesNotFound(Collection<String> sandboxesNotFound) {
            this.sandboxesNotFound = SandboxIdsCopier.copy(sandboxesNotFound);
        }

        @Override
        public final Builder sandboxesNotFound(Collection<String> sandboxesNotFound) {
            this.sandboxesNotFound = SandboxIdsCopier.copy(sandboxesNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sandboxesNotFound(String... sandboxesNotFound) {
            sandboxesNotFound(Arrays.asList(sandboxesNotFound));
            return this;
        }

        @Override
        public BatchGetSandboxesResponse build() {
            return new BatchGetSandboxesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
