/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.codebuild.auth.scheme.CodeBuildAuthSchemeParams;
import software.amazon.awssdk.services.codebuild.auth.scheme.CodeBuildAuthSchemeProvider;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public final class DefaultCodeBuildAuthSchemeProvider implements CodeBuildAuthSchemeProvider {
    private static final DefaultCodeBuildAuthSchemeProvider DEFAULT = new DefaultCodeBuildAuthSchemeProvider();

    private DefaultCodeBuildAuthSchemeProvider() {
    }

    public static DefaultCodeBuildAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(CodeBuildAuthSchemeParams params) {
        List<AuthSchemeOption> options = new ArrayList<>();
        options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4")
                .putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, "codebuild")
                .putSignerProperty(AwsV4HttpSigner.REGION_NAME, params.region().id()).build());
        return Collections.unmodifiableList(options);
    }
}
