/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDestinationPolicyRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutDestinationPolicyRequest.Builder, PutDestinationPolicyRequest> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationName").getter(getter(PutDestinationPolicyRequest::destinationName))
            .setter(setter(Builder::destinationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()).build();

    private static final SdkField<String> ACCESS_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPolicy").getter(getter(PutDestinationPolicyRequest::accessPolicy))
            .setter(setter(Builder::accessPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicy").build()).build();

    private static final SdkField<Boolean> FORCE_UPDATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("forceUpdate").getter(getter(PutDestinationPolicyRequest::forceUpdate))
            .setter(setter(Builder::forceUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD,
            ACCESS_POLICY_FIELD, FORCE_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String destinationName;

    private final String accessPolicy;

    private final Boolean forceUpdate;

    private PutDestinationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.accessPolicy = builder.accessPolicy;
        this.forceUpdate = builder.forceUpdate;
    }

    /**
     * <p>
     * A name for an existing destination.
     * </p>
     * 
     * @return A name for an existing destination.
     */
    public final String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * An IAM policy document that authorizes cross-account users to deliver their log events to the associated
     * destination. This can be up to 5120 bytes.
     * </p>
     * 
     * @return An IAM policy document that authorizes cross-account users to deliver their log events to the associated
     *         destination. This can be up to 5120 bytes.
     */
    public final String accessPolicy() {
        return accessPolicy;
    }

    /**
     * <p>
     * Specify true if you are updating an existing destination policy to grant permission to an organization ID instead
     * of granting permission to individual Amazon Web Services accounts. Before you update a destination policy this
     * way, you must first update the subscription filters in the accounts that send logs to this destination. If you do
     * not, the subscription filters might stop working. By specifying <code>true</code> for <code>forceUpdate</code>,
     * you are affirming that you have already updated the subscription filters. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Cross-Account-Log_Subscription-Update.html">
     * Updating an existing cross-account subscription</a>
     * </p>
     * <p>
     * If you omit this parameter, the default of <code>false</code> is used.
     * </p>
     * 
     * @return Specify true if you are updating an existing destination policy to grant permission to an organization ID
     *         instead of granting permission to individual Amazon Web Services accounts. Before you update a
     *         destination policy this way, you must first update the subscription filters in the accounts that send
     *         logs to this destination. If you do not, the subscription filters might stop working. By specifying
     *         <code>true</code> for <code>forceUpdate</code>, you are affirming that you have already updated the
     *         subscription filters. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Cross-Account-Log_Subscription-Update.html">
     *         Updating an existing cross-account subscription</a> </p>
     *         <p>
     *         If you omit this parameter, the default of <code>false</code> is used.
     */
    public final Boolean forceUpdate() {
        return forceUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(forceUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDestinationPolicyRequest)) {
            return false;
        }
        PutDestinationPolicyRequest other = (PutDestinationPolicyRequest) obj;
        return Objects.equals(destinationName(), other.destinationName()) && Objects.equals(accessPolicy(), other.accessPolicy())
                && Objects.equals(forceUpdate(), other.forceUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDestinationPolicyRequest").add("DestinationName", destinationName())
                .add("AccessPolicy", accessPolicy()).add("ForceUpdate", forceUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationName":
            return Optional.ofNullable(clazz.cast(destinationName()));
        case "accessPolicy":
            return Optional.ofNullable(clazz.cast(accessPolicy()));
        case "forceUpdate":
            return Optional.ofNullable(clazz.cast(forceUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationName", DESTINATION_NAME_FIELD);
        map.put("accessPolicy", ACCESS_POLICY_FIELD);
        map.put("forceUpdate", FORCE_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDestinationPolicyRequest, T> g) {
        return obj -> g.apply((PutDestinationPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDestinationPolicyRequest> {
        /**
         * <p>
         * A name for an existing destination.
         * </p>
         * 
         * @param destinationName
         *        A name for an existing destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * An IAM policy document that authorizes cross-account users to deliver their log events to the associated
         * destination. This can be up to 5120 bytes.
         * </p>
         * 
         * @param accessPolicy
         *        An IAM policy document that authorizes cross-account users to deliver their log events to the
         *        associated destination. This can be up to 5120 bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicy(String accessPolicy);

        /**
         * <p>
         * Specify true if you are updating an existing destination policy to grant permission to an organization ID
         * instead of granting permission to individual Amazon Web Services accounts. Before you update a destination
         * policy this way, you must first update the subscription filters in the accounts that send logs to this
         * destination. If you do not, the subscription filters might stop working. By specifying <code>true</code> for
         * <code>forceUpdate</code>, you are affirming that you have already updated the subscription filters. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Cross-Account-Log_Subscription-Update.html">
         * Updating an existing cross-account subscription</a>
         * </p>
         * <p>
         * If you omit this parameter, the default of <code>false</code> is used.
         * </p>
         * 
         * @param forceUpdate
         *        Specify true if you are updating an existing destination policy to grant permission to an organization
         *        ID instead of granting permission to individual Amazon Web Services accounts. Before you update a
         *        destination policy this way, you must first update the subscription filters in the accounts that send
         *        logs to this destination. If you do not, the subscription filters might stop working. By specifying
         *        <code>true</code> for <code>forceUpdate</code>, you are affirming that you have already updated the
         *        subscription filters. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Cross-Account-Log_Subscription-Update.html">
         *        Updating an existing cross-account subscription</a> </p>
         *        <p>
         *        If you omit this parameter, the default of <code>false</code> is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceUpdate(Boolean forceUpdate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String destinationName;

        private String accessPolicy;

        private Boolean forceUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDestinationPolicyRequest model) {
            super(model);
            destinationName(model.destinationName);
            accessPolicy(model.accessPolicy);
            forceUpdate(model.forceUpdate);
        }

        public final String getDestinationName() {
            return destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getAccessPolicy() {
            return accessPolicy;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        @Override
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final Boolean getForceUpdate() {
            return forceUpdate;
        }

        public final void setForceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
        }

        @Override
        public final Builder forceUpdate(Boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDestinationPolicyRequest build() {
            return new PutDestinationPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
