/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for the GetLogObject operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLogObjectRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<GetLogObjectRequest.Builder, GetLogObjectRequest> {
    private static final SdkField<Boolean> UNMASK_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("unmask").getter(getter(GetLogObjectRequest::unmask)).setter(setter(Builder::unmask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unmask").build()).build();

    private static final SdkField<String> LOG_OBJECT_POINTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logObjectPointer").getter(getter(GetLogObjectRequest::logObjectPointer))
            .setter(setter(Builder::logObjectPointer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logObjectPointer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNMASK_FIELD,
            LOG_OBJECT_POINTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean unmask;

    private final String logObjectPointer;

    private GetLogObjectRequest(BuilderImpl builder) {
        super(builder);
        this.unmask = builder.unmask;
        this.logObjectPointer = builder.logObjectPointer;
    }

    /**
     * <p>
     * A boolean flag that indicates whether to unmask sensitive log data. When set to true, any masked or redacted data
     * in the log object will be displayed in its original form. Default is false.
     * </p>
     * 
     * @return A boolean flag that indicates whether to unmask sensitive log data. When set to true, any masked or
     *         redacted data in the log object will be displayed in its original form. Default is false.
     */
    public final Boolean unmask() {
        return unmask;
    }

    /**
     * <p>
     * A pointer to the specific log object to retrieve. This is a required parameter that uniquely identifies the log
     * object within CloudWatch Logs. The pointer is typically obtained from a previous query or filter operation.
     * </p>
     * 
     * @return A pointer to the specific log object to retrieve. This is a required parameter that uniquely identifies
     *         the log object within CloudWatch Logs. The pointer is typically obtained from a previous query or filter
     *         operation.
     */
    public final String logObjectPointer() {
        return logObjectPointer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(unmask());
        hashCode = 31 * hashCode + Objects.hashCode(logObjectPointer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogObjectRequest)) {
            return false;
        }
        GetLogObjectRequest other = (GetLogObjectRequest) obj;
        return Objects.equals(unmask(), other.unmask()) && Objects.equals(logObjectPointer(), other.logObjectPointer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLogObjectRequest").add("Unmask", unmask()).add("LogObjectPointer", logObjectPointer())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unmask":
            return Optional.ofNullable(clazz.cast(unmask()));
        case "logObjectPointer":
            return Optional.ofNullable(clazz.cast(logObjectPointer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("unmask", UNMASK_FIELD);
        map.put("logObjectPointer", LOG_OBJECT_POINTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLogObjectRequest, T> g) {
        return obj -> g.apply((GetLogObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLogObjectRequest> {
        /**
         * <p>
         * A boolean flag that indicates whether to unmask sensitive log data. When set to true, any masked or redacted
         * data in the log object will be displayed in its original form. Default is false.
         * </p>
         * 
         * @param unmask
         *        A boolean flag that indicates whether to unmask sensitive log data. When set to true, any masked or
         *        redacted data in the log object will be displayed in its original form. Default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmask(Boolean unmask);

        /**
         * <p>
         * A pointer to the specific log object to retrieve. This is a required parameter that uniquely identifies the
         * log object within CloudWatch Logs. The pointer is typically obtained from a previous query or filter
         * operation.
         * </p>
         * 
         * @param logObjectPointer
         *        A pointer to the specific log object to retrieve. This is a required parameter that uniquely
         *        identifies the log object within CloudWatch Logs. The pointer is typically obtained from a previous
         *        query or filter operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logObjectPointer(String logObjectPointer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private Boolean unmask;

        private String logObjectPointer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogObjectRequest model) {
            super(model);
            unmask(model.unmask);
            logObjectPointer(model.logObjectPointer);
        }

        public final Boolean getUnmask() {
            return unmask;
        }

        public final void setUnmask(Boolean unmask) {
            this.unmask = unmask;
        }

        @Override
        public final Builder unmask(Boolean unmask) {
            this.unmask = unmask;
            return this;
        }

        public final String getLogObjectPointer() {
            return logObjectPointer;
        }

        public final void setLogObjectPointer(String logObjectPointer) {
            this.logObjectPointer = logObjectPointer;
        }

        @Override
        public final Builder logObjectPointer(String logObjectPointer) {
            this.logObjectPointer = logObjectPointer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLogObjectRequest build() {
            return new GetLogObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
