/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourcePoliciesRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<DescribeResourcePoliciesRequest.Builder, DescribeResourcePoliciesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeResourcePoliciesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(DescribeResourcePoliciesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(DescribeResourcePoliciesRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> POLICY_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyScope").getter(getter(DescribeResourcePoliciesRequest::policyScopeAsString))
            .setter(setter(Builder::policyScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyScope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, LIMIT_FIELD,
            RESOURCE_ARN_FIELD, POLICY_SCOPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer limit;

    private final String resourceArn;

    private final String policyScope;

    private DescribeResourcePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.resourceArn = builder.resourceArn;
        this.policyScope = builder.policyScope;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of resource policies to be displayed with one call of this API.
     * </p>
     * 
     * @return The maximum number of resource policies to be displayed with one call of this API.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The ARN of the CloudWatch Logs resource for which to query the resource policy.
     * </p>
     * 
     * @return The ARN of the CloudWatch Logs resource for which to query the resource policy.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Specifies the scope of the resource policy. Valid values are <code>ACCOUNT</code> or <code>RESOURCE</code>. When
     * not specified, defaults to <code>ACCOUNT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyScope} will
     * return {@link PolicyScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyScopeAsString}.
     * </p>
     * 
     * @return Specifies the scope of the resource policy. Valid values are <code>ACCOUNT</code> or
     *         <code>RESOURCE</code>. When not specified, defaults to <code>ACCOUNT</code>.
     * @see PolicyScope
     */
    public final PolicyScope policyScope() {
        return PolicyScope.fromValue(policyScope);
    }

    /**
     * <p>
     * Specifies the scope of the resource policy. Valid values are <code>ACCOUNT</code> or <code>RESOURCE</code>. When
     * not specified, defaults to <code>ACCOUNT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyScope} will
     * return {@link PolicyScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyScopeAsString}.
     * </p>
     * 
     * @return Specifies the scope of the resource policy. Valid values are <code>ACCOUNT</code> or
     *         <code>RESOURCE</code>. When not specified, defaults to <code>ACCOUNT</code>.
     * @see PolicyScope
     */
    public final String policyScopeAsString() {
        return policyScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyScopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePoliciesRequest)) {
            return false;
        }
        DescribeResourcePoliciesRequest other = (DescribeResourcePoliciesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(policyScopeAsString(), other.policyScopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourcePoliciesRequest").add("NextToken", nextToken()).add("Limit", limit())
                .add("ResourceArn", resourceArn()).add("PolicyScope", policyScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "policyScope":
            return Optional.ofNullable(clazz.cast(policyScopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("policyScope", POLICY_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourcePoliciesRequest, T> g) {
        return obj -> g.apply((DescribeResourcePoliciesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResourcePoliciesRequest> {
        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of resource policies to be displayed with one call of this API.
         * </p>
         * 
         * @param limit
         *        The maximum number of resource policies to be displayed with one call of this API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The ARN of the CloudWatch Logs resource for which to query the resource policy.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the CloudWatch Logs resource for which to query the resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Specifies the scope of the resource policy. Valid values are <code>ACCOUNT</code> or <code>RESOURCE</code>.
         * When not specified, defaults to <code>ACCOUNT</code>.
         * </p>
         * 
         * @param policyScope
         *        Specifies the scope of the resource policy. Valid values are <code>ACCOUNT</code> or
         *        <code>RESOURCE</code>. When not specified, defaults to <code>ACCOUNT</code>.
         * @see PolicyScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyScope
         */
        Builder policyScope(String policyScope);

        /**
         * <p>
         * Specifies the scope of the resource policy. Valid values are <code>ACCOUNT</code> or <code>RESOURCE</code>.
         * When not specified, defaults to <code>ACCOUNT</code>.
         * </p>
         * 
         * @param policyScope
         *        Specifies the scope of the resource policy. Valid values are <code>ACCOUNT</code> or
         *        <code>RESOURCE</code>. When not specified, defaults to <code>ACCOUNT</code>.
         * @see PolicyScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyScope
         */
        Builder policyScope(PolicyScope policyScope);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer limit;

        private String resourceArn;

        private String policyScope;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePoliciesRequest model) {
            super(model);
            nextToken(model.nextToken);
            limit(model.limit);
            resourceArn(model.resourceArn);
            policyScope(model.policyScope);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getPolicyScope() {
            return policyScope;
        }

        public final void setPolicyScope(String policyScope) {
            this.policyScope = policyScope;
        }

        @Override
        public final Builder policyScope(String policyScope) {
            this.policyScope = policyScope;
            return this;
        }

        @Override
        public final Builder policyScope(PolicyScope policyScope) {
            this.policyScope(policyScope == null ? null : policyScope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeResourcePoliciesRequest build() {
            return new DescribeResourcePoliciesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
