/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationTemplatesRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<DescribeConfigurationTemplatesRequest.Builder, DescribeConfigurationTemplatesRequest> {
    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(DescribeConfigurationTemplatesRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<List<String>> LOG_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logTypes")
            .getter(getter(DescribeConfigurationTemplatesRequest::logTypes))
            .setter(setter(Builder::logTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceTypes")
            .getter(getter(DescribeConfigurationTemplatesRequest::resourceTypes))
            .setter(setter(Builder::resourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DELIVERY_DESTINATION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("deliveryDestinationTypes")
            .getter(getter(DescribeConfigurationTemplatesRequest::deliveryDestinationTypesAsStrings))
            .setter(setter(Builder::deliveryDestinationTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeConfigurationTemplatesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("limit")
            .getter(getter(DescribeConfigurationTemplatesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD,
            LOG_TYPES_FIELD, RESOURCE_TYPES_FIELD, DELIVERY_DESTINATION_TYPES_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String service;

    private final List<String> logTypes;

    private final List<String> resourceTypes;

    private final List<String> deliveryDestinationTypes;

    private final String nextToken;

    private final Integer limit;

    private DescribeConfigurationTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
        this.logTypes = builder.logTypes;
        this.resourceTypes = builder.resourceTypes;
        this.deliveryDestinationTypes = builder.deliveryDestinationTypes;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * Use this parameter to filter the response to include only the configuration templates that apply to the Amazon
     * Web Services service that you specify here.
     * </p>
     * 
     * @return Use this parameter to filter the response to include only the configuration templates that apply to the
     *         Amazon Web Services service that you specify here.
     */
    public final String service() {
        return service;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogTypes() {
        return logTypes != null && !(logTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this parameter to filter the response to include only the configuration templates that apply to the log types
     * that you specify here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogTypes} method.
     * </p>
     * 
     * @return Use this parameter to filter the response to include only the configuration templates that apply to the
     *         log types that you specify here.
     */
    public final List<String> logTypes() {
        return logTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this parameter to filter the response to include only the configuration templates that apply to the resource
     * types that you specify here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return Use this parameter to filter the response to include only the configuration templates that apply to the
     *         resource types that you specify here.
     */
    public final List<String> resourceTypes() {
        return resourceTypes;
    }

    /**
     * <p>
     * Use this parameter to filter the response to include only the configuration templates that apply to the delivery
     * destination types that you specify here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeliveryDestinationTypes} method.
     * </p>
     * 
     * @return Use this parameter to filter the response to include only the configuration templates that apply to the
     *         delivery destination types that you specify here.
     */
    public final List<DeliveryDestinationType> deliveryDestinationTypes() {
        return DeliveryDestinationTypesCopier.copyStringToEnum(deliveryDestinationTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the DeliveryDestinationTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDeliveryDestinationTypes() {
        return deliveryDestinationTypes != null && !(deliveryDestinationTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this parameter to filter the response to include only the configuration templates that apply to the delivery
     * destination types that you specify here.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeliveryDestinationTypes} method.
     * </p>
     * 
     * @return Use this parameter to filter the response to include only the configuration templates that apply to the
     *         delivery destination types that you specify here.
     */
    public final List<String> deliveryDestinationTypesAsStrings() {
        return deliveryDestinationTypes;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Use this parameter to limit the number of configuration templates that are returned in the response.
     * </p>
     * 
     * @return Use this parameter to limit the number of configuration templates that are returned in the response.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogTypes() ? logTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeliveryDestinationTypes() ? deliveryDestinationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationTemplatesRequest)) {
            return false;
        }
        DescribeConfigurationTemplatesRequest other = (DescribeConfigurationTemplatesRequest) obj;
        return Objects.equals(service(), other.service()) && hasLogTypes() == other.hasLogTypes()
                && Objects.equals(logTypes(), other.logTypes()) && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypes(), other.resourceTypes())
                && hasDeliveryDestinationTypes() == other.hasDeliveryDestinationTypes()
                && Objects.equals(deliveryDestinationTypesAsStrings(), other.deliveryDestinationTypesAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationTemplatesRequest").add("Service", service())
                .add("LogTypes", hasLogTypes() ? logTypes() : null)
                .add("ResourceTypes", hasResourceTypes() ? resourceTypes() : null)
                .add("DeliveryDestinationTypes", hasDeliveryDestinationTypes() ? deliveryDestinationTypesAsStrings() : null)
                .add("NextToken", nextToken()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "logTypes":
            return Optional.ofNullable(clazz.cast(logTypes()));
        case "resourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypes()));
        case "deliveryDestinationTypes":
            return Optional.ofNullable(clazz.cast(deliveryDestinationTypesAsStrings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("service", SERVICE_FIELD);
        map.put("logTypes", LOG_TYPES_FIELD);
        map.put("resourceTypes", RESOURCE_TYPES_FIELD);
        map.put("deliveryDestinationTypes", DELIVERY_DESTINATION_TYPES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationTemplatesRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationTemplatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationTemplatesRequest> {
        /**
         * <p>
         * Use this parameter to filter the response to include only the configuration templates that apply to the
         * Amazon Web Services service that you specify here.
         * </p>
         * 
         * @param service
         *        Use this parameter to filter the response to include only the configuration templates that apply to
         *        the Amazon Web Services service that you specify here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * Use this parameter to filter the response to include only the configuration templates that apply to the log
         * types that you specify here.
         * </p>
         * 
         * @param logTypes
         *        Use this parameter to filter the response to include only the configuration templates that apply to
         *        the log types that you specify here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypes(Collection<String> logTypes);

        /**
         * <p>
         * Use this parameter to filter the response to include only the configuration templates that apply to the log
         * types that you specify here.
         * </p>
         * 
         * @param logTypes
         *        Use this parameter to filter the response to include only the configuration templates that apply to
         *        the log types that you specify here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypes(String... logTypes);

        /**
         * <p>
         * Use this parameter to filter the response to include only the configuration templates that apply to the
         * resource types that you specify here.
         * </p>
         * 
         * @param resourceTypes
         *        Use this parameter to filter the response to include only the configuration templates that apply to
         *        the resource types that you specify here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<String> resourceTypes);

        /**
         * <p>
         * Use this parameter to filter the response to include only the configuration templates that apply to the
         * resource types that you specify here.
         * </p>
         * 
         * @param resourceTypes
         *        Use this parameter to filter the response to include only the configuration templates that apply to
         *        the resource types that you specify here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(String... resourceTypes);

        /**
         * <p>
         * Use this parameter to filter the response to include only the configuration templates that apply to the
         * delivery destination types that you specify here.
         * </p>
         * 
         * @param deliveryDestinationTypes
         *        Use this parameter to filter the response to include only the configuration templates that apply to
         *        the delivery destination types that you specify here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationTypesWithStrings(Collection<String> deliveryDestinationTypes);

        /**
         * <p>
         * Use this parameter to filter the response to include only the configuration templates that apply to the
         * delivery destination types that you specify here.
         * </p>
         * 
         * @param deliveryDestinationTypes
         *        Use this parameter to filter the response to include only the configuration templates that apply to
         *        the delivery destination types that you specify here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationTypesWithStrings(String... deliveryDestinationTypes);

        /**
         * <p>
         * Use this parameter to filter the response to include only the configuration templates that apply to the
         * delivery destination types that you specify here.
         * </p>
         * 
         * @param deliveryDestinationTypes
         *        Use this parameter to filter the response to include only the configuration templates that apply to
         *        the delivery destination types that you specify here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationTypes(Collection<DeliveryDestinationType> deliveryDestinationTypes);

        /**
         * <p>
         * Use this parameter to filter the response to include only the configuration templates that apply to the
         * delivery destination types that you specify here.
         * </p>
         * 
         * @param deliveryDestinationTypes
         *        Use this parameter to filter the response to include only the configuration templates that apply to
         *        the delivery destination types that you specify here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryDestinationTypes(DeliveryDestinationType... deliveryDestinationTypes);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Use this parameter to limit the number of configuration templates that are returned in the response.
         * </p>
         * 
         * @param limit
         *        Use this parameter to limit the number of configuration templates that are returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String service;

        private List<String> logTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> deliveryDestinationTypes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationTemplatesRequest model) {
            super(model);
            service(model.service);
            logTypes(model.logTypes);
            resourceTypes(model.resourceTypes);
            deliveryDestinationTypesWithStrings(model.deliveryDestinationTypes);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Collection<String> getLogTypes() {
            if (logTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return logTypes;
        }

        public final void setLogTypes(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
        }

        @Override
        public final Builder logTypes(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypes(String... logTypes) {
            logTypes(Arrays.asList(logTypes));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getDeliveryDestinationTypes() {
            if (deliveryDestinationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return deliveryDestinationTypes;
        }

        public final void setDeliveryDestinationTypes(Collection<String> deliveryDestinationTypes) {
            this.deliveryDestinationTypes = DeliveryDestinationTypesCopier.copy(deliveryDestinationTypes);
        }

        @Override
        public final Builder deliveryDestinationTypesWithStrings(Collection<String> deliveryDestinationTypes) {
            this.deliveryDestinationTypes = DeliveryDestinationTypesCopier.copy(deliveryDestinationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryDestinationTypesWithStrings(String... deliveryDestinationTypes) {
            deliveryDestinationTypesWithStrings(Arrays.asList(deliveryDestinationTypes));
            return this;
        }

        @Override
        public final Builder deliveryDestinationTypes(Collection<DeliveryDestinationType> deliveryDestinationTypes) {
            this.deliveryDestinationTypes = DeliveryDestinationTypesCopier.copyEnumToString(deliveryDestinationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveryDestinationTypes(DeliveryDestinationType... deliveryDestinationTypes) {
            deliveryDestinationTypes(Arrays.asList(deliveryDestinationTypes));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationTemplatesRequest build() {
            return new DescribeConfigurationTemplatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
