/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteIntegrationRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<DeleteIntegrationRequest.Builder, DeleteIntegrationRequest> {
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("integrationName").getter(getter(DeleteIntegrationRequest::integrationName))
            .setter(setter(Builder::integrationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationName").build()).build();

    private static final SdkField<Boolean> FORCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("force")
            .getter(getter(DeleteIntegrationRequest::force)).setter(setter(Builder::force))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("force").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_NAME_FIELD,
            FORCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String integrationName;

    private final Boolean force;

    private DeleteIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.integrationName = builder.integrationName;
        this.force = builder.force;
    }

    /**
     * <p>
     * The name of the integration to delete. To find the name of your integration, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListIntegrations.html"
     * >ListIntegrations</a>.
     * </p>
     * 
     * @return The name of the integration to delete. To find the name of your integration, use <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListIntegrations.html"
     *         >ListIntegrations</a>.
     */
    public final String integrationName() {
        return integrationName;
    }

    /**
     * <p>
     * Specify <code>true</code> to force the deletion of the integration even if vended logs dashboards currently
     * exist.
     * </p>
     * <p>
     * The default is <code>false</code>.
     * </p>
     * 
     * @return Specify <code>true</code> to force the deletion of the integration even if vended logs dashboards
     *         currently exist.</p>
     *         <p>
     *         The default is <code>false</code>.
     */
    public final Boolean force() {
        return force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(force());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIntegrationRequest)) {
            return false;
        }
        DeleteIntegrationRequest other = (DeleteIntegrationRequest) obj;
        return Objects.equals(integrationName(), other.integrationName()) && Objects.equals(force(), other.force());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteIntegrationRequest").add("IntegrationName", integrationName()).add("Force", force())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "integrationName":
            return Optional.ofNullable(clazz.cast(integrationName()));
        case "force":
            return Optional.ofNullable(clazz.cast(force()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("integrationName", INTEGRATION_NAME_FIELD);
        map.put("force", FORCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteIntegrationRequest, T> g) {
        return obj -> g.apply((DeleteIntegrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteIntegrationRequest> {
        /**
         * <p>
         * The name of the integration to delete. To find the name of your integration, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListIntegrations.html"
         * >ListIntegrations</a>.
         * </p>
         * 
         * @param integrationName
         *        The name of the integration to delete. To find the name of your integration, use <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListIntegrations.html"
         *        >ListIntegrations</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationName(String integrationName);

        /**
         * <p>
         * Specify <code>true</code> to force the deletion of the integration even if vended logs dashboards currently
         * exist.
         * </p>
         * <p>
         * The default is <code>false</code>.
         * </p>
         * 
         * @param force
         *        Specify <code>true</code> to force the deletion of the integration even if vended logs dashboards
         *        currently exist.</p>
         *        <p>
         *        The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder force(Boolean force);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String integrationName;

        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIntegrationRequest model) {
            super(model);
            integrationName(model.integrationName);
            force(model.force);
        }

        public final String getIntegrationName() {
            return integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final Boolean getForce() {
            return force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteIntegrationRequest build() {
            return new DeleteIntegrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
