/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift
 * Data API ExecuteStatement based on EventBridge events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftDataParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftDataParameters.Builder, RedshiftDataParameters> {
    private static final SdkField<String> SECRET_MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretManagerArn").getter(getter(RedshiftDataParameters::secretManagerArn))
            .setter(setter(Builder::secretManagerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretManagerArn").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(RedshiftDataParameters::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(RedshiftDataParameters::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<String> SQL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sql")
            .getter(getter(RedshiftDataParameters::sql)).setter(setter(Builder::sql))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sql").build()).build();

    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(RedshiftDataParameters::statementName))
            .setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<Boolean> WITH_EVENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WithEvent").getter(getter(RedshiftDataParameters::withEvent)).setter(setter(Builder::withEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEvent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRET_MANAGER_ARN_FIELD,
            DATABASE_FIELD, DB_USER_FIELD, SQL_FIELD, STATEMENT_NAME_FIELD, WITH_EVENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String secretManagerArn;

    private final String database;

    private final String dbUser;

    private final String sql;

    private final String statementName;

    private final Boolean withEvent;

    private RedshiftDataParameters(BuilderImpl builder) {
        this.secretManagerArn = builder.secretManagerArn;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.sql = builder.sql;
        this.statementName = builder.statementName;
        this.withEvent = builder.withEvent;
    }

    /**
     * <p>
     * The name or ARN of the secret that enables access to the database. Required when authenticating using Amazon Web
     * Services Secrets Manager.
     * </p>
     * 
     * @return The name or ARN of the secret that enables access to the database. Required when authenticating using
     *         Amazon Web Services Secrets Manager.
     */
    public final String secretManagerArn() {
        return secretManagerArn;
    }

    /**
     * <p>
     * The name of the database. Required when authenticating using temporary credentials.
     * </p>
     * 
     * @return The name of the database. Required when authenticating using temporary credentials.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The database user name. Required when authenticating using temporary credentials.
     * </p>
     * 
     * @return The database user name. Required when authenticating using temporary credentials.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The SQL statement text to run.
     * </p>
     * 
     * @return The SQL statement text to run.
     */
    public final String sql() {
        return sql;
    }

    /**
     * <p>
     * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     * </p>
     * 
     * @return The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * Indicates whether to send an event back to EventBridge after the SQL statement runs.
     * </p>
     * 
     * @return Indicates whether to send an event back to EventBridge after the SQL statement runs.
     */
    public final Boolean withEvent() {
        return withEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(secretManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(sql());
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(withEvent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDataParameters)) {
            return false;
        }
        RedshiftDataParameters other = (RedshiftDataParameters) obj;
        return Objects.equals(secretManagerArn(), other.secretManagerArn()) && Objects.equals(database(), other.database())
                && Objects.equals(dbUser(), other.dbUser()) && Objects.equals(sql(), other.sql())
                && Objects.equals(statementName(), other.statementName()) && Objects.equals(withEvent(), other.withEvent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftDataParameters").add("SecretManagerArn", secretManagerArn()).add("Database", database())
                .add("DbUser", dbUser()).add("Sql", sql()).add("StatementName", statementName()).add("WithEvent", withEvent())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecretManagerArn":
            return Optional.ofNullable(clazz.cast(secretManagerArn()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "Sql":
            return Optional.ofNullable(clazz.cast(sql()));
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "WithEvent":
            return Optional.ofNullable(clazz.cast(withEvent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecretManagerArn", SECRET_MANAGER_ARN_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("DbUser", DB_USER_FIELD);
        map.put("Sql", SQL_FIELD);
        map.put("StatementName", STATEMENT_NAME_FIELD);
        map.put("WithEvent", WITH_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftDataParameters, T> g) {
        return obj -> g.apply((RedshiftDataParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftDataParameters> {
        /**
         * <p>
         * The name or ARN of the secret that enables access to the database. Required when authenticating using Amazon
         * Web Services Secrets Manager.
         * </p>
         * 
         * @param secretManagerArn
         *        The name or ARN of the secret that enables access to the database. Required when authenticating using
         *        Amazon Web Services Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretManagerArn(String secretManagerArn);

        /**
         * <p>
         * The name of the database. Required when authenticating using temporary credentials.
         * </p>
         * 
         * @param database
         *        The name of the database. Required when authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database user name. Required when authenticating using temporary credentials.
         * </p>
         * 
         * @param dbUser
         *        The database user name. Required when authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The SQL statement text to run.
         * </p>
         * 
         * @param sql
         *        The SQL statement text to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);

        /**
         * <p>
         * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
         * </p>
         * 
         * @param statementName
         *        The name of the SQL statement. You can name the SQL statement when you create it to identify the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * Indicates whether to send an event back to EventBridge after the SQL statement runs.
         * </p>
         * 
         * @param withEvent
         *        Indicates whether to send an event back to EventBridge after the SQL statement runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withEvent(Boolean withEvent);
    }

    static final class BuilderImpl implements Builder {
        private String secretManagerArn;

        private String database;

        private String dbUser;

        private String sql;

        private String statementName;

        private Boolean withEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDataParameters model) {
            secretManagerArn(model.secretManagerArn);
            database(model.database);
            dbUser(model.dbUser);
            sql(model.sql);
            statementName(model.statementName);
            withEvent(model.withEvent);
        }

        public final String getSecretManagerArn() {
            return secretManagerArn;
        }

        public final void setSecretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
        }

        @Override
        public final Builder secretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getSql() {
            return sql;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final String getStatementName() {
            return statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final Boolean getWithEvent() {
            return withEvent;
        }

        public final void setWithEvent(Boolean withEvent) {
            this.withEvent = withEvent;
        }

        @Override
        public final Builder withEvent(Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        @Override
        public RedshiftDataParameters build() {
            return new RedshiftDataParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
