/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchevents.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectionResponse extends CloudWatchEventsResponse implements
        ToCopyableBuilder<DescribeConnectionResponse.Builder, DescribeConnectionResponse> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionArn").getter(getter(DescribeConnectionResponse::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeConnectionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeConnectionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionState").getter(getter(DescribeConnectionResponse::connectionStateAsString))
            .setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(DescribeConnectionResponse::stateReason))
            .setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthorizationType").getter(getter(DescribeConnectionResponse::authorizationTypeAsString))
            .setter(setter(Builder::authorizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationType").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(DescribeConnectionResponse::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<ConnectionAuthResponseParameters> AUTH_PARAMETERS_FIELD = SdkField
            .<ConnectionAuthResponseParameters> builder(MarshallingType.SDK_POJO).memberName("AuthParameters")
            .getter(getter(DescribeConnectionResponse::authParameters)).setter(setter(Builder::authParameters))
            .constructor(ConnectionAuthResponseParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthParameters").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeConnectionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeConnectionResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> LAST_AUTHORIZED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAuthorizedTime").getter(getter(DescribeConnectionResponse::lastAuthorizedTime))
            .setter(setter(Builder::lastAuthorizedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAuthorizedTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, CONNECTION_STATE_FIELD, STATE_REASON_FIELD, AUTHORIZATION_TYPE_FIELD,
            SECRET_ARN_FIELD, AUTH_PARAMETERS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_AUTHORIZED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String connectionArn;

    private final String name;

    private final String description;

    private final String connectionState;

    private final String stateReason;

    private final String authorizationType;

    private final String secretArn;

    private final ConnectionAuthResponseParameters authParameters;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final Instant lastAuthorizedTime;

    private DescribeConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionArn = builder.connectionArn;
        this.name = builder.name;
        this.description = builder.description;
        this.connectionState = builder.connectionState;
        this.stateReason = builder.stateReason;
        this.authorizationType = builder.authorizationType;
        this.secretArn = builder.secretArn;
        this.authParameters = builder.authParameters;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastAuthorizedTime = builder.lastAuthorizedTime;
    }

    /**
     * <p>
     * The ARN of the connection retrieved.
     * </p>
     * 
     * @return The ARN of the connection retrieved.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The name of the connection retrieved.
     * </p>
     * 
     * @return The name of the connection retrieved.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for the connection retrieved.
     * </p>
     * 
     * @return The description for the connection retrieved.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The state of the connection retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection retrieved.
     * @see ConnectionState
     */
    public final ConnectionState connectionState() {
        return ConnectionState.fromValue(connectionState);
    }

    /**
     * <p>
     * The state of the connection retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link ConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return The state of the connection retrieved.
     * @see ConnectionState
     */
    public final String connectionStateAsString() {
        return connectionState;
    }

    /**
     * <p>
     * The reason that the connection is in the current connection state.
     * </p>
     * 
     * @return The reason that the connection is in the current connection state.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The type of authorization specified for the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link ConnectionAuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The type of authorization specified for the connection.
     * @see ConnectionAuthorizationType
     */
    public final ConnectionAuthorizationType authorizationType() {
        return ConnectionAuthorizationType.fromValue(authorizationType);
    }

    /**
     * <p>
     * The type of authorization specified for the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link ConnectionAuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The type of authorization specified for the connection.
     * @see ConnectionAuthorizationType
     */
    public final String authorizationTypeAsString() {
        return authorizationType;
    }

    /**
     * <p>
     * The ARN of the secret created from the authorization parameters specified for the connection.
     * </p>
     * 
     * @return The ARN of the secret created from the authorization parameters specified for the connection.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The parameters to use for authorization for the connection.
     * </p>
     * 
     * @return The parameters to use for authorization for the connection.
     */
    public final ConnectionAuthResponseParameters authParameters() {
        return authParameters;
    }

    /**
     * <p>
     * A time stamp for the time that the connection was created.
     * </p>
     * 
     * @return A time stamp for the time that the connection was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A time stamp for the time that the connection was last modified.
     * </p>
     * 
     * @return A time stamp for the time that the connection was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A time stamp for the time that the connection was last authorized.
     * </p>
     * 
     * @return A time stamp for the time that the connection was last authorized.
     */
    public final Instant lastAuthorizedTime() {
        return lastAuthorizedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(authParameters());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastAuthorizedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionResponse)) {
            return false;
        }
        DescribeConnectionResponse other = (DescribeConnectionResponse) obj;
        return Objects.equals(connectionArn(), other.connectionArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(connectionStateAsString(), other.connectionStateAsString())
                && Objects.equals(stateReason(), other.stateReason())
                && Objects.equals(authorizationTypeAsString(), other.authorizationTypeAsString())
                && Objects.equals(secretArn(), other.secretArn()) && Objects.equals(authParameters(), other.authParameters())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastAuthorizedTime(), other.lastAuthorizedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectionResponse").add("ConnectionArn", connectionArn()).add("Name", name())
                .add("Description", description()).add("ConnectionState", connectionStateAsString())
                .add("StateReason", stateReason()).add("AuthorizationType", authorizationTypeAsString())
                .add("SecretArn", secretArn()).add("AuthParameters", authParameters()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("LastAuthorizedTime", lastAuthorizedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ConnectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "AuthorizationType":
            return Optional.ofNullable(clazz.cast(authorizationTypeAsString()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "AuthParameters":
            return Optional.ofNullable(clazz.cast(authParameters()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastAuthorizedTime":
            return Optional.ofNullable(clazz.cast(lastAuthorizedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConnectionArn", CONNECTION_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ConnectionState", CONNECTION_STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("AuthorizationType", AUTHORIZATION_TYPE_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("AuthParameters", AUTH_PARAMETERS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastAuthorizedTime", LAST_AUTHORIZED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionResponse, T> g) {
        return obj -> g.apply((DescribeConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudWatchEventsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConnectionResponse> {
        /**
         * <p>
         * The ARN of the connection retrieved.
         * </p>
         * 
         * @param connectionArn
         *        The ARN of the connection retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The name of the connection retrieved.
         * </p>
         * 
         * @param name
         *        The name of the connection retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the connection retrieved.
         * </p>
         * 
         * @param description
         *        The description for the connection retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The state of the connection retrieved.
         * </p>
         * 
         * @param connectionState
         *        The state of the connection retrieved.
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * <p>
         * The state of the connection retrieved.
         * </p>
         * 
         * @param connectionState
         *        The state of the connection retrieved.
         * @see ConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionState
         */
        Builder connectionState(ConnectionState connectionState);

        /**
         * <p>
         * The reason that the connection is in the current connection state.
         * </p>
         * 
         * @param stateReason
         *        The reason that the connection is in the current connection state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The type of authorization specified for the connection.
         * </p>
         * 
         * @param authorizationType
         *        The type of authorization specified for the connection.
         * @see ConnectionAuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionAuthorizationType
         */
        Builder authorizationType(String authorizationType);

        /**
         * <p>
         * The type of authorization specified for the connection.
         * </p>
         * 
         * @param authorizationType
         *        The type of authorization specified for the connection.
         * @see ConnectionAuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionAuthorizationType
         */
        Builder authorizationType(ConnectionAuthorizationType authorizationType);

        /**
         * <p>
         * The ARN of the secret created from the authorization parameters specified for the connection.
         * </p>
         * 
         * @param secretArn
         *        The ARN of the secret created from the authorization parameters specified for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The parameters to use for authorization for the connection.
         * </p>
         * 
         * @param authParameters
         *        The parameters to use for authorization for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authParameters(ConnectionAuthResponseParameters authParameters);

        /**
         * <p>
         * The parameters to use for authorization for the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionAuthResponseParameters.Builder}
         * avoiding the need to create one manually via {@link ConnectionAuthResponseParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionAuthResponseParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #authParameters(ConnectionAuthResponseParameters)}.
         * 
         * @param authParameters
         *        a consumer that will call methods on {@link ConnectionAuthResponseParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authParameters(ConnectionAuthResponseParameters)
         */
        default Builder authParameters(Consumer<ConnectionAuthResponseParameters.Builder> authParameters) {
            return authParameters(ConnectionAuthResponseParameters.builder().applyMutation(authParameters).build());
        }

        /**
         * <p>
         * A time stamp for the time that the connection was created.
         * </p>
         * 
         * @param creationTime
         *        A time stamp for the time that the connection was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A time stamp for the time that the connection was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A time stamp for the time that the connection was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A time stamp for the time that the connection was last authorized.
         * </p>
         * 
         * @param lastAuthorizedTime
         *        A time stamp for the time that the connection was last authorized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAuthorizedTime(Instant lastAuthorizedTime);
    }

    static final class BuilderImpl extends CloudWatchEventsResponse.BuilderImpl implements Builder {
        private String connectionArn;

        private String name;

        private String description;

        private String connectionState;

        private String stateReason;

        private String authorizationType;

        private String secretArn;

        private ConnectionAuthResponseParameters authParameters;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private Instant lastAuthorizedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionResponse model) {
            super(model);
            connectionArn(model.connectionArn);
            name(model.name);
            description(model.description);
            connectionState(model.connectionState);
            stateReason(model.stateReason);
            authorizationType(model.authorizationType);
            secretArn(model.secretArn);
            authParameters(model.authParameters);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            lastAuthorizedTime(model.lastAuthorizedTime);
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectionState() {
            return connectionState;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(ConnectionState connectionState) {
            this.connectionState(connectionState == null ? null : connectionState.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getAuthorizationType() {
            return authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        public final Builder authorizationType(ConnectionAuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final ConnectionAuthResponseParameters.Builder getAuthParameters() {
            return authParameters != null ? authParameters.toBuilder() : null;
        }

        public final void setAuthParameters(ConnectionAuthResponseParameters.BuilderImpl authParameters) {
            this.authParameters = authParameters != null ? authParameters.build() : null;
        }

        @Override
        public final Builder authParameters(ConnectionAuthResponseParameters authParameters) {
            this.authParameters = authParameters;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getLastAuthorizedTime() {
            return lastAuthorizedTime;
        }

        public final void setLastAuthorizedTime(Instant lastAuthorizedTime) {
            this.lastAuthorizedTime = lastAuthorizedTime;
        }

        @Override
        public final Builder lastAuthorizedTime(Instant lastAuthorizedTime) {
            this.lastAuthorizedTime = lastAuthorizedTime;
            return this;
        }

        @Override
        public DescribeConnectionResponse build() {
            return new DescribeConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
