/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDashboardResponse extends CloudTrailResponse implements
        ToCopyableBuilder<UpdateDashboardResponse.Builder, UpdateDashboardResponse> {
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardArn").getter(getter(UpdateDashboardResponse::dashboardArn))
            .setter(setter(Builder::dashboardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateDashboardResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateDashboardResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<Widget>> WIDGETS_FIELD = SdkField
            .<List<Widget>> builder(MarshallingType.LIST)
            .memberName("Widgets")
            .getter(getter(UpdateDashboardResponse::widgets))
            .setter(setter(Builder::widgets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Widgets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Widget> builder(MarshallingType.SDK_POJO)
                                            .constructor(Widget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField
            .<RefreshSchedule> builder(MarshallingType.SDK_POJO).memberName("RefreshSchedule")
            .getter(getter(UpdateDashboardResponse::refreshSchedule)).setter(setter(Builder::refreshSchedule))
            .constructor(RefreshSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()).build();

    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtectionEnabled")
            .getter(getter(UpdateDashboardResponse::terminationProtectionEnabled))
            .setter(setter(Builder::terminationProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled")
                    .build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(UpdateDashboardResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp").getter(getter(UpdateDashboardResponse::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ARN_FIELD,
            NAME_FIELD, TYPE_FIELD, WIDGETS_FIELD, REFRESH_SCHEDULE_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD,
            CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dashboardArn;

    private final String name;

    private final String type;

    private final List<Widget> widgets;

    private final RefreshSchedule refreshSchedule;

    private final Boolean terminationProtectionEnabled;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private UpdateDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.name = builder.name;
        this.type = builder.type;
        this.widgets = builder.widgets;
        this.refreshSchedule = builder.refreshSchedule;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The ARN for the dashboard.
     * </p>
     * 
     * @return The ARN for the dashboard.
     */
    public final String dashboardArn() {
        return dashboardArn;
    }

    /**
     * <p>
     * The name for the dashboard.
     * </p>
     * 
     * @return The name for the dashboard.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of dashboard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of dashboard.
     * @see DashboardType
     */
    public final DashboardType type() {
        return DashboardType.fromValue(type);
    }

    /**
     * <p>
     * The type of dashboard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of dashboard.
     * @see DashboardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Widgets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWidgets() {
        return widgets != null && !(widgets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of widgets for the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWidgets} method.
     * </p>
     * 
     * @return An array of widgets for the dashboard.
     */
    public final List<Widget> widgets() {
        return widgets;
    }

    /**
     * <p>
     * The refresh schedule for the dashboard, if configured.
     * </p>
     * 
     * @return The refresh schedule for the dashboard, if configured.
     */
    public final RefreshSchedule refreshSchedule() {
        return refreshSchedule;
    }

    /**
     * <p>
     * Indicates whether termination protection is enabled for the dashboard.
     * </p>
     * 
     * @return Indicates whether termination protection is enabled for the dashboard.
     */
    public final Boolean terminationProtectionEnabled() {
        return terminationProtectionEnabled;
    }

    /**
     * <p>
     * The timestamp that shows when the dashboard was created.
     * </p>
     * 
     * @return The timestamp that shows when the dashboard was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp that shows when the dashboard was updated.
     * </p>
     * 
     * @return The timestamp that shows when the dashboard was updated.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasWidgets() ? widgets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardResponse)) {
            return false;
        }
        UpdateDashboardResponse other = (UpdateDashboardResponse) obj;
        return Objects.equals(dashboardArn(), other.dashboardArn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasWidgets() == other.hasWidgets()
                && Objects.equals(widgets(), other.widgets()) && Objects.equals(refreshSchedule(), other.refreshSchedule())
                && Objects.equals(terminationProtectionEnabled(), other.terminationProtectionEnabled())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDashboardResponse").add("DashboardArn", dashboardArn()).add("Name", name())
                .add("Type", typeAsString()).add("Widgets", hasWidgets() ? widgets() : null)
                .add("RefreshSchedule", refreshSchedule()).add("TerminationProtectionEnabled", terminationProtectionEnabled())
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardArn":
            return Optional.ofNullable(clazz.cast(dashboardArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Widgets":
            return Optional.ofNullable(clazz.cast(widgets()));
        case "RefreshSchedule":
            return Optional.ofNullable(clazz.cast(refreshSchedule()));
        case "TerminationProtectionEnabled":
            return Optional.ofNullable(clazz.cast(terminationProtectionEnabled()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardArn", DASHBOARD_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Widgets", WIDGETS_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardResponse, T> g) {
        return obj -> g.apply((UpdateDashboardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDashboardResponse> {
        /**
         * <p>
         * The ARN for the dashboard.
         * </p>
         * 
         * @param dashboardArn
         *        The ARN for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardArn(String dashboardArn);

        /**
         * <p>
         * The name for the dashboard.
         * </p>
         * 
         * @param name
         *        The name for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of dashboard.
         * </p>
         * 
         * @param type
         *        The type of dashboard.
         * @see DashboardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of dashboard.
         * </p>
         * 
         * @param type
         *        The type of dashboard.
         * @see DashboardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardType
         */
        Builder type(DashboardType type);

        /**
         * <p>
         * An array of widgets for the dashboard.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(Collection<Widget> widgets);

        /**
         * <p>
         * An array of widgets for the dashboard.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(Widget... widgets);

        /**
         * <p>
         * An array of widgets for the dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.Widget.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudtrail.model.Widget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.Widget.Builder#build()} is called immediately and its
         * result is passed to {@link #widgets(List<Widget>)}.
         * 
         * @param widgets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.Widget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #widgets(java.util.Collection<Widget>)
         */
        Builder widgets(Consumer<Widget.Builder>... widgets);

        /**
         * <p>
         * The refresh schedule for the dashboard, if configured.
         * </p>
         * 
         * @param refreshSchedule
         *        The refresh schedule for the dashboard, if configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedule(RefreshSchedule refreshSchedule);

        /**
         * <p>
         * The refresh schedule for the dashboard, if configured.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshSchedule.Builder} avoiding the
         * need to create one manually via {@link RefreshSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #refreshSchedule(RefreshSchedule)}.
         * 
         * @param refreshSchedule
         *        a consumer that will call methods on {@link RefreshSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedule(RefreshSchedule)
         */
        default Builder refreshSchedule(Consumer<RefreshSchedule.Builder> refreshSchedule) {
            return refreshSchedule(RefreshSchedule.builder().applyMutation(refreshSchedule).build());
        }

        /**
         * <p>
         * Indicates whether termination protection is enabled for the dashboard.
         * </p>
         * 
         * @param terminationProtectionEnabled
         *        Indicates whether termination protection is enabled for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled);

        /**
         * <p>
         * The timestamp that shows when the dashboard was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp that shows when the dashboard was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp that shows when the dashboard was updated.
         * </p>
         * 
         * @param updatedTimestamp
         *        The timestamp that shows when the dashboard was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String dashboardArn;

        private String name;

        private String type;

        private List<Widget> widgets = DefaultSdkAutoConstructList.getInstance();

        private RefreshSchedule refreshSchedule;

        private Boolean terminationProtectionEnabled;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardResponse model) {
            super(model);
            dashboardArn(model.dashboardArn);
            name(model.name);
            type(model.type);
            widgets(model.widgets);
            refreshSchedule(model.refreshSchedule);
            terminationProtectionEnabled(model.terminationProtectionEnabled);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getDashboardArn() {
            return dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DashboardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Widget.Builder> getWidgets() {
            List<Widget.Builder> result = WidgetListCopier.copyToBuilder(this.widgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWidgets(Collection<Widget.BuilderImpl> widgets) {
            this.widgets = WidgetListCopier.copyFromBuilder(widgets);
        }

        @Override
        public final Builder widgets(Collection<Widget> widgets) {
            this.widgets = WidgetListCopier.copy(widgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Widget... widgets) {
            widgets(Arrays.asList(widgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Consumer<Widget.Builder>... widgets) {
            widgets(Stream.of(widgets).map(c -> Widget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RefreshSchedule.Builder getRefreshSchedule() {
            return refreshSchedule != null ? refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(RefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(RefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public UpdateDashboardResponse build() {
            return new UpdateDashboardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
