/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopImportResponse extends CloudTrailResponse implements
        ToCopyableBuilder<StopImportResponse.Builder, StopImportResponse> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportId").getter(getter(StopImportResponse::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportId").build()).build();

    private static final SdkField<ImportSource> IMPORT_SOURCE_FIELD = SdkField.<ImportSource> builder(MarshallingType.SDK_POJO)
            .memberName("ImportSource").getter(getter(StopImportResponse::importSource)).setter(setter(Builder::importSource))
            .constructor(ImportSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSource").build()).build();

    private static final SdkField<List<String>> DESTINATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(StopImportResponse::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportStatus").getter(getter(StopImportResponse::importStatusAsString))
            .setter(setter(Builder::importStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(StopImportResponse::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp").getter(getter(StopImportResponse::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build()).build();

    private static final SdkField<Instant> START_EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartEventTime").getter(getter(StopImportResponse::startEventTime))
            .setter(setter(Builder::startEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartEventTime").build()).build();

    private static final SdkField<Instant> END_EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndEventTime").getter(getter(StopImportResponse::endEventTime)).setter(setter(Builder::endEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndEventTime").build()).build();

    private static final SdkField<ImportStatistics> IMPORT_STATISTICS_FIELD = SdkField
            .<ImportStatistics> builder(MarshallingType.SDK_POJO).memberName("ImportStatistics")
            .getter(getter(StopImportResponse::importStatistics)).setter(setter(Builder::importStatistics))
            .constructor(ImportStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD,
            IMPORT_SOURCE_FIELD, DESTINATIONS_FIELD, IMPORT_STATUS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD,
            START_EVENT_TIME_FIELD, END_EVENT_TIME_FIELD, IMPORT_STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String importId;

    private final ImportSource importSource;

    private final List<String> destinations;

    private final String importStatus;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private final Instant startEventTime;

    private final Instant endEventTime;

    private final ImportStatistics importStatistics;

    private StopImportResponse(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.importSource = builder.importSource;
        this.destinations = builder.destinations;
        this.importStatus = builder.importStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
        this.startEventTime = builder.startEventTime;
        this.endEventTime = builder.endEventTime;
        this.importStatistics = builder.importStatistics;
    }

    /**
     * <p>
     * The ID for the import.
     * </p>
     * 
     * @return The ID for the import.
     */
    public final String importId() {
        return importId;
    }

    /**
     * <p>
     * The source S3 bucket for the import.
     * </p>
     * 
     * @return The source S3 bucket for the import.
     */
    public final ImportSource importSource() {
        return importSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN of the destination event data store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The ARN of the destination event data store.
     */
    public final List<String> destinations() {
        return destinations;
    }

    /**
     * <p>
     * The status of the import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import.
     * @see ImportStatus
     */
    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(importStatus);
    }

    /**
     * <p>
     * The status of the import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importStatus} will
     * return {@link ImportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #importStatusAsString}.
     * </p>
     * 
     * @return The status of the import.
     * @see ImportStatus
     */
    public final String importStatusAsString() {
        return importStatus;
    }

    /**
     * <p>
     * The timestamp of the import's creation.
     * </p>
     * 
     * @return The timestamp of the import's creation.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The timestamp of the import's last update.
     * </p>
     * 
     * @return The timestamp of the import's last update.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    /**
     * <p>
     * Used with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events
     * to only those events logged within a specified time period.
     * </p>
     * 
     * @return Used with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail
     *         events to only those events logged within a specified time period.
     */
    public final Instant startEventTime() {
        return startEventTime;
    }

    /**
     * <p>
     * Used with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail
     * events to only those events logged within a specified time period.
     * </p>
     * 
     * @return Used with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported
     *         trail events to only those events logged within a specified time period.
     */
    public final Instant endEventTime() {
        return endEventTime;
    }

    /**
     * <p>
     * Returns information on the stopped import.
     * </p>
     * 
     * @return Returns information on the stopped import.
     */
    public final ImportStatistics importStatistics() {
        return importStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        hashCode = 31 * hashCode + Objects.hashCode(importSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(startEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(endEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(importStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopImportResponse)) {
            return false;
        }
        StopImportResponse other = (StopImportResponse) obj;
        return Objects.equals(importId(), other.importId()) && Objects.equals(importSource(), other.importSource())
                && hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && Objects.equals(importStatusAsString(), other.importStatusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp())
                && Objects.equals(startEventTime(), other.startEventTime())
                && Objects.equals(endEventTime(), other.endEventTime())
                && Objects.equals(importStatistics(), other.importStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopImportResponse").add("ImportId", importId()).add("ImportSource", importSource())
                .add("Destinations", hasDestinations() ? destinations() : null).add("ImportStatus", importStatusAsString())
                .add("CreatedTimestamp", createdTimestamp()).add("UpdatedTimestamp", updatedTimestamp())
                .add("StartEventTime", startEventTime()).add("EndEventTime", endEventTime())
                .add("ImportStatistics", importStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportId":
            return Optional.ofNullable(clazz.cast(importId()));
        case "ImportSource":
            return Optional.ofNullable(clazz.cast(importSource()));
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "ImportStatus":
            return Optional.ofNullable(clazz.cast(importStatusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        case "StartEventTime":
            return Optional.ofNullable(clazz.cast(startEventTime()));
        case "EndEventTime":
            return Optional.ofNullable(clazz.cast(endEventTime()));
        case "ImportStatistics":
            return Optional.ofNullable(clazz.cast(importStatistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImportId", IMPORT_ID_FIELD);
        map.put("ImportSource", IMPORT_SOURCE_FIELD);
        map.put("Destinations", DESTINATIONS_FIELD);
        map.put("ImportStatus", IMPORT_STATUS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        map.put("StartEventTime", START_EVENT_TIME_FIELD);
        map.put("EndEventTime", END_EVENT_TIME_FIELD);
        map.put("ImportStatistics", IMPORT_STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopImportResponse, T> g) {
        return obj -> g.apply((StopImportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, StopImportResponse> {
        /**
         * <p>
         * The ID for the import.
         * </p>
         * 
         * @param importId
         *        The ID for the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        /**
         * <p>
         * The source S3 bucket for the import.
         * </p>
         * 
         * @param importSource
         *        The source S3 bucket for the import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSource(ImportSource importSource);

        /**
         * <p>
         * The source S3 bucket for the import.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportSource.Builder} avoiding the need
         * to create one manually via {@link ImportSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportSource.Builder#build()} is called immediately and its
         * result is passed to {@link #importSource(ImportSource)}.
         * 
         * @param importSource
         *        a consumer that will call methods on {@link ImportSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importSource(ImportSource)
         */
        default Builder importSource(Consumer<ImportSource.Builder> importSource) {
            return importSource(ImportSource.builder().applyMutation(importSource).build());
        }

        /**
         * <p>
         * The ARN of the destination event data store.
         * </p>
         * 
         * @param destinations
         *        The ARN of the destination event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<String> destinations);

        /**
         * <p>
         * The ARN of the destination event data store.
         * </p>
         * 
         * @param destinations
         *        The ARN of the destination event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(String... destinations);

        /**
         * <p>
         * The status of the import.
         * </p>
         * 
         * @param importStatus
         *        The status of the import.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(String importStatus);

        /**
         * <p>
         * The status of the import.
         * </p>
         * 
         * @param importStatus
         *        The status of the import.
         * @see ImportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportStatus
         */
        Builder importStatus(ImportStatus importStatus);

        /**
         * <p>
         * The timestamp of the import's creation.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp of the import's creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The timestamp of the import's last update.
         * </p>
         * 
         * @param updatedTimestamp
         *        The timestamp of the import's last update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);

        /**
         * <p>
         * Used with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail
         * events to only those events logged within a specified time period.
         * </p>
         * 
         * @param startEventTime
         *        Used with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported
         *        trail events to only those events logged within a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startEventTime(Instant startEventTime);

        /**
         * <p>
         * Used with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail
         * events to only those events logged within a specified time period.
         * </p>
         * 
         * @param endEventTime
         *        Used with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported
         *        trail events to only those events logged within a specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endEventTime(Instant endEventTime);

        /**
         * <p>
         * Returns information on the stopped import.
         * </p>
         * 
         * @param importStatistics
         *        Returns information on the stopped import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importStatistics(ImportStatistics importStatistics);

        /**
         * <p>
         * Returns information on the stopped import.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportStatistics.Builder} avoiding the
         * need to create one manually via {@link ImportStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #importStatistics(ImportStatistics)}.
         * 
         * @param importStatistics
         *        a consumer that will call methods on {@link ImportStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importStatistics(ImportStatistics)
         */
        default Builder importStatistics(Consumer<ImportStatistics.Builder> importStatistics) {
            return importStatistics(ImportStatistics.builder().applyMutation(importStatistics).build());
        }
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String importId;

        private ImportSource importSource;

        private List<String> destinations = DefaultSdkAutoConstructList.getInstance();

        private String importStatus;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private Instant startEventTime;

        private Instant endEventTime;

        private ImportStatistics importStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(StopImportResponse model) {
            super(model);
            importId(model.importId);
            importSource(model.importSource);
            destinations(model.destinations);
            importStatus(model.importStatus);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
            startEventTime(model.startEventTime);
            endEventTime(model.endEventTime);
            importStatistics(model.importStatistics);
        }

        public final String getImportId() {
            return importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final ImportSource.Builder getImportSource() {
            return importSource != null ? importSource.toBuilder() : null;
        }

        public final void setImportSource(ImportSource.BuilderImpl importSource) {
            this.importSource = importSource != null ? importSource.build() : null;
        }

        @Override
        public final Builder importSource(ImportSource importSource) {
            this.importSource = importSource;
            return this;
        }

        public final Collection<String> getDestinations() {
            if (destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return destinations;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        public final String getImportStatus() {
            return importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final Instant getStartEventTime() {
            return startEventTime;
        }

        public final void setStartEventTime(Instant startEventTime) {
            this.startEventTime = startEventTime;
        }

        @Override
        public final Builder startEventTime(Instant startEventTime) {
            this.startEventTime = startEventTime;
            return this;
        }

        public final Instant getEndEventTime() {
            return endEventTime;
        }

        public final void setEndEventTime(Instant endEventTime) {
            this.endEventTime = endEventTime;
        }

        @Override
        public final Builder endEventTime(Instant endEventTime) {
            this.endEventTime = endEventTime;
            return this;
        }

        public final ImportStatistics.Builder getImportStatistics() {
            return importStatistics != null ? importStatistics.toBuilder() : null;
        }

        public final void setImportStatistics(ImportStatistics.BuilderImpl importStatistics) {
            this.importStatistics = importStatistics != null ? importStatistics.build() : null;
        }

        @Override
        public final Builder importStatistics(ImportStatistics importStatistics) {
            this.importStatistics = importStatistics;
            return this;
        }

        @Override
        public StopImportResponse build() {
            return new StopImportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
