/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportRequest extends CloudTrailRequest implements
        ToCopyableBuilder<StartImportRequest.Builder, StartImportRequest> {
    private static final SdkField<List<String>> DESTINATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(StartImportRequest::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ImportSource> IMPORT_SOURCE_FIELD = SdkField.<ImportSource> builder(MarshallingType.SDK_POJO)
            .memberName("ImportSource").getter(getter(StartImportRequest::importSource)).setter(setter(Builder::importSource))
            .constructor(ImportSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportSource").build()).build();

    private static final SdkField<Instant> START_EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartEventTime").getter(getter(StartImportRequest::startEventTime))
            .setter(setter(Builder::startEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartEventTime").build()).build();

    private static final SdkField<Instant> END_EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndEventTime").getter(getter(StartImportRequest::endEventTime)).setter(setter(Builder::endEventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndEventTime").build()).build();

    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImportId").getter(getter(StartImportRequest::importId)).setter(setter(Builder::importId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD,
            IMPORT_SOURCE_FIELD, START_EVENT_TIME_FIELD, END_EVENT_TIME_FIELD, IMPORT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> destinations;

    private final ImportSource importSource;

    private final Instant startEventTime;

    private final Instant endEventTime;

    private final String importId;

    private StartImportRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.importSource = builder.importSource;
        this.startEventTime = builder.startEventTime;
        this.endEventTime = builder.endEventTime;
        this.importId = builder.importId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARN of the destination event data store. Use this parameter for a new import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return The ARN of the destination event data store. Use this parameter for a new import.
     */
    public final List<String> destinations() {
        return destinations;
    }

    /**
     * <p>
     * The source S3 bucket for the import. Use this parameter for a new import.
     * </p>
     * 
     * @return The source S3 bucket for the import. Use this parameter for a new import.
     */
    public final ImportSource importSource() {
        return importSource;
    }

    /**
     * <p>
     * Use with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events
     * to only those events logged within a specified time period. When you specify a time range, CloudTrail checks the
     * prefix and log file names to verify the names contain a date between the specified <code>StartEventTime</code>
     * and <code>EndEventTime</code> before attempting to import events.
     * </p>
     * 
     * @return Use with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail
     *         events to only those events logged within a specified time period. When you specify a time range,
     *         CloudTrail checks the prefix and log file names to verify the names contain a date between the specified
     *         <code>StartEventTime</code> and <code>EndEventTime</code> before attempting to import events.
     */
    public final Instant startEventTime() {
        return startEventTime;
    }

    /**
     * <p>
     * Use with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail events
     * to only those events logged within a specified time period. When you specify a time range, CloudTrail checks the
     * prefix and log file names to verify the names contain a date between the specified <code>StartEventTime</code>
     * and <code>EndEventTime</code> before attempting to import events.
     * </p>
     * 
     * @return Use with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported
     *         trail events to only those events logged within a specified time period. When you specify a time range,
     *         CloudTrail checks the prefix and log file names to verify the names contain a date between the specified
     *         <code>StartEventTime</code> and <code>EndEventTime</code> before attempting to import events.
     */
    public final Instant endEventTime() {
        return endEventTime;
    }

    /**
     * <p>
     * The ID of the import. Use this parameter when you are retrying an import.
     * </p>
     * 
     * @return The ID of the import. Use this parameter when you are retrying an import.
     */
    public final String importId() {
        return importId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(importSource());
        hashCode = 31 * hashCode + Objects.hashCode(startEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(endEventTime());
        hashCode = 31 * hashCode + Objects.hashCode(importId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportRequest)) {
            return false;
        }
        StartImportRequest other = (StartImportRequest) obj;
        return hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && Objects.equals(importSource(), other.importSource())
                && Objects.equals(startEventTime(), other.startEventTime())
                && Objects.equals(endEventTime(), other.endEventTime()) && Objects.equals(importId(), other.importId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImportRequest").add("Destinations", hasDestinations() ? destinations() : null)
                .add("ImportSource", importSource()).add("StartEventTime", startEventTime()).add("EndEventTime", endEventTime())
                .add("ImportId", importId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "ImportSource":
            return Optional.ofNullable(clazz.cast(importSource()));
        case "StartEventTime":
            return Optional.ofNullable(clazz.cast(startEventTime()));
        case "EndEventTime":
            return Optional.ofNullable(clazz.cast(endEventTime()));
        case "ImportId":
            return Optional.ofNullable(clazz.cast(importId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Destinations", DESTINATIONS_FIELD);
        map.put("ImportSource", IMPORT_SOURCE_FIELD);
        map.put("StartEventTime", START_EVENT_TIME_FIELD);
        map.put("EndEventTime", END_EVENT_TIME_FIELD);
        map.put("ImportId", IMPORT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartImportRequest, T> g) {
        return obj -> g.apply((StartImportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartImportRequest> {
        /**
         * <p>
         * The ARN of the destination event data store. Use this parameter for a new import.
         * </p>
         * 
         * @param destinations
         *        The ARN of the destination event data store. Use this parameter for a new import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<String> destinations);

        /**
         * <p>
         * The ARN of the destination event data store. Use this parameter for a new import.
         * </p>
         * 
         * @param destinations
         *        The ARN of the destination event data store. Use this parameter for a new import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(String... destinations);

        /**
         * <p>
         * The source S3 bucket for the import. Use this parameter for a new import.
         * </p>
         * 
         * @param importSource
         *        The source S3 bucket for the import. Use this parameter for a new import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importSource(ImportSource importSource);

        /**
         * <p>
         * The source S3 bucket for the import. Use this parameter for a new import.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportSource.Builder} avoiding the need
         * to create one manually via {@link ImportSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportSource.Builder#build()} is called immediately and its
         * result is passed to {@link #importSource(ImportSource)}.
         * 
         * @param importSource
         *        a consumer that will call methods on {@link ImportSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importSource(ImportSource)
         */
        default Builder importSource(Consumer<ImportSource.Builder> importSource) {
            return importSource(ImportSource.builder().applyMutation(importSource).build());
        }

        /**
         * <p>
         * Use with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail
         * events to only those events logged within a specified time period. When you specify a time range, CloudTrail
         * checks the prefix and log file names to verify the names contain a date between the specified
         * <code>StartEventTime</code> and <code>EndEventTime</code> before attempting to import events.
         * </p>
         * 
         * @param startEventTime
         *        Use with <code>EndEventTime</code> to bound a <code>StartImport</code> request, and limit imported
         *        trail events to only those events logged within a specified time period. When you specify a time
         *        range, CloudTrail checks the prefix and log file names to verify the names contain a date between the
         *        specified <code>StartEventTime</code> and <code>EndEventTime</code> before attempting to import
         *        events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startEventTime(Instant startEventTime);

        /**
         * <p>
         * Use with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported trail
         * events to only those events logged within a specified time period. When you specify a time range, CloudTrail
         * checks the prefix and log file names to verify the names contain a date between the specified
         * <code>StartEventTime</code> and <code>EndEventTime</code> before attempting to import events.
         * </p>
         * 
         * @param endEventTime
         *        Use with <code>StartEventTime</code> to bound a <code>StartImport</code> request, and limit imported
         *        trail events to only those events logged within a specified time period. When you specify a time
         *        range, CloudTrail checks the prefix and log file names to verify the names contain a date between the
         *        specified <code>StartEventTime</code> and <code>EndEventTime</code> before attempting to import
         *        events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endEventTime(Instant endEventTime);

        /**
         * <p>
         * The ID of the import. Use this parameter when you are retrying an import.
         * </p>
         * 
         * @param importId
         *        The ID of the import. Use this parameter when you are retrying an import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importId(String importId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private List<String> destinations = DefaultSdkAutoConstructList.getInstance();

        private ImportSource importSource;

        private Instant startEventTime;

        private Instant endEventTime;

        private String importId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportRequest model) {
            super(model);
            destinations(model.destinations);
            importSource(model.importSource);
            startEventTime(model.startEventTime);
            endEventTime(model.endEventTime);
            importId(model.importId);
        }

        public final Collection<String> getDestinations() {
            if (destinations instanceof SdkAutoConstructList) {
                return null;
            }
            return destinations;
        }

        public final void setDestinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
        }

        @Override
        public final Builder destinations(Collection<String> destinations) {
            this.destinations = ImportDestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(String... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        public final ImportSource.Builder getImportSource() {
            return importSource != null ? importSource.toBuilder() : null;
        }

        public final void setImportSource(ImportSource.BuilderImpl importSource) {
            this.importSource = importSource != null ? importSource.build() : null;
        }

        @Override
        public final Builder importSource(ImportSource importSource) {
            this.importSource = importSource;
            return this;
        }

        public final Instant getStartEventTime() {
            return startEventTime;
        }

        public final void setStartEventTime(Instant startEventTime) {
            this.startEventTime = startEventTime;
        }

        @Override
        public final Builder startEventTime(Instant startEventTime) {
            this.startEventTime = startEventTime;
            return this;
        }

        public final Instant getEndEventTime() {
            return endEventTime;
        }

        public final void setEndEventTime(Instant endEventTime) {
            this.endEventTime = endEventTime;
        }

        @Override
        public final Builder endEventTime(Instant endEventTime) {
            this.endEventTime = endEventTime;
            return this;
        }

        public final String getImportId() {
            return importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportRequest build() {
            return new StartImportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
