/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A search result returned by the <code>SearchSampleQueries</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchSampleQueriesSearchResult implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchSampleQueriesSearchResult.Builder, SearchSampleQueriesSearchResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SearchSampleQueriesSearchResult::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SearchSampleQueriesSearchResult::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SQL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SQL")
            .getter(getter(SearchSampleQueriesSearchResult::sql)).setter(setter(Builder::sql))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SQL").build()).build();

    private static final SdkField<Float> RELEVANCE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("Relevance").getter(getter(SearchSampleQueriesSearchResult::relevance))
            .setter(setter(Builder::relevance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relevance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SQL_FIELD, RELEVANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String sql;

    private final Float relevance;

    private SearchSampleQueriesSearchResult(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.sql = builder.sql;
        this.relevance = builder.relevance;
    }

    /**
     * <p>
     * The name of a sample query.
     * </p>
     * 
     * @return The name of a sample query.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A longer description of a sample query.
     * </p>
     * 
     * @return A longer description of a sample query.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The SQL code of the sample query.
     * </p>
     * 
     * @return The SQL code of the sample query.
     */
    public final String sql() {
        return sql;
    }

    /**
     * <p>
     * A value between 0 and 1 indicating the similarity between the search phrase and result.
     * </p>
     * 
     * @return A value between 0 and 1 indicating the similarity between the search phrase and result.
     */
    public final Float relevance() {
        return relevance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sql());
        hashCode = 31 * hashCode + Objects.hashCode(relevance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSampleQueriesSearchResult)) {
            return false;
        }
        SearchSampleQueriesSearchResult other = (SearchSampleQueriesSearchResult) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(sql(), other.sql()) && Objects.equals(relevance(), other.relevance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchSampleQueriesSearchResult").add("Name", name()).add("Description", description())
                .add("SQL", sql()).add("Relevance", relevance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SQL":
            return Optional.ofNullable(clazz.cast(sql()));
        case "Relevance":
            return Optional.ofNullable(clazz.cast(relevance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SQL", SQL_FIELD);
        map.put("Relevance", RELEVANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchSampleQueriesSearchResult, T> g) {
        return obj -> g.apply((SearchSampleQueriesSearchResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchSampleQueriesSearchResult> {
        /**
         * <p>
         * The name of a sample query.
         * </p>
         * 
         * @param name
         *        The name of a sample query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A longer description of a sample query.
         * </p>
         * 
         * @param description
         *        A longer description of a sample query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The SQL code of the sample query.
         * </p>
         * 
         * @param sql
         *        The SQL code of the sample query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);

        /**
         * <p>
         * A value between 0 and 1 indicating the similarity between the search phrase and result.
         * </p>
         * 
         * @param relevance
         *        A value between 0 and 1 indicating the similarity between the search phrase and result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relevance(Float relevance);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String sql;

        private Float relevance;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSampleQueriesSearchResult model) {
            name(model.name);
            description(model.description);
            sql(model.sql);
            relevance(model.relevance);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSql() {
            return sql;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final Float getRelevance() {
            return relevance;
        }

        public final void setRelevance(Float relevance) {
            this.relevance = relevance;
        }

        @Override
        public final Builder relevance(Float relevance) {
            this.relevance = relevance;
            return this;
        }

        @Override
        public SearchSampleQueriesSearchResult build() {
            return new SearchSampleQueriesSearchResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
