/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the frequency for a dashboard refresh schedule.
 * </p>
 * <p>
 * For a custom dashboard, you can schedule a refresh for every 1, 6, 12, or 24 hours, or every day.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RefreshScheduleFrequency implements SdkPojo, Serializable,
        ToCopyableBuilder<RefreshScheduleFrequency.Builder, RefreshScheduleFrequency> {
    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(RefreshScheduleFrequency::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Value")
            .getter(getter(RefreshScheduleFrequency::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String unit;

    private final Integer value;

    private RefreshScheduleFrequency(BuilderImpl builder) {
        this.unit = builder.unit;
        this.value = builder.value;
    }

    /**
     * <p>
     * The unit to use for the refresh.
     * </p>
     * <p>
     * For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code>.
     * </p>
     * <p>
     * For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link RefreshScheduleFrequencyUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #unitAsString}.
     * </p>
     * 
     * @return The unit to use for the refresh. </p>
     *         <p>
     *         For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code>.
     *         </p>
     *         <p>
     *         For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code>.
     * @see RefreshScheduleFrequencyUnit
     */
    public final RefreshScheduleFrequencyUnit unit() {
        return RefreshScheduleFrequencyUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit to use for the refresh.
     * </p>
     * <p>
     * For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code>.
     * </p>
     * <p>
     * For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link RefreshScheduleFrequencyUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #unitAsString}.
     * </p>
     * 
     * @return The unit to use for the refresh. </p>
     *         <p>
     *         For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code>.
     *         </p>
     *         <p>
     *         For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code>.
     * @see RefreshScheduleFrequencyUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The value for the refresh schedule.
     * </p>
     * <p>
     * For custom dashboards, the following values are valid when the unit is <code>HOURS</code>: <code>1</code>,
     * <code>6</code>, <code>12</code>, <code>24</code>
     * </p>
     * <p>
     * For custom dashboards, the only valid value when the unit is <code>DAYS</code> is <code>1</code>.
     * </p>
     * <p>
     * For the Highlights dashboard, the <code>Value</code> must be <code>6</code>.
     * </p>
     * 
     * @return The value for the refresh schedule. </p>
     *         <p>
     *         For custom dashboards, the following values are valid when the unit is <code>HOURS</code>: <code>1</code>, <code>6</code>, <code>12</code>, <code>24</code>
     *         </p>
     *         <p>
     *         For custom dashboards, the only valid value when the unit is <code>DAYS</code> is <code>1</code>.
     *         </p>
     *         <p>
     *         For the Highlights dashboard, the <code>Value</code> must be <code>6</code>.
     */
    public final Integer value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefreshScheduleFrequency)) {
            return false;
        }
        RefreshScheduleFrequency other = (RefreshScheduleFrequency) obj;
        return Objects.equals(unitAsString(), other.unitAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RefreshScheduleFrequency").add("Unit", unitAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Unit", UNIT_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RefreshScheduleFrequency, T> g) {
        return obj -> g.apply((RefreshScheduleFrequency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RefreshScheduleFrequency> {
        /**
         * <p>
         * The unit to use for the refresh.
         * </p>
         * <p>
         * For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code>.
         * </p>
         * <p>
         * For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code>.
         * </p>
         * 
         * @param unit
         *        The unit to use for the refresh. </p>
         *        <p>
         *        For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code>.
         *        </p>
         *        <p>
         *        For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code>.
         * @see RefreshScheduleFrequencyUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshScheduleFrequencyUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit to use for the refresh.
         * </p>
         * <p>
         * For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code>.
         * </p>
         * <p>
         * For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code>.
         * </p>
         * 
         * @param unit
         *        The unit to use for the refresh. </p>
         *        <p>
         *        For custom dashboards, the unit can be <code>HOURS</code> or <code>DAYS</code>.
         *        </p>
         *        <p>
         *        For the Highlights dashboard, the <code>Unit</code> must be <code>HOURS</code>.
         * @see RefreshScheduleFrequencyUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RefreshScheduleFrequencyUnit
         */
        Builder unit(RefreshScheduleFrequencyUnit unit);

        /**
         * <p>
         * The value for the refresh schedule.
         * </p>
         * <p>
         * For custom dashboards, the following values are valid when the unit is <code>HOURS</code>: <code>1</code>,
         * <code>6</code>, <code>12</code>, <code>24</code>
         * </p>
         * <p>
         * For custom dashboards, the only valid value when the unit is <code>DAYS</code> is <code>1</code>.
         * </p>
         * <p>
         * For the Highlights dashboard, the <code>Value</code> must be <code>6</code>.
         * </p>
         * 
         * @param value
         *        The value for the refresh schedule. </p>
         *        <p>
         *        For custom dashboards, the following values are valid when the unit is <code>HOURS</code>:
         *        <code>1</code>, <code>6</code>, <code>12</code>, <code>24</code>
         *        </p>
         *        <p>
         *        For custom dashboards, the only valid value when the unit is <code>DAYS</code> is <code>1</code>.
         *        </p>
         *        <p>
         *        For the Highlights dashboard, the <code>Value</code> must be <code>6</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);
    }

    static final class BuilderImpl implements Builder {
        private String unit;

        private Integer value;

        private BuilderImpl() {
        }

        private BuilderImpl(RefreshScheduleFrequency model) {
            unit(model.unit);
            value(model.value);
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(RefreshScheduleFrequencyUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Integer getValue() {
            return value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        @Override
        public RefreshScheduleFrequency build() {
            return new RefreshScheduleFrequency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
