/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata about a query, such as the number of results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryStatistics implements SdkPojo, Serializable, ToCopyableBuilder<QueryStatistics.Builder, QueryStatistics> {
    private static final SdkField<Integer> RESULTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResultsCount").getter(getter(QueryStatistics::resultsCount)).setter(setter(Builder::resultsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsCount").build()).build();

    private static final SdkField<Integer> TOTAL_RESULTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalResultsCount").getter(getter(QueryStatistics::totalResultsCount))
            .setter(setter(Builder::totalResultsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResultsCount").build()).build();

    private static final SdkField<Long> BYTES_SCANNED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BytesScanned").getter(getter(QueryStatistics::bytesScanned)).setter(setter(Builder::bytesScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesScanned").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_COUNT_FIELD,
            TOTAL_RESULTS_COUNT_FIELD, BYTES_SCANNED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer resultsCount;

    private final Integer totalResultsCount;

    private final Long bytesScanned;

    private QueryStatistics(BuilderImpl builder) {
        this.resultsCount = builder.resultsCount;
        this.totalResultsCount = builder.totalResultsCount;
        this.bytesScanned = builder.bytesScanned;
    }

    /**
     * <p>
     * The number of results returned.
     * </p>
     * 
     * @return The number of results returned.
     */
    public final Integer resultsCount() {
        return resultsCount;
    }

    /**
     * <p>
     * The total number of results returned by a query.
     * </p>
     * 
     * @return The total number of results returned by a query.
     */
    public final Integer totalResultsCount() {
        return totalResultsCount;
    }

    /**
     * <p>
     * The total bytes that the query scanned in the event data store. This value matches the number of bytes for which
     * your account is billed for the query, unless the query is still running.
     * </p>
     * 
     * @return The total bytes that the query scanned in the event data store. This value matches the number of bytes
     *         for which your account is billed for the query, unless the query is still running.
     */
    public final Long bytesScanned() {
        return bytesScanned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultsCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalResultsCount());
        hashCode = 31 * hashCode + Objects.hashCode(bytesScanned());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStatistics)) {
            return false;
        }
        QueryStatistics other = (QueryStatistics) obj;
        return Objects.equals(resultsCount(), other.resultsCount())
                && Objects.equals(totalResultsCount(), other.totalResultsCount())
                && Objects.equals(bytesScanned(), other.bytesScanned());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryStatistics").add("ResultsCount", resultsCount())
                .add("TotalResultsCount", totalResultsCount()).add("BytesScanned", bytesScanned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResultsCount":
            return Optional.ofNullable(clazz.cast(resultsCount()));
        case "TotalResultsCount":
            return Optional.ofNullable(clazz.cast(totalResultsCount()));
        case "BytesScanned":
            return Optional.ofNullable(clazz.cast(bytesScanned()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResultsCount", RESULTS_COUNT_FIELD);
        map.put("TotalResultsCount", TOTAL_RESULTS_COUNT_FIELD);
        map.put("BytesScanned", BYTES_SCANNED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryStatistics, T> g) {
        return obj -> g.apply((QueryStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryStatistics> {
        /**
         * <p>
         * The number of results returned.
         * </p>
         * 
         * @param resultsCount
         *        The number of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsCount(Integer resultsCount);

        /**
         * <p>
         * The total number of results returned by a query.
         * </p>
         * 
         * @param totalResultsCount
         *        The total number of results returned by a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResultsCount(Integer totalResultsCount);

        /**
         * <p>
         * The total bytes that the query scanned in the event data store. This value matches the number of bytes for
         * which your account is billed for the query, unless the query is still running.
         * </p>
         * 
         * @param bytesScanned
         *        The total bytes that the query scanned in the event data store. This value matches the number of bytes
         *        for which your account is billed for the query, unless the query is still running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesScanned(Long bytesScanned);
    }

    static final class BuilderImpl implements Builder {
        private Integer resultsCount;

        private Integer totalResultsCount;

        private Long bytesScanned;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStatistics model) {
            resultsCount(model.resultsCount);
            totalResultsCount(model.totalResultsCount);
            bytesScanned(model.bytesScanned);
        }

        public final Integer getResultsCount() {
            return resultsCount;
        }

        public final void setResultsCount(Integer resultsCount) {
            this.resultsCount = resultsCount;
        }

        @Override
        public final Builder resultsCount(Integer resultsCount) {
            this.resultsCount = resultsCount;
            return this;
        }

        public final Integer getTotalResultsCount() {
            return totalResultsCount;
        }

        public final void setTotalResultsCount(Integer totalResultsCount) {
            this.totalResultsCount = totalResultsCount;
        }

        @Override
        public final Builder totalResultsCount(Integer totalResultsCount) {
            this.totalResultsCount = totalResultsCount;
            return this;
        }

        public final Long getBytesScanned() {
            return bytesScanned;
        }

        public final void setBytesScanned(Long bytesScanned) {
            this.bytesScanned = bytesScanned;
        }

        @Override
        public final Builder bytesScanned(Long bytesScanned) {
            this.bytesScanned = bytesScanned;
            return this;
        }

        @Override
        public QueryStatistics build() {
            return new QueryStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
