/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInsightsMetricDataResponse extends CloudTrailResponse implements
        ToCopyableBuilder<ListInsightsMetricDataResponse.Builder, ListInsightsMetricDataResponse> {
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSource").getter(getter(ListInsightsMetricDataResponse::eventSource))
            .setter(setter(Builder::eventSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()).build();

    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventName").getter(getter(ListInsightsMetricDataResponse::eventName)).setter(setter(Builder::eventName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventName").build()).build();

    private static final SdkField<String> INSIGHT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InsightType").getter(getter(ListInsightsMetricDataResponse::insightTypeAsString))
            .setter(setter(Builder::insightType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightType").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(ListInsightsMetricDataResponse::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<List<Instant>> TIMESTAMPS_FIELD = SdkField
            .<List<Instant>> builder(MarshallingType.LIST)
            .memberName("Timestamps")
            .getter(getter(ListInsightsMetricDataResponse::timestamps))
            .setter(setter(Builder::timestamps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instant> builder(MarshallingType.INSTANT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> VALUES_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(ListInsightsMetricDataResponse::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInsightsMetricDataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_FIELD,
            EVENT_NAME_FIELD, INSIGHT_TYPE_FIELD, ERROR_CODE_FIELD, TIMESTAMPS_FIELD, VALUES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eventSource;

    private final String eventName;

    private final String insightType;

    private final String errorCode;

    private final List<Instant> timestamps;

    private final List<Double> values;

    private final String nextToken;

    private ListInsightsMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.eventSource = builder.eventSource;
        this.eventName = builder.eventName;
        this.insightType = builder.insightType;
        this.errorCode = builder.errorCode;
        this.timestamps = builder.timestamps;
        this.values = builder.values;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code> or
     * <code>s3.amazonaws.com</code>.
     * </p>
     * 
     * @return The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code> or
     *         <code>s3.amazonaws.com</code>.
     */
    public final String eventSource() {
        return eventSource;
    }

    /**
     * <p>
     * The name of the event, typically the Amazon Web Services API on which unusual levels of activity were recorded.
     * </p>
     * 
     * @return The name of the event, typically the Amazon Web Services API on which unusual levels of activity were
     *         recorded.
     */
    public final String eventName() {
        return eventName;
    }

    /**
     * <p>
     * The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
     * <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
     * management API calls that are aggregated per minute against a baseline API call volume. The
     * <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #insightType} will
     * return {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #insightTypeAsString}.
     * </p>
     * 
     * @return The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
     *         <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
     *         management API calls that are aggregated per minute against a baseline API call volume. The
     *         <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
     * @see InsightType
     */
    public final InsightType insightType() {
        return InsightType.fromValue(insightType);
    }

    /**
     * <p>
     * The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
     * <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
     * management API calls that are aggregated per minute against a baseline API call volume. The
     * <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #insightType} will
     * return {@link InsightType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #insightTypeAsString}.
     * </p>
     * 
     * @return The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
     *         <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
     *         management API calls that are aggregated per minute against a baseline API call volume. The
     *         <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
     * @see InsightType
     */
    public final String insightTypeAsString() {
        return insightType;
    }

    /**
     * <p>
     * Only returned if <code>InsightType</code> parameter was set to <code>ApiErrorRateInsight</code>.
     * </p>
     * <p>
     * If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to retrieve data
     * for. For example, <code>AccessDenied</code>.
     * </p>
     * 
     * @return Only returned if <code>InsightType</code> parameter was set to <code>ApiErrorRateInsight</code>.</p>
     *         <p>
     *         If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to
     *         retrieve data for. For example, <code>AccessDenied</code>.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Timestamps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTimestamps() {
        return timestamps != null && !(timestamps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of timestamps at intervals corresponding to the specified time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimestamps} method.
     * </p>
     * 
     * @return List of timestamps at intervals corresponding to the specified time period.
     */
    public final List<Instant> timestamps() {
        return timestamps;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of values representing the API call rate or error rate at each timestamp. The number of values is equal to
     * the number of timestamps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return List of values representing the API call rate or error rate at each timestamp. The number of values is
     *         equal to the number of timestamps.
     */
    public final List<Double> values() {
        return values;
    }

    /**
     * <p>
     * Only returned if the full results could not be returned in a single query. You can set the <code>NextToken</code>
     * parameter in the next request to this value to continue retrieval.
     * </p>
     * 
     * @return Only returned if the full results could not be returned in a single query. You can set the
     *         <code>NextToken</code> parameter in the next request to this value to continue retrieval.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(eventName());
        hashCode = 31 * hashCode + Objects.hashCode(insightTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimestamps() ? timestamps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsMetricDataResponse)) {
            return false;
        }
        ListInsightsMetricDataResponse other = (ListInsightsMetricDataResponse) obj;
        return Objects.equals(eventSource(), other.eventSource()) && Objects.equals(eventName(), other.eventName())
                && Objects.equals(insightTypeAsString(), other.insightTypeAsString())
                && Objects.equals(errorCode(), other.errorCode()) && hasTimestamps() == other.hasTimestamps()
                && Objects.equals(timestamps(), other.timestamps()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInsightsMetricDataResponse").add("EventSource", eventSource()).add("EventName", eventName())
                .add("InsightType", insightTypeAsString()).add("ErrorCode", errorCode())
                .add("Timestamps", hasTimestamps() ? timestamps() : null).add("Values", hasValues() ? values() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventSource":
            return Optional.ofNullable(clazz.cast(eventSource()));
        case "EventName":
            return Optional.ofNullable(clazz.cast(eventName()));
        case "InsightType":
            return Optional.ofNullable(clazz.cast(insightTypeAsString()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "Timestamps":
            return Optional.ofNullable(clazz.cast(timestamps()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventSource", EVENT_SOURCE_FIELD);
        map.put("EventName", EVENT_NAME_FIELD);
        map.put("InsightType", INSIGHT_TYPE_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("Timestamps", TIMESTAMPS_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsMetricDataResponse, T> g) {
        return obj -> g.apply((ListInsightsMetricDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInsightsMetricDataResponse> {
        /**
         * <p>
         * The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code> or
         * <code>s3.amazonaws.com</code>.
         * </p>
         * 
         * @param eventSource
         *        The Amazon Web Services service to which the request was made, such as <code>iam.amazonaws.com</code>
         *        or <code>s3.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSource(String eventSource);

        /**
         * <p>
         * The name of the event, typically the Amazon Web Services API on which unusual levels of activity were
         * recorded.
         * </p>
         * 
         * @param eventName
         *        The name of the event, typically the Amazon Web Services API on which unusual levels of activity were
         *        recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventName(String eventName);

        /**
         * <p>
         * The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
         * <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
         * management API calls that are aggregated per minute against a baseline API call volume. The
         * <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
         * </p>
         * 
         * @param insightType
         *        The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
         *        <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes
         *        write-only management API calls that are aggregated per minute against a baseline API call volume. The
         *        <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
         *        codes.
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder insightType(String insightType);

        /**
         * <p>
         * The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
         * <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes write-only
         * management API calls that are aggregated per minute against a baseline API call volume. The
         * <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes.
         * </p>
         * 
         * @param insightType
         *        The type of CloudTrail Insights event, which is either <code>ApiCallRateInsight</code> or
         *        <code>ApiErrorRateInsight</code>. The <code>ApiCallRateInsight</code> Insights type analyzes
         *        write-only management API calls that are aggregated per minute against a baseline API call volume. The
         *        <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error
         *        codes.
         * @see InsightType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightType
         */
        Builder insightType(InsightType insightType);

        /**
         * <p>
         * Only returned if <code>InsightType</code> parameter was set to <code>ApiErrorRateInsight</code>.
         * </p>
         * <p>
         * If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to retrieve
         * data for. For example, <code>AccessDenied</code>.
         * </p>
         * 
         * @param errorCode
         *        Only returned if <code>InsightType</code> parameter was set to <code>ApiErrorRateInsight</code>.</p>
         *        <p>
         *        If returning metrics for the <code>ApiErrorRateInsight</code> Insights type, this is the error to
         *        retrieve data for. For example, <code>AccessDenied</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * List of timestamps at intervals corresponding to the specified time period.
         * </p>
         * 
         * @param timestamps
         *        List of timestamps at intervals corresponding to the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamps(Collection<Instant> timestamps);

        /**
         * <p>
         * List of timestamps at intervals corresponding to the specified time period.
         * </p>
         * 
         * @param timestamps
         *        List of timestamps at intervals corresponding to the specified time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamps(Instant... timestamps);

        /**
         * <p>
         * List of values representing the API call rate or error rate at each timestamp. The number of values is equal
         * to the number of timestamps.
         * </p>
         * 
         * @param values
         *        List of values representing the API call rate or error rate at each timestamp. The number of values is
         *        equal to the number of timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<Double> values);

        /**
         * <p>
         * List of values representing the API call rate or error rate at each timestamp. The number of values is equal
         * to the number of timestamps.
         * </p>
         * 
         * @param values
         *        List of values representing the API call rate or error rate at each timestamp. The number of values is
         *        equal to the number of timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Double... values);

        /**
         * <p>
         * Only returned if the full results could not be returned in a single query. You can set the
         * <code>NextToken</code> parameter in the next request to this value to continue retrieval.
         * </p>
         * 
         * @param nextToken
         *        Only returned if the full results could not be returned in a single query. You can set the
         *        <code>NextToken</code> parameter in the next request to this value to continue retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String eventSource;

        private String eventName;

        private String insightType;

        private String errorCode;

        private List<Instant> timestamps = DefaultSdkAutoConstructList.getInstance();

        private List<Double> values = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsMetricDataResponse model) {
            super(model);
            eventSource(model.eventSource);
            eventName(model.eventName);
            insightType(model.insightType);
            errorCode(model.errorCode);
            timestamps(model.timestamps);
            values(model.values);
            nextToken(model.nextToken);
        }

        public final String getEventSource() {
            return eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final String getEventName() {
            return eventName;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final String getInsightType() {
            return insightType;
        }

        public final void setInsightType(String insightType) {
            this.insightType = insightType;
        }

        @Override
        public final Builder insightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        @Override
        public final Builder insightType(InsightType insightType) {
            this.insightType(insightType == null ? null : insightType.toString());
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final Collection<Instant> getTimestamps() {
            if (timestamps instanceof SdkAutoConstructList) {
                return null;
            }
            return timestamps;
        }

        public final void setTimestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
        }

        @Override
        public final Builder timestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Instant... timestamps) {
            timestamps(Arrays.asList(timestamps));
            return this;
        }

        public final Collection<Double> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<Double> values) {
            this.values = InsightsMetricValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<Double> values) {
            this.values = InsightsMetricValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Double... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInsightsMetricDataResponse build() {
            return new ListInsightsMetricDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
