/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A table showing information about the most recent successful and failed attempts to ingest events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestionStatus implements SdkPojo, Serializable, ToCopyableBuilder<IngestionStatus.Builder, IngestionStatus> {
    private static final SdkField<Instant> LATEST_INGESTION_SUCCESS_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestIngestionSuccessTime")
            .getter(getter(IngestionStatus::latestIngestionSuccessTime))
            .setter(setter(Builder::latestIngestionSuccessTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionSuccessTime").build())
            .build();

    private static final SdkField<String> LATEST_INGESTION_SUCCESS_EVENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestIngestionSuccessEventID")
            .getter(getter(IngestionStatus::latestIngestionSuccessEventID))
            .setter(setter(Builder::latestIngestionSuccessEventID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionSuccessEventID")
                    .build()).build();

    private static final SdkField<String> LATEST_INGESTION_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestIngestionErrorCode").getter(getter(IngestionStatus::latestIngestionErrorCode))
            .setter(setter(Builder::latestIngestionErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionErrorCode").build())
            .build();

    private static final SdkField<Instant> LATEST_INGESTION_ATTEMPT_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestIngestionAttemptTime")
            .getter(getter(IngestionStatus::latestIngestionAttemptTime))
            .setter(setter(Builder::latestIngestionAttemptTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionAttemptTime").build())
            .build();

    private static final SdkField<String> LATEST_INGESTION_ATTEMPT_EVENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestIngestionAttemptEventID")
            .getter(getter(IngestionStatus::latestIngestionAttemptEventID))
            .setter(setter(Builder::latestIngestionAttemptEventID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionAttemptEventID")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LATEST_INGESTION_SUCCESS_TIME_FIELD, LATEST_INGESTION_SUCCESS_EVENT_ID_FIELD, LATEST_INGESTION_ERROR_CODE_FIELD,
            LATEST_INGESTION_ATTEMPT_TIME_FIELD, LATEST_INGESTION_ATTEMPT_EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant latestIngestionSuccessTime;

    private final String latestIngestionSuccessEventID;

    private final String latestIngestionErrorCode;

    private final Instant latestIngestionAttemptTime;

    private final String latestIngestionAttemptEventID;

    private IngestionStatus(BuilderImpl builder) {
        this.latestIngestionSuccessTime = builder.latestIngestionSuccessTime;
        this.latestIngestionSuccessEventID = builder.latestIngestionSuccessEventID;
        this.latestIngestionErrorCode = builder.latestIngestionErrorCode;
        this.latestIngestionAttemptTime = builder.latestIngestionAttemptTime;
        this.latestIngestionAttemptEventID = builder.latestIngestionAttemptEventID;
    }

    /**
     * <p>
     * The time stamp of the most recent successful ingestion of events for the channel.
     * </p>
     * 
     * @return The time stamp of the most recent successful ingestion of events for the channel.
     */
    public final Instant latestIngestionSuccessTime() {
        return latestIngestionSuccessTime;
    }

    /**
     * <p>
     * The event ID of the most recent successful ingestion of events.
     * </p>
     * 
     * @return The event ID of the most recent successful ingestion of events.
     */
    public final String latestIngestionSuccessEventID() {
        return latestIngestionSuccessEventID;
    }

    /**
     * <p>
     * The error code for the most recent failure to ingest events.
     * </p>
     * 
     * @return The error code for the most recent failure to ingest events.
     */
    public final String latestIngestionErrorCode() {
        return latestIngestionErrorCode;
    }

    /**
     * <p>
     * The time stamp of the most recent attempt to ingest events on the channel.
     * </p>
     * 
     * @return The time stamp of the most recent attempt to ingest events on the channel.
     */
    public final Instant latestIngestionAttemptTime() {
        return latestIngestionAttemptTime;
    }

    /**
     * <p>
     * The event ID of the most recent attempt to ingest events.
     * </p>
     * 
     * @return The event ID of the most recent attempt to ingest events.
     */
    public final String latestIngestionAttemptEventID() {
        return latestIngestionAttemptEventID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latestIngestionSuccessTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestIngestionSuccessEventID());
        hashCode = 31 * hashCode + Objects.hashCode(latestIngestionErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(latestIngestionAttemptTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestIngestionAttemptEventID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionStatus)) {
            return false;
        }
        IngestionStatus other = (IngestionStatus) obj;
        return Objects.equals(latestIngestionSuccessTime(), other.latestIngestionSuccessTime())
                && Objects.equals(latestIngestionSuccessEventID(), other.latestIngestionSuccessEventID())
                && Objects.equals(latestIngestionErrorCode(), other.latestIngestionErrorCode())
                && Objects.equals(latestIngestionAttemptTime(), other.latestIngestionAttemptTime())
                && Objects.equals(latestIngestionAttemptEventID(), other.latestIngestionAttemptEventID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestionStatus").add("LatestIngestionSuccessTime", latestIngestionSuccessTime())
                .add("LatestIngestionSuccessEventID", latestIngestionSuccessEventID())
                .add("LatestIngestionErrorCode", latestIngestionErrorCode())
                .add("LatestIngestionAttemptTime", latestIngestionAttemptTime())
                .add("LatestIngestionAttemptEventID", latestIngestionAttemptEventID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LatestIngestionSuccessTime":
            return Optional.ofNullable(clazz.cast(latestIngestionSuccessTime()));
        case "LatestIngestionSuccessEventID":
            return Optional.ofNullable(clazz.cast(latestIngestionSuccessEventID()));
        case "LatestIngestionErrorCode":
            return Optional.ofNullable(clazz.cast(latestIngestionErrorCode()));
        case "LatestIngestionAttemptTime":
            return Optional.ofNullable(clazz.cast(latestIngestionAttemptTime()));
        case "LatestIngestionAttemptEventID":
            return Optional.ofNullable(clazz.cast(latestIngestionAttemptEventID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LatestIngestionSuccessTime", LATEST_INGESTION_SUCCESS_TIME_FIELD);
        map.put("LatestIngestionSuccessEventID", LATEST_INGESTION_SUCCESS_EVENT_ID_FIELD);
        map.put("LatestIngestionErrorCode", LATEST_INGESTION_ERROR_CODE_FIELD);
        map.put("LatestIngestionAttemptTime", LATEST_INGESTION_ATTEMPT_TIME_FIELD);
        map.put("LatestIngestionAttemptEventID", LATEST_INGESTION_ATTEMPT_EVENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestionStatus, T> g) {
        return obj -> g.apply((IngestionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestionStatus> {
        /**
         * <p>
         * The time stamp of the most recent successful ingestion of events for the channel.
         * </p>
         * 
         * @param latestIngestionSuccessTime
         *        The time stamp of the most recent successful ingestion of events for the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestIngestionSuccessTime(Instant latestIngestionSuccessTime);

        /**
         * <p>
         * The event ID of the most recent successful ingestion of events.
         * </p>
         * 
         * @param latestIngestionSuccessEventID
         *        The event ID of the most recent successful ingestion of events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestIngestionSuccessEventID(String latestIngestionSuccessEventID);

        /**
         * <p>
         * The error code for the most recent failure to ingest events.
         * </p>
         * 
         * @param latestIngestionErrorCode
         *        The error code for the most recent failure to ingest events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestIngestionErrorCode(String latestIngestionErrorCode);

        /**
         * <p>
         * The time stamp of the most recent attempt to ingest events on the channel.
         * </p>
         * 
         * @param latestIngestionAttemptTime
         *        The time stamp of the most recent attempt to ingest events on the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestIngestionAttemptTime(Instant latestIngestionAttemptTime);

        /**
         * <p>
         * The event ID of the most recent attempt to ingest events.
         * </p>
         * 
         * @param latestIngestionAttemptEventID
         *        The event ID of the most recent attempt to ingest events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestIngestionAttemptEventID(String latestIngestionAttemptEventID);
    }

    static final class BuilderImpl implements Builder {
        private Instant latestIngestionSuccessTime;

        private String latestIngestionSuccessEventID;

        private String latestIngestionErrorCode;

        private Instant latestIngestionAttemptTime;

        private String latestIngestionAttemptEventID;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionStatus model) {
            latestIngestionSuccessTime(model.latestIngestionSuccessTime);
            latestIngestionSuccessEventID(model.latestIngestionSuccessEventID);
            latestIngestionErrorCode(model.latestIngestionErrorCode);
            latestIngestionAttemptTime(model.latestIngestionAttemptTime);
            latestIngestionAttemptEventID(model.latestIngestionAttemptEventID);
        }

        public final Instant getLatestIngestionSuccessTime() {
            return latestIngestionSuccessTime;
        }

        public final void setLatestIngestionSuccessTime(Instant latestIngestionSuccessTime) {
            this.latestIngestionSuccessTime = latestIngestionSuccessTime;
        }

        @Override
        public final Builder latestIngestionSuccessTime(Instant latestIngestionSuccessTime) {
            this.latestIngestionSuccessTime = latestIngestionSuccessTime;
            return this;
        }

        public final String getLatestIngestionSuccessEventID() {
            return latestIngestionSuccessEventID;
        }

        public final void setLatestIngestionSuccessEventID(String latestIngestionSuccessEventID) {
            this.latestIngestionSuccessEventID = latestIngestionSuccessEventID;
        }

        @Override
        public final Builder latestIngestionSuccessEventID(String latestIngestionSuccessEventID) {
            this.latestIngestionSuccessEventID = latestIngestionSuccessEventID;
            return this;
        }

        public final String getLatestIngestionErrorCode() {
            return latestIngestionErrorCode;
        }

        public final void setLatestIngestionErrorCode(String latestIngestionErrorCode) {
            this.latestIngestionErrorCode = latestIngestionErrorCode;
        }

        @Override
        public final Builder latestIngestionErrorCode(String latestIngestionErrorCode) {
            this.latestIngestionErrorCode = latestIngestionErrorCode;
            return this;
        }

        public final Instant getLatestIngestionAttemptTime() {
            return latestIngestionAttemptTime;
        }

        public final void setLatestIngestionAttemptTime(Instant latestIngestionAttemptTime) {
            this.latestIngestionAttemptTime = latestIngestionAttemptTime;
        }

        @Override
        public final Builder latestIngestionAttemptTime(Instant latestIngestionAttemptTime) {
            this.latestIngestionAttemptTime = latestIngestionAttemptTime;
            return this;
        }

        public final String getLatestIngestionAttemptEventID() {
            return latestIngestionAttemptEventID;
        }

        public final void setLatestIngestionAttemptEventID(String latestIngestionAttemptEventID) {
            this.latestIngestionAttemptEventID = latestIngestionAttemptEventID;
        }

        @Override
        public final Builder latestIngestionAttemptEventID(String latestIngestionAttemptEventID) {
            this.latestIngestionAttemptEventID = latestIngestionAttemptEventID;
            return this;
        }

        @Override
        public IngestionStatus build() {
            return new IngestionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
