/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDashboardResponse extends CloudTrailResponse implements
        ToCopyableBuilder<CreateDashboardResponse.Builder, CreateDashboardResponse> {
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardArn").getter(getter(CreateDashboardResponse::dashboardArn))
            .setter(setter(Builder::dashboardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDashboardResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateDashboardResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<Widget>> WIDGETS_FIELD = SdkField
            .<List<Widget>> builder(MarshallingType.LIST)
            .memberName("Widgets")
            .getter(getter(CreateDashboardResponse::widgets))
            .setter(setter(Builder::widgets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Widgets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Widget> builder(MarshallingType.SDK_POJO)
                                            .constructor(Widget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagsList")
            .getter(getter(CreateDashboardResponse::tagsList))
            .setter(setter(Builder::tagsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RefreshSchedule> REFRESH_SCHEDULE_FIELD = SdkField
            .<RefreshSchedule> builder(MarshallingType.SDK_POJO).memberName("RefreshSchedule")
            .getter(getter(CreateDashboardResponse::refreshSchedule)).setter(setter(Builder::refreshSchedule))
            .constructor(RefreshSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RefreshSchedule").build()).build();

    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtectionEnabled")
            .getter(getter(CreateDashboardResponse::terminationProtectionEnabled))
            .setter(setter(Builder::terminationProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DASHBOARD_ARN_FIELD, NAME_FIELD, TYPE_FIELD, WIDGETS_FIELD, TAGS_LIST_FIELD,
                    REFRESH_SCHEDULE_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dashboardArn;

    private final String name;

    private final String type;

    private final List<Widget> widgets;

    private final List<Tag> tagsList;

    private final RefreshSchedule refreshSchedule;

    private final Boolean terminationProtectionEnabled;

    private CreateDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.name = builder.name;
        this.type = builder.type;
        this.widgets = builder.widgets;
        this.tagsList = builder.tagsList;
        this.refreshSchedule = builder.refreshSchedule;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
    }

    /**
     * <p>
     * The ARN for the dashboard.
     * </p>
     * 
     * @return The ARN for the dashboard.
     */
    public final String dashboardArn() {
        return dashboardArn;
    }

    /**
     * <p>
     * The name of the dashboard.
     * </p>
     * 
     * @return The name of the dashboard.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The dashboard type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The dashboard type.
     * @see DashboardType
     */
    public final DashboardType type() {
        return DashboardType.fromValue(type);
    }

    /**
     * <p>
     * The dashboard type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The dashboard type.
     * @see DashboardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Widgets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWidgets() {
        return widgets != null && !(widgets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of widgets for the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWidgets} method.
     * </p>
     * 
     * @return An array of widgets for the dashboard.
     */
    public final List<Widget> widgets() {
        return widgets;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagsList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagsList() {
        return tagsList != null && !(tagsList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagsList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagsList} method.
     * </p>
     * 
     * @return The value of the TagsList property for this object.
     */
    public final List<Tag> tagsList() {
        return tagsList;
    }

    /**
     * <p>
     * The refresh schedule for the dashboard, if configured.
     * </p>
     * 
     * @return The refresh schedule for the dashboard, if configured.
     */
    public final RefreshSchedule refreshSchedule() {
        return refreshSchedule;
    }

    /**
     * <p>
     * Indicates whether termination protection is enabled for the dashboard.
     * </p>
     * 
     * @return Indicates whether termination protection is enabled for the dashboard.
     */
    public final Boolean terminationProtectionEnabled() {
        return terminationProtectionEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasWidgets() ? widgets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagsList() ? tagsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(refreshSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtectionEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardResponse)) {
            return false;
        }
        CreateDashboardResponse other = (CreateDashboardResponse) obj;
        return Objects.equals(dashboardArn(), other.dashboardArn()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasWidgets() == other.hasWidgets()
                && Objects.equals(widgets(), other.widgets()) && hasTagsList() == other.hasTagsList()
                && Objects.equals(tagsList(), other.tagsList()) && Objects.equals(refreshSchedule(), other.refreshSchedule())
                && Objects.equals(terminationProtectionEnabled(), other.terminationProtectionEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDashboardResponse").add("DashboardArn", dashboardArn()).add("Name", name())
                .add("Type", typeAsString()).add("Widgets", hasWidgets() ? widgets() : null)
                .add("TagsList", hasTagsList() ? tagsList() : null).add("RefreshSchedule", refreshSchedule())
                .add("TerminationProtectionEnabled", terminationProtectionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardArn":
            return Optional.ofNullable(clazz.cast(dashboardArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Widgets":
            return Optional.ofNullable(clazz.cast(widgets()));
        case "TagsList":
            return Optional.ofNullable(clazz.cast(tagsList()));
        case "RefreshSchedule":
            return Optional.ofNullable(clazz.cast(refreshSchedule()));
        case "TerminationProtectionEnabled":
            return Optional.ofNullable(clazz.cast(terminationProtectionEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DashboardArn", DASHBOARD_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Widgets", WIDGETS_FIELD);
        map.put("TagsList", TAGS_LIST_FIELD);
        map.put("RefreshSchedule", REFRESH_SCHEDULE_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDashboardResponse, T> g) {
        return obj -> g.apply((CreateDashboardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDashboardResponse> {
        /**
         * <p>
         * The ARN for the dashboard.
         * </p>
         * 
         * @param dashboardArn
         *        The ARN for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardArn(String dashboardArn);

        /**
         * <p>
         * The name of the dashboard.
         * </p>
         * 
         * @param name
         *        The name of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The dashboard type.
         * </p>
         * 
         * @param type
         *        The dashboard type.
         * @see DashboardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardType
         */
        Builder type(String type);

        /**
         * <p>
         * The dashboard type.
         * </p>
         * 
         * @param type
         *        The dashboard type.
         * @see DashboardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardType
         */
        Builder type(DashboardType type);

        /**
         * <p>
         * An array of widgets for the dashboard.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(Collection<Widget> widgets);

        /**
         * <p>
         * An array of widgets for the dashboard.
         * </p>
         * 
         * @param widgets
         *        An array of widgets for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widgets(Widget... widgets);

        /**
         * <p>
         * An array of widgets for the dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.Widget.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudtrail.model.Widget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.Widget.Builder#build()} is called immediately and its
         * result is passed to {@link #widgets(List<Widget>)}.
         * 
         * @param widgets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.Widget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #widgets(java.util.Collection<Widget>)
         */
        Builder widgets(Consumer<Widget.Builder>... widgets);

        /**
         * Sets the value of the TagsList property for this object.
         *
         * @param tagsList
         *        The new value for the TagsList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsList(Collection<Tag> tagsList);

        /**
         * Sets the value of the TagsList property for this object.
         *
         * @param tagsList
         *        The new value for the TagsList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsList(Tag... tagsList);

        /**
         * Sets the value of the TagsList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.cloudtrail.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tagsList(List<Tag>)}.
         * 
         * @param tagsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagsList(java.util.Collection<Tag>)
         */
        Builder tagsList(Consumer<Tag.Builder>... tagsList);

        /**
         * <p>
         * The refresh schedule for the dashboard, if configured.
         * </p>
         * 
         * @param refreshSchedule
         *        The refresh schedule for the dashboard, if configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshSchedule(RefreshSchedule refreshSchedule);

        /**
         * <p>
         * The refresh schedule for the dashboard, if configured.
         * </p>
         * This is a convenience method that creates an instance of the {@link RefreshSchedule.Builder} avoiding the
         * need to create one manually via {@link RefreshSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RefreshSchedule.Builder#build()} is called immediately and its
         * result is passed to {@link #refreshSchedule(RefreshSchedule)}.
         * 
         * @param refreshSchedule
         *        a consumer that will call methods on {@link RefreshSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #refreshSchedule(RefreshSchedule)
         */
        default Builder refreshSchedule(Consumer<RefreshSchedule.Builder> refreshSchedule) {
            return refreshSchedule(RefreshSchedule.builder().applyMutation(refreshSchedule).build());
        }

        /**
         * <p>
         * Indicates whether termination protection is enabled for the dashboard.
         * </p>
         * 
         * @param terminationProtectionEnabled
         *        Indicates whether termination protection is enabled for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String dashboardArn;

        private String name;

        private String type;

        private List<Widget> widgets = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tagsList = DefaultSdkAutoConstructList.getInstance();

        private RefreshSchedule refreshSchedule;

        private Boolean terminationProtectionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashboardResponse model) {
            super(model);
            dashboardArn(model.dashboardArn);
            name(model.name);
            type(model.type);
            widgets(model.widgets);
            tagsList(model.tagsList);
            refreshSchedule(model.refreshSchedule);
            terminationProtectionEnabled(model.terminationProtectionEnabled);
        }

        public final String getDashboardArn() {
            return dashboardArn;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DashboardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<Widget.Builder> getWidgets() {
            List<Widget.Builder> result = WidgetListCopier.copyToBuilder(this.widgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWidgets(Collection<Widget.BuilderImpl> widgets) {
            this.widgets = WidgetListCopier.copyFromBuilder(widgets);
        }

        @Override
        public final Builder widgets(Collection<Widget> widgets) {
            this.widgets = WidgetListCopier.copy(widgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Widget... widgets) {
            widgets(Arrays.asList(widgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder widgets(Consumer<Widget.Builder>... widgets) {
            widgets(Stream.of(widgets).map(c -> Widget.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTagsList() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tagsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagsList(Collection<Tag.BuilderImpl> tagsList) {
            this.tagsList = TagsListCopier.copyFromBuilder(tagsList);
        }

        @Override
        public final Builder tagsList(Collection<Tag> tagsList) {
            this.tagsList = TagsListCopier.copy(tagsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Tag... tagsList) {
            tagsList(Arrays.asList(tagsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Consumer<Tag.Builder>... tagsList) {
            tagsList(Stream.of(tagsList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RefreshSchedule.Builder getRefreshSchedule() {
            return refreshSchedule != null ? refreshSchedule.toBuilder() : null;
        }

        public final void setRefreshSchedule(RefreshSchedule.BuilderImpl refreshSchedule) {
            this.refreshSchedule = refreshSchedule != null ? refreshSchedule.build() : null;
        }

        @Override
        public final Builder refreshSchedule(RefreshSchedule refreshSchedule) {
            this.refreshSchedule = refreshSchedule;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        @Override
        public CreateDashboardResponse build() {
            return new CreateDashboardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
