/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudtrail.internal.CloudTrailServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudtrail.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.cloudtrail.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudtrail.model.AccountHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AccountRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.CannotDelegateManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelExistsForEdsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailAccessNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailInvalidClientTokenIdException;
import software.amazon.awssdk.services.cloudtrail.model.CloudWatchLogsDeliveryUnavailableException;
import software.amazon.awssdk.services.cloudtrail.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudtrail.model.ConflictException;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DelegatedAdminAccountLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreFederationEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreTerminationProtectedException;
import software.amazon.awssdk.services.cloudtrail.model.GenerateQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.GenerateQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.GenerateResponseException;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventConfigurationRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventConfigurationResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusResponse;
import software.amazon.awssdk.services.cloudtrail.model.ImportNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveEventDataStoreException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveQueryException;
import software.amazon.awssdk.services.cloudtrail.model.InsightNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientDependencyServiceAccessPermissionException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientEncryptionPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientIamAccessPermissionException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientSnsTopicPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsLogGroupArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsRoleArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidDateRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidHomeRegionException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidImportSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidInsightSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidKmsKeyIdException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidLookupAttributesException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatementException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3PrefixException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSnsTopicNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTagParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTrailNameException;
import software.amazon.awssdk.services.cloudtrail.model.KmsException;
import software.amazon.awssdk.services.cloudtrail.model.KmsKeyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;
import software.amazon.awssdk.services.cloudtrail.model.MaxConcurrentQueriesException;
import software.amazon.awssdk.services.cloudtrail.model.MaximumNumberOfTrailsExceededException;
import software.amazon.awssdk.services.cloudtrail.model.NoManagementAccountSlrExistsException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationMasterAccountException;
import software.amazon.awssdk.services.cloudtrail.model.OperationNotPermittedException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationsNotInUseException;
import software.amazon.awssdk.services.cloudtrail.model.PutEventConfigurationRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventConfigurationResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.QueryIdNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ResourceArnNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.S3BucketDoesNotExistException;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cloudtrail.model.StartDashboardRefreshRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartDashboardRefreshResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.TagsLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ThrottlingException;
import software.amazon.awssdk.services.cloudtrail.model.TrailAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotProvidedException;
import software.amazon.awssdk.services.cloudtrail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CancelQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeregisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DisableFederationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.EnableFederationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GenerateQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListEventDataStoresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportFailuresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListInsightsMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.LookupEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutEventConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RegisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RestoreEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.SearchSampleQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartDashboardRefreshRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateTrailRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link CloudTrailClient}.
 *
 * @see CloudTrailClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudTrailClient implements CloudTrailClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudTrailClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudTrailClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "CloudTrail" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds one or more tags to a trail, event data store, dashboard, or channel, up to a limit of 50. Overwrites an
     * existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique; you
     * cannot have two keys with the same name but different values. If you specify a key without a value, the tag will
     * be created with the specified key and a value of null. You can tag a trail or event data store that applies to
     * all Amazon Web Services Regions only from the Region in which the trail or event data store was created (also
     * known as its home Region).
     * </p>
     *
     * @param addTagsRequest
     *        Specifies the tags to add to a trail, event data store, dashboard, or channel.
     * @return Result of the AddTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the specified resource is not found.
     * @throws CloudTrailArnInvalidException
     *         This exception is thrown when an operation is called with an ARN that is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws ChannelArnInvalidException
     *         This exception is thrown when the specified value of <code>ChannelARN</code> is not valid.
     * @throws ResourceTypeNotSupportedException
     *         This exception is thrown when the specified resource type is not supported by CloudTrail.
     * @throws TagsLimitExceededException
     *         The number of tags per trail, event data store, dashboard, or channel has exceeded the permitted amount.
     *         Currently, the limit is 50.
     * @throws InvalidTrailNameException
     *         This exception is thrown when the provided trail name is not valid. Trail names must meet the following
     *         requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     * @throws InvalidTagParameterException
     *         This exception is thrown when the specified tag key or values are not valid. It can also occur if there
     *         are duplicate tags or too many tags on the resource.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws ChannelNotFoundException
     *         This exception is thrown when CloudTrail cannot find the specified channel.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws NotOrganizationMasterAccountException
     *         This exception is thrown when the Amazon Web Services account making the request to create or update an
     *         organization trail or event data store is not the management account for an organization in
     *         Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws ResourceNotFoundException,
            CloudTrailArnInvalidException, EventDataStoreArnInvalidException, ChannelArnInvalidException,
            ResourceTypeNotSupportedException, TagsLimitExceededException, InvalidTrailNameException,
            InvalidTagParameterException, InactiveEventDataStoreException, EventDataStoreNotFoundException,
            ChannelNotFoundException, UnsupportedOperationException, OperationNotPermittedException,
            NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, ConflictException, AwsServiceException,
            SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");

            return clientHandler.execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>()
                    .withOperationName("AddTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(addTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a query if the query is not in a terminated state, such as <code>CANCELLED</code>, <code>FAILED</code>,
     * <code>TIMED_OUT</code>, or <code>FINISHED</code>. You must specify an ARN value for <code>EventDataStore</code>.
     * The ID of the query that you want to cancel is also required. When you run <code>CancelQuery</code>, the query
     * status might show as <code>CANCELLED</code> even if the operation is not yet finished.
     * </p>
     *
     * @param cancelQueryRequest
     * @return Result of the CancelQuery operation returned by the service.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws InactiveQueryException
     *         The specified query cannot be canceled because it is in the <code>FINISHED</code>, <code>FAILED</code>,
     *         <code>TIMED_OUT</code>, or <code>CANCELLED</code> state.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws QueryIdNotFoundException
     *         The query ID does not exist or does not map to a query.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.CancelQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CancelQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelQueryResponse cancelQuery(CancelQueryRequest cancelQueryRequest) throws EventDataStoreArnInvalidException,
            EventDataStoreNotFoundException, InactiveEventDataStoreException, InactiveQueryException, InvalidParameterException,
            QueryIdNotFoundException, OperationNotPermittedException, UnsupportedOperationException,
            NoManagementAccountSlrExistsException, ConflictException, AwsServiceException, SdkClientException,
            CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelQuery");

            return clientHandler.execute(new ClientExecutionParams<CancelQueryRequest, CancelQueryResponse>()
                    .withOperationName("CancelQuery").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(cancelQueryRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a channel for CloudTrail to ingest events from a partner or external source. After you create a channel,
     * a CloudTrail Lake event data store can log events from the partner or source that you specify.
     * </p>
     *
     * @param createChannelRequest
     * @return Result of the CreateChannel operation returned by the service.
     * @throws ChannelMaxLimitExceededException
     *         This exception is thrown when the maximum number of channels limit is exceeded.
     * @throws InvalidSourceException
     *         This exception is thrown when the specified value of <code>Source</code> is not valid.
     * @throws ChannelAlreadyExistsException
     *         This exception is thrown when the provided channel already exists.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InvalidEventDataStoreCategoryException
     *         This exception is thrown when event categories of specified event data stores are not valid.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws InvalidTagParameterException
     *         This exception is thrown when the specified tag key or values are not valid. It can also occur if there
     *         are duplicate tags or too many tags on the resource.
     * @throws TagsLimitExceededException
     *         The number of tags per trail, event data store, dashboard, or channel has exceeded the permitted amount.
     *         Currently, the limit is 50.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.CreateChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest)
            throws ChannelMaxLimitExceededException, InvalidSourceException, ChannelAlreadyExistsException,
            EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventDataStoreCategoryException,
            InactiveEventDataStoreException, InvalidParameterException, InvalidTagParameterException, TagsLimitExceededException,
            OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateChannel");

            return clientHandler.execute(new ClientExecutionParams<CreateChannelRequest, CreateChannelResponse>()
                    .withOperationName("CreateChannel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom dashboard or the Highlights dashboard.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Custom dashboards</b> - Custom dashboards allow you to query events in any event data store type. You can add
     * up to 10 widgets to a custom dashboard. You can manually refresh a custom dashboard, or you can set a refresh
     * schedule.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Highlights dashboard</b> - You can create the Highlights dashboard to see a summary of key user activities and
     * API usage across all your event data stores. CloudTrail Lake manages the Highlights dashboard and refreshes the
     * dashboard every 6 hours. To create the Highlights dashboard, you must set and enable a refresh schedule.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CloudTrail runs queries to populate the dashboard's widgets during a manual or scheduled refresh. CloudTrail must
     * be granted permissions to run the <code>StartQuery</code> operation on your behalf. To provide permissions, run
     * the <code>PutResourcePolicy</code> operation to attach a resource-based policy to each event data store. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard"
     * >Example: Allow CloudTrail to run queries to populate a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * To set a refresh schedule, CloudTrail must be granted permissions to run the <code>StartDashboardRefresh</code>
     * operation to refresh the dashboard on your behalf. To provide permissions, run the <code>PutResourcePolicy</code>
     * operation to attach a resource-based policy to the dashboard. For more information, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards"
     * > Resource-based policy example for a dashboard</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     * <p>
     * For more information about dashboards, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-dashboard.html">CloudTrail Lake
     * dashboards</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param createDashboardRequest
     * @return Result of the CreateDashboard operation returned by the service.
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws InvalidTagParameterException
     *         This exception is thrown when the specified tag key or values are not valid. It can also occur if there
     *         are duplicate tags or too many tags on the resource.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws InsufficientEncryptionPolicyException
     *         For the <code>CreateTrail</code> <code>PutInsightSelectors</code>, <code>UpdateTrail</code>,
     *         <code>StartQuery</code>, and <code>StartImport</code> operations, this exception is thrown when the
     *         policy on the S3 bucket or KMS key does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.
     * @throws InvalidQueryStatementException
     *         The query that was submitted has validation errors, or uses incorrect syntax or unsupported keywords. For
     *         more information about writing a query, see <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-create-edit-query.html">Create or
     *         edit a query</a> in the <i>CloudTrail User Guide</i>.
     * @throws ServiceQuotaExceededException
     *         This exception is thrown when the quota is exceeded. For information about CloudTrail quotas, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ct.html#limits_cloudtrail">Service quotas</a> in the
     *         <i>Amazon Web Services General Reference</i>.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDashboardResponse createDashboard(CreateDashboardRequest createDashboardRequest) throws ConflictException,
            InvalidTagParameterException, EventDataStoreNotFoundException, InactiveEventDataStoreException,
            InsufficientEncryptionPolicyException, InvalidQueryStatementException, ServiceQuotaExceededException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDashboard");

            return clientHandler.execute(new ClientExecutionParams<CreateDashboardRequest, CreateDashboardResponse>()
                    .withOperationName("CreateDashboard").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new event data store.
     * </p>
     *
     * @param createEventDataStoreRequest
     * @return Result of the CreateEventDataStore operation returned by the service.
     * @throws EventDataStoreAlreadyExistsException
     *         An event data store with that name already exists.
     * @throws EventDataStoreMaxLimitExceededException
     *         Your account has used the maximum number of event data stores.
     * @throws InvalidEventSelectorsException
     *         This exception is thrown when the <code>PutEventSelectors</code> operation is called with a number of
     *         event selectors, advanced event selectors, or data resources that is not valid. The combination of event
     *         selectors or advanced event selectors and data resources is not valid. A trail can have up to 5 event
     *         selectors. If a trail uses advanced event selectors, a maximum of 500 total values for all conditions in
     *         all advanced event selectors is allowed. A trail is limited to 250 data resources. These data resources
     *         can be distributed across event selectors, but the overall total cannot exceed 250.</p>
     *         <p>
     *         You can:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Specify a valid number of event selectors (1 to 5) for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid number of data resources (1 to 250) for an event selector. The limit of number of
     *         resources on an individual event selector is configurable up to 250. However, this upper limit is allowed
     *         only if the total number of data resources does not exceed 250 across all event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify up to 500 values for all conditions in all advanced event selectors for a trail.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Specify a valid value for a parameter. For example, specifying the <code>ReadWriteType</code> parameter
     *         with a value of <code>read-only</code> is not valid.
     *         </p>
     *         </li>
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws InvalidTagParameterException
     *         This exception is thrown when the specified tag key or values are not valid. It can also occur if there
     *         are duplicate tags or too many tags on the resource.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws InsufficientEncryptionPolicyException
     *         For the <code>CreateTrail</code> <code>PutInsightSelectors</code>, <code>UpdateTrail</code>,
     *         <code>StartQuery</code>, and <code>StartImport</code> operations, this exception is thrown when the
     *         policy on the S3 bucket or KMS key does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.
     * @throws InvalidKmsKeyIdException
     *         This exception is thrown when the KMS key ARN is not valid.
     * @throws KmsKeyNotFoundException
     *         This exception is thrown when the KMS key does not exist, when the S3 bucket and the KMS key are not in
     *         the same Region, or when the KMS key associated with the Amazon SNS topic either does not exist or is not
     *         in the same Region.
     * @throws KmsException
     *         This exception is thrown when there is an issue with the specified KMS key and the trail or event data
     *         store can't be updated.
     * @throws CloudTrailAccessNotEnabledException
     *         This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.
     * @throws InsufficientDependencyServiceAccessPermissionException
     *         This exception is thrown when the IAM identity that is used to create the organization resource lacks one
     *         or more required permissions for creating an organization resource in a required service.
     * @throws NotOrganizationMasterAccountException
     *         This exception is thrown when the Amazon Web Services account making the request to create or update an
     *         organization trail or event data store is not the management account for an organization in
     *         Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.
     * @throws OrganizationsNotInUseException
     *         This exception is thrown when the request is made from an Amazon Web Services account that is not a
     *         member of an organization. To make this request, sign in using the credentials of an account that belongs
     *         to an organization.
     * @throws OrganizationNotInAllFeaturesModeException
     *         This exception is thrown when Organizations is not configured to support all features. All features must
     *         be enabled in Organizations to support creating an organization trail or event data store.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.CreateEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEventDataStoreResponse createEventDataStore(CreateEventDataStoreRequest createEventDataStoreRequest)
            throws EventDataStoreAlreadyExistsException, EventDataStoreMaxLimitExceededException, InvalidEventSelectorsException,
            InvalidParameterException, InvalidTagParameterException, OperationNotPermittedException,
            UnsupportedOperationException, ConflictException, InsufficientEncryptionPolicyException, InvalidKmsKeyIdException,
            KmsKeyNotFoundException, KmsException, CloudTrailAccessNotEnabledException,
            InsufficientDependencyServiceAccessPermissionException, NotOrganizationMasterAccountException,
            OrganizationsNotInUseException, OrganizationNotInAllFeaturesModeException, NoManagementAccountSlrExistsException,
            AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEventDataStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEventDataStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEventDataStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventDataStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventDataStore");

            return clientHandler.execute(new ClientExecutionParams<CreateEventDataStoreRequest, CreateEventDataStoreResponse>()
                    .withOperationName("CreateEventDataStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createEventDataStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEventDataStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
     * </p>
     *
     * @param createTrailRequest
     *        Specifies the settings for each trail.
     * @return Result of the CreateTrail operation returned by the service.
     * @throws MaximumNumberOfTrailsExceededException
     *         This exception is thrown when the maximum number of trails is reached.
     * @throws TrailAlreadyExistsException
     *         This exception is thrown when the specified trail already exists.
     * @throws S3BucketDoesNotExistException
     *         This exception is thrown when the specified S3 bucket does not exist.
     * @throws InsufficientS3BucketPolicyException
     *         This exception is thrown when the policy on the S3 bucket is not sufficient.
     * @throws InsufficientSnsTopicPolicyException
     *         This exception is thrown when the policy on the Amazon SNS topic is not sufficient.
     * @throws InsufficientEncryptionPolicyException
     *         For the <code>CreateTrail</code> <code>PutInsightSelectors</code>, <code>UpdateTrail</code>,
     *         <code>StartQuery</code>, and <code>StartImport</code> operations, this exception is thrown when the
     *         policy on the S3 bucket or KMS key does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.
     * @throws InvalidS3BucketNameException
     *         This exception is thrown when the provided S3 bucket name is not valid.
     * @throws InvalidS3PrefixException
     *         This exception is thrown when the provided S3 prefix is not valid.
     * @throws InvalidSnsTopicNameException
     *         This exception is thrown when the provided SNS topic name is not valid.
     * @throws InvalidKmsKeyIdException
     *         This exception is thrown when the KMS key ARN is not valid.
     * @throws InvalidTrailNameException
     *         This exception is thrown when the provided trail name is not valid. Trail names must meet the following
     *         requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     * @throws TrailNotProvidedException
     *         This exception is no longer in use.
     * @throws TagsLimitExceededException
     *         The number of tags per trail, event data store, dashboard, or channel has exceeded the permitted amount.
     *         Currently, the limit is 50.
     * @throws InvalidParameterCombinationException
     *         This exception is thrown when the combination of parameters provided is not valid.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws KmsKeyNotFoundException
     *         This exception is thrown when the KMS key does not exist, when the S3 bucket and the KMS key are not in
     *         the same Region, or when the KMS key associated with the Amazon SNS topic either does not exist or is not
     *         in the same Region.
     * @throws KmsException
     *         This exception is thrown when there is an issue with the specified KMS key and the trail or event data
     *         store can't be updated.
     * @throws InvalidCloudWatchLogsLogGroupArnException
     *         This exception is thrown when the provided CloudWatch Logs log group is not valid.
     * @throws InvalidCloudWatchLogsRoleArnException
     *         This exception is thrown when the provided role is not valid.
     * @throws CloudWatchLogsDeliveryUnavailableException
     *         Cannot set a CloudWatch Logs delivery for this Region.
     * @throws InvalidTagParameterException
     *         This exception is thrown when the specified tag key or values are not valid. It can also occur if there
     *         are duplicate tags or too many tags on the resource.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws CloudTrailAccessNotEnabledException
     *         This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.
     * @throws InsufficientDependencyServiceAccessPermissionException
     *         This exception is thrown when the IAM identity that is used to create the organization resource lacks one
     *         or more required permissions for creating an organization resource in a required service.
     * @throws NotOrganizationMasterAccountException
     *         This exception is thrown when the Amazon Web Services account making the request to create or update an
     *         organization trail or event data store is not the management account for an organization in
     *         Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.
     * @throws OrganizationsNotInUseException
     *         This exception is thrown when the request is made from an Amazon Web Services account that is not a
     *         member of an organization. To make this request, sign in using the credentials of an account that belongs
     *         to an organization.
     * @throws OrganizationNotInAllFeaturesModeException
     *         This exception is thrown when Organizations is not configured to support all features. All features must
     *         be enabled in Organizations to support creating an organization trail or event data store.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws CloudTrailInvalidClientTokenIdException
     *         This exception is thrown when a call results in the <code>InvalidClientTokenId</code> error code. This
     *         can occur when you are creating or updating a trail to send notifications to an Amazon SNS topic that is
     *         in a suspended Amazon Web Services account.
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws ThrottlingException
     *         This exception is thrown when the request rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.CreateTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTrailResponse createTrail(CreateTrailRequest createTrailRequest) throws MaximumNumberOfTrailsExceededException,
            TrailAlreadyExistsException, S3BucketDoesNotExistException, InsufficientS3BucketPolicyException,
            InsufficientSnsTopicPolicyException, InsufficientEncryptionPolicyException, InvalidS3BucketNameException,
            InvalidS3PrefixException, InvalidSnsTopicNameException, InvalidKmsKeyIdException, InvalidTrailNameException,
            TrailNotProvidedException, TagsLimitExceededException, InvalidParameterCombinationException,
            InvalidParameterException, KmsKeyNotFoundException, KmsException, InvalidCloudWatchLogsLogGroupArnException,
            InvalidCloudWatchLogsRoleArnException, CloudWatchLogsDeliveryUnavailableException, InvalidTagParameterException,
            UnsupportedOperationException, OperationNotPermittedException, CloudTrailAccessNotEnabledException,
            InsufficientDependencyServiceAccessPermissionException, NotOrganizationMasterAccountException,
            OrganizationsNotInUseException, OrganizationNotInAllFeaturesModeException, NoManagementAccountSlrExistsException,
            CloudTrailInvalidClientTokenIdException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrail");

            return clientHandler.execute(new ClientExecutionParams<CreateTrailRequest, CreateTrailResponse>()
                    .withOperationName("CreateTrail").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createTrailRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrailRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a channel.
     * </p>
     *
     * @param deleteChannelRequest
     * @return Result of the DeleteChannel operation returned by the service.
     * @throws ChannelArnInvalidException
     *         This exception is thrown when the specified value of <code>ChannelARN</code> is not valid.
     * @throws ChannelNotFoundException
     *         This exception is thrown when CloudTrail cannot find the specified channel.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.DeleteChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws ChannelArnInvalidException,
            ChannelNotFoundException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteChannel");

            return clientHandler.execute(new ClientExecutionParams<DeleteChannelRequest, DeleteChannelResponse>()
                    .withOperationName("DeleteChannel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteChannelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified dashboard. You cannot delete a dashboard that has termination protection enabled.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return Result of the DeleteDashboard operation returned by the service.
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the specified resource is not found.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) throws ConflictException,
            ResourceNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDashboardRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDashboard");

            return clientHandler.execute(new ClientExecutionParams<DeleteDashboardRequest, DeleteDashboardResponse>()
                    .withOperationName("DeleteDashboard").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the event data store specified by <code>EventDataStore</code>, which accepts an event data store ARN.
     * After you run <code>DeleteEventDataStore</code>, the event data store enters a <code>PENDING_DELETION</code>
     * state, and is automatically deleted after a wait period of seven days. <code>TerminationProtectionEnabled</code>
     * must be set to <code>False</code> on the event data store and the <code>FederationStatus</code> must be
     * <code>DISABLED</code>. You cannot delete an event data store if <code>TerminationProtectionEnabled</code> is
     * <code>True</code> or the <code>FederationStatus</code> is <code>ENABLED</code>.
     * </p>
     * <p>
     * After you run <code>DeleteEventDataStore</code> on an event data store, you cannot run <code>ListQueries</code>,
     * <code>DescribeQuery</code>, or <code>GetQueryResults</code> on queries that are using an event data store in a
     * <code>PENDING_DELETION</code> state. An event data store in the <code>PENDING_DELETION</code> state does not
     * incur costs.
     * </p>
     *
     * @param deleteEventDataStoreRequest
     * @return Result of the DeleteEventDataStore operation returned by the service.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws EventDataStoreTerminationProtectedException
     *         The event data store cannot be deleted because termination protection is enabled for it.
     * @throws EventDataStoreHasOngoingImportException
     *         This exception is thrown when you try to update or delete an event data store that currently has an
     *         import in progress.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws NotOrganizationMasterAccountException
     *         This exception is thrown when the Amazon Web Services account making the request to create or update an
     *         organization trail or event data store is not the management account for an organization in
     *         Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws ChannelExistsForEdsException
     *         This exception is thrown when the specified event data store cannot yet be deleted because it is in use
     *         by a channel.
     * @throws InsufficientDependencyServiceAccessPermissionException
     *         This exception is thrown when the IAM identity that is used to create the organization resource lacks one
     *         or more required permissions for creating an organization resource in a required service.
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws EventDataStoreFederationEnabledException
     *         You cannot delete the event data store because Lake query federation is enabled. To delete the event data
     *         store, run the <code>DisableFederation</code> operation to disable Lake query federation on the event
     *         data store.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.DeleteEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteEventDataStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEventDataStoreResponse deleteEventDataStore(DeleteEventDataStoreRequest deleteEventDataStoreRequest)
            throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException,
            EventDataStoreTerminationProtectedException, EventDataStoreHasOngoingImportException,
            InactiveEventDataStoreException, InvalidParameterException, OperationNotPermittedException,
            UnsupportedOperationException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException,
            ChannelExistsForEdsException, InsufficientDependencyServiceAccessPermissionException, ConflictException,
            EventDataStoreFederationEnabledException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventDataStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEventDataStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEventDataStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventDataStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventDataStore");

            return clientHandler.execute(new ClientExecutionParams<DeleteEventDataStoreRequest, DeleteEventDataStoreResponse>()
                    .withOperationName("DeleteEventDataStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteEventDataStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEventDataStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the resource-based policy attached to the CloudTrail event data store, dashboard, or channel.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ResourceArnNotValidException
     *         This exception is thrown when the provided resource does not exist, or the ARN format of the resource is
     *         not valid. </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws ResourceNotFoundException
     *         This exception is thrown when the specified resource is not found.
     * @throws ResourcePolicyNotFoundException
     *         This exception is thrown when the specified resource policy is not found.
     * @throws ResourceTypeNotSupportedException
     *         This exception is thrown when the specified resource type is not supported by CloudTrail.
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ResourceArnNotValidException, ResourceNotFoundException, ResourcePolicyNotFoundException,
            ResourceTypeNotSupportedException, ConflictException, OperationNotPermittedException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                    .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a trail. This operation must be called from the Region in which the trail was created.
     * <code>DeleteTrail</code> cannot be called on the shadow trails (replicated trails in other Regions) of a trail
     * that is enabled in all Regions.
     * </p>
     *
     * @param deleteTrailRequest
     *        The request that specifies the name of a trail to delete.
     * @return Result of the DeleteTrail operation returned by the service.
     * @throws TrailNotFoundException
     *         This exception is thrown when the trail with the given name is not found.
     * @throws InvalidTrailNameException
     *         This exception is thrown when the provided trail name is not valid. Trail names must meet the following
     *         requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     * @throws CloudTrailArnInvalidException
     *         This exception is thrown when an operation is called with an ARN that is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
     *         </code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN: <code>
     *         arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN: <code>
     *         arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN: <code>
     *         arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws ThrottlingException
     *         This exception is thrown when the request rate exceeds the limit.
     * @throws InvalidHomeRegionException
     *         This exception is thrown when an operation is called on a trail from a Region other than the Region in
     *         which the trail was created.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws NotOrganizationMasterAccountException
     *         This exception is thrown when the Amazon Web Services account making the request to create or update an
     *         organization trail or event data store is not the management account for an organization in
     *         Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws InsufficientDependencyServiceAccessPermissionException
     *         This exception is thrown when the IAM identity that is used to create the organization resource lacks one
     *         or more required permissions for creating an organization resource in a required service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.DeleteTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTrailResponse deleteTrail(DeleteTrailRequest deleteTrailRequest) throws TrailNotFoundException,
            InvalidTrailNameException, CloudTrailArnInvalidException, ConflictException, ThrottlingException,
            InvalidHomeRegionException, UnsupportedOperationException, OperationNotPermittedException,
            NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException,
            InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrail");

            return clientHandler.execute(new ClientExecutionParams<DeleteTrailRequest, DeleteTrailResponse>()
                    .withOperationName("DeleteTrail").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteTrailRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTrailRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes CloudTrail delegated administrator permissions from a member account in an organization.
     * </p>
     *
     * @param deregisterOrganizationDelegatedAdminRequest
     *        Removes CloudTrail delegated administrator permissions from a specified member account in an organization
     *        that is currently designated as a delegated administrator.
     * @return Result of the DeregisterOrganizationDelegatedAdmin operation returned by the service.
     * @throws AccountNotFoundException
     *         This exception is thrown when the specified account is not found or not part of an organization.
     * @throws AccountNotRegisteredException
     *         This exception is thrown when the specified account is not registered as the CloudTrail delegated
     *         administrator.
     * @throws CloudTrailAccessNotEnabledException
     *         This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.
     * @throws ConflictException
     *         This exception is thrown when the specified resource is not ready for an operation. This can occur when
     *         you try to run an operation on a resource before CloudTrail has time to fully load the resource, or
     *         because another operation is modifying the resource. If this exception occurs, wait a few minutes, and
     *         then try the operation again.
     * @throws InsufficientDependencyServiceAccessPermissionException
     *         This exception is thrown when the IAM identity that is used to create the organization resource lacks one
     *         or more required permissions for creating an organization resource in a required service.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws NotOrganizationManagementAccountException
     *         This exception is thrown when the account making the request is not the organization's management
     *         account.
     * @throws OrganizationNotInAllFeaturesModeException
     *         This exception is thrown when Organizations is not configured to support all features. All features must
     *         be enabled in Organizations to support creating an organization trail or event data store.
     * @throws OrganizationsNotInUseException
     *         This exception is thrown when the request is made from an Amazon Web Services account that is not a
     *         member of an organization. To make this request, sign in using the credentials of an account that belongs
     *         to an organization.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.DeregisterOrganizationDelegatedAdmin
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeregisterOrganizationDelegatedAdmin"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterOrganizationDelegatedAdminResponse deregisterOrganizationDelegatedAdmin(
            DeregisterOrganizationDelegatedAdminRequest deregisterOrganizationDelegatedAdminRequest)
            throws AccountNotFoundException, AccountNotRegisteredException, CloudTrailAccessNotEnabledException,
            ConflictException, InsufficientDependencyServiceAccessPermissionException, InvalidParameterException,
            NotOrganizationManagementAccountException, OrganizationNotInAllFeaturesModeException, OrganizationsNotInUseException,
            UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterOrganizationDelegatedAdminResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeregisterOrganizationDelegatedAdminResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterOrganizationDelegatedAdminRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterOrganizationDelegatedAdminRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterOrganizationDelegatedAdmin");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterOrganizationDelegatedAdminRequest, DeregisterOrganizationDelegatedAdminResponse>()
                            .withOperationName("DeregisterOrganizationDelegatedAdmin").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deregisterOrganizationDelegatedAdminRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterOrganizationDelegatedAdminRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns metadata about a query, including query run time in milliseconds, number of events scanned and matched,
     * and query status. If the query results were delivered to an S3 bucket, the response also provides the S3 URI and
     * the delivery status.
     * </p>
     * <p>
     * You must specify either <code>QueryId</code> or <code>QueryAlias</code>. Specifying the <code>QueryAlias</code>
     * parameter returns information about the last query run for the alias. You can provide <code>RefreshId</code>
     * along with <code>QueryAlias</code> to view the query results of a dashboard query for the specified
     * <code>RefreshId</code>.
     * </p>
     *
     * @param describeQueryRequest
     * @return Result of the DescribeQuery operation returned by the service.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws QueryIdNotFoundException
     *         The query ID does not exist or does not map to a query.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.DescribeQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeQueryResponse describeQuery(DescribeQueryRequest describeQueryRequest)
            throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException,
            InvalidParameterException, QueryIdNotFoundException, OperationNotPermittedException, UnsupportedOperationException,
            NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeQuery");

            return clientHandler.execute(new ClientExecutionParams<DescribeQueryRequest, DescribeQueryResponse>()
                    .withOperationName("DescribeQuery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves settings for one or more trails associated with the current Region for your account.
     * </p>
     *
     * @param describeTrailsRequest
     *        Returns information about the trail.
     * @return Result of the DescribeTrails operation returned by the service.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws InvalidTrailNameException
     *         This exception is thrown when the provided trail name is not valid. Trail names must meet the following
     *         requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     * @throws CloudTrailArnInvalidException
     *         This exception is thrown when an operation is called with an ARN that is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
     *         </code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN: <code>
     *         arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN: <code>
     *         arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN: <code>
     *         arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.DescribeTrails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeTrailsResponse describeTrails(DescribeTrailsRequest describeTrailsRequest)
            throws UnsupportedOperationException, OperationNotPermittedException, InvalidTrailNameException,
            CloudTrailArnInvalidException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException,
            CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTrailsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeTrailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrails");

            return clientHandler.execute(new ClientExecutionParams<DescribeTrailsRequest, DescribeTrailsResponse>()
                    .withOperationName("DescribeTrails").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTrailsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTrailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables Lake query federation on the specified event data store. When you disable federation, CloudTrail
     * disables the integration with Glue, Lake Formation, and Amazon Athena. After disabling Lake query federation, you
     * can no longer query your event data in Amazon Athena.
     * </p>
     * <p>
     * No CloudTrail Lake data is deleted when you disable federation and you can continue to run queries in CloudTrail
     * Lake.
     * </p>
     *
     * @param disableFederationRequest
     * @return Result of the DisableFederation operation returned by the service.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws CloudTrailAccessNotEnabledException
     *         This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.
     * @throws InsufficientDependencyServiceAccessPermissionException
     *         This exception is thrown when the IAM identity that is used to create the organization resource lacks one
     *         or more required permissions for creating an organization resource in a required service.
     * @throws NotOrganizationMasterAccountException
     *         This exception is thrown when the Amazon Web Services account making the request to create or update an
     *         organization trail or event data store is not the management account for an organization in
     *         Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws OrganizationsNotInUseException
     *         This exception is thrown when the request is made from an Amazon Web Services account that is not a
     *         member of an organization. To make this request, sign in using the credentials of an account that belongs
     *         to an organization.
     * @throws OrganizationNotInAllFeaturesModeException
     *         This exception is thrown when Organizations is not configured to support all features. All features must
     *         be enabled in Organizations to support creating an organization trail or event data store.
     * @throws ConcurrentModificationException
     *         You are trying to update a resource when another request is in progress. Allow sufficient wait time for
     *         the previous request to complete, then retry your request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.DisableFederation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DisableFederation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DisableFederationResponse disableFederation(DisableFederationRequest disableFederationRequest)
            throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidParameterException,
            InactiveEventDataStoreException, OperationNotPermittedException, UnsupportedOperationException,
            CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException,
            NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, OrganizationsNotInUseException,
            OrganizationNotInAllFeaturesModeException, ConcurrentModificationException, AccessDeniedException,
            AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableFederationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisableFederationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableFederationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableFederationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableFederation");

            return clientHandler.execute(new ClientExecutionParams<DisableFederationRequest, DisableFederationResponse>()
                    .withOperationName("DisableFederation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disableFederationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisableFederationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables Lake query federation on the specified event data store. Federating an event data store lets you view the
     * metadata associated with the event data store in the Glue <a
     * href="https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro">Data Catalog</a>
     * and run SQL queries against your event data using Amazon Athena. The table metadata stored in the Glue Data
     * Catalog lets the Athena query engine know how to find, read, and process the data that you want to query.
     * </p>
     * <p>
     * When you enable Lake query federation, CloudTrail creates a managed database named <code>aws:cloudtrail</code>
     * (if the database doesn't already exist) and a managed federated table in the Glue Data Catalog. The event data
     * store ID is used for the table name. CloudTrail registers the role ARN and event data store in <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation-lake-formation.html">Lake
     * Formation</a>, the service responsible for allowing fine-grained access control of the federated resources in the
     * Glue Data Catalog.
     * </p>
     * <p>
     * For more information about Lake query federation, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html">Federate an event data
     * store</a>.
     * </p>
     *
     * @param enableFederationRequest
     * @return Result of the EnableFederation operation returned by the service.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws CloudTrailAccessNotEnabledException
     *         This exception is thrown when trusted access has not been enabled between CloudTrail and Organizations.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_how-to-enable-disable-trusted-access"
     *         >How to enable or disable trusted access</a> in the <i>Organizations User Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> in the <i>CloudTrail User Guide</i>.
     * @throws InsufficientDependencyServiceAccessPermissionException
     *         This exception is thrown when the IAM identity that is used to create the organization resource lacks one
     *         or more required permissions for creating an organization resource in a required service.
     * @throws NotOrganizationMasterAccountException
     *         This exception is thrown when the Amazon Web Services account making the request to create or update an
     *         organization trail or event data store is not the management account for an organization in
     *         Organizations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/creating-an-organizational-trail-prepare.html"
     *         >Prepare For Creating a Trail For Your Organization</a> or <a
     *         href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-lake-organizations.html"
     *         >Organization event data stores</a>.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws OrganizationsNotInUseException
     *         This exception is thrown when the request is made from an Amazon Web Services account that is not a
     *         member of an organization. To make this request, sign in using the credentials of an account that belongs
     *         to an organization.
     * @throws OrganizationNotInAllFeaturesModeException
     *         This exception is thrown when Organizations is not configured to support all features. All features must
     *         be enabled in Organizations to support creating an organization trail or event data store.
     * @throws ConcurrentModificationException
     *         You are trying to update a resource when another request is in progress. Allow sufficient wait time for
     *         the previous request to complete, then retry your request.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws EventDataStoreFederationEnabledException
     *         You cannot delete the event data store because Lake query federation is enabled. To delete the event data
     *         store, run the <code>DisableFederation</code> operation to disable Lake query federation on the event
     *         data store.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.EnableFederation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/EnableFederation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public EnableFederationResponse enableFederation(EnableFederationRequest enableFederationRequest)
            throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidParameterException,
            InactiveEventDataStoreException, OperationNotPermittedException, UnsupportedOperationException,
            CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException,
            NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, OrganizationsNotInUseException,
            OrganizationNotInAllFeaturesModeException, ConcurrentModificationException, AccessDeniedException,
            EventDataStoreFederationEnabledException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableFederationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                EnableFederationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableFederationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableFederationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableFederation");

            return clientHandler.execute(new ClientExecutionParams<EnableFederationRequest, EnableFederationResponse>()
                    .withOperationName("EnableFederation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(enableFederationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EnableFederationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a query from a natural language prompt. This operation uses generative artificial intelligence
     * (generative AI) to produce a ready-to-use SQL query from the prompt.
     * </p>
     * <p>
     * The prompt can be a question or a statement about the event data in your event data store. For example, you can
     * enter prompts like "What are my top errors in the past month?" and “Give me a list of users that used SNS.”
     * </p>
     * <p>
     * The prompt must be in English. For information about limitations, permissions, and supported Regions, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html">Create CloudTrail
     * Lake queries from natural language prompts</a> in the <i>CloudTrail </i> user guide.
     * </p>
     * <note>
     * <p>
     * Do not include any personally identifying, confidential, or sensitive information in your prompts.
     * </p>
     * <p>
     * This feature uses generative AI large language models (LLMs); we recommend double-checking the LLM response.
     * </p>
     * </note>
     *
     * @param generateQueryRequest
     * @return Result of the GenerateQuery operation returned by the service.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws GenerateResponseException
     *         This exception is thrown when a valid query could not be generated for the provided prompt.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GenerateQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GenerateQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GenerateQueryResponse generateQuery(GenerateQueryRequest generateQueryRequest)
            throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException,
            InvalidParameterException, GenerateResponseException, OperationNotPermittedException, UnsupportedOperationException,
            NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GenerateQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GenerateQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(generateQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, generateQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateQuery");

            return clientHandler.execute(new ClientExecutionParams<GenerateQueryRequest, GenerateQueryResponse>()
                    .withOperationName("GenerateQuery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(generateQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GenerateQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific channel.
     * </p>
     *
     * @param getChannelRequest
     * @return Result of the GetChannel operation returned by the service.
     * @throws ChannelArnInvalidException
     *         This exception is thrown when the specified value of <code>ChannelARN</code> is not valid.
     * @throws ChannelNotFoundException
     *         This exception is thrown when CloudTrail cannot find the specified channel.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetChannel" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetChannelResponse getChannel(GetChannelRequest getChannelRequest) throws ChannelArnInvalidException,
            ChannelNotFoundException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetChannelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetChannel");

            return clientHandler.execute(new ClientExecutionParams<GetChannelRequest, GetChannelResponse>()
                    .withOperationName("GetChannel").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getChannelRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetChannelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the specified dashboard.
     * </p>
     *
     * @param getDashboardRequest
     * @return Result of the GetDashboard operation returned by the service.
     * @throws ResourceNotFoundException
     *         This exception is thrown when the specified resource is not found.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetDashboard" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDashboardResponse getDashboard(GetDashboardRequest getDashboardRequest) throws ResourceNotFoundException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDashboardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDashboard");

            return clientHandler.execute(new ClientExecutionParams<GetDashboardRequest, GetDashboardResponse>()
                    .withOperationName("GetDashboard").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current event configuration settings for the specified event data store, including details about
     * maximum event size and context key selectors configured for the event data store.
     * </p>
     *
     * @param getEventConfigurationRequest
     * @return Result of the GetEventConfiguration operation returned by the service.
     * @throws CloudTrailArnInvalidException
     *         This exception is thrown when an operation is called with an ARN that is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InvalidEventDataStoreStatusException
     *         The event data store is not in a status that supports the operation.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws InvalidEventDataStoreCategoryException
     *         This exception is thrown when event categories of specified event data stores are not valid.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws InvalidParameterCombinationException
     *         This exception is thrown when the combination of parameters provided is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEventConfigurationResponse getEventConfiguration(GetEventConfigurationRequest getEventConfigurationRequest)
            throws CloudTrailArnInvalidException, UnsupportedOperationException, OperationNotPermittedException,
            EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventDataStoreStatusException,
            InvalidParameterException, InvalidEventDataStoreCategoryException, NoManagementAccountSlrExistsException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEventConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventConfiguration");

            return clientHandler.execute(new ClientExecutionParams<GetEventConfigurationRequest, GetEventConfigurationResponse>()
                    .withOperationName("GetEventConfiguration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getEventConfigurationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEventConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about an event data store specified as either an ARN or the ID portion of the ARN.
     * </p>
     *
     * @param getEventDataStoreRequest
     * @return Result of the GetEventDataStore operation returned by the service.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetEventDataStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventDataStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetEventDataStoreResponse getEventDataStore(GetEventDataStoreRequest getEventDataStoreRequest)
            throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidParameterException,
            OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException,
            AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventDataStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEventDataStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventDataStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventDataStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventDataStore");

            return clientHandler.execute(new ClientExecutionParams<GetEventDataStoreRequest, GetEventDataStoreResponse>()
                    .withOperationName("GetEventDataStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getEventDataStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEventDataStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the settings for the event selectors that you configured for your trail. The information returned for
     * your event selectors includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your event selector includes read-only events, write-only events, or all events. This applies to management
     * events, data events, and network activity events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes management events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes network activity events, the event sources for which you are logging network
     * activity events.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your event selector includes data events, the resources on which you are logging data events.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about logging management, data, and network activity events, see the following topics in the
     * <i>CloudTrail User Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html"
     * >Logging management events</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">
     * Logging data events</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html">
     * Logging network activity events</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getEventSelectorsRequest
     * @return Result of the GetEventSelectors operation returned by the service.
     * @throws TrailNotFoundException
     *         This exception is thrown when the trail with the given name is not found.
     * @throws InvalidTrailNameException
     *         This exception is thrown when the provided trail name is not valid. Trail names must meet the following
     *         requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     * @throws CloudTrailArnInvalidException
     *         This exception is thrown when an operation is called with an ARN that is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
     *         </code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN: <code>
     *         arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN: <code>
     *         arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN: <code>
     *         arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetEventSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetEventSelectorsResponse getEventSelectors(GetEventSelectorsRequest getEventSelectorsRequest)
            throws TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException,
            UnsupportedOperationException, OperationNotPermittedException, NoManagementAccountSlrExistsException,
            AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventSelectorsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEventSelectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEventSelectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEventSelectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEventSelectors");

            return clientHandler.execute(new ClientExecutionParams<GetEventSelectorsRequest, GetEventSelectorsResponse>()
                    .withOperationName("GetEventSelectors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getEventSelectorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEventSelectorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a specific import.
     * </p>
     *
     * @param getImportRequest
     * @return Result of the GetImport operation returned by the service.
     * @throws ImportNotFoundException
     *         The specified import was not found.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetImport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetImportResponse getImport(GetImportRequest getImportRequest) throws ImportNotFoundException,
            InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetImportResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetImportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getImportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetImport");

            return clientHandler.execute(new ClientExecutionParams<GetImportRequest, GetImportResponse>()
                    .withOperationName("GetImport").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getImportRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetImportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the settings for the Insights event selectors that you configured for your trail or event data store.
     * <code>GetInsightSelectors</code> shows if CloudTrail Insights event logging is enabled on the trail or event data
     * store, and if it is, which Insights types are enabled. If you run <code>GetInsightSelectors</code> on a trail or
     * event data store that does not have Insights events enabled, the operation throws the exception
     * <code>InsightNotEnabledException</code>
     * </p>
     * <p>
     * Specify either the <code>EventDataStore</code> parameter to get Insights event selectors for an event data store,
     * or the <code>TrailName</code> parameter to the get Insights event selectors for a trail. You cannot specify these
     * parameters together.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html"
     * >Working with CloudTrail Insights</a> in the <i>CloudTrail User Guide</i>.
     * </p>
     *
     * @param getInsightSelectorsRequest
     * @return Result of the GetInsightSelectors operation returned by the service.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws InvalidParameterCombinationException
     *         This exception is thrown when the combination of parameters provided is not valid.
     * @throws TrailNotFoundException
     *         This exception is thrown when the trail with the given name is not found.
     * @throws InvalidTrailNameException
     *         This exception is thrown when the provided trail name is not valid. Trail names must meet the following
     *         requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     * @throws CloudTrailArnInvalidException
     *         This exception is thrown when an operation is called with an ARN that is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail
     *         </code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN: <code>
     *         arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN: <code>
     *         arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN: <code>
     *         arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws InsightNotEnabledException
     *         If you run <code>GetInsightSelectors</code> on a trail or event data store that does not have Insights
     *         events enabled, the operation throws the exception <code>InsightNotEnabledException</code>.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws ThrottlingException
     *         This exception is thrown when the request rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetInsightSelectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetInsightSelectors"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetInsightSelectorsResponse getInsightSelectors(GetInsightSelectorsRequest getInsightSelectorsRequest)
            throws InvalidParameterException, InvalidParameterCombinationException, TrailNotFoundException,
            InvalidTrailNameException, CloudTrailArnInvalidException, UnsupportedOperationException,
            OperationNotPermittedException, InsightNotEnabledException, NoManagementAccountSlrExistsException,
            ThrottlingException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInsightSelectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInsightSelectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInsightSelectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInsightSelectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInsightSelectors");

            return clientHandler.execute(new ClientExecutionParams<GetInsightSelectorsRequest, GetInsightSelectorsResponse>()
                    .withOperationName("GetInsightSelectors").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getInsightSelectorsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetInsightSelectorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets event data results of a query. You must specify the <code>QueryID</code> value returned by the
     * <code>StartQuery</code> operation.
     * </p>
     *
     * @param getQueryResultsRequest
     * @return Result of the GetQueryResults operation returned by the service.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws EventDataStoreNotFoundException
     *         The specified event data store was not found.
     * @throws InactiveEventDataStoreException
     *         The event data store is inactive.
     * @throws InvalidMaxResultsException
     *         This exception is thrown if the limit specified is not valid.
     * @throws InvalidNextTokenException
     *         A token that is not valid, or a token that was previously used in a request with different parameters.
     *         This exception is thrown if the token is not valid.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws QueryIdNotFoundException
     *         The query ID does not exist or does not map to a query.
     * @throws InsufficientEncryptionPolicyException
     *         For the <code>CreateTrail</code> <code>PutInsightSelectors</code>, <code>UpdateTrail</code>,
     *         <code>StartQuery</code>, and <code>StartImport</code> operations, this exception is thrown when the
     *         policy on the S3 bucket or KMS key does not have sufficient permissions for the operation.</p>
     *         <p>
     *         For all other operations, this exception is thrown when the policy for the KMS key does not have
     *         sufficient permissions for the operation.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetQueryResults" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetQueryResultsResponse getQueryResults(GetQueryResultsRequest getQueryResultsRequest)
            throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException,
            InvalidMaxResultsException, InvalidNextTokenException, InvalidParameterException, QueryIdNotFoundException,
            InsufficientEncryptionPolicyException, OperationNotPermittedException, UnsupportedOperationException,
            NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQueryResultsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetQueryResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryResults");

            return clientHandler.execute(new ClientExecutionParams<GetQueryResultsRequest, GetQueryResultsResponse>()
                    .withOperationName("GetQueryResults").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getQueryResultsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetQueryResultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the JSON text of the resource-based policy document attached to the CloudTrail event data store,
     * dashboard, or channel.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ResourceArnNotValidException
     *         This exception is thrown when the provided resource does not exist, or the ARN format of the resource is
     *         not valid. </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws ResourceNotFoundException
     *         This exception is thrown when the specified resource is not found.
     * @throws ResourcePolicyNotFoundException
     *         This exception is thrown when the specified resource policy is not found.
     * @throws ResourceTypeNotSupportedException
     *         This exception is thrown when the specified resource type is not supported by CloudTrail.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws ResourceArnNotValidException, ResourceNotFoundException, ResourcePolicyNotFoundException,
            ResourceTypeNotSupportedException, OperationNotPermittedException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                    .withOperationName("GetResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns settings information for a specified trail.
     * </p>
     *
     * @param getTrailRequest
     * @return Result of the GetTrail operation returned by the service.
     * @throws CloudTrailArnInvalidException
     *         This exception is thrown when an operation is called with an ARN that is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws TrailNotFoundException
     *         This exception is thrown when the trail with the given name is not found.
     * @throws InvalidTrailNameException
     *         This exception is thrown when the provided trail name is not valid. Trail names must meet the following
     *         requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetTrail
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrail" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTrailResponse getTrail(GetTrailRequest getTrailRequest) throws CloudTrailArnInvalidException,
            TrailNotFoundException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException,
            AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTrailResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrailRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrail");

            return clientHandler.execute(new ClientExecutionParams<GetTrailRequest, GetTrailResponse>()
                    .withOperationName("GetTrail").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getTrailRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTrailRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a JSON-formatted list of information about the specified trail. Fields include information on delivery
     * errors, Amazon SNS and Amazon S3 errors, and start and stop logging times for each trail. This operation returns
     * trail status from a single Region. To return trail status from all Regions, you must call the operation on each
     * Region.
     * </p>
     *
     * @param getTrailStatusRequest
     *        The name of a trail about which you want the current status.
     * @return Result of the GetTrailStatus operation returned by the service.
     * @throws CloudTrailArnInvalidException
     *         This exception is thrown when an operation is called with an ARN that is not valid.</p>
     *         <p>
     *         The following is the format of a trail ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         The following is the format of an event data store ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
     *         </p>
     *         <p>
     *         The following is the format of a dashboard ARN:
     *         <code>arn:aws:cloudtrail:us-east-1:123456789012:dashboard/exampleDash</code>
     *         </p>
     *         <p>
     *         The following is the format of a channel ARN:
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
     * @throws TrailNotFoundException
     *         This exception is thrown when the trail with the given name is not found.
     * @throws InvalidTrailNameException
     *         This exception is thrown when the provided trail name is not valid. Trail names must meet the following
     *         requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.GetTrailStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTrailStatusResponse getTrailStatus(GetTrailStatusRequest getTrailStatusRequest)
            throws CloudTrailArnInvalidException, TrailNotFoundException, InvalidTrailNameException,
            UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTrailStatusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTrailStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrailStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrailStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrailStatus");

            return clientHandler.execute(new ClientExecutionParams<GetTrailStatusRequest, GetTrailStatusResponse>()
                    .withOperationName("GetTrailStatus").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getTrailStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTrailStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the channels in the current account, and their source names.
     * </p>
     *
     * @param listChannelsRequest
     * @return Result of the ListChannels operation returned by the service.
     * @throws InvalidNextTokenException
     *         A token that is not valid, or a token that was previously used in a request with different parameters.
     *         This exception is thrown if the token is not valid.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.ListChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListChannels" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws InvalidNextTokenException,
            OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListChannelsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListChannelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListChannels");

            return clientHandler.execute(new ClientExecutionParams<ListChannelsRequest, ListChannelsResponse>()
                    .withOperationName("ListChannels").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listChannelsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListChannelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about all dashboards in the account, in the current Region.
     * </p>
     *
     * @param listDashboardsRequest
     * @return Result of the ListDashboards operation returned by the service.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest)
            throws UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDashboardsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDashboardsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDashboardsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDashboardsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDashboards");

            return clientHandler.execute(new ClientExecutionParams<ListDashboardsRequest, ListDashboardsResponse>()
                    .withOperationName("ListDashboards").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDashboardsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDashboardsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about all event data stores in the account, in the current Region.
     * </p>
     *
     * @param listEventDataStoresRequest
     * @return Result of the ListEventDataStores operation returned by the service.
     * @throws InvalidMaxResultsException
     *         This exception is thrown if the limit specified is not valid.
     * @throws InvalidNextTokenException
     *         A token that is not valid, or a token that was previously used in a request with different parameters.
     *         This exception is thrown if the token is not valid.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws NoManagementAccountSlrExistsException
     *         This exception is thrown when the management account does not have a service-linked role.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.ListEventDataStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListEventDataStores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEventDataStoresResponse listEventDataStores(ListEventDataStoresRequest listEventDataStoresRequest)
            throws InvalidMaxResultsException, InvalidNextTokenException, OperationNotPermittedException,
            UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException,
            CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEventDataStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEventDataStoresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEventDataStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEventDataStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEventDataStores");

            return clientHandler.execute(new ClientExecutionParams<ListEventDataStoresRequest, ListEventDataStoresResponse>()
                    .withOperationName("ListEventDataStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listEventDataStoresRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEventDataStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of failures for the specified import.
     * </p>
     *
     * @param listImportFailuresRequest
     * @return Result of the ListImportFailures operation returned by the service.
     * @throws InvalidNextTokenException
     *         A token that is not valid, or a token that was previously used in a request with different parameters.
     *         This exception is thrown if the token is not valid.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.ListImportFailures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImportFailures" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListImportFailuresResponse listImportFailures(ListImportFailuresRequest listImportFailuresRequest)
            throws InvalidNextTokenException, OperationNotPermittedException, UnsupportedOperationException,
            InvalidParameterException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImportFailuresResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListImportFailuresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "EventDataStoreMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
            case "EventDataStoreTerminationProtectedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder)
                        .build());
            case "ResourcePolicyNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
            case "InvalidKmsKeyIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
            case "InsufficientIAMAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
            case "ResourceARNNotValidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
            case "InvalidCloudWatchLogsLogGroupArnException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException")
                                .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder)
                                .build());
            case "InvalidEventDataStoreCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
            case "InvalidSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSourceException::builder).build());
            case "EventDataStoreAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
            case "CloudTrailARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
            case "NotOrganizationMasterAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InvalidLookupAttributesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
            case "CloudTrailInvalidClientTokenIdException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
            case "OrganizationsNotInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "GenerateResponseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(GenerateResponseException::builder).build());
            case "ChannelExistsForEDSException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidEventSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "InvalidEventDataStoreStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
            case "AccountNotRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
            case "EventDataStoreFederationEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
            case "NoManagementAccountSLRExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException")
                        .httpStatusCode(400).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
            case "CloudTrailAccessNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
            case "InvalidTrailNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
            case "InvalidImportSourceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
            case "InsufficientEncryptionPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
            case "ResourcePolicyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
            case "DelegatedAdminAccountLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder)
                        .build());
            case "EventDataStoreARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
            case "InvalidS3PrefixException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
            case "InsufficientSnsTopicPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
            case "InvalidHomeRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
            case "InsufficientDependencyServiceAccessPermissionException":
                return Optional.of(ExceptionMetadata.builder()
                        .errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
            case "ChannelAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ChannelARNInvalidException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
            case "QueryIdNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
            case "InactiveEventDataStoreException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
            case "TrailNotProvidedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
            case "InvalidQueryStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
            case "InvalidEventCategoryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
            case "KmsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsException::builder).build());
            case "OrganizationNotInAllFeaturesModeException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException")
                                .httpStatusCode(400).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder)
                                .build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "S3BucketDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
            case "CannotDelegateManagementAccountException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
            case "TagsLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
            case "InvalidSnsTopicNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
            case "KmsKeyNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
            case "AccountRegisteredException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountRegisteredException::builder).build());
            case "OperationNotPermittedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
            case "AccountHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
            case "ResourceTypeNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
            case "InvalidTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTokenException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidCloudWatchLogsRoleArnException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
            case "InvalidQueryStatementException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
            case "InvalidTimeRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
            case "ImportNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ImportNotFoundException::builder).build());
            case "AccountNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccountNotFoundException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            case "InvalidMaxResultsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
            case "InvalidS3BucketNameException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
            case "CloudWatchLogsDeliveryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException")
                        .httpStatusCode(400).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder)
                        .build());
            case "InactiveQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InactiveQueryException::builder).build());
            case "ChannelMaxLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
            case "EventDataStoreNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
            case "InvalidTagParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
            case "TrailNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailNotFoundException::builder).build());
            case "MaximumNumberOfTrailsExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
            case "EventDataStoreHasOngoingImportException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException")
                        .httpStatusCode(400).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
            case "InvalidInsightSelectorsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
            case "InvalidDateRangeException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
            case "NotOrganizationManagementAccountException":
                return Optional
                        .of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException")
                                .httpStatusCode(400).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder)
                                .build());
            case "ChannelNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
            case "MaxConcurrentQueriesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
            case "InsufficientS3BucketPolicyException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
            case "TrailAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
            case "InsightNotEnabledException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listImportFailuresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listImportFailuresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListImportFailures");

            return clientHandler.execute(new ClientExecutionParams<ListImportFailuresRequest, ListImportFailuresResponse>()
                    .withOperationName("ListImportFailures").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listImportFailuresRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListImportFailuresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information on all imports, or a select set of imports by <code>ImportStatus</code> or
     * <code>Destination</code>.
     * </p>
     *
     * @param listImportsRequest
     * @return Result of the ListImports operation returned by the service.
     * @throws EventDataStoreArnInvalidException
     *         The specified event data store ARN is not valid or does not map to an event data store in your account.
     * @throws InvalidNextTokenException
     *         A token that is not valid, or a token that was previously used in a request with different parameters.
     *         This exception is thrown if the token is not valid.
     * @throws InvalidParameterException
     *         The request includes a parameter that is not valid.
     * @throws OperationNotPermittedException
     *         This exception is thrown when the requested operation is not permitted.
     * @throws UnsupportedOperationException
     *         This exception is thrown when the requested operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws EventDataStoreArnInvalidException,
            InvalidNextTokenException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListImportsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListImportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ConcurrentModificationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
            case "