/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a document that matches the search request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hit implements SdkPojo, Serializable, ToCopyableBuilder<Hit.Builder, Hit> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Hit::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Map<String, List<String>>> FIELDS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("fields")
            .getter(getter(Hit::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, String>> EXPRS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("exprs")
            .getter(getter(Hit::exprs))
            .setter(setter(Builder::exprs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exprs").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> HIGHLIGHTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("highlights")
            .getter(getter(Hit::highlights))
            .setter(setter(Builder::highlights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highlights").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FIELDS_FIELD,
            EXPRS_FIELD, HIGHLIGHTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Map<String, List<String>> fields;

    private final Map<String, String> exprs;

    private final Map<String, String> highlights;

    private Hit(BuilderImpl builder) {
        this.id = builder.id;
        this.fields = builder.fields;
        this.exprs = builder.exprs;
        this.highlights = builder.highlights;
    }

    /**
     * <p>
     * The document ID of a document that matches the search request.
     * </p>
     * 
     * @return The document ID of a document that matches the search request.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The fields returned from a document that matches the search request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The fields returned from a document that matches the search request.
     */
    public final Map<String, List<String>> fields() {
        return fields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Exprs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasExprs() {
        return exprs != null && !(exprs instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The expressions returned from a document that matches the search request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExprs} method.
     * </p>
     * 
     * @return The expressions returned from a document that matches the search request.
     */
    public final Map<String, String> exprs() {
        return exprs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Highlights property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHighlights() {
        return highlights != null && !(highlights instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The highlights returned from a document that matches the search request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHighlights} method.
     * </p>
     * 
     * @return The highlights returned from a document that matches the search request.
     */
    public final Map<String, String> highlights() {
        return highlights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExprs() ? exprs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasHighlights() ? highlights() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hit)) {
            return false;
        }
        Hit other = (Hit) obj;
        return Objects.equals(id(), other.id()) && hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && hasExprs() == other.hasExprs() && Objects.equals(exprs(), other.exprs())
                && hasHighlights() == other.hasHighlights() && Objects.equals(highlights(), other.highlights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Hit").add("Id", id()).add("Fields", hasFields() ? fields() : null)
                .add("Exprs", hasExprs() ? exprs() : null).add("Highlights", hasHighlights() ? highlights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "exprs":
            return Optional.ofNullable(clazz.cast(exprs()));
        case "highlights":
            return Optional.ofNullable(clazz.cast(highlights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("fields", FIELDS_FIELD);
        map.put("exprs", EXPRS_FIELD);
        map.put("highlights", HIGHLIGHTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Hit, T> g) {
        return obj -> g.apply((Hit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hit> {
        /**
         * <p>
         * The document ID of a document that matches the search request.
         * </p>
         * 
         * @param id
         *        The document ID of a document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The fields returned from a document that matches the search request.
         * </p>
         * 
         * @param fields
         *        The fields returned from a document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, ? extends Collection<String>> fields);

        /**
         * <p>
         * The expressions returned from a document that matches the search request.
         * </p>
         * 
         * @param exprs
         *        The expressions returned from a document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exprs(Map<String, String> exprs);

        /**
         * <p>
         * The highlights returned from a document that matches the search request.
         * </p>
         * 
         * @param highlights
         *        The highlights returned from a document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlights(Map<String, String> highlights);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Map<String, List<String>> fields = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> exprs = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> highlights = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Hit model) {
            id(model.id);
            fields(model.fields);
            exprs(model.exprs);
            highlights(model.highlights);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFields() {
            if (fields instanceof SdkAutoConstructMap) {
                return null;
            }
            return fields;
        }

        public final void setFields(Map<String, ? extends Collection<String>> fields) {
            this.fields = FieldsCopier.copy(fields);
        }

        @Override
        public final Builder fields(Map<String, ? extends Collection<String>> fields) {
            this.fields = FieldsCopier.copy(fields);
            return this;
        }

        public final Map<String, String> getExprs() {
            if (exprs instanceof SdkAutoConstructMap) {
                return null;
            }
            return exprs;
        }

        public final void setExprs(Map<String, String> exprs) {
            this.exprs = ExprsCopier.copy(exprs);
        }

        @Override
        public final Builder exprs(Map<String, String> exprs) {
            this.exprs = ExprsCopier.copy(exprs);
            return this;
        }

        public final Map<String, String> getHighlights() {
            if (highlights instanceof SdkAutoConstructMap) {
                return null;
            }
            return highlights;
        }

        public final void setHighlights(Map<String, String> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
        }

        @Override
        public final Builder highlights(Map<String, String> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
            return this;
        }

        @Override
        public Hit build() {
            return new Hit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
