/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The instance type (such as <code>search.m1.small</code>) on which an index partition is hosted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum PartitionInstanceType {
    SEARCH_M1_SMALL("search.m1.small"),

    SEARCH_M1_LARGE("search.m1.large"),

    SEARCH_M2_XLARGE("search.m2.xlarge"),

    SEARCH_M2_2_XLARGE("search.m2.2xlarge"),

    SEARCH_M3_MEDIUM("search.m3.medium"),

    SEARCH_M3_LARGE("search.m3.large"),

    SEARCH_M3_XLARGE("search.m3.xlarge"),

    SEARCH_M3_2_XLARGE("search.m3.2xlarge"),

    SEARCH_SMALL("search.small"),

    SEARCH_MEDIUM("search.medium"),

    SEARCH_LARGE("search.large"),

    SEARCH_XLARGE("search.xlarge"),

    SEARCH_2_XLARGE("search.2xlarge"),

    SEARCH_PREVIOUSGENERATION_SMALL("search.previousgeneration.small"),

    SEARCH_PREVIOUSGENERATION_LARGE("search.previousgeneration.large"),

    SEARCH_PREVIOUSGENERATION_XLARGE("search.previousgeneration.xlarge"),

    SEARCH_PREVIOUSGENERATION_2_XLARGE("search.previousgeneration.2xlarge"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PartitionInstanceType> VALUE_MAP = EnumUtils.uniqueIndex(PartitionInstanceType.class,
            PartitionInstanceType::toString);

    private final String value;

    private PartitionInstanceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PartitionInstanceType corresponding to the value
     */
    public static PartitionInstanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PartitionInstanceType}s
     */
    public static Set<PartitionInstanceType> knownValues() {
        Set<PartitionInstanceType> knownValues = EnumSet.allOf(PartitionInstanceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
