/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsRequest;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsResponse;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesResponse;

/**
 * Service client for accessing Amazon CloudSearch asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <fullname>Amazon CloudSearch Configuration Service</fullname>
 * <p>
 * You use the Amazon CloudSearch configuration service to create, configure, and manage search domains. Configuration
 * service requests are submitted using the AWS Query protocol. AWS Query requests are HTTP or HTTPS requests submitted
 * via HTTP GET or POST with a query parameter named Action.
 * </p>
 * <p>
 * The endpoint for configuration service requests is region-specific: cloudsearch.<i>region</i>.amazonaws.com. For
 * example, cloudsearch.us-east-1.amazonaws.com. For a current list of supported regions and endpoints, see <a
 * href="http://docs.aws.amazon.com/general/latest/gr/rande.html#cloudsearch_region" target="_blank">Regions and
 * Endpoints</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudSearchAsyncClient extends AwsClient {
    String SERVICE_NAME = "cloudsearch";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudsearch";

    /**
     * <p>
     * Indexes the search suggestions. For more information, see <a href=
     * "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters"
     * >Configuring Suggesters</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param buildSuggestersRequest
     *        Container for the parameters to the <code><a>BuildSuggester</a></code> operation. Specifies the name of
     *        the domain you want to update.
     * @return A Java Future containing the result of the BuildSuggesters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.BuildSuggesters
     */
    default CompletableFuture<BuildSuggestersResponse> buildSuggesters(BuildSuggestersRequest buildSuggestersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Indexes the search suggestions. For more information, see <a href=
     * "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html#configuring-suggesters"
     * >Configuring Suggesters</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BuildSuggestersRequest.Builder} avoiding the need
     * to create one manually via {@link BuildSuggestersRequest#builder()}
     * </p>
     *
     * @param buildSuggestersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>BuildSuggester</a></code> operation. Specifies the
     *        name of the domain you want to update.
     * @return A Java Future containing the result of the BuildSuggesters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.BuildSuggesters
     */
    default CompletableFuture<BuildSuggestersResponse> buildSuggesters(
            Consumer<BuildSuggestersRequest.Builder> buildSuggestersRequest) {
        return buildSuggesters(BuildSuggestersRequest.builder().applyMutation(buildSuggestersRequest).build());
    }

    /**
     * <p>
     * Creates a new search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html"
     * target="_blank">Creating a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param createDomainRequest
     *        Container for the parameters to the <code><a>CreateDomain</a></code> operation. Specifies a name for the
     *        new search domain.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceAlreadyExistsException The request was rejected because it attempted to create a resource
     *         that already exists.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.CreateDomain
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/creating-domains.html"
     * target="_blank">Creating a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.CreateDomainRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>CreateDomain</a></code> operation. Specifies a name for the
     *        new search domain.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceAlreadyExistsException The request was rejected because it attempted to create a resource
     *         that already exists.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.CreateDomain
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Configures an analysis scheme that can be applied to a <code>text</code> or <code>text-array</code> field to
     * define language-specific text processing options. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param defineAnalysisSchemeRequest
     *        Container for the parameters to the <code><a>DefineAnalysisScheme</a></code> operation. Specifies the name
     *        of the domain you want to update and the analysis scheme configuration.
     * @return A Java Future containing the result of the DefineAnalysisScheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DefineAnalysisScheme
     */
    default CompletableFuture<DefineAnalysisSchemeResponse> defineAnalysisScheme(
            DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an analysis scheme that can be applied to a <code>text</code> or <code>text-array</code> field to
     * define language-specific text processing options. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DefineAnalysisSchemeRequest.Builder} avoiding the
     * need to create one manually via {@link DefineAnalysisSchemeRequest#builder()}
     * </p>
     *
     * @param defineAnalysisSchemeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DefineAnalysisScheme</a></code> operation. Specifies
     *        the name of the domain you want to update and the analysis scheme configuration.
     * @return A Java Future containing the result of the DefineAnalysisScheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DefineAnalysisScheme
     */
    default CompletableFuture<DefineAnalysisSchemeResponse> defineAnalysisScheme(
            Consumer<DefineAnalysisSchemeRequest.Builder> defineAnalysisSchemeRequest) {
        return defineAnalysisScheme(DefineAnalysisSchemeRequest.builder().applyMutation(defineAnalysisSchemeRequest).build());
    }

    /**
     * <p>
     * Configures an <code><a>Expression</a></code> for the search domain. Used to create new expressions and modify
     * existing ones. If the expression exists, the new configuration replaces the old one. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param defineExpressionRequest
     *        Container for the parameters to the <code><a>DefineExpression</a></code> operation. Specifies the name of
     *        the domain you want to update and the expression you want to configure.
     * @return A Java Future containing the result of the DefineExpression operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DefineExpression
     */
    default CompletableFuture<DefineExpressionResponse> defineExpression(DefineExpressionRequest defineExpressionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an <code><a>Expression</a></code> for the search domain. Used to create new expressions and modify
     * existing ones. If the expression exists, the new configuration replaces the old one. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DefineExpressionRequest.Builder} avoiding the need
     * to create one manually via {@link DefineExpressionRequest#builder()}
     * </p>
     *
     * @param defineExpressionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DefineExpressionRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DefineExpression</a></code> operation. Specifies the
     *        name of the domain you want to update and the expression you want to configure.
     * @return A Java Future containing the result of the DefineExpression operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DefineExpression
     */
    default CompletableFuture<DefineExpressionResponse> defineExpression(
            Consumer<DefineExpressionRequest.Builder> defineExpressionRequest) {
        return defineExpression(DefineExpressionRequest.builder().applyMutation(defineExpressionRequest).build());
    }

    /**
     * <p>
     * Configures an <code><a>IndexField</a></code> for the search domain. Used to create new fields and modify existing
     * ones. You must specify the name of the domain you are configuring and an index field configuration. The index
     * field configuration specifies a unique name, the index field type, and the options you want to configure for the
     * field. The options you can specify depend on the <code><a>IndexFieldType</a></code>. If the field exists, the new
     * configuration replaces the old one. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
     * target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param defineIndexFieldRequest
     *        Container for the parameters to the <code><a>DefineIndexField</a></code> operation. Specifies the name of
     *        the domain you want to update and the index field configuration.
     * @return A Java Future containing the result of the DefineIndexField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DefineIndexField
     */
    default CompletableFuture<DefineIndexFieldResponse> defineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an <code><a>IndexField</a></code> for the search domain. Used to create new fields and modify existing
     * ones. You must specify the name of the domain you are configuring and an index field configuration. The index
     * field configuration specifies a unique name, the index field type, and the options you want to configure for the
     * field. The options you can specify depend on the <code><a>IndexFieldType</a></code>. If the field exists, the new
     * configuration replaces the old one. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
     * target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DefineIndexFieldRequest.Builder} avoiding the need
     * to create one manually via {@link DefineIndexFieldRequest#builder()}
     * </p>
     *
     * @param defineIndexFieldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DefineIndexField</a></code> operation. Specifies the
     *        name of the domain you want to update and the index field configuration.
     * @return A Java Future containing the result of the DefineIndexField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DefineIndexField
     */
    default CompletableFuture<DefineIndexFieldResponse> defineIndexField(
            Consumer<DefineIndexFieldRequest.Builder> defineIndexFieldRequest) {
        return defineIndexField(DefineIndexFieldRequest.builder().applyMutation(defineIndexFieldRequest).build());
    }

    /**
     * <p>
     * Configures a suggester for a domain. A suggester enables you to display possible matches before users finish
     * typing their queries. When you configure a suggester, you must specify the name of the text field you want to
     * search for possible matches and a unique name for the suggester. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param defineSuggesterRequest
     *        Container for the parameters to the <code><a>DefineSuggester</a></code> operation. Specifies the name of
     *        the domain you want to update and the suggester configuration.
     * @return A Java Future containing the result of the DefineSuggester operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DefineSuggester
     */
    default CompletableFuture<DefineSuggesterResponse> defineSuggester(DefineSuggesterRequest defineSuggesterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures a suggester for a domain. A suggester enables you to display possible matches before users finish
     * typing their queries. When you configure a suggester, you must specify the name of the text field you want to
     * search for possible matches and a unique name for the suggester. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DefineSuggesterRequest.Builder} avoiding the need
     * to create one manually via {@link DefineSuggesterRequest#builder()}
     * </p>
     *
     * @param defineSuggesterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DefineSuggester</a></code> operation. Specifies the
     *        name of the domain you want to update and the suggester configuration.
     * @return A Java Future containing the result of the DefineSuggester operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DefineSuggester
     */
    default CompletableFuture<DefineSuggesterResponse> defineSuggester(
            Consumer<DefineSuggesterRequest.Builder> defineSuggesterRequest) {
        return defineSuggester(DefineSuggesterRequest.builder().applyMutation(defineSuggesterRequest).build());
    }

    /**
     * <p>
     * Deletes an analysis scheme. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteAnalysisSchemeRequest
     *        Container for the parameters to the <code><a>DeleteAnalysisScheme</a></code> operation. Specifies the name
     *        of the domain you want to update and the analysis scheme you want to delete.
     * @return A Java Future containing the result of the DeleteAnalysisScheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteAnalysisScheme
     */
    default CompletableFuture<DeleteAnalysisSchemeResponse> deleteAnalysisScheme(
            DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an analysis scheme. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnalysisSchemeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAnalysisSchemeRequest#builder()}
     * </p>
     *
     * @param deleteAnalysisSchemeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteAnalysisScheme</a></code> operation. Specifies
     *        the name of the domain you want to update and the analysis scheme you want to delete.
     * @return A Java Future containing the result of the DeleteAnalysisScheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteAnalysisScheme
     */
    default CompletableFuture<DeleteAnalysisSchemeResponse> deleteAnalysisScheme(
            Consumer<DeleteAnalysisSchemeRequest.Builder> deleteAnalysisSchemeRequest) {
        return deleteAnalysisScheme(DeleteAnalysisSchemeRequest.builder().applyMutation(deleteAnalysisSchemeRequest).build());
    }

    /**
     * <p>
     * Permanently deletes a search domain and all of its data. Once a domain has been deleted, it cannot be recovered.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html"
     * target="_blank">Deleting a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteDomainRequest
     *        Container for the parameters to the <code><a>DeleteDomain</a></code> operation. Specifies the name of the
     *        domain you want to delete.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteDomain
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently deletes a search domain and all of its data. Once a domain has been deleted, it cannot be recovered.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/deleting-domains.html"
     * target="_blank">Deleting a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteDomainRequest.Builder} to create a request.
     *        Container for the parameters to the <code><a>DeleteDomain</a></code> operation. Specifies the name of the
     *        domain you want to delete.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteDomain
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Removes an <code><a>Expression</a></code> from the search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteExpressionRequest
     *        Container for the parameters to the <code><a>DeleteExpression</a></code> operation. Specifies the name of
     *        the domain you want to update and the name of the expression you want to delete.
     * @return A Java Future containing the result of the DeleteExpression operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteExpression
     */
    default CompletableFuture<DeleteExpressionResponse> deleteExpression(DeleteExpressionRequest deleteExpressionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an <code><a>Expression</a></code> from the search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExpressionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteExpressionRequest#builder()}
     * </p>
     *
     * @param deleteExpressionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteExpression</a></code> operation. Specifies the
     *        name of the domain you want to update and the name of the expression you want to delete.
     * @return A Java Future containing the result of the DeleteExpression operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteExpression
     */
    default CompletableFuture<DeleteExpressionResponse> deleteExpression(
            Consumer<DeleteExpressionRequest.Builder> deleteExpressionRequest) {
        return deleteExpression(DeleteExpressionRequest.builder().applyMutation(deleteExpressionRequest).build());
    }

    /**
     * <p>
     * Removes an <code><a>IndexField</a></code> from the search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
     * target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteIndexFieldRequest
     *        Container for the parameters to the <code><a>DeleteIndexField</a></code> operation. Specifies the name of
     *        the domain you want to update and the name of the index field you want to delete.
     * @return A Java Future containing the result of the DeleteIndexField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteIndexField
     */
    default CompletableFuture<DeleteIndexFieldResponse> deleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an <code><a>IndexField</a></code> from the search domain. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-index-fields.html"
     * target="_blank">Configuring Index Fields</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexFieldRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIndexFieldRequest#builder()}
     * </p>
     *
     * @param deleteIndexFieldRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteIndexField</a></code> operation. Specifies the
     *        name of the domain you want to update and the name of the index field you want to delete.
     * @return A Java Future containing the result of the DeleteIndexField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteIndexField
     */
    default CompletableFuture<DeleteIndexFieldResponse> deleteIndexField(
            Consumer<DeleteIndexFieldRequest.Builder> deleteIndexFieldRequest) {
        return deleteIndexField(DeleteIndexFieldRequest.builder().applyMutation(deleteIndexFieldRequest).build());
    }

    /**
     * <p>
     * Deletes a suggester. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param deleteSuggesterRequest
     *        Container for the parameters to the <code><a>DeleteSuggester</a></code> operation. Specifies the name of
     *        the domain you want to update and name of the suggester you want to delete.
     * @return A Java Future containing the result of the DeleteSuggester operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteSuggester
     */
    default CompletableFuture<DeleteSuggesterResponse> deleteSuggester(DeleteSuggesterRequest deleteSuggesterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a suggester. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSuggesterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteSuggesterRequest#builder()}
     * </p>
     *
     * @param deleteSuggesterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DeleteSuggester</a></code> operation. Specifies the
     *        name of the domain you want to update and name of the suggester you want to delete.
     * @return A Java Future containing the result of the DeleteSuggester operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DeleteSuggester
     */
    default CompletableFuture<DeleteSuggesterResponse> deleteSuggester(
            Consumer<DeleteSuggesterRequest.Builder> deleteSuggesterRequest) {
        return deleteSuggester(DeleteSuggesterRequest.builder().applyMutation(deleteSuggesterRequest).build());
    }

    /**
     * <p>
     * Gets the analysis schemes configured for a domain. An analysis scheme defines language-specific text processing
     * options for a <code>text</code> field. Can be limited to specific analysis schemes by name. By default, shows all
     * analysis schemes and includes any pending changes to the configuration. Set the <code>Deployed</code> option to
     * <code>true</code> to show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeAnalysisSchemesRequest
     *        Container for the parameters to the <code><a>DescribeAnalysisSchemes</a></code> operation. Specifies the
     *        name of the domain you want to describe. To limit the response to particular analysis schemes, specify the
     *        names of the analysis schemes you want to describe. To show the active configuration and exclude any
     *        pending changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeAnalysisSchemes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeAnalysisSchemes
     */
    default CompletableFuture<DescribeAnalysisSchemesResponse> describeAnalysisSchemes(
            DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the analysis schemes configured for a domain. An analysis scheme defines language-specific text processing
     * options for a <code>text</code> field. Can be limited to specific analysis schemes by name. By default, shows all
     * analysis schemes and includes any pending changes to the configuration. Set the <code>Deployed</code> option to
     * <code>true</code> to show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html"
     * target="_blank">Configuring Analysis Schemes</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAnalysisSchemesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAnalysisSchemesRequest#builder()}
     * </p>
     *
     * @param describeAnalysisSchemesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesRequest.Builder} to create
     *        a request. Container for the parameters to the <code><a>DescribeAnalysisSchemes</a></code> operation.
     *        Specifies the name of the domain you want to describe. To limit the response to particular analysis
     *        schemes, specify the names of the analysis schemes you want to describe. To show the active configuration
     *        and exclude any pending changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeAnalysisSchemes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeAnalysisSchemes
     */
    default CompletableFuture<DescribeAnalysisSchemesResponse> describeAnalysisSchemes(
            Consumer<DescribeAnalysisSchemesRequest.Builder> describeAnalysisSchemesRequest) {
        return describeAnalysisSchemes(DescribeAnalysisSchemesRequest.builder().applyMutation(describeAnalysisSchemesRequest)
                .build());
    }

    /**
     * <p>
     * Gets the availability options configured for a domain. By default, shows the configuration with any pending
     * changes. Set the <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude
     * pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
     * target="_blank">Configuring Availability Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeAvailabilityOptionsRequest
     *        Container for the parameters to the <code><a>DescribeAvailabilityOptions</a></code> operation. Specifies
     *        the name of the domain you want to describe. To show the active configuration and exclude any pending
     *        changes, set the Deployed option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeAvailabilityOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>DisabledOperationException The request was rejected because it attempted an operation which is not
     *         enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeAvailabilityOptions
     */
    default CompletableFuture<DescribeAvailabilityOptionsResponse> describeAvailabilityOptions(
            DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the availability options configured for a domain. By default, shows the configuration with any pending
     * changes. Set the <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude
     * pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
     * target="_blank">Configuring Availability Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAvailabilityOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAvailabilityOptionsRequest#builder()}
     * </p>
     *
     * @param describeAvailabilityOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>DescribeAvailabilityOptions</a></code>
     *        operation. Specifies the name of the domain you want to describe. To show the active configuration and
     *        exclude any pending changes, set the Deployed option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeAvailabilityOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>DisabledOperationException The request was rejected because it attempted an operation which is not
     *         enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeAvailabilityOptions
     */
    default CompletableFuture<DescribeAvailabilityOptionsResponse> describeAvailabilityOptions(
            Consumer<DescribeAvailabilityOptionsRequest.Builder> describeAvailabilityOptionsRequest) {
        return describeAvailabilityOptions(DescribeAvailabilityOptionsRequest.builder()
                .applyMutation(describeAvailabilityOptionsRequest).build());
    }

    /**
     * <p>
     * Returns the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html"
     * target="_blank">Configuring Domain Endpoint Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeDomainEndpointOptionsRequest
     *        Container for the parameters to the <code><a>DescribeDomainEndpointOptions</a></code> operation. Specify
     *        the name of the domain you want to describe. To show the active configuration and exclude any pending
     *        changes, set the Deployed option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeDomainEndpointOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>DisabledOperationException The request was rejected because it attempted an operation which is not
     *         enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeDomainEndpointOptions
     */
    default CompletableFuture<DescribeDomainEndpointOptionsResponse> describeDomainEndpointOptions(
            DescribeDomainEndpointOptionsRequest describeDomainEndpointOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html"
     * target="_blank">Configuring Domain Endpoint Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainEndpointOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDomainEndpointOptionsRequest#builder()}
     * </p>
     *
     * @param describeDomainEndpointOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>DescribeDomainEndpointOptions</a></code>
     *        operation. Specify the name of the domain you want to describe. To show the active configuration and
     *        exclude any pending changes, set the Deployed option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeDomainEndpointOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>DisabledOperationException The request was rejected because it attempted an operation which is not
     *         enabled.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeDomainEndpointOptions
     */
    default CompletableFuture<DescribeDomainEndpointOptionsResponse> describeDomainEndpointOptions(
            Consumer<DescribeDomainEndpointOptionsRequest.Builder> describeDomainEndpointOptionsRequest) {
        return describeDomainEndpointOptions(DescribeDomainEndpointOptionsRequest.builder()
                .applyMutation(describeDomainEndpointOptionsRequest).build());
    }

    /**
     * <p>
     * Gets information about the search domains owned by this account. Can be limited to specific domains. Shows all
     * domains by default. To get the number of searchable documents in a domain, use the console or submit a
     * <code>matchall</code> request to your domain's search endpoint:
     * <code>q=matchall&amp;amp;q.parser=structured&amp;amp;size=0</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Information about a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeDomainsRequest
     *        Container for the parameters to the <code><a>DescribeDomains</a></code> operation. By default shows the
     *        status of all domains. To restrict the response to particular domains, specify the names of the domains
     *        you want to describe.
     * @return A Java Future containing the result of the DescribeDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeDomains
     */
    default CompletableFuture<DescribeDomainsResponse> describeDomains(DescribeDomainsRequest describeDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the search domains owned by this account. Can be limited to specific domains. Shows all
     * domains by default. To get the number of searchable documents in a domain, use the console or submit a
     * <code>matchall</code> request to your domain's search endpoint:
     * <code>q=matchall&amp;amp;q.parser=structured&amp;amp;size=0</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Information about a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDomainsRequest#builder()}
     * </p>
     *
     * @param describeDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DescribeDomains</a></code> operation. By default
     *        shows the status of all domains. To restrict the response to particular domains, specify the names of the
     *        domains you want to describe.
     * @return A Java Future containing the result of the DescribeDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeDomains
     */
    default CompletableFuture<DescribeDomainsResponse> describeDomains(
            Consumer<DescribeDomainsRequest.Builder> describeDomainsRequest) {
        return describeDomains(DescribeDomainsRequest.builder().applyMutation(describeDomainsRequest).build());
    }

    /**
     * <p>
     * Gets information about the search domains owned by this account. Can be limited to specific domains. Shows all
     * domains by default. To get the number of searchable documents in a domain, use the console or submit a
     * <code>matchall</code> request to your domain's search endpoint:
     * <code>q=matchall&amp;amp;q.parser=structured&amp;amp;size=0</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Information about a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeDomains
     */
    default CompletableFuture<DescribeDomainsResponse> describeDomains() {
        return describeDomains(DescribeDomainsRequest.builder().build());
    }

    /**
     * <p>
     * Gets the expressions configured for the search domain. Can be limited to specific expressions by name. By
     * default, shows all expressions and includes any pending changes to the configuration. Set the
     * <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude pending changes.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeExpressionsRequest
     *        Container for the parameters to the <code><a>DescribeDomains</a></code> operation. Specifies the name of
     *        the domain you want to describe. To restrict the response to particular expressions, specify the names of
     *        the expressions you want to describe. To show the active configuration and exclude any pending changes,
     *        set the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeExpressions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeExpressions
     */
    default CompletableFuture<DescribeExpressionsResponse> describeExpressions(
            DescribeExpressionsRequest describeExpressionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the expressions configured for the search domain. Can be limited to specific expressions by name. By
     * default, shows all expressions and includes any pending changes to the configuration. Set the
     * <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude pending changes.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-expressions.html"
     * target="_blank">Configuring Expressions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExpressionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExpressionsRequest#builder()}
     * </p>
     *
     * @param describeExpressionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DescribeDomains</a></code> operation. Specifies the
     *        name of the domain you want to describe. To restrict the response to particular expressions, specify the
     *        names of the expressions you want to describe. To show the active configuration and exclude any pending
     *        changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeExpressions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeExpressions
     */
    default CompletableFuture<DescribeExpressionsResponse> describeExpressions(
            Consumer<DescribeExpressionsRequest.Builder> describeExpressionsRequest) {
        return describeExpressions(DescribeExpressionsRequest.builder().applyMutation(describeExpressionsRequest).build());
    }

    /**
     * <p>
     * Gets information about the index fields configured for the search domain. Can be limited to specific fields by
     * name. By default, shows all fields and includes any pending changes to the configuration. Set the
     * <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude pending changes.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Domain Information</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeIndexFieldsRequest
     *        Container for the parameters to the <code><a>DescribeIndexFields</a></code> operation. Specifies the name
     *        of the domain you want to describe. To restrict the response to particular index fields, specify the names
     *        of the index fields you want to describe. To show the active configuration and exclude any pending
     *        changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeIndexFields operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeIndexFields
     */
    default CompletableFuture<DescribeIndexFieldsResponse> describeIndexFields(
            DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the index fields configured for the search domain. Can be limited to specific fields by
     * name. By default, shows all fields and includes any pending changes to the configuration. Set the
     * <code>Deployed</code> option to <code>true</code> to show the active configuration and exclude pending changes.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-domain-info.html"
     * target="_blank">Getting Domain Information</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIndexFieldsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeIndexFieldsRequest#builder()}
     * </p>
     *
     * @param describeIndexFieldsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DescribeIndexFields</a></code> operation. Specifies
     *        the name of the domain you want to describe. To restrict the response to particular index fields, specify
     *        the names of the index fields you want to describe. To show the active configuration and exclude any
     *        pending changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeIndexFields operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeIndexFields
     */
    default CompletableFuture<DescribeIndexFieldsResponse> describeIndexFields(
            Consumer<DescribeIndexFieldsRequest.Builder> describeIndexFieldsRequest) {
        return describeIndexFields(DescribeIndexFieldsRequest.builder().applyMutation(describeIndexFieldsRequest).build());
    }

    /**
     * <p>
     * Gets the scaling parameters configured for a domain. A domain's scaling parameters specify the desired search
     * instance type and replication count. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
     * target="_blank">Configuring Scaling Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeScalingParametersRequest
     *        Container for the parameters to the <code><a>DescribeScalingParameters</a></code> operation. Specifies the
     *        name of the domain you want to describe.
     * @return A Java Future containing the result of the DescribeScalingParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeScalingParameters
     */
    default CompletableFuture<DescribeScalingParametersResponse> describeScalingParameters(
            DescribeScalingParametersRequest describeScalingParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the scaling parameters configured for a domain. A domain's scaling parameters specify the desired search
     * instance type and replication count. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
     * target="_blank">Configuring Scaling Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingParametersRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingParametersRequest#builder()}
     * </p>
     *
     * @param describeScalingParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>DescribeScalingParameters</a></code>
     *        operation. Specifies the name of the domain you want to describe.
     * @return A Java Future containing the result of the DescribeScalingParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeScalingParameters
     */
    default CompletableFuture<DescribeScalingParametersResponse> describeScalingParameters(
            Consumer<DescribeScalingParametersRequest.Builder> describeScalingParametersRequest) {
        return describeScalingParameters(DescribeScalingParametersRequest.builder()
                .applyMutation(describeScalingParametersRequest).build());
    }

    /**
     * <p>
     * Gets information about the access policies that control access to the domain's document and search endpoints. By
     * default, shows the configuration with any pending changes. Set the <code>Deployed</code> option to
     * <code>true</code> to show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
     * target="_blank">Configuring Access for a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeServiceAccessPoliciesRequest
     *        Container for the parameters to the <code><a>DescribeServiceAccessPolicies</a></code> operation. Specifies
     *        the name of the domain you want to describe. To show the active configuration and exclude any pending
     *        changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeServiceAccessPolicies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeServiceAccessPolicies
     */
    default CompletableFuture<DescribeServiceAccessPoliciesResponse> describeServiceAccessPolicies(
            DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the access policies that control access to the domain's document and search endpoints. By
     * default, shows the configuration with any pending changes. Set the <code>Deployed</code> option to
     * <code>true</code> to show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
     * target="_blank">Configuring Access for a Search Domain</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeServiceAccessPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeServiceAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param describeServiceAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>DescribeServiceAccessPolicies</a></code>
     *        operation. Specifies the name of the domain you want to describe. To show the active configuration and
     *        exclude any pending changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeServiceAccessPolicies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeServiceAccessPolicies
     */
    default CompletableFuture<DescribeServiceAccessPoliciesResponse> describeServiceAccessPolicies(
            Consumer<DescribeServiceAccessPoliciesRequest.Builder> describeServiceAccessPoliciesRequest) {
        return describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest.builder()
                .applyMutation(describeServiceAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * Gets the suggesters configured for a domain. A suggester enables you to display possible matches before users
     * finish typing their queries. Can be limited to specific suggesters by name. By default, shows all suggesters and
     * includes any pending changes to the configuration. Set the <code>Deployed</code> option to <code>true</code> to
     * show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param describeSuggestersRequest
     *        Container for the parameters to the <code><a>DescribeSuggester</a></code> operation. Specifies the name of
     *        the domain you want to describe. To restrict the response to particular suggesters, specify the names of
     *        the suggesters you want to describe. To show the active configuration and exclude any pending changes, set
     *        the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeSuggesters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeSuggesters
     */
    default CompletableFuture<DescribeSuggestersResponse> describeSuggesters(DescribeSuggestersRequest describeSuggestersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the suggesters configured for a domain. A suggester enables you to display possible matches before users
     * finish typing their queries. Can be limited to specific suggesters by name. By default, shows all suggesters and
     * includes any pending changes to the configuration. Set the <code>Deployed</code> option to <code>true</code> to
     * show the active configuration and exclude pending changes. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/getting-suggestions.html"
     * target="_blank">Getting Search Suggestions</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSuggestersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSuggestersRequest#builder()}
     * </p>
     *
     * @param describeSuggestersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>DescribeSuggester</a></code> operation. Specifies
     *        the name of the domain you want to describe. To restrict the response to particular suggesters, specify
     *        the names of the suggesters you want to describe. To show the active configuration and exclude any pending
     *        changes, set the <code>Deployed</code> option to <code>true</code>.
     * @return A Java Future containing the result of the DescribeSuggesters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.DescribeSuggesters
     */
    default CompletableFuture<DescribeSuggestersResponse> describeSuggesters(
            Consumer<DescribeSuggestersRequest.Builder> describeSuggestersRequest) {
        return describeSuggesters(DescribeSuggestersRequest.builder().applyMutation(describeSuggestersRequest).build());
    }

    /**
     * <p>
     * Tells the search domain to start indexing its documents using the latest indexing options. This operation must be
     * invoked to activate options whose <a>OptionStatus</a> is <code>RequiresIndexDocuments</code>.
     * </p>
     *
     * @param indexDocumentsRequest
     *        Container for the parameters to the <code><a>IndexDocuments</a></code> operation. Specifies the name of
     *        the domain you want to re-index.
     * @return A Java Future containing the result of the IndexDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.IndexDocuments
     */
    default CompletableFuture<IndexDocumentsResponse> indexDocuments(IndexDocumentsRequest indexDocumentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tells the search domain to start indexing its documents using the latest indexing options. This operation must be
     * invoked to activate options whose <a>OptionStatus</a> is <code>RequiresIndexDocuments</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IndexDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link IndexDocumentsRequest#builder()}
     * </p>
     *
     * @param indexDocumentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsRequest.Builder} to create a
     *        request. Container for the parameters to the <code><a>IndexDocuments</a></code> operation. Specifies the
     *        name of the domain you want to re-index.
     * @return A Java Future containing the result of the IndexDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.IndexDocuments
     */
    default CompletableFuture<IndexDocumentsResponse> indexDocuments(Consumer<IndexDocumentsRequest.Builder> indexDocumentsRequest) {
        return indexDocuments(IndexDocumentsRequest.builder().applyMutation(indexDocumentsRequest).build());
    }

    /**
     * <p>
     * Lists all search domains owned by an account.
     * </p>
     *
     * @param listDomainNamesRequest
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all search domains owned by an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainNamesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainNamesRequest#builder()}
     * </p>
     *
     * @param listDomainNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames(
            Consumer<ListDomainNamesRequest.Builder> listDomainNamesRequest) {
        return listDomainNames(ListDomainNamesRequest.builder().applyMutation(listDomainNamesRequest).build());
    }

    /**
     * <p>
     * Lists all search domains owned by an account.
     * </p>
     *
     * @return A Java Future containing the result of the ListDomainNames operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.ListDomainNames
     */
    default CompletableFuture<ListDomainNamesResponse> listDomainNames() {
        return listDomainNames(ListDomainNamesRequest.builder().build());
    }

    /**
     * <p>
     * Configures the availability options for a domain. Enabling the Multi-AZ option expands an Amazon CloudSearch
     * domain to an additional Availability Zone in the same Region to increase fault tolerance in the event of a
     * service disruption. Changes to the Multi-AZ option can take about half an hour to become active. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
     * target="_blank">Configuring Availability Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param updateAvailabilityOptionsRequest
     *        Container for the parameters to the <code><a>UpdateAvailabilityOptions</a></code> operation. Specifies the
     *        name of the domain you want to update and the Multi-AZ availability option.
     * @return A Java Future containing the result of the UpdateAvailabilityOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>DisabledOperationException The request was rejected because it attempted an operation which is not
     *         enabled.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.UpdateAvailabilityOptions
     */
    default CompletableFuture<UpdateAvailabilityOptionsResponse> updateAvailabilityOptions(
            UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the availability options for a domain. Enabling the Multi-AZ option expands an Amazon CloudSearch
     * domain to an additional Availability Zone in the same Region to increase fault tolerance in the event of a
     * service disruption. Changes to the Multi-AZ option can take about half an hour to become active. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html"
     * target="_blank">Configuring Availability Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAvailabilityOptionsRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateAvailabilityOptionsRequest#builder()}
     * </p>
     *
     * @param updateAvailabilityOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>UpdateAvailabilityOptions</a></code>
     *        operation. Specifies the name of the domain you want to update and the Multi-AZ availability option.
     * @return A Java Future containing the result of the UpdateAvailabilityOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>DisabledOperationException The request was rejected because it attempted an operation which is not
     *         enabled.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.UpdateAvailabilityOptions
     */
    default CompletableFuture<UpdateAvailabilityOptionsResponse> updateAvailabilityOptions(
            Consumer<UpdateAvailabilityOptionsRequest.Builder> updateAvailabilityOptionsRequest) {
        return updateAvailabilityOptions(UpdateAvailabilityOptionsRequest.builder()
                .applyMutation(updateAvailabilityOptionsRequest).build());
    }

    /**
     * <p>
     * Updates the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html"
     * target="_blank">Configuring Domain Endpoint Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param updateDomainEndpointOptionsRequest
     *        Container for the parameters to the <code><a>UpdateDomainEndpointOptions</a></code> operation. Specifies
     *        the name of the domain you want to update and the domain endpoint options.
     * @return A Java Future containing the result of the UpdateDomainEndpointOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>DisabledOperationException The request was rejected because it attempted an operation which is not
     *         enabled.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.UpdateDomainEndpointOptions
     */
    default CompletableFuture<UpdateDomainEndpointOptionsResponse> updateDomainEndpointOptions(
            UpdateDomainEndpointOptionsRequest updateDomainEndpointOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS.
     * For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-domain-endpoint-options.html"
     * target="_blank">Configuring Domain Endpoint Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainEndpointOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDomainEndpointOptionsRequest#builder()}
     * </p>
     *
     * @param updateDomainEndpointOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>UpdateDomainEndpointOptions</a></code>
     *        operation. Specifies the name of the domain you want to update and the domain endpoint options.
     * @return A Java Future containing the result of the UpdateDomainEndpointOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>DisabledOperationException The request was rejected because it attempted an operation which is not
     *         enabled.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.UpdateDomainEndpointOptions
     */
    default CompletableFuture<UpdateDomainEndpointOptionsResponse> updateDomainEndpointOptions(
            Consumer<UpdateDomainEndpointOptionsRequest.Builder> updateDomainEndpointOptionsRequest) {
        return updateDomainEndpointOptions(UpdateDomainEndpointOptionsRequest.builder()
                .applyMutation(updateDomainEndpointOptionsRequest).build());
    }

    /**
     * <p>
     * Configures scaling parameters for a domain. A domain's scaling parameters specify the desired search instance
     * type and replication count. Amazon CloudSearch will still automatically scale your domain based on the volume of
     * data and traffic, but not below the desired instance type and replication count. If the Multi-AZ option is
     * enabled, these values control the resources used per Availability Zone. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
     * target="_blank">Configuring Scaling Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     *
     * @param updateScalingParametersRequest
     *        Container for the parameters to the <code><a>UpdateScalingParameters</a></code> operation. Specifies the
     *        name of the domain you want to update and the scaling parameters you want to configure.
     * @return A Java Future containing the result of the UpdateScalingParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.UpdateScalingParameters
     */
    default CompletableFuture<UpdateScalingParametersResponse> updateScalingParameters(
            UpdateScalingParametersRequest updateScalingParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures scaling parameters for a domain. A domain's scaling parameters specify the desired search instance
     * type and replication count. Amazon CloudSearch will still automatically scale your domain based on the volume of
     * data and traffic, but not below the desired instance type and replication count. If the Multi-AZ option is
     * enabled, these values control the resources used per Availability Zone. For more information, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-scaling-options.html"
     * target="_blank">Configuring Scaling Options</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateScalingParametersRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateScalingParametersRequest#builder()}
     * </p>
     *
     * @param updateScalingParametersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest.Builder} to create
     *        a request. Container for the parameters to the <code><a>UpdateScalingParameters</a></code> operation.
     *        Specifies the name of the domain you want to update and the scaling parameters you want to configure.
     * @return A Java Future containing the result of the UpdateScalingParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.UpdateScalingParameters
     */
    default CompletableFuture<UpdateScalingParametersResponse> updateScalingParameters(
            Consumer<UpdateScalingParametersRequest.Builder> updateScalingParametersRequest) {
        return updateScalingParameters(UpdateScalingParametersRequest.builder().applyMutation(updateScalingParametersRequest)
                .build());
    }

    /**
     * <p>
     * Configures the access rules that control access to the domain's document and search endpoints. For more
     * information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
     * target="_blank"> Configuring Access for an Amazon CloudSearch Domain</a>.
     * </p>
     *
     * @param updateServiceAccessPoliciesRequest
     *        Container for the parameters to the <code><a>UpdateServiceAccessPolicies</a></code> operation. Specifies
     *        the name of the domain you want to update and the access rules you want to configure.
     * @return A Java Future containing the result of the UpdateServiceAccessPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.UpdateServiceAccessPolicies
     */
    default CompletableFuture<UpdateServiceAccessPoliciesResponse> updateServiceAccessPolicies(
            UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures the access rules that control access to the domain's document and search endpoints. For more
     * information, see <a href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-access.html"
     * target="_blank"> Configuring Access for an Amazon CloudSearch Domain</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceAccessPoliciesRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateServiceAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param updateServiceAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest.Builder} to
     *        create a request. Container for the parameters to the <code><a>UpdateServiceAccessPolicies</a></code>
     *        operation. Specifies the name of the domain you want to update and the access rules you want to configure.
     * @return A Java Future containing the result of the UpdateServiceAccessPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>BaseException An error occurred while processing the request.</li>
     *         <li>InternalException An internal error occurred while processing the request. If this problem persists,
     *         report an issue from the <a href="http://status.aws.amazon.com/" target="_blank">Service Health
     *         Dashboard</a>.</li>
     *         <li>LimitExceededException The request was rejected because a resource limit has already been met.</li>
     *         <li>ResourceNotFoundException The request was rejected because it attempted to reference a resource that
     *         does not exist.</li>
     *         <li>InvalidTypeException The request was rejected because it specified an invalid type definition.</li>
     *         <li>ValidationException The request was rejected because it has invalid parameters.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudSearchException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudSearchAsyncClient.UpdateServiceAccessPolicies
     */
    default CompletableFuture<UpdateServiceAccessPoliciesResponse> updateServiceAccessPolicies(
            Consumer<UpdateServiceAccessPoliciesRequest.Builder> updateServiceAccessPoliciesRequest) {
        return updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest.builder()
                .applyMutation(updateServiceAccessPoliciesRequest).build());
    }

    @Override
    default CloudSearchServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link CloudSearchAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudSearchAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudSearchAsyncClient}.
     */
    static CloudSearchAsyncClientBuilder builder() {
        return new DefaultCloudSearchAsyncClientBuilder();
    }
}
