/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitializeClusterResponse extends CloudHsmV2Response implements
        ToCopyableBuilder<InitializeClusterResponse.Builder, InitializeClusterResponse> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(InitializeClusterResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateMessage").getter(getter(InitializeClusterResponse::stateMessage))
            .setter(setter(Builder::stateMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String state;

    private final String stateMessage;

    private InitializeClusterResponse(BuilderImpl builder) {
        super(builder);
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
    }

    /**
     * <p>
     * The cluster's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The cluster's state.
     * @see ClusterState
     */
    public final ClusterState state() {
        return ClusterState.fromValue(state);
    }

    /**
     * <p>
     * The cluster's state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ClusterState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The cluster's state.
     * @see ClusterState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * A description of the cluster's state.
     * </p>
     * 
     * @return A description of the cluster's state.
     */
    public final String stateMessage() {
        return stateMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitializeClusterResponse)) {
            return false;
        }
        InitializeClusterResponse other = (InitializeClusterResponse) obj;
        return Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateMessage(), other.stateMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InitializeClusterResponse").add("State", stateAsString()).add("StateMessage", stateMessage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateMessage":
            return Optional.ofNullable(clazz.cast(stateMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("StateMessage", STATE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InitializeClusterResponse, T> g) {
        return obj -> g.apply((InitializeClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudHsmV2Response.Builder, SdkPojo, CopyableBuilder<Builder, InitializeClusterResponse> {
        /**
         * <p>
         * The cluster's state.
         * </p>
         * 
         * @param state
         *        The cluster's state.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(String state);

        /**
         * <p>
         * The cluster's state.
         * </p>
         * 
         * @param state
         *        The cluster's state.
         * @see ClusterState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterState
         */
        Builder state(ClusterState state);

        /**
         * <p>
         * A description of the cluster's state.
         * </p>
         * 
         * @param stateMessage
         *        A description of the cluster's state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMessage(String stateMessage);
    }

    static final class BuilderImpl extends CloudHsmV2Response.BuilderImpl implements Builder {
        private String state;

        private String stateMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(InitializeClusterResponse model) {
            super(model);
            state(model.state);
            stateMessage(model.stateMessage);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateMessage() {
            return stateMessage;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        @Override
        public InitializeClusterResponse build() {
            return new InitializeClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
